/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.ResidueNumber;
import org.biojava.nbio.structure.ResidueRange;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.StructureIdentifier;
import org.biojava.nbio.structure.SubstructureIdentifier;
import org.biojava.nbio.structure.align.model.AFPChain;
import org.biojava.nbio.structure.align.multiple.Block;
import org.biojava.nbio.structure.align.multiple.MultipleAlignment;
import org.biojava.nbio.structure.symmetry.internal.CESymmParameters;
import org.biojava.nbio.structure.symmetry.internal.SymmetryAxes;
import org.biojava.nbio.structure.symmetry.utils.SymmetryTools;

public class CeSymmResult {
    private MultipleAlignment multipleAlignment;
    private AFPChain selfAlignment;
    private StructureIdentifier structureId;
    private Atom[] atoms;
    private CESymmParameters params;
    private SymmetryAxes axes;
    private String symmGroup;
    private int symmOrder;
    private int symmLevels;
    private boolean refined;
    private CESymmParameters.SymmetryType type;

    public boolean isSignificant() {
        if (this.symmOrder < 2) {
            return false;
        }
        if (this.selfAlignment.getTMScore() < this.params.getScoreThreshold()) {
            return false;
        }
        if (this.params.getRefineMethod() != CESymmParameters.RefineMethod.NOT_REFINED) {
            if (this.multipleAlignment.getCoreLength() < this.params.getMinCoreLength()) {
                return false;
            }
            return !(this.multipleAlignment.getScore("AvgTM-score") < this.params.getScoreThreshold() * 0.9);
        }
        return true;
    }

    public List<StructureIdentifier> getRepeatsID() throws StructureException {
        if (!this.isRefined()) {
            return null;
        }
        ArrayList<StructureIdentifier> repeats = new ArrayList<StructureIdentifier>(this.symmOrder);
        String pdbId = this.structureId.toCanonical().getPdbId();
        Block align = this.multipleAlignment.getBlocks().get(0);
        for (int su = 0; su < this.symmOrder; ++su) {
            ResidueNumber res1 = this.atoms[align.getStartResidue(su)].getGroup().getResidueNumber();
            ResidueNumber res2 = this.atoms[align.getFinalResidue(su)].getGroup().getResidueNumber();
            ResidueRange range = new ResidueRange(res1.getChainId(), res1, res2);
            SubstructureIdentifier id = new SubstructureIdentifier(pdbId, Arrays.asList(range));
            repeats.add(id);
        }
        return repeats;
    }

    public String toString() {
        return this.structureId + ", symmGroup=" + this.getSymmGroup() + ", symmOrder=" + this.symmOrder + ", symmLevels=" + this.symmLevels + ", refined=" + this.refined + ", type=" + (Object)((Object)this.type) + " | " + this.params;
    }

    public MultipleAlignment getMultipleAlignment() {
        return this.multipleAlignment;
    }

    public void setMultipleAlignment(MultipleAlignment multipleAlignment) {
        this.multipleAlignment = multipleAlignment;
    }

    public AFPChain getSelfAlignment() {
        return this.selfAlignment;
    }

    public void setSelfAlignment(AFPChain selfAlignment) {
        this.selfAlignment = selfAlignment;
    }

    public CESymmParameters getParams() {
        return this.params;
    }

    public void setParams(CESymmParameters params) {
        this.params = params.clone();
    }

    public SymmetryAxes getAxes() {
        return this.axes;
    }

    public void setAxes(SymmetryAxes axes) {
        this.axes = axes;
    }

    public int getSymmOrder() {
        if (this.isSignificant()) {
            return this.symmOrder;
        }
        return 1;
    }

    public void setSymmOrder(int symmOrder) {
        this.symmOrder = symmOrder;
    }

    public boolean isRefined() {
        return this.refined;
    }

    public void setRefined(boolean refined) {
        this.refined = refined;
    }

    public String getSymmGroup() {
        if (this.symmGroup == null) {
            if (this.isSignificant()) {
                if (this.isRefined()) {
                    try {
                        this.symmGroup = SymmetryTools.getQuaternarySymmetry(this).getSymmetry();
                    }
                    catch (StructureException e) {
                        this.symmGroup = "C1";
                    }
                    if (this.symmGroup.equals("C1")) {
                        this.symmGroup = "R";
                    }
                } else {
                    this.symmGroup = this.type.equals((Object)CESymmParameters.SymmetryType.CLOSED) ? "C" + this.symmOrder : "R";
                }
            } else {
                this.symmGroup = "C1";
            }
        }
        return this.symmGroup;
    }

    public void setSymmGroup(String symmGroup) {
        this.symmGroup = symmGroup;
    }

    public CESymmParameters.SymmetryType getType() {
        return this.type;
    }

    public void setType(CESymmParameters.SymmetryType type) {
        this.type = type;
    }

    public Atom[] getAtoms() {
        return this.atoms;
    }

    public void setAtoms(Atom[] atoms) {
        this.atoms = atoms;
    }

    public int getSymmLevels() {
        return this.symmLevels;
    }

    public void setSymmLevels(int symmLevels) {
        this.symmLevels = symmLevels;
    }

    public StructureIdentifier getStructureId() {
        return this.structureId;
    }

    public void setStructureId(StructureIdentifier structureId) {
        this.structureId = structureId;
    }
}

