/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.ChainImpl;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.SVDSuperimposer;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.StructureIdentifier;
import org.biojava.nbio.structure.StructureImpl;
import org.biojava.nbio.structure.StructureTools;
import org.biojava.nbio.structure.align.ce.CECalculator;
import org.biojava.nbio.structure.align.helper.AlignTools;
import org.biojava.nbio.structure.align.model.AFPChain;
import org.biojava.nbio.structure.align.multiple.Block;
import org.biojava.nbio.structure.align.multiple.BlockImpl;
import org.biojava.nbio.structure.align.multiple.BlockSetImpl;
import org.biojava.nbio.structure.align.multiple.MultipleAlignment;
import org.biojava.nbio.structure.align.multiple.MultipleAlignmentEnsemble;
import org.biojava.nbio.structure.align.multiple.MultipleAlignmentEnsembleImpl;
import org.biojava.nbio.structure.align.multiple.MultipleAlignmentImpl;
import org.biojava.nbio.structure.align.multiple.util.CoreSuperimposer;
import org.biojava.nbio.structure.align.multiple.util.MultipleAlignmentScorer;
import org.biojava.nbio.structure.align.multiple.util.MultipleAlignmentTools;
import org.biojava.nbio.structure.jama.Matrix;
import org.biojava.nbio.structure.symmetry.core.QuatSymmetryDetector;
import org.biojava.nbio.structure.symmetry.core.QuatSymmetryParameters;
import org.biojava.nbio.structure.symmetry.core.QuatSymmetryResults;
import org.biojava.nbio.structure.symmetry.core.Subunits;
import org.biojava.nbio.structure.symmetry.internal.CeSymmResult;
import org.biojava.nbio.structure.symmetry.internal.SymmetryAxes;
import org.jgrapht.UndirectedGraph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.SimpleGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SymmetryTools {
    private static final Logger logger = LoggerFactory.getLogger(SymmetryTools.class);

    private SymmetryTools() {
    }

    private static double getResetVal(double unpenalizedScore, double nResFromMainDiag, double[] gradientPolyCoeff, double gradientExpCoeff) {
        if (unpenalizedScore == Double.NaN) {
            return 0.0;
        }
        double updateVal = unpenalizedScore;
        updateVal -= gradientExpCoeff * Math.pow(Math.E, -nResFromMainDiag);
        for (int p = 0; p < gradientPolyCoeff.length; ++p) {
            updateVal -= gradientPolyCoeff[gradientPolyCoeff.length - 1 - p] * Math.pow(nResFromMainDiag, -p);
        }
        return updateVal;
    }

    public static Matrix grayOutCEOrig(Atom[] ca2, int rows, int cols, CECalculator calculator, Matrix origM, int blankWindowSize, double[] gradientPolyCoeff, double gradientExpCoeff) {
        if (origM == null) {
            origM = new Matrix(calculator.getMatMatrix());
        }
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                int diff = Math.abs(i - j);
                double resetVal = SymmetryTools.getResetVal(origM.get(i, j), diff, gradientPolyCoeff, gradientExpCoeff);
                if (diff < blankWindowSize) {
                    origM.set(i, j, origM.get(i, j) + resetVal);
                }
                int diff2 = Math.abs(i - (j - ca2.length / 2));
                double resetVal2 = SymmetryTools.getResetVal(origM.get(i, j), diff2, gradientPolyCoeff, gradientExpCoeff);
                if (diff2 >= blankWindowSize) continue;
                origM.set(i, j, origM.get(i, j) + resetVal2);
            }
        }
        return origM;
    }

    public static Matrix grayOutPreviousAlignment(AFPChain afpChain, Atom[] ca2, int rows, int cols, CECalculator calculator, Matrix max, int blankWindowSize, double[] gradientPolyCoeff, double gradientExpCoeff) {
        max = SymmetryTools.grayOutCEOrig(ca2, rows, cols, calculator, max, blankWindowSize, gradientPolyCoeff, gradientExpCoeff);
        double[][] dist1 = calculator.getDist1();
        double[][] dist2 = calculator.getDist2();
        int[][][] optAln = afpChain.getOptAln();
        int blockNum = afpChain.getBlockNum();
        int[] optLen = afpChain.getOptLen();
        int breakPoint = ca2.length / 2;
        for (int bk = 0; bk < blockNum; ++bk) {
            for (int i = 0; i < optLen[bk]; ++i) {
                int pos1 = optAln[bk][0][i];
                int pos2 = optAln[bk][1][i];
                int dist = blankWindowSize / 2;
                int start1 = Math.max(pos1 - dist, 0);
                int start2 = Math.max(pos2 - dist, 0);
                int end1 = Math.min(pos1 + dist, rows - 1);
                int end2 = Math.min(pos2 + dist, cols - 1);
                for (int i1 = start1; i1 < end1; ++i1) {
                    double resetVal;
                    for (int k = 0; k < blankWindowSize / 2; ++k) {
                        if (i1 - k >= 0) {
                            dist1[i1 - k][i1 - k] = resetVal = SymmetryTools.getResetVal(max.get(i1 - k, i1 - k), 0.0, gradientPolyCoeff, gradientExpCoeff);
                            continue;
                        }
                        if (i1 + k >= rows) continue;
                        dist1[i1 + k][i1 + k] = resetVal = SymmetryTools.getResetVal(max.get(i1 + k, i1 + k), 0.0, gradientPolyCoeff, gradientExpCoeff);
                    }
                    for (int j2 = start2; j2 < end2; ++j2) {
                        double resetVal2;
                        resetVal = SymmetryTools.getResetVal(max.get(i1, j2), Math.abs(i1 - j2), gradientPolyCoeff, gradientExpCoeff);
                        max.set(i1, j2, resetVal);
                        if (j2 < breakPoint) {
                            resetVal2 = SymmetryTools.getResetVal(max.get(i1, j2 + breakPoint), Math.abs(i1 - (j2 + breakPoint)), gradientPolyCoeff, gradientExpCoeff);
                            max.set(i1, j2 + breakPoint, resetVal2);
                        } else {
                            resetVal2 = SymmetryTools.getResetVal(max.get(i1, j2 - breakPoint), Math.abs(i1 - (j2 - breakPoint)), gradientPolyCoeff, gradientExpCoeff);
                            max.set(i1, j2 - breakPoint, resetVal2);
                        }
                        for (int k = 0; k < blankWindowSize / 2; ++k) {
                            double resetVal22;
                            if (j2 - k >= 0) {
                                if (j2 - k < breakPoint) {
                                    dist2[j2 - k][j2 - k] = resetVal22 = SymmetryTools.getResetVal(max.get(j2 - k, j2 - k), 0.0, gradientPolyCoeff, gradientExpCoeff);
                                    continue;
                                }
                                dist2[j2 - k - breakPoint][j2 - k - breakPoint] = resetVal22 = SymmetryTools.getResetVal(max.get(j2 - k - breakPoint, j2 - k), 0.0, gradientPolyCoeff, gradientExpCoeff);
                                continue;
                            }
                            if (j2 + k >= cols) continue;
                            if (j2 + k < breakPoint) {
                                dist2[j2 + k][j2 + k] = resetVal22 = SymmetryTools.getResetVal(max.get(j2 + k, j2 + k), 0.0, gradientPolyCoeff, gradientExpCoeff);
                                continue;
                            }
                            dist2[j2 + k - breakPoint][j2 + k - breakPoint] = resetVal22 = SymmetryTools.getResetVal(max.get(j2 + k - breakPoint, j2 + k), 0.0, gradientPolyCoeff, gradientExpCoeff);
                        }
                    }
                }
            }
        }
        calculator.setDist1(dist1);
        calculator.setDist2(dist2);
        return max;
    }

    public Matrix getDkMatrix(Atom[] ca1, Atom[] ca2, int fragmentLength, double[] dist1, double[] dist2, int rows, int cols) {
        int i;
        Matrix diffDistMax = Matrix.identity(ca1.length, ca2.length);
        for (i = 0; i < rows; ++i) {
            double score1 = 0.0;
            for (int x = 0; x < fragmentLength; ++x) {
                score1 += dist1[i + x];
            }
            for (int j = 0; j < cols; ++j) {
                double score2 = 0.0;
                for (int y = 0; y < fragmentLength; ++y) {
                    score2 += dist2[j + y];
                }
                diffDistMax.set(i, j, Math.abs(score1 - score2));
            }
        }
        for (i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                int diff2;
                int diff = Math.abs(i - j);
                if (diff < 15) {
                    diffDistMax.set(i, j, 99.0);
                }
                if ((diff2 = Math.abs(i - (j - ca2.length / 2))) >= 15) continue;
                diffDistMax.set(i, j, 99.0);
            }
        }
        return diffDistMax;
    }

    public static Matrix blankOutPreviousAlignment(AFPChain afpChain, Atom[] ca2, int rows, int cols, CECalculator calculator, Matrix max, int blankWindowSize) {
        return SymmetryTools.grayOutPreviousAlignment(afpChain, ca2, rows, cols, calculator, max, blankWindowSize, new double[]{-2.147483648E9}, 0.0);
    }

    public static Matrix blankOutCEOrig(Atom[] ca2, int rows, int cols, CECalculator calculator, Matrix origM, int blankWindowSize) {
        return SymmetryTools.grayOutCEOrig(ca2, rows, cols, calculator, origM, blankWindowSize, new double[]{-2.147483648E9}, 0.0);
    }

    public static Matrix getDkMatrix(Atom[] ca1, Atom[] ca2, int k, int fragmentLength) {
        double[] dist1 = AlignTools.getDiagonalAtK(ca1, k);
        double[] dist2 = AlignTools.getDiagonalAtK(ca2, k);
        int rows = ca1.length - fragmentLength - k + 1;
        int cols = ca2.length - fragmentLength - k + 1;
        Matrix m2 = new Matrix(rows, cols);
        for (int i = 0; i < rows; ++i) {
            double score1 = 0.0;
            for (int x = 0; x < fragmentLength; ++x) {
                score1 += dist1[i + x];
            }
            for (int j = 0; j < cols; ++j) {
                double score2 = 0.0;
                for (int y = 0; y < fragmentLength; ++y) {
                    score2 += dist2[j + y];
                }
                m2.set(i, j, Math.abs(score1 - score2));
            }
        }
        return m2;
    }

    public static boolean[][] blankOutBreakFlag(AFPChain afpChain, Atom[] ca2, int rows, int cols, CECalculator calculator, boolean[][] breakFlag, int blankWindowSize) {
        int[][][] optAln = afpChain.getOptAln();
        int blockNum = afpChain.getBlockNum();
        int[] optLen = afpChain.getOptLen();
        int breakPoint = ca2.length / 2;
        for (int bk = 0; bk < blockNum; ++bk) {
            for (int i = 0; i < optLen[bk]; ++i) {
                int pos1 = optAln[bk][0][i];
                int pos2 = optAln[bk][1][i];
                int dist = blankWindowSize;
                int start1 = Math.max(pos1 - dist, 0);
                int start2 = Math.max(pos2 - dist, 0);
                int end1 = Math.min(pos1 + dist, rows - 1);
                int end2 = Math.min(pos2 + dist, cols - 1);
                for (int i1 = start1; i1 < end1; ++i1) {
                    for (int j2 = start2; j2 < end2; ++j2) {
                        breakFlag[i1][j2] = true;
                        if (j2 >= breakPoint) continue;
                        breakFlag[i1][j2 + breakPoint] = true;
                    }
                }
            }
        }
        return breakFlag;
    }

    public static double getAngle(AFPChain afpChain, Atom[] ca1, Atom[] ca2) {
        Matrix rotation = afpChain.getBlockRotationMatrix()[0];
        return Math.acos(rotation.trace() - 1.0) * 180.0 / Math.PI;
    }

    public static List<List<Integer>> buildSymmetryGraph(List<AFPChain> afps, Atom[] atoms, boolean undirected) {
        ArrayList<List<Integer>> graph = new ArrayList<List<Integer>>();
        for (int n = 0; n < atoms.length; ++n) {
            graph.add(new ArrayList());
        }
        for (int k = 0; k < afps.size(); ++k) {
            for (int i = 0; i < afps.get(k).getOptAln().length; ++i) {
                for (int j = 0; j < afps.get(k).getOptAln()[i][0].length; ++j) {
                    Integer res1 = afps.get(k).getOptAln()[i][0][j];
                    Integer res2 = afps.get(k).getOptAln()[i][1][j];
                    ((List)graph.get(res1)).add(res2);
                    if (!undirected) continue;
                    ((List)graph.get(res2)).add(res1);
                }
            }
        }
        return graph;
    }

    public static UndirectedGraph<Integer, DefaultEdge> buildSymmetryGraph(AFPChain selfAlignment) {
        SimpleGraph graph = new SimpleGraph(DefaultEdge.class);
        for (int i = 0; i < selfAlignment.getOptAln().length; ++i) {
            for (int j = 0; j < selfAlignment.getOptAln()[i][0].length; ++j) {
                Integer res1 = selfAlignment.getOptAln()[i][0][j];
                Integer res2 = selfAlignment.getOptAln()[i][1][j];
                graph.addVertex((Object)res1);
                graph.addVertex((Object)res2);
                graph.addEdge((Object)res1, (Object)res2);
            }
        }
        return graph;
    }

    public static Structure getQuaternaryStructure(CeSymmResult symmetry) {
        if (!symmetry.isRefined()) {
            throw new IllegalArgumentException("The symmetry result is not refined, repeats cannot be defined");
        }
        Atom[] atoms = symmetry.getAtoms();
        StructureImpl symm = new StructureImpl();
        symm.setStructureIdentifier(symmetry.getStructureId());
        symm.setChains(new ArrayList<Chain>());
        char chainID = 'A';
        for (int i = 0; i < symmetry.getMultipleAlignment().size(); ++i) {
            ChainImpl newCh = new ChainImpl();
            Block align = symmetry.getMultipleAlignment().getBlock(0);
            int res1 = align.getStartResidue(i);
            int res2 = align.getFinalResidue(i);
            Atom[] repeat = Arrays.copyOfRange(atoms, res1, res2 + 1);
            for (int k = 0; k < repeat.length; ++k) {
                Group g = (Group)repeat[k].getGroup().clone();
                newCh.addGroup(g);
            }
            newCh.setChainID(chainID + "");
            chainID = (char)(chainID + '\u0001');
            symm.addChain(newCh);
        }
        return symm;
    }

    public static MultipleAlignment toFullAlignment(CeSymmResult symm) {
        if (!symm.isRefined()) {
            throw new IllegalArgumentException("The symmetry result is not refined, repeats cannot be defined");
        }
        MultipleAlignment full = symm.getMultipleAlignment().clone();
        for (int str = 1; str < full.size(); ++str) {
            Block b = full.getBlock(full.getBlocks().size() - 1).clone();
            b.getAlignRes().add(b.getAlignRes().get(0));
            b.getAlignRes().remove(0);
            full.getBlockSet(0).getBlocks().add(b);
        }
        return full;
    }

    public static MultipleAlignment toRepeatsAlignment(CeSymmResult result) throws StructureException {
        if (!result.isRefined()) {
            throw new IllegalArgumentException("The symmetry result is not refined, repeats cannot be defined");
        }
        MultipleAlignment msa = result.getMultipleAlignment();
        MultipleAlignmentEnsemble newEnsemble = msa.getEnsemble().clone();
        newEnsemble.setStructureIdentifiers(result.getRepeatsID());
        ArrayList<Atom[]> atomArrays = new ArrayList<Atom[]>();
        Structure divided = SymmetryTools.getQuaternaryStructure(result);
        MultipleAlignment repeats = newEnsemble.getMultipleAlignment(0);
        Block block = repeats.getBlock(0);
        for (int i = 0; i < result.getMultipleAlignment().size(); ++i) {
            StructureImpl newStr = new StructureImpl();
            Chain newCh = divided.getChain(i);
            newStr.addChain(newCh);
            Atom[] repeat = StructureTools.getRepresentativeAtomArray(newCh);
            atomArrays.add(repeat);
        }
        newEnsemble.setAtomArrays(atomArrays);
        for (int su = 0; su < block.size(); ++su) {
            Integer start = block.getStartResidue(su);
            for (int res = 0; res < block.length(); ++res) {
                Integer residue = block.getAlignRes().get(su).get(res);
                if (residue != null) {
                    residue = residue - start;
                }
                block.getAlignRes().get(su).set(res, residue);
            }
        }
        return repeats;
    }

    public static MultipleAlignment fromAFP(AFPChain symm, Atom[] atoms) throws StructureException {
        if (!symm.getAlgorithmName().contains("symm")) {
            throw new IllegalArgumentException("The input alignment is not a symmetry alignment.");
        }
        MultipleAlignmentEnsembleImpl e = new MultipleAlignmentEnsembleImpl(symm, atoms, atoms, false);
        e.setAtomArrays(new ArrayList<Atom[]>());
        StructureIdentifier name = null;
        if (e.getStructureIdentifiers() != null) {
            if (!e.getStructureIdentifiers().isEmpty()) {
                name = e.getStructureIdentifiers().get(0);
            }
        } else {
            name = atoms[0].getGroup().getChain().getStructure().getStructureIdentifier();
        }
        e.setStructureIdentifiers(new ArrayList<StructureIdentifier>());
        MultipleAlignmentImpl result = new MultipleAlignmentImpl();
        BlockSetImpl bs = new BlockSetImpl(result);
        BlockImpl b = new BlockImpl(bs);
        b.setAlignRes(new ArrayList<List<Integer>>());
        int order = symm.getBlockNum();
        for (int su = 0; su < order; ++su) {
            List<Integer> residues = e.getMultipleAlignment(0).getBlock(su).getAlignRes().get(0);
            b.getAlignRes().add(residues);
            e.getStructureIdentifiers().add(name);
            e.getAtomArrays().add(atoms);
        }
        e.getMultipleAlignments().set(0, result);
        result.setEnsemble(e);
        CoreSuperimposer imposer = new CoreSuperimposer();
        imposer.superimpose(result);
        SymmetryTools.updateSymmetryScores(result);
        return result;
    }

    public static boolean equivalentAxes(Matrix4d axis1, Matrix4d axis2, double epsilon) {
        AxisAngle4d rot1 = new AxisAngle4d();
        rot1.set(axis1);
        AxisAngle4d rot2 = new AxisAngle4d();
        rot2.set(axis2);
        ArrayList<Double> sameDir = new ArrayList<Double>();
        sameDir.add(Math.abs(rot1.x - rot2.x));
        sameDir.add(Math.abs(rot1.y - rot2.y));
        sameDir.add(Math.abs(rot1.z - rot2.z));
        ArrayList<Double> otherDir = new ArrayList<Double>();
        otherDir.add(Math.abs(rot1.x + rot2.x));
        otherDir.add(Math.abs(rot1.y + rot2.y));
        otherDir.add(Math.abs(rot1.z + rot2.z));
        Double error = Math.min((Double)Collections.max(sameDir), (Double)Collections.max(otherDir));
        return error < epsilon;
    }

    public static QuatSymmetryResults getQuaternarySymmetry(CeSymmResult result) throws StructureException {
        MultipleAlignment repeats = SymmetryTools.toRepeatsAlignment(result);
        List<Atom[]> alignedCA = repeats.getAtomArrays();
        List<Integer> corePos = MultipleAlignmentTools.getCorePositions(repeats.getBlock(0));
        ArrayList<Point3d[]> caCoords = new ArrayList<Point3d[]>();
        ArrayList<Integer> folds = new ArrayList<Integer>();
        ArrayList<Boolean> pseudo = new ArrayList<Boolean>();
        ArrayList<String> chainIds = new ArrayList<String>();
        ArrayList<Integer> models = new ArrayList<Integer>();
        ArrayList<Double> seqIDmin = new ArrayList<Double>();
        ArrayList<Double> seqIDmax = new ArrayList<Double>();
        ArrayList<Integer> clusterIDs = new ArrayList<Integer>();
        int fold = 1;
        for (int str = 0; str < alignedCA.size(); ++str) {
            Atom[] array = alignedCA.get(str);
            ArrayList<Point3d> points = new ArrayList<Point3d>();
            List<Integer> alignedRes = repeats.getBlock(0).getAlignRes().get(str);
            for (int pos = 0; pos < alignedRes.size(); ++pos) {
                Integer residue = alignedRes.get(pos);
                if (residue == null || !corePos.contains(pos)) continue;
                Atom a = array[residue];
                points.add(new Point3d(a.getCoords()));
            }
            caCoords.add(points.toArray(new Point3d[points.size()]));
            if (alignedCA.size() % fold == 0) {
                folds.add(fold);
            }
            ++fold;
            pseudo.add(false);
            chainIds.add(alignedCA.get(str)[0].getGroup().getChainId());
            models.add(0);
            seqIDmax.add(1.0);
            seqIDmin.add(1.0);
            clusterIDs.add(0);
        }
        Subunits globalSubunits = new Subunits(caCoords, clusterIDs, pseudo, seqIDmin, seqIDmax, folds, chainIds, models);
        QuatSymmetryParameters param = new QuatSymmetryParameters();
        QuatSymmetryResults gSymmetry = QuatSymmetryDetector.calcQuatSymmetry(globalSubunits, param);
        return gSymmetry;
    }

    public static boolean isRefined(MultipleAlignment symm) {
        if (symm.getBlocks().size() > 1) {
            return false;
        }
        if (symm.size() < 2) {
            return false;
        }
        ArrayList<Integer> alreadySeen = new ArrayList<Integer>();
        List<List<Integer>> align = symm.getBlock(0).getAlignRes();
        for (int str = 0; str < symm.size(); ++str) {
            for (int res = 0; res < align.get(str).size(); ++res) {
                Integer residue = align.get(str).get(res);
                if (residue == null) continue;
                if (alreadySeen.contains(residue)) {
                    return false;
                }
                alreadySeen.add(residue);
            }
        }
        return true;
    }

    public static boolean isSignificant(MultipleAlignment msa, double symmetryThreshold) throws StructureException {
        if (!SymmetryTools.isRefined(msa)) {
            return false;
        }
        double tm = 0.0;
        tm = msa.getScore("AvgTM-score") == null ? MultipleAlignmentScorer.getAvgTMScore(msa) : msa.getScore("AvgTM-score");
        return !(tm < symmetryThreshold);
    }

    public static List<Group> getGroups(Atom[] rAtoms) {
        ArrayList<Group> groups = new ArrayList<Group>(rAtoms.length);
        for (Atom a : rAtoms) {
            Group g = a.getGroup();
            if (g != null) {
                groups.add(g);
                continue;
            }
            logger.info("Group not found for representative Atom {}", (Object)a);
        }
        return groups;
    }

    public static void updateSymmetryTransformation(SymmetryAxes axes, MultipleAlignment msa, Atom[] atoms) throws StructureException {
        List<List<Integer>> block = msa.getBlocks().get(0).getAlignRes();
        int length = block.get(0).size();
        if (axes != null) {
            for (int t = 0; t < axes.getElementaryAxes().size(); ++t) {
                Matrix4d axis = axes.getElementaryAxes().get(t);
                List<Integer> chain1 = axes.getRepeatRelation(t).get(0);
                List<Integer> chain2 = axes.getRepeatRelation(t).get(1);
                ArrayList<Atom> list1 = new ArrayList<Atom>();
                ArrayList<Atom> list2 = new ArrayList<Atom>();
                for (int pair = 0; pair < chain1.size(); ++pair) {
                    int p1 = chain1.get(pair);
                    int p2 = chain2.get(pair);
                    for (int k = 0; k < length; ++k) {
                        Integer pos1 = block.get(p1).get(k);
                        Integer pos2 = block.get(p2).get(k);
                        if (pos1 == null || pos2 == null) continue;
                        list1.add(atoms[pos1]);
                        list2.add(atoms[pos2]);
                    }
                }
                Atom[] arr1 = list1.toArray(new Atom[list1.size()]);
                Atom[] arr2 = list2.toArray(new Atom[list2.size()]);
                if (arr1.length > 0 && arr2.length > 0) {
                    SVDSuperimposer svd = new SVDSuperimposer(arr1, arr2);
                    axis = svd.getTransformation();
                    axes.updateAxis(t, axis);
                }
                ArrayList<Matrix4d> transformations = new ArrayList<Matrix4d>();
                for (int su = 0; su < msa.size(); ++su) {
                    transformations.add(axes.getRepeatTransform(su));
                }
                msa.getBlockSet(0).setTransformations(transformations);
            }
        } else {
            CoreSuperimposer imposer = new CoreSuperimposer();
            imposer.superimpose(msa);
        }
        SymmetryTools.updateSymmetryScores(msa);
    }

    public static void updateSymmetryScores(MultipleAlignment symm) throws StructureException {
        double tmScore = MultipleAlignmentScorer.getAvgTMScore(symm) * (double)symm.size();
        double rmsd = MultipleAlignmentScorer.getRMSD(symm);
        symm.putScore("AvgTM-score", tmScore);
        symm.putScore("RMSD", rmsd);
    }
}

