/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.biojava.nbio.structure.symmetry.core.PermutationGroup;
import org.biojava.nbio.structure.symmetry.core.QuatSuperpositionScorer;
import org.biojava.nbio.structure.symmetry.core.QuatSymmetryParameters;
import org.biojava.nbio.structure.symmetry.core.QuatSymmetryScores;
import org.biojava.nbio.structure.symmetry.core.QuatSymmetrySolver;
import org.biojava.nbio.structure.symmetry.core.Rotation;
import org.biojava.nbio.structure.symmetry.core.RotationGroup;
import org.biojava.nbio.structure.symmetry.core.Subunits;
import org.biojava.nbio.structure.symmetry.geometry.DistanceBox;
import org.biojava.nbio.structure.symmetry.geometry.MomentsOfInertia;
import org.biojava.nbio.structure.symmetry.geometry.SphereSampler;
import org.biojava.nbio.structure.symmetry.geometry.SuperPosition;

public class RotationSolver
implements QuatSymmetrySolver {
    private Subunits subunits = null;
    private QuatSymmetryParameters parameters = null;
    private double distanceThreshold = 0.0;
    private DistanceBox<Integer> box = null;
    private Vector3d centroid = new Vector3d();
    private Matrix4d centroidInverse = new Matrix4d();
    private Point3d[] originalCoords = null;
    private Point3d[] transformedCoords = null;
    private Set<List<Integer>> hashCodes = new HashSet<List<Integer>>();
    private RotationGroup rotations = new RotationGroup();

    public RotationSolver(Subunits subunits, QuatSymmetryParameters parameters) {
        if (subunits.getSubunitCount() == 2) {
            throw new IllegalArgumentException("RotationSolver cannot be applied to subunits with 2 centers");
        }
        this.subunits = subunits;
        this.parameters = parameters;
    }

    @Override
    public RotationGroup getSymmetryOperations() {
        if (this.rotations.getOrder() == 0) {
            this.solve();
            this.completeRotationGroup();
            this.rotations.complete();
        }
        return this.rotations;
    }

    private void solve() {
        this.initialize();
        int maxSymOps = this.subunits.getSubunitCount();
        boolean isSpherical = this.isSpherical();
        if (maxSymOps % 60 == 0 && isSpherical) {
            maxSymOps = 60;
        }
        AxisAngle4d sphereAngle = new AxisAngle4d();
        Matrix4d transformation = new Matrix4d();
        int n = this.subunits.getSubunitCount();
        int sphereCount = SphereSampler.getSphereCount();
        List<Double> angles = this.getAngles();
        for (int i = 0; i < sphereCount; ++i) {
            SphereSampler.getAxisAngle(i, sphereAngle);
            Iterator<Double> iterator = angles.iterator();
            while (iterator.hasNext()) {
                double angle;
                sphereAngle.angle = angle = iterator.next().doubleValue();
                transformation.set(sphereAngle);
                transformation.setElement(3, 3, 1.0);
                for (int j = 0; j < n; ++j) {
                    this.transformedCoords[j].set((Tuple3d)this.originalCoords[j]);
                    transformation.transform(this.transformedCoords[j]);
                }
                List<Integer> permutation = this.getPermutation();
                boolean isValidPermuation = this.isValidPermutation(permutation);
                if (!isValidPermuation) continue;
                boolean newPermutation = this.evaluatePermutation(permutation);
                if (newPermutation) {
                    this.completeRotationGroup();
                }
                if (this.rotations.getOrder() < maxSymOps) continue;
                return;
            }
        }
    }

    private void completeRotationGroup() {
        int i;
        PermutationGroup g = new PermutationGroup();
        for (i = 0; i < this.rotations.getOrder(); ++i) {
            Rotation s = this.rotations.getRotation(i);
            g.addPermutation(s.getPermutation());
        }
        g.completeGroup();
        if (g.getOrder() == this.rotations.getOrder()) {
            return;
        }
        for (i = 0; i < g.getOrder(); ++i) {
            List<Integer> permutation = g.getPermutation(i);
            boolean isValidPermutation = this.isValidPermutation(permutation);
            if (!isValidPermutation) continue;
            this.evaluatePermutation(permutation);
        }
    }

    private boolean evaluatePermutation(List<Integer> permutation) {
        int n = this.subunits.getSubunitCount();
        for (int j = 0; j < n; ++j) {
            this.transformedCoords[j].set((Tuple3d)this.originalCoords[permutation.get(j)]);
        }
        int fold = PermutationGroup.getOrder(permutation);
        AxisAngle4d axisAngle = new AxisAngle4d();
        Matrix4d transformation = SuperPosition.superposeAtOrigin(this.transformedCoords, this.originalCoords, axisAngle);
        double subunitRmsd = SuperPosition.rmsd(this.transformedCoords, this.originalCoords);
        if (subunitRmsd < this.parameters.getRmsdThreshold()) {
            this.combineWithTranslation(transformation);
            QuatSymmetryScores scores = QuatSuperpositionScorer.calcScores(this.subunits, transformation, permutation);
            if (scores.getRmsd() < 0.0 || scores.getRmsd() > this.parameters.getRmsdThreshold()) {
                return false;
            }
            scores.setRmsdCenters(subunitRmsd);
            Rotation symmetryOperation = this.createSymmetryOperation(permutation, transformation, axisAngle, fold, scores);
            this.rotations.addRotation(symmetryOperation);
            return true;
        }
        return false;
    }

    private List<Double> getAngles() {
        int n = this.subunits.getSubunitCount();
        if (n % 60 == 0 && this.isSpherical()) {
            n = 60;
        }
        List<Integer> folds = this.subunits.getFolds();
        ArrayList<Double> angles = new ArrayList<Double>(folds.size() - 1);
        for (int fold : folds) {
            if (fold <= 0 || fold > n) continue;
            angles.add(Math.PI * 2 / (double)fold);
        }
        return angles;
    }

    private boolean isSpherical() {
        MomentsOfInertia m = this.subunits.getMomentsOfInertia();
        return m.getSymmetryClass(0.05) == MomentsOfInertia.SymmetryClass.SYMMETRIC;
    }

    private boolean isValidPermutation(List<Integer> permutation) {
        if (permutation.size() == 0) {
            return false;
        }
        if (this.hashCodes.contains(permutation)) {
            return false;
        }
        if (!this.isAllowedPermutation(permutation)) {
            return false;
        }
        int fold = PermutationGroup.getOrder(permutation);
        if (this.rotations.getOrder() > 1 && fold == 1) {
            return false;
        }
        if (fold == 0 || this.subunits.getSubunitCount() % fold != 0) {
            return false;
        }
        return this.hashCodes.add(permutation);
    }

    private boolean isAllowedPermutation(List<Integer> permutation) {
        List<Integer> seqClusterId = this.subunits.getSequenceClusterIds();
        for (int i = 0; i < permutation.size(); ++i) {
            int j = permutation.get(i);
            if (seqClusterId.get(i) == seqClusterId.get(j)) continue;
            return false;
        }
        return true;
    }

    private void combineWithTranslation(Matrix4d rotation) {
        rotation.setTranslation(this.centroid);
        rotation.mul(rotation, this.centroidInverse);
    }

    private Rotation createSymmetryOperation(List<Integer> permutation, Matrix4d transformation, AxisAngle4d axisAngle, int fold, QuatSymmetryScores scores) {
        Rotation s = new Rotation();
        s.setPermutation(new ArrayList<Integer>(permutation));
        s.setTransformation(new Matrix4d(transformation));
        s.setAxisAngle(new AxisAngle4d(axisAngle));
        s.setFold(fold);
        s.setScores(scores);
        return s;
    }

    private void setupDistanceBox() {
        this.distanceThreshold = this.calcDistanceThreshold();
        this.box = new DistanceBox(this.distanceThreshold);
        for (int i = 0; i < this.originalCoords.length; ++i) {
            this.box.addPoint(this.originalCoords[i], i);
        }
    }

    private double calcDistanceThreshold() {
        double threshold = Double.MAX_VALUE;
        int n = this.subunits.getSubunitCount();
        List<Point3d> centers = this.subunits.getCenters();
        for (int i = 0; i < n - 1; ++i) {
            Point3d pi = centers.get(i);
            for (int j = i + 1; j < n; ++j) {
                Point3d pj = centers.get(j);
                threshold = Math.min(threshold, pi.distanceSquared(pj));
            }
        }
        double distanceThreshold = Math.sqrt(threshold);
        distanceThreshold = Math.max(distanceThreshold, this.parameters.getRmsdThreshold());
        return distanceThreshold;
    }

    private List<Integer> getPermutation() {
        double rmsd;
        ArrayList<Integer> permutation = new ArrayList<Integer>(this.transformedCoords.length);
        double sum = 0.0;
        for (Point3d t : this.transformedCoords) {
            List<Integer> neighbors = this.box.getNeighborsWithCache(t);
            int closest = -1;
            double minDist = Double.MAX_VALUE;
            for (int j : neighbors) {
                double dist = t.distanceSquared(this.originalCoords[j]);
                if (!(dist < minDist)) continue;
                closest = j;
                minDist = dist;
            }
            sum += minDist;
            if (closest == -1) break;
            permutation.add(closest);
        }
        if ((rmsd = Math.sqrt(sum / (double)this.transformedCoords.length)) > this.distanceThreshold || permutation.size() != this.transformedCoords.length) {
            permutation.clear();
            return permutation;
        }
        HashSet<Integer> set = new HashSet<Integer>(permutation);
        if (set.size() != this.originalCoords.length) {
            permutation.clear();
        }
        return permutation;
    }

    private void initialize() {
        this.centroid = new Vector3d((Tuple3d)this.subunits.getCentroid());
        Vector3d reverse = new Vector3d(this.centroid);
        reverse.negate();
        this.centroidInverse.set(reverse);
        this.centroidInverse.setElement(3, 3, 1.0);
        List<Point3d> centers = this.subunits.getCenters();
        int n = this.subunits.getSubunitCount();
        this.originalCoords = new Point3d[n];
        this.transformedCoords = new Point3d[n];
        for (int i = 0; i < n; ++i) {
            this.originalCoords[i] = centers.get(i);
            this.transformedCoords[i] = new Point3d();
        }
        this.setupDistanceBox();
    }
}

