/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class PermutationGroup
implements Iterable<List<Integer>> {
    List<List<Integer>> permutations = new ArrayList<List<Integer>>();

    public void addPermutation(List<Integer> permutation) {
        if (!this.permutations.contains(permutation)) {
            this.permutations.add(permutation);
        }
    }

    public List<Integer> getPermutation(int index) {
        return this.permutations.get(index);
    }

    public int getOrder() {
        return this.permutations.size();
    }

    public void completeGroup() {
        ArrayList<List<Integer>> gens = new ArrayList<List<Integer>>(this.permutations);
        HashSet<List<Integer>> known = new HashSet<List<Integer>>(this.permutations);
        ArrayList<List<Integer>> currentLevel = new ArrayList<List<Integer>>(this.permutations);
        while (currentLevel.size() > 0) {
            ArrayList<List<Integer>> nextLevel = new ArrayList<List<Integer>>();
            for (List list : currentLevel) {
                for (List list2 : gens) {
                    List<Integer> y = PermutationGroup.combine(list, list2);
                    if (known.contains(y)) continue;
                    nextLevel.add(y);
                    this.permutations.add(y);
                    known.add(y);
                }
            }
            currentLevel = nextLevel;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Permutation Group: " + this.permutations.size() + " permutation");
        for (List<Integer> permutation : this.permutations) {
            sb.append(permutation.toString());
        }
        return sb.toString();
    }

    public static List<Integer> combine(List<Integer> permutation1, List<Integer> permutation2) {
        ArrayList<Integer> intermediate = new ArrayList<Integer>(permutation1.size());
        int n = permutation1.size();
        for (int i = 0; i < n; ++i) {
            intermediate.add(permutation2.get(permutation1.get(i)));
        }
        return intermediate;
    }

    public static int getOrder(List<Integer> permutation) {
        List<Integer> copy = new ArrayList<Integer>(permutation);
        int n = permutation.size();
        for (int i = 0; i < n; ++i) {
            if (!(copy = PermutationGroup.combine(copy, permutation)).equals(permutation)) continue;
            return i + 1;
        }
        return 0;
    }

    public String getGroupTable() {
        int i;
        StringBuilder builder = new StringBuilder();
        builder.append("  |");
        for (i = 0; i < this.getOrder(); ++i) {
            builder.append(" ");
            builder.append(i);
        }
        builder.append("\n");
        builder.append("---");
        for (i = 0; i < this.getOrder(); ++i) {
            builder.append("--");
        }
        builder.append("\n");
        for (i = 0; i < this.getOrder(); ++i) {
            builder.append(i);
            builder.append(" |");
            for (int j = 0; j < this.getOrder(); ++j) {
                builder.append(" ");
                builder.append(this.permutations.indexOf(PermutationGroup.combine(this.permutations.get(i), this.permutations.get(j))));
            }
            builder.append("\n");
        }
        return builder.toString();
    }

    public int hashCode() {
        return this.getGroupTable().hashCode();
    }

    @Override
    public Iterator<List<Integer>> iterator() {
        return this.permutations.iterator();
    }
}

