/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.client;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import org.biojava.nbio.core.util.FlatFileCache;
import org.biojava.nbio.core.util.PrettyXMLWriter;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.align.StructureAlignment;
import org.biojava.nbio.structure.align.StructureAlignmentFactory;
import org.biojava.nbio.structure.align.ce.CeCPMain;
import org.biojava.nbio.structure.align.ce.CeMain;
import org.biojava.nbio.structure.align.client.CountProgressListener;
import org.biojava.nbio.structure.align.client.FarmJobParameters;
import org.biojava.nbio.structure.align.client.JFatCatClient;
import org.biojava.nbio.structure.align.client.JobKillException;
import org.biojava.nbio.structure.align.client.PdbPair;
import org.biojava.nbio.structure.align.events.AlignmentProgressListener;
import org.biojava.nbio.structure.align.fatcat.FatCatFlexible;
import org.biojava.nbio.structure.align.fatcat.FatCatRigid;
import org.biojava.nbio.structure.align.model.AFPChain;
import org.biojava.nbio.structure.align.util.AFPChainScorer;
import org.biojava.nbio.structure.align.util.AlignmentTools;
import org.biojava.nbio.structure.align.util.AtomCache;
import org.biojava.nbio.structure.align.util.ResourceManager;
import org.biojava.nbio.structure.align.xml.AFPChainXMLConverter;
import org.biojava.nbio.structure.align.xml.PdbPairsMessage;
import org.biojava.nbio.structure.domain.RemotePDPProvider;
import org.biojava.nbio.structure.io.LocalPDBDirectory;
import org.biojava.nbio.structure.scop.RemoteScopInstallation;
import org.biojava.nbio.structure.scop.ScopFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FarmJobRunnable
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(FarmJobRunnable.class);
    private static final String JFATCAT_NAME = "jfatcat.name";
    private static final String JFATCAT_VERSION = "jfatcat.version";
    private static ResourceManager resourceManager = ResourceManager.getResourceManager("jfatcat");
    FarmJobParameters params;
    String prevName1;
    Atom[] ca1;
    long startTime;
    long maxTime;
    int maxNrAlignments;
    int alignmentsCalculated;
    boolean waitForAlignments;
    private static final String randomUsername = FarmJobRunnable.getRandomUsername();
    boolean terminated = false;
    List<AlignmentProgressListener> progressListeners;
    CountProgressListener counter;
    String userName = null;
    protected AtomCache cache;
    boolean verbose = false;
    String version = null;
    private static final String alignURL = "/align/";

    public FarmJobRunnable(FarmJobParameters params) {
        this.params = params;
        this.verbose = false;
        this.cache = new AtomCache(params.getPdbFilePath(), params.getCacheFilePath());
        if (params.getServer() != null && !params.getServer().equals("")) {
            RemotePDPProvider pdpprovider = new RemotePDPProvider();
            String serverURL = params.getServer();
            if (!serverURL.endsWith("/")) {
                serverURL = serverURL + "/";
            }
            if (serverURL.endsWith(alignURL)) {
                serverURL = serverURL.substring(0, serverURL.length() - alignURL.length());
            }
            pdpprovider.setServer(serverURL + "/domains/");
            this.cache.setPdpprovider(pdpprovider);
            RemoteScopInstallation scop = new RemoteScopInstallation();
            scop.setServer(serverURL + "/domains/");
            ScopFactory.setScopDatabase(scop);
        }
        this.cache.setFetchBehavior(LocalPDBDirectory.FetchBehavior.FETCH_FILES);
        this.maxNrAlignments = params.getNrAlignments();
        this.progressListeners = null;
        this.userName = params.getUsername() == null ? randomUsername : params.getUsername();
        this.counter = new CountProgressListener();
        this.addAlignmentProgressListener(this.counter);
        this.waitForAlignments = true;
        if (params.isVerbose()) {
            this.verbose = true;
        }
    }

    public void addAlignmentProgressListener(AlignmentProgressListener listener) {
        if (this.progressListeners == null) {
            this.progressListeners = new ArrayList<AlignmentProgressListener>();
        }
        this.progressListeners.add(listener);
    }

    public void clearListeners() {
        if (this.progressListeners == null) {
            return;
        }
        this.progressListeners.clear();
        this.progressListeners = null;
    }

    protected static String getRandomUsername() {
        String name = "";
        try {
            InetAddress i = InetAddress.getLocalHost();
            name = name + i.getHostAddress();
            name = name + "_";
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        name = name + UUID.randomUUID();
        return name;
    }

    @Override
    public void run() {
        String appVersion = resourceManager.getString(JFATCAT_VERSION);
        String appName = resourceManager.getString(JFATCAT_NAME);
        logger.info("{} version: {}", (Object)appName, (Object)appVersion);
        this.startTime = System.currentTimeMillis();
        long maxSec = this.params.getTime();
        this.maxTime = maxSec < 5L ? Long.MAX_VALUE : this.startTime + (long)(this.params.getTime() * 1000);
        this.terminated = false;
        this.alignmentsCalculated = 0;
        this.maxNrAlignments = this.params.getNrAlignments();
        if (this.maxNrAlignments < 0) {
            this.maxNrAlignments = Integer.MAX_VALUE;
        }
        logger.info("running job for max {} alignments", (Object)this.maxNrAlignments);
        while (!this.terminated) {
            long tdiff;
            PdbPairsMessage msg = this.getAlignmentPairsFromServer();
            if (msg == null) {
                logger.error("Got null instead of alignment pairs from server.");
                this.randomSleep();
                continue;
            }
            SortedSet<PdbPair> alignmentPairs = msg.getPairs();
            logger.debug("{}: Server responded with {} pairs.", (Object)this.userName, (Object)alignmentPairs.size());
            ArrayList<String> results = new ArrayList<String>();
            String algorithmName = msg.getMethod();
            if (this.version == null) {
                this.setVersion(algorithmName);
            }
            for (PdbPair pair : alignmentPairs) {
                if (this.terminated) break;
                long now = System.currentTimeMillis();
                if (now >= this.maxTime) {
                    this.terminated = true;
                    break;
                }
                if (this.alignmentsCalculated >= this.maxNrAlignments) {
                    this.terminated = true;
                    break;
                }
                String name1 = pair.getName1();
                String name2 = pair.getName2();
                if (this.progressListeners != null) {
                    this.notifyStartAlignment(name1, name2);
                }
                try {
                    String resultXML = this.alignPair(name1, name2, algorithmName);
                    if (this.progressListeners != null) {
                        this.notifyEndAlignment();
                    }
                    results.add(resultXML);
                }
                catch (Exception e) {
                    logger.error("Problem aligning {} with {}", new Object[]{name1, name2, e});
                    StringWriter sw = new StringWriter();
                    PrettyXMLWriter xml = new PrettyXMLWriter(new PrintWriter(sw));
                    try {
                        xml.openTag("AFPChain");
                        xml.attribute("name1", name1);
                        xml.attribute("name2", name2);
                        xml.attribute("error", e.getMessage());
                        xml.closeTag("AFPChain");
                    }
                    catch (IOException ex) {
                        logger.error("Error occured converting alignment for {} and {} to XML", new Object[]{name1, name2, ex});
                    }
                    if (this.progressListeners != null) {
                        this.notifyEndAlignment();
                    }
                    results.add(sw.toString());
                }
                ++this.alignmentsCalculated;
            }
            this.sendResultsToServer(results);
            long end = System.currentTimeMillis();
            if (end >= this.maxTime) {
                logger.info("OK end of job: reached maxTime {}", (Object)this.maxTime);
                this.terminated = true;
            }
            if (this.alignmentsCalculated >= this.maxNrAlignments) {
                logger.info("OK end of job: reached maxNrAlignments", (Object)this.maxNrAlignments);
                this.terminated = true;
            }
            if ((tdiff = end - this.startTime) == 0L) continue;
            logger.info(this.userName + String.format(": job has run for :  %.2f", (double)tdiff / 1000.0 / 60.0) + " min.");
            logger.info("{}: total nr of alignments calculated: {}", (Object)this.userName, (Object)this.alignmentsCalculated);
            if (this.alignmentsCalculated <= 0) continue;
            logger.info(this.userName + String.format(": average time / alignment: %.2f", (double)(tdiff / (long)this.alignmentsCalculated) / 1000.0) + " sec.");
        }
        logger.info(this.userName + ": jFATCAT job result: " + this.counter);
        this.clearListeners();
        this.cache.notifyShutdown();
    }

    private void setVersion(String algorithmName) {
        try {
            StructureAlignment algorithm = StructureAlignmentFactory.getAlgorithm(algorithmName);
            this.version = algorithm.getVersion();
        }
        catch (StructureException e) {
            throw new RuntimeException("Couldn't set version for algorithm \"" + algorithmName + "\"", e);
        }
    }

    private void notifyStartAlignment(String name1, String name2) {
        if (this.progressListeners != null) {
            for (AlignmentProgressListener li : this.progressListeners) {
                li.alignmentStarted(name1, name2);
            }
        }
    }

    private void notifyEndAlignment() {
        if (this.progressListeners != null) {
            for (AlignmentProgressListener li : this.progressListeners) {
                li.alignmentEnded();
            }
        }
    }

    private void notifyRequestingAlignments(int nrAlignments) {
        if (this.progressListeners != null) {
            for (AlignmentProgressListener li : this.progressListeners) {
                li.requestingAlignmentsFromServer(nrAlignments);
            }
        }
    }

    private void notifySubmittingAlignments(int nrAlignments, String message) {
        if (this.progressListeners != null) {
            for (AlignmentProgressListener li : this.progressListeners) {
                li.sentResultsToServer(nrAlignments, message);
            }
        }
    }

    public String alignPair(String name1, String name2) throws StructureException, IOException {
        return this.alignPair(name1, name2, "jFatCat_rigid");
    }

    public String alignPair(String name1, String name2, String algorithmName) throws StructureException, IOException {
        StructureAlignment algorithm = this.getAlgorithm(algorithmName);
        if (this.verbose) {
            logger.debug("aligning {} against {}", (Object)name1, (Object)name2);
        }
        long startTime = System.currentTimeMillis();
        if (this.prevName1 == null) {
            this.initMaster(name1);
        }
        if (!this.prevName1.equals(name1)) {
            this.initMaster(name1);
        }
        Atom[] ca2 = this.cache.getAtoms(name2);
        AFPChain afpChain = algorithm.align(this.ca1, ca2);
        afpChain.setName1(name1);
        afpChain.setName2(name2);
        try {
            double tmScore = AFPChainScorer.getTMScore(afpChain, this.ca1, ca2);
            afpChain.setTMScore(tmScore);
        }
        catch (RuntimeException e) {
            logger.error("ca1 size: {} ca2 length: {} {}  {}", new Object[]{this.ca1.length, ca2.length, afpChain.getName1(), afpChain.getName2(), e});
        }
        long endTime = System.currentTimeMillis();
        long calcTime = endTime - startTime;
        if (this.verbose) {
            boolean isCP = !AlignmentTools.isSequentialAlignment(afpChain, false);
            String msg = "finished alignment: " + name1 + " vs. " + name2 + " in " + (double)calcTime / 1000.0 + " sec.";
            msg = msg + " algo: " + algorithmName + " v:" + this.version + " " + afpChain;
            if (isCP) {
                msg = msg + "HAS A CIRCULAR PERMUTATION!!!";
            }
            logger.debug(msg);
        }
        if (this.verbose) {
            this.printMemory();
        }
        afpChain.setCalculationTime(calcTime);
        return AFPChainXMLConverter.toXML(afpChain, this.ca1, ca2);
    }

    private void printMemory() {
        int size = 0x100000;
        long heapSize = Runtime.getRuntime().totalMemory() / (long)size;
        long heapMaxSize = Runtime.getRuntime().maxMemory() / (long)size;
        long heapFreeSize = Runtime.getRuntime().freeMemory() / (long)size;
        StringBuilder msg = new StringBuilder();
        msg.append("  total: ").append(heapSize).append(" M");
        msg.append(" max: ").append(heapMaxSize).append(" M");
        msg.append(" free: ").append(heapFreeSize).append(" M");
        logger.debug(msg.toString());
    }

    private StructureAlignment getAlgorithm(String algorithmName) throws StructureException {
        StructureAlignment algorithm = null;
        algorithm = algorithmName == null ? new FatCatRigid() : (algorithmName.equalsIgnoreCase("jFatCat_rigid") ? new FatCatRigid() : (algorithmName.equalsIgnoreCase("jCE") ? new CeMain() : (algorithmName.equalsIgnoreCase("jCE Circular Permutation") ? new CeCPMain() : (algorithmName.equalsIgnoreCase("jFatCat_flexible") ? new FatCatFlexible() : StructureAlignmentFactory.getAlgorithm(algorithmName)))));
        if (algorithm == null) {
            algorithm = new FatCatRigid();
        }
        return algorithm;
    }

    private void initMaster(String name1) throws IOException, StructureException {
        this.ca1 = this.cache.getAtoms(name1);
        this.prevName1 = name1;
    }

    protected PdbPairsMessage getAlignmentPairsFromServer() {
        String url = this.params.getServer();
        int nrPairs = this.params.getStepSize();
        if (this.maxNrAlignments < nrPairs) {
            nrPairs = this.maxNrAlignments;
        }
        SortedSet<Object> allPairs = new TreeSet();
        PdbPairsMessage msg = null;
        try {
            if (this.progressListeners != null) {
                this.notifyRequestingAlignments(nrPairs);
            }
            if (!this.waitForAlignments) {
                msg = JFatCatClient.getPdbPairs(url, nrPairs, this.userName);
                allPairs = msg.getPairs();
            } else {
                while (allPairs.isEmpty()) {
                    msg = JFatCatClient.getPdbPairs(url, nrPairs, this.userName);
                    allPairs = msg.getPairs();
                    if (!allPairs.isEmpty()) continue;
                    this.randomSleep();
                }
            }
        }
        catch (JobKillException k) {
            logger.debug("Terminating job", (Throwable)k);
            this.terminate();
        }
        catch (Exception e) {
            logger.error("Error while requesting alignment pairs", (Throwable)e);
            this.randomSleep();
        }
        return msg;
    }

    private void randomSleep() {
        try {
            int delay = JFatCatClient.getRandomSleepTime();
            logger.debug("sleeping {} sec.", (Object)(delay / 1000));
            Thread.sleep(delay);
        }
        catch (InterruptedException ex) {
            logger.trace("InterruptedException occurred while sleeping", (Throwable)ex);
        }
    }

    protected void sendResultsToServer(List<String> results) {
        String serverLocation = this.params.getServer();
        if (results.size() < 1) {
            return;
        }
        String fullXml = "<alignments>";
        for (String xml : results) {
            fullXml = fullXml + xml;
        }
        fullXml = fullXml + "</alignments>";
        String msg = "";
        try {
            msg = JFatCatClient.sendMultiAFPChainToServer(serverLocation, fullXml, this.userName, this.version);
        }
        catch (JobKillException e) {
            logger.info("{} Got Job Kill message from server, terminating...", (Object)this.userName, (Object)e);
            this.terminate();
        }
        if (this.progressListeners != null) {
            this.notifySubmittingAlignments(results.size(), msg);
        }
        logger.info("{}: Sent {} results to server. job status: {}", new Object[]{this.userName, results.size(), this.counter});
        logger.info("{}: fileCache size: {}", (Object)this.userName, (Object)FlatFileCache.getInstance().size());
    }

    public synchronized void terminate() {
        this.terminated = true;
    }

    public boolean isWaitForAlignments() {
        return this.waitForAlignments;
    }

    public void setWaitForAlignments(boolean waitForAlignments) {
        this.waitForAlignments = waitForAlignments;
    }
}

