/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.geometry;

import java.util.ArrayList;
import java.util.List;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Point3i;
import javax.vecmath.Quat4d;
import org.biojava.nbio.structure.symmetry.geometry.IcosahedralSampler;
import org.biojava.nbio.structure.symmetry.geometry.Permute;

public final class SphereSampler {
    private static final List<Quat4d> orientations;
    private static final double[][] cubeSyms;
    private static final double delta = 0.15846;
    private static final double sigma = 0.0;
    private static final int ntot = 7416;
    private static final int ncell = 309;
    private static final int nent = 18;
    private static final int[] k;
    private static final int[] l;
    private static final int[] m;
    private static final int[] mult;

    private SphereSampler() {
    }

    public static int getSphereCount() {
        return orientations.size();
    }

    public static Quat4d getQuat4d(int index) {
        return orientations.get(index);
    }

    public static void getAxisAngle(int index, AxisAngle4f axisAngle) {
        axisAngle.set(orientations.get(index));
    }

    public static void getAxisAngle(int index, AxisAngle4d axisAngle) {
        axisAngle.set(orientations.get(index));
    }

    private static double pind(double ind, double delta, double sigma) {
        return sigma == 0.0 ? ind * delta : Math.sinh(sigma * ind * delta) / sigma;
    }

    static {
        cubeSyms = new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, -1.0}, {1.0, 1.0, -1.0, 1.0}, {1.0, 1.0, -1.0, -1.0}, {1.0, -1.0, 1.0, 1.0}, {1.0, -1.0, 1.0, -1.0}, {1.0, -1.0, -1.0, 1.0}, {1.0, -1.0, -1.0, -1.0}, {1.0, 1.0, 0.0, 0.0}, {1.0, -1.0, 0.0, 0.0}, {1.0, 0.0, 1.0, 0.0}, {1.0, 0.0, -1.0, 0.0}, {1.0, 0.0, 0.0, 1.0}, {1.0, 0.0, 0.0, -1.0}, {0.0, 1.0, 1.0, 0.0}, {0.0, 1.0, -1.0, 0.0}, {0.0, 1.0, 0.0, 1.0}, {0.0, 1.0, 0.0, -1.0}, {0.0, 0.0, 1.0, 1.0}, {0.0, 0.0, 1.0, -1.0}};
        k = new int[]{0, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5};
        l = new int[]{0, 1, 0, 2, 2, 1, 3, 3, 0, 2, 2, 4, 4, 4, 1, 3, 3, 5};
        m = new int[]{0, 1, 0, 0, 2, 1, 1, 3, 0, 0, 2, 0, 2, 4, 1, 1, 3, 1};
        mult = new int[]{1, 8, 6, 12, 8, 24, 24, 8, 6, 24, 24, 12, 24, 8, 24, 48, 24, 24};
        ArrayList<Quat4d> myorientations = new ArrayList<Quat4d>();
        for (int i = 0; i < IcosahedralSampler.getSphereCount(); ++i) {
            myorientations.add(IcosahedralSampler.getQuat4d(i));
        }
        ArrayList<Quat4d> grid = new ArrayList<Quat4d>();
        int ncell1 = 0;
        for (int n = 0; n < 18; ++n) {
            Permute p = new Permute(new Point3i(k[n], l[n], m[n]));
            assert (mult[n] == p.size());
            for (int i = 0; i < mult[n]; ++i) {
                Point3i t = p.get(i);
                grid.add(new Quat4d(1.0, SphereSampler.pind(0.5 * (double)t.x, 0.15846, 0.0), SphereSampler.pind(0.5 * (double)t.y, 0.15846, 0.0), SphereSampler.pind(0.5 * (double)t.z, 0.15846, 0.0)));
            }
            ncell1 += mult[n];
        }
        assert (ncell1 == 309);
        int nc = grid.size();
        assert (nc == 309);
        for (int n = 1; n < 24; ++n) {
            Quat4d q = new Quat4d(cubeSyms[n][0], cubeSyms[n][1], cubeSyms[n][2], cubeSyms[n][3]);
            for (int i = 0; i < nc; ++i) {
                Quat4d qs = new Quat4d();
                qs.mul(q, (Quat4d)grid.get(i));
                grid.add(qs);
            }
        }
        assert (grid.size() == 7416);
        myorientations.addAll(grid);
        orientations = myorientations;
    }
}

