/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.contact;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.biojava.nbio.core.util.SingleLinkageClusterer;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.asa.AsaCalculator;
import org.biojava.nbio.structure.contact.StructureInterface;
import org.biojava.nbio.structure.contact.StructureInterfaceCluster;
import org.biojava.nbio.structure.xtal.CrystalBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StructureInterfaceList
implements Serializable,
Iterable<StructureInterface> {
    private static final Logger logger = LoggerFactory.getLogger(StructureInterfaceList.class);
    public static final double DEFAULT_MINIMUM_INTERFACE_AREA = 35.0;
    public static final int DEFAULT_ASA_SPHERE_POINTS = 3000;
    public static final int DEFAULT_MIN_COFACTOR_SIZE = 40;
    public static final double DEFAULT_CONTACT_OVERLAP_SCORE_CLUSTER_CUTOFF = 0.2;
    private static final long serialVersionUID = 1L;
    private List<StructureInterface> list = new ArrayList<StructureInterface>();
    private List<StructureInterfaceCluster> clusters;

    public void add(StructureInterface interf) {
        this.list.add(interf);
    }

    public int size() {
        return this.list.size();
    }

    public StructureInterface get(int id) {
        return this.list.get(id - 1);
    }

    public void calcAsas() {
        this.calcAsas(3000, Runtime.getRuntime().availableProcessors(), 40);
    }

    public void calcAsas(int nSpherePoints, int nThreads, int cofactorSizeToUse) {
        TreeMap<Object, Atom[]> uniqAsaChains = new TreeMap<Object, Atom[]>();
        TreeMap<String, double[]> chainAsas = new TreeMap<String, double[]>();
        for (StructureInterface interf : this.list) {
            String molecId1 = interf.getMoleculeIds().getFirst() + interf.getTransforms().getFirst().getTransformId();
            String molecId2 = interf.getMoleculeIds().getSecond() + interf.getTransforms().getSecond().getTransformId();
            uniqAsaChains.put(molecId1, interf.getFirstAtomsForAsa(cofactorSizeToUse));
            uniqAsaChains.put(molecId2, interf.getSecondAtomsForAsa(cofactorSizeToUse));
        }
        long start = System.currentTimeMillis();
        for (String molecId : uniqAsaChains.keySet()) {
            AsaCalculator asaCalc = new AsaCalculator((Atom[])uniqAsaChains.get(molecId), 1.4, nSpherePoints, nThreads);
            double[] atomAsas = asaCalc.calculateAsas();
            chainAsas.put(molecId, atomAsas);
        }
        long end = System.currentTimeMillis();
        logger.debug("Calculated uncomplexed ASA for " + uniqAsaChains.size() + " orientation-unique chains. " + "Time: " + (double)(end - start) / 1000.0 + " s");
        start = System.currentTimeMillis();
        for (StructureInterface interf : this.list) {
            String molecId1 = interf.getMoleculeIds().getFirst() + interf.getTransforms().getFirst().getTransformId();
            String molecId2 = interf.getMoleculeIds().getSecond() + interf.getTransforms().getSecond().getTransformId();
            interf.setAsas((double[])chainAsas.get(molecId1), (double[])chainAsas.get(molecId2), nSpherePoints, nThreads, cofactorSizeToUse);
        }
        end = System.currentTimeMillis();
        logger.debug("Calculated complexes ASA for " + this.list.size() + " pairwise complexes. " + "Time: " + (double)(end - start) / 1000.0 + " s");
        this.sort();
    }

    public void sort() {
        Collections.sort(this.list);
        int i = 1;
        for (StructureInterface interf : this.list) {
            interf.setId(i);
            ++i;
        }
    }

    public void removeInterfacesBelowArea() {
        this.removeInterfacesBelowArea(35.0);
    }

    public void removeInterfacesBelowArea(double area) {
        Iterator<StructureInterface> it = this.iterator();
        while (it.hasNext()) {
            StructureInterface interf = it.next();
            if (!(interf.getTotalArea() < area)) continue;
            it.remove();
        }
    }

    public List<StructureInterfaceCluster> getClusters() {
        return this.getClusters(0.2);
    }

    public List<StructureInterfaceCluster> getClusters(double contactOverlapScoreClusterCutoff) {
        Iterator<StructureInterfaceCluster> iInterf;
        if (this.clusters != null) {
            return this.clusters;
        }
        this.clusters = new ArrayList<StructureInterfaceCluster>();
        if (this.list.size() == 0) {
            return this.clusters;
        }
        double[][] matrix = new double[this.list.size()][this.list.size()];
        for (int i = 0; i < this.list.size(); ++i) {
            for (int j = i + 1; j < this.list.size(); ++j) {
                double maxScore;
                iInterf = this.list.get(i);
                StructureInterface jInterf = this.list.get(j);
                double scoreDirect = ((StructureInterface)((Object)iInterf)).getContactOverlapScore(jInterf, false);
                double scoreInvert = ((StructureInterface)((Object)iInterf)).getContactOverlapScore(jInterf, true);
                matrix[i][j] = maxScore = Math.max(scoreDirect, scoreInvert);
            }
        }
        SingleLinkageClusterer slc = new SingleLinkageClusterer(matrix, true);
        Map clusteredIndices = slc.getClusters(contactOverlapScoreClusterCutoff);
        iInterf = clusteredIndices.keySet().iterator();
        while (iInterf.hasNext()) {
            int clusterIdx = (Integer)iInterf.next();
            ArrayList<StructureInterface> members = new ArrayList<StructureInterface>();
            Iterator iterator = ((Set)clusteredIndices.get(clusterIdx)).iterator();
            while (iterator.hasNext()) {
                int idx = (Integer)iterator.next();
                members.add(this.list.get(idx));
            }
            StructureInterfaceCluster cluster = new StructureInterfaceCluster();
            cluster.setMembers(members);
            double averageScore = 0.0;
            int countPairs = 0;
            for (int i = 0; i < members.size(); ++i) {
                for (int j = i + 1; j < members.size(); ++j) {
                    averageScore += matrix[((StructureInterface)members.get(i)).getId() - 1][((StructureInterface)members.get(j)).getId() - 1];
                    ++countPairs;
                }
            }
            averageScore = countPairs > 0 ? (averageScore /= (double)countPairs) : 1.0;
            cluster.setAverageScore(averageScore);
            this.clusters.add(cluster);
        }
        for (StructureInterfaceCluster cluster : this.clusters) {
            for (StructureInterface interf : cluster.getMembers()) {
                interf.setCluster(cluster);
            }
        }
        Collections.sort(this.clusters, new Comparator<StructureInterfaceCluster>(){

            @Override
            public int compare(StructureInterfaceCluster o1, StructureInterfaceCluster o2) {
                return Double.compare(o2.getTotalArea(), o1.getTotalArea());
            }
        });
        int id = 1;
        for (StructureInterfaceCluster cluster : this.clusters) {
            cluster.setId(id);
            ++id;
        }
        return this.clusters;
    }

    @Override
    public Iterator<StructureInterface> iterator() {
        return this.list.iterator();
    }

    public String toString() {
        return this.list.toString();
    }

    public static StructureInterfaceList calculateInterfaces(Structure struc) {
        CrystalBuilder builder = new CrystalBuilder(struc);
        StructureInterfaceList interfaces = builder.getUniqueInterfaces();
        logger.debug("Calculating ASA for " + interfaces.size() + " potential interfaces");
        interfaces.calcAsas(3000, Runtime.getRuntime().availableProcessors(), 40);
        interfaces.removeInterfacesBelowArea();
        interfaces.getClusters();
        logger.debug("Found " + interfaces.size() + " interfaces");
        return interfaces;
    }
}

