/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.domain;

import java.util.List;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.StructureTools;
import org.biojava.nbio.structure.domain.pdp.ClusterDomains;
import org.biojava.nbio.structure.domain.pdp.CutDomain;
import org.biojava.nbio.structure.domain.pdp.CutSites;
import org.biojava.nbio.structure.domain.pdp.Domain;
import org.biojava.nbio.structure.domain.pdp.GetDistanceMatrix;
import org.biojava.nbio.structure.domain.pdp.PDPDistanceMatrix;
import org.biojava.nbio.structure.domain.pdp.ShortSegmentRemover;

public class LocalProteinDomainParser {
    private LocalProteinDomainParser() {
    }

    public static List<Domain> suggestDomains(Structure s) throws StructureException {
        Atom[] ca = StructureTools.getRepresentativeAtomArray(s);
        return LocalProteinDomainParser.suggestDomains(ca);
    }

    public static List<Domain> suggestDomains(Atom[] ca) throws StructureException {
        GetDistanceMatrix distMaxCalculator = new GetDistanceMatrix();
        PDPDistanceMatrix pdpMatrix = distMaxCalculator.getDistanceMatrix(ca);
        Domain dom = new Domain();
        Chain c = ca[0].getGroup().getChain();
        dom.setId("D" + c.getStructure().getPDBCode() + c.getId() + "1");
        dom.setSize(ca.length);
        dom.setNseg(1);
        dom.getSegmentAtPos(0).setFrom(0);
        dom.getSegmentAtPos(0).setTo(ca.length - 1);
        CutSites cutSites = new CutSites();
        CutDomain cutDomain = new CutDomain(ca, pdpMatrix);
        cutDomain.cutDomain(dom, cutSites, pdpMatrix);
        List<Domain> domains = cutDomain.getDomains();
        domains = ClusterDomains.cluster(domains, pdpMatrix);
        ShortSegmentRemover.cleanup(domains);
        return domains;
    }
}

