/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.biojava.nbio.structure.symmetry.core.HelicalRepeatUnit;
import org.biojava.nbio.structure.symmetry.core.Helix;
import org.biojava.nbio.structure.symmetry.core.HelixExtender;
import org.biojava.nbio.structure.symmetry.core.HelixLayers;
import org.biojava.nbio.structure.symmetry.core.QuatSuperpositionScorer;
import org.biojava.nbio.structure.symmetry.core.QuatSymmetryParameters;
import org.biojava.nbio.structure.symmetry.core.QuatSymmetryScores;
import org.biojava.nbio.structure.symmetry.core.Subunits;
import org.biojava.nbio.structure.symmetry.geometry.SuperPosition;

public class HelixSolver {
    private Subunits subunits = null;
    private int fold = 1;
    private HelixLayers helixLayers = new HelixLayers();
    private QuatSymmetryParameters parameters = null;
    boolean modified = true;

    public HelixSolver(Subunits subunits, int fold, QuatSymmetryParameters parameters) {
        this.subunits = subunits;
        this.fold = fold;
        this.parameters = parameters;
    }

    public HelixLayers getSymmetryOperations() {
        if (this.modified) {
            this.solve();
            this.modified = false;
        }
        return this.helixLayers;
    }

    private void solve() {
        if (!this.preCheck()) {
            return;
        }
        HelicalRepeatUnit unit = new HelicalRepeatUnit(this.subunits);
        List<Point3d> repeatUnitCenters = unit.getRepeatUnitCenters();
        List<Point3d[]> repeatUnits = unit.getRepeatUnits();
        HashSet<List<Integer>> permutations = new HashSet<List<Integer>>();
        double minRise = this.parameters.getMinimumHelixRise() * (double)this.fold;
        Map<Integer[], Integer> interactionMap = unit.getInteractingRepeatUnits();
        int maxLayerLineLength = 0;
        for (Map.Entry<Integer[], Integer> entry : interactionMap.entrySet()) {
            List<Integer> permutation;
            Object[] pair = entry.getKey();
            if (this.parameters.isVerbose()) {
                System.out.println("HelixSolver: pair: " + Arrays.toString(pair));
            }
            int contacts = entry.getValue();
            Point3d[] h1 = null;
            Point3d[] h2 = null;
            h1 = SuperPosition.clonePoint3dArray(repeatUnits.get((Integer)pair[0]));
            h2 = SuperPosition.clonePoint3dArray(repeatUnits.get((Integer)pair[1]));
            Matrix4d transformation = SuperPosition.superposeWithTranslation(h1, h2);
            double rmsd = SuperPosition.rmsd(h1, h2);
            double rise = HelixSolver.getRise(transformation, repeatUnitCenters.get((Integer)pair[0]), repeatUnitCenters.get((Integer)pair[1]));
            double angle = HelixSolver.getAngle(transformation);
            if (this.parameters.isVerbose()) {
                System.out.println();
                System.out.println("Original rmsd: " + rmsd);
                System.out.println("Original rise: " + rise);
                System.out.println("Original angle: " + Math.toDegrees(angle));
            }
            if (rmsd > this.parameters.getRmsdThreshold() || Math.abs(rise) < minRise || permutations.contains(permutation = this.getPermutation(transformation))) continue;
            permutations.add(permutation);
            if (this.parameters.isVerbose()) {
                System.out.println("Permutation: " + permutation);
            }
            HashSet<Integer> permSet = new HashSet<Integer>();
            int count = 0;
            boolean valid = true;
            for (int i = 0; i < permutation.size(); ++i) {
                if (permutation.get(i) == i) {
                    valid = false;
                    break;
                }
                if (permutation.get(i) == -1) continue;
                permSet.add(permutation.get(i));
                permSet.add(i);
                ++count;
            }
            if (!valid) {
                if (!this.parameters.isVerbose()) continue;
                System.out.println("Invalid mapping");
                continue;
            }
            if (permSet.size() != this.subunits.getSubunitCount()) {
                if (!this.parameters.isVerbose()) continue;
                System.out.println("Not all subunits involved in permutation");
                continue;
            }
            if (count == permutation.size()) continue;
            ArrayList<Point3d> point1 = new ArrayList<Point3d>();
            ArrayList<Point3d> point2 = new ArrayList<Point3d>();
            List<Point3d> centers = this.subunits.getOriginalCenters();
            for (int j = 0; j < permutation.size(); ++j) {
                if (permutation.get(j) == -1) continue;
                point1.add(new Point3d(centers.get(j)));
                point2.add(new Point3d(centers.get(permutation.get(j))));
            }
            h1 = new Point3d[point1.size()];
            h2 = new Point3d[point2.size()];
            point1.toArray(h1);
            point2.toArray(h2);
            double subunitRmsd = 0.0;
            if (point1.size() > 2) {
                transformation = SuperPosition.superposeWithTranslation(h1, h2);
                subunitRmsd = SuperPosition.rmsd(h1, h2);
                rise = HelixSolver.getRise(transformation, repeatUnitCenters.get((Integer)pair[0]), repeatUnitCenters.get((Integer)pair[1]));
                angle = HelixSolver.getAngle(transformation);
                if (this.parameters.isVerbose()) {
                    System.out.println("Subunit rmsd: " + subunitRmsd);
                    System.out.println("Subunit rise: " + rise);
                    System.out.println("Subunit angle: " + Math.toDegrees(angle));
                }
                if (subunitRmsd > this.parameters.getRmsdThreshold() || Math.abs(rise) < minRise || subunitRmsd > this.parameters.getHelixRmsdToRiseRatio() * Math.abs(rise)) continue;
            }
            point1.clear();
            point2.clear();
            List<Point3d[]> traces = this.subunits.getTraces();
            for (int j = 0; j < permutation.size(); ++j) {
                if (permutation.get(j) == -1) continue;
                for (Point3d p : traces.get(j)) {
                    point1.add(new Point3d(p));
                }
                for (Point3d p : traces.get(permutation.get(j))) {
                    point2.add(new Point3d(p));
                }
            }
            h1 = new Point3d[point1.size()];
            h2 = new Point3d[point2.size()];
            point1.toArray(h1);
            point2.toArray(h2);
            Point3d[] h3 = SuperPosition.clonePoint3dArray(h1);
            transformation = SuperPosition.superposeWithTranslation(h1, h2);
            Point3d xtrans = SuperPosition.centroid(h3);
            xtrans.negate();
            double traceRmsd = SuperPosition.rmsd(h1, h2);
            rise = HelixSolver.getRise(transformation, repeatUnitCenters.get((Integer)pair[0]), repeatUnitCenters.get((Integer)pair[1]));
            angle = HelixSolver.getAngle(transformation);
            if (this.parameters.isVerbose()) {
                System.out.println("Trace rmsd: " + traceRmsd);
                System.out.println("Trace rise: " + rise);
                System.out.println("Trace angle: " + Math.toDegrees(angle));
                System.out.println("Permutation: " + permutation);
            }
            if (traceRmsd > this.parameters.getRmsdThreshold() || Math.abs(rise) < minRise || angle < Math.toRadians(this.parameters.getMinimumHelixAngle()) || traceRmsd > this.parameters.getHelixRmsdToRiseRatio() * Math.abs(rise)) continue;
            AxisAngle4d a1 = new AxisAngle4d();
            a1.set(transformation);
            Helix helix = new Helix();
            helix.setTransformation(transformation);
            helix.setPermutation(permutation);
            helix.setRise(rise);
            transformation.setElement(3, 3, 1.0);
            transformation.invert();
            QuatSymmetryScores scores = QuatSuperpositionScorer.calcScores(this.subunits, transformation, permutation);
            scores.setRmsdCenters(subunitRmsd);
            helix.setScores(scores);
            helix.setFold(this.fold);
            helix.setContacts(contacts);
            helix.setRepeatUnits(unit.getRepeatUnitIndices());
            if (this.parameters.isVerbose()) {
                System.out.println("Layerlines: " + helix.getLayerLines());
            }
            for (List<Integer> line : helix.getLayerLines()) {
                maxLayerLineLength = Math.max(maxLayerLineLength, line.size());
            }
            this.helixLayers.addHelix(helix);
        }
        if (maxLayerLineLength < 3) {
            this.helixLayers.clear();
        }
    }

    private void checkSelfLimitingHelix(Helix helix) {
        HelixExtender he = new HelixExtender(this.subunits, helix);
        Point3d[] extendedHelix = he.extendHelix(1);
        int overlap1 = 0;
        for (Point3d[] trace : this.subunits.getTraces()) {
            for (Point3d pt : trace) {
                for (Point3d pe : extendedHelix) {
                    if (!(pt.distance(pe) < 5.0)) continue;
                    ++overlap1;
                }
            }
        }
        extendedHelix = he.extendHelix(-1);
        int overlap2 = 0;
        for (Point3d[] trace : this.subunits.getTraces()) {
            for (Point3d pt : trace) {
                for (Point3d pe : extendedHelix) {
                    if (!(pt.distance(pe) < 3.0)) continue;
                    ++overlap2;
                }
            }
        }
        System.out.println("SelfLimiting helix: " + overlap1 + ", " + overlap2);
    }

    private boolean preCheck() {
        if (this.subunits.getSubunitCount() < 3) {
            return false;
        }
        List<Integer> folds = this.subunits.getFolds();
        int maxFold = folds.get(folds.size() - 1);
        return maxFold > 1;
    }

    private List<Integer> getPermutation(Matrix4d transformation) {
        double rmsdThresholdSq = Math.pow(this.parameters.getRmsdThreshold(), 2.0);
        List<Point3d> centers = this.subunits.getOriginalCenters();
        List<Integer> seqClusterId = this.subunits.getSequenceClusterIds();
        ArrayList<Integer> permutations = new ArrayList<Integer>(centers.size());
        double[] dSqs = new double[centers.size()];
        boolean[] used = new boolean[centers.size()];
        Arrays.fill(used, false);
        for (int i = 0; i < centers.size(); ++i) {
            Point3d tCenter = new Point3d(centers.get(i));
            transformation.transform(tCenter);
            int permutation = -1;
            double minDistSq = Double.MAX_VALUE;
            for (int j = 0; j < centers.size(); ++j) {
                double dSq;
                if (seqClusterId.get(i) != seqClusterId.get(j) || used[j] || !((dSq = tCenter.distanceSquared(centers.get(j))) < minDistSq) || !(dSq <= rmsdThresholdSq)) continue;
                minDistSq = dSq;
                permutation = j;
                dSqs[j] = dSq;
            }
            if (permutations.size() == permutation) {
                permutation = -1;
            }
            if (permutation != -1) {
                used[permutation] = true;
            }
            permutations.add(permutation);
        }
        return permutations;
    }

    private static double getRise(Matrix4d transformation, Point3d p1, Point3d p2) {
        AxisAngle4d axis = HelixSolver.getAxisAngle(transformation);
        Vector3d h = new Vector3d(axis.x, axis.y, axis.z);
        Vector3d p = new Vector3d();
        p.sub((Tuple3d)p1, (Tuple3d)p2);
        return p.dot(h);
    }

    private static double getAngle(Matrix4d transformation) {
        return HelixSolver.getAxisAngle((Matrix4d)transformation).angle;
    }

    private static AxisAngle4d getAxisAngle(Matrix4d transformation) {
        AxisAngle4d axis = new AxisAngle4d();
        axis.set(transformation);
        return axis;
    }
}

