/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.fatcat.calc;

import java.util.List;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.align.fatcat.calc.AFPChainer;
import org.biojava.nbio.structure.align.fatcat.calc.FatCatParameters;
import org.biojava.nbio.structure.align.model.AFP;
import org.biojava.nbio.structure.align.model.AFPChain;

public class AFPPostProcessor {
    public static final boolean debug = false;

    public static void postProcess(FatCatParameters params, AFPChain afpChain, Atom[] ca1, Atom[] ca2) {
        int blockNum = afpChain.getBlockNum();
        afpChain.setBlockNumIni(blockNum);
        afpChain.setBlockNumIni(blockNum);
        AFPPostProcessor.splitBlock(params, afpChain, ca1, ca2);
        blockNum = afpChain.getBlockNum();
        afpChain.setBlockNumSpt(blockNum);
        AFPPostProcessor.deleteBlock(params, afpChain, ca1, ca2);
        AFPPostProcessor.mergeBlock(params, afpChain, ca1, ca2);
        afpChain.setBlockNumClu(afpChain.getBlockNum());
    }

    private static void splitBlock(FatCatParameters params, AFPChain afpChain, Atom[] ca1, Atom[] ca2) {
        int i;
        int blockNum;
        int maxTra = params.getMaxTra();
        double badRmsd = params.getBadRmsd();
        int blockNum0 = blockNum;
        double[] blockRmsd = afpChain.getBlockRmsd();
        int[] blockSize = afpChain.getBlockSize();
        int[] block2Afp = afpChain.getBlock2Afp();
        double[] afpChainTwiList = afpChain.getAfpChainTwiList();
        int bk = 0;
        for (blockNum = afpChain.getBlockNum(); blockNum < maxTra + 1; ++blockNum) {
            double maxs = 0.0;
            for (i = 0; i < blockNum; ++i) {
                if (!(blockRmsd[i] > maxs) || blockSize[i] <= 2) continue;
                maxs = blockRmsd[i];
                bk = i;
            }
            if (maxs < badRmsd) break;
            double maxt = 0.0;
            int cut = 0;
            for (i = 1; i < blockSize[bk]; ++i) {
                int a = i + block2Afp[bk];
                if (!(afpChainTwiList[a] > maxt)) continue;
                maxt = afpChainTwiList[a];
                cut = i;
            }
            for (i = blockNum - 1; i > bk; --i) {
                block2Afp[i + 1] = block2Afp[i];
                blockSize[i + 1] = blockSize[i];
                blockRmsd[i + 1] = blockRmsd[i];
            }
            block2Afp[bk + 1] = cut + block2Afp[bk];
            blockSize[bk + 1] = blockSize[bk] - cut;
            blockSize[bk] = cut;
            int[] afpChainList = afpChain.getAfpChainList();
            blockRmsd[bk + 1] = AFPChainer.calAfpRmsd(blockSize[bk + 1], afpChainList, block2Afp[bk + 1], afpChain, ca1, ca2);
            blockRmsd[bk] = AFPChainer.calAfpRmsd(blockSize[bk], afpChainList, block2Afp[bk], afpChain, ca1, ca2);
            afpChain.setAfpChainList(afpChainList);
        }
        if (blockNum - blockNum0 > 0) {
            for (i = 0; i < blockNum; ++i) {
            }
        }
        afpChain.setBlockNum(blockNum);
        afpChain.setBlockSize(blockSize);
        afpChain.setBlockRmsd(blockRmsd);
        afpChain.setBlock2Afp(block2Afp);
    }

    private static void deleteBlock(FatCatParameters params, AFPChain afpChain, Atom[] ca1, Atom[] ca2) {
        int blockNum = afpChain.getBlockNum();
        List<AFP> afpSet = afpChain.getAfpSet();
        int[] afpChainList = afpChain.getAfpChainList();
        int[] block2Afp = afpChain.getBlock2Afp();
        int[] blockSize = afpChain.getBlockSize();
        double[] blockRmsd = afpChain.getBlockRmsd();
        int fragLen = params.getFragLen();
        if (blockNum <= 1) {
            return;
        }
        int blockNumOld = blockNum;
        int e2 = 0;
        int e1 = 0;
        for (int i = 0; i < blockNum; ++i) {
            int len;
            int b1 = e1;
            int b2 = e2;
            if (i < blockNum - 1) {
                e1 = afpSet.get(afpChainList[block2Afp[i + 1]]).getP1();
                e2 = afpSet.get(afpChainList[block2Afp[i + 1]]).getP2();
            } else {
                e1 = ca1.length;
                e2 = ca2.length;
            }
            if (blockSize[i] > 1) continue;
            int n = len = e1 - b1 < e2 - b2 ? e1 - b1 : e2 - b2;
            if (len >= 2 * fragLen) continue;
            for (int j = i; j < blockNum - 1; ++j) {
                blockRmsd[j] = blockRmsd[j + 1];
                blockSize[j] = blockSize[j + 1];
                block2Afp[j] = block2Afp[j + 1];
            }
            --blockNum;
            --i;
        }
        if (blockNumOld > blockNum) {
            // empty if block
        }
        afpChain.setBlock2Afp(block2Afp);
        afpChain.setBlockSize(blockSize);
        afpChain.setAfpChainList(afpChainList);
        afpChain.setBlockNum(blockNum);
        afpChain.setBlockRmsd(blockRmsd);
    }

    private static void mergeBlock(FatCatParameters params, AFPChain afpChain, Atom[] ca1, Atom[] ca2) {
        int b2;
        int b1;
        int blockNum = afpChain.getBlockNum();
        double badRmsd = params.getBadRmsd();
        int[] block2Afp = afpChain.getBlock2Afp();
        int[] blockSize = afpChain.getBlockSize();
        double[] blockRmsd = afpChain.getBlockRmsd();
        int afpChainTwiNum = afpChain.getAfpChainTwiNum();
        int merge = 0;
        int blockNumOld = blockNum;
        double[][] rmsdlist = null;
        if (blockNum > 1) {
            rmsdlist = new double[blockNumOld][blockNumOld];
            for (b1 = 0; b1 < blockNum - 1; ++b1) {
                for (b2 = b1 + 1; b2 < blockNum; ++b2) {
                    rmsdlist[b1][b2] = AFPPostProcessor.combineRmsd(b1, b2, afpChain, ca1, ca2);
                }
            }
        }
        int minb1 = 0;
        while (blockNum > 1) {
            int i;
            double minrmsd = 1000.0;
            for (i = 0; i < blockNum - 1; ++i) {
                int j = i + 1;
                if (!(minrmsd > rmsdlist[i][j])) continue;
                minrmsd = rmsdlist[i][j];
                minb1 = i;
            }
            int minb2 = minb1 + 1;
            if (minrmsd < badRmsd) {
                int n = minb1;
                blockSize[n] = blockSize[n] + blockSize[minb2];
                blockRmsd[minb1] = minrmsd;
                for (i = minb2; i < blockNum - 1; ++i) {
                    block2Afp[i] = block2Afp[i + 1];
                    blockSize[i] = blockSize[i + 1];
                    blockRmsd[i] = blockRmsd[i + 1];
                }
                --afpChainTwiNum;
                --blockNum;
                for (b1 = 0; b1 < blockNum - 1; ++b1) {
                    for (b2 = b1 + 1; b2 < blockNum; ++b2) {
                        if (b1 == minb1 || b2 == minb1) {
                            rmsdlist[b1][b2] = AFPPostProcessor.combineRmsd(b1, b2, afpChain, ca1, ca2);
                            continue;
                        }
                        if (b2 < minb1) continue;
                        rmsdlist[b1][b2] = b1 < minb1 ? rmsdlist[b1][b2 + 1] : rmsdlist[b1 + 1][b2 + 1];
                    }
                }
                ++merge;
                continue;
            }
            if (minrmsd >= 100.0) break;
            double[] dArray = rmsdlist[minb1];
            int n = minb2;
            dArray[n] = dArray[n] + 100.0;
        }
        if (merge > 0) {
            // empty if block
        }
        afpChain.setBlock2Afp(block2Afp);
        afpChain.setBlockSize(blockSize);
        afpChain.setBlockNum(blockNum);
        afpChain.setBlockRmsd(blockRmsd);
        afpChain.setAfpChainTwiNum(afpChainTwiNum);
    }

    private static double combineRmsd(int b1, int b2, AFPChain afpChain, Atom[] ca1, Atom[] ca2) {
        int i;
        int afpn = 0;
        int[] afpChainList = afpChain.getAfpChainList();
        int[] block2Afp = afpChain.getBlock2Afp();
        int[] blockSize = afpChain.getBlockSize();
        int[] list = new int[blockSize[b1] + blockSize[b2]];
        for (i = block2Afp[b1]; i < block2Afp[b1] + blockSize[b1]; ++i) {
            list[afpn++] = afpChainList[i];
        }
        for (i = block2Afp[b2]; i < block2Afp[b2] + blockSize[b2]; ++i) {
            list[afpn++] = afpChainList[i];
        }
        double rmsd = AFPChainer.calAfpRmsd(afpn, list, 0, afpChain, ca1, ca2);
        afpChain.setBlock2Afp(block2Afp);
        afpChain.setBlockSize(blockSize);
        afpChain.setAfpChainList(afpChainList);
        return rmsd;
    }
}

