/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.domain.pdp;

import org.biojava.nbio.structure.AminoAcid;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Calc;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.domain.pdp.PDPDistanceMatrix;

public class GetDistanceMatrix {
    public PDPDistanceMatrix getDistanceMatrix(Atom[] protein) throws StructureException {
        int j;
        int i;
        int[][] dist = new int[protein.length + 3][protein.length + 3];
        int nclose = 0;
        int[] iclose = new int[protein.length * protein.length];
        int[] jclose = new int[protein.length * protein.length];
        if (protein.length >= 3200) {
            System.err.println(String.format("%d protein.len > MAXLEN %d\n", protein.length, 3200));
            return null;
        }
        for (i = 0; i < protein.length; ++i) {
            for (j = i; j < protein.length; ++j) {
                double distance;
                dist[i][j] = 0;
                dist[j][i] = 0;
                double d = 0.0;
                Atom ca1 = protein[i];
                Atom ca2 = protein[j];
                Group g1 = ca1.getGroup();
                Group g2 = ca2.getGroup();
                Atom cb1 = this.getCBeta(g1);
                Atom cb2 = this.getCBeta(g2);
                boolean hasCbeta1 = cb1 != null;
                boolean hasCbeta2 = cb2 != null;
                double dt1 = 81.0;
                double dt2 = 64.0;
                double dt3 = 49.0;
                double dt4 = 36.0;
                if (hasCbeta1 && hasCbeta2) {
                    distance = Calc.getDistance(cb1, cb2);
                    d += distance * distance;
                } else if (hasCbeta1 && !hasCbeta2) {
                    distance = 999.0;
                    distance = Calc.getDistance(cb1, ca2);
                    d += distance * distance;
                } else if (!hasCbeta1 && hasCbeta2) {
                    distance = Calc.getDistance(ca1, cb2);
                    d += distance * distance;
                } else if (!hasCbeta1 && !hasCbeta2) {
                    distance = Calc.getDistance(ca1, ca2);
                    d += distance * distance;
                }
                if (!(d < dt1)) continue;
                dist[i][j] = 1;
                dist[j][i] = 1;
                if (!(d < dt2)) continue;
                dist[i][j] = 2;
                dist[j][i] = 2;
                if (j - i > 35) {
                    iclose[nclose] = i;
                    jclose[nclose] = j;
                    ++nclose;
                }
                if (!(d < dt3)) continue;
                dist[i][j] = 4;
                dist[j][i] = 4;
                if (!(d < dt4)) continue;
                dist[i][j] = 6;
                dist[j][i] = 6;
            }
        }
        for (i = 1; i < protein.length; ++i) {
            for (j = i; j < protein.length - 1; ++j) {
                if (dist[i][j] < 2 || j - i <= 5) continue;
                if (dist[i - 1][j - 1] >= 2 && dist[i + 1][j + 1] >= 2 || dist[i - 1][j + 1] >= 2 && dist[i + 1][j - 1] >= 2) {
                    int[] nArray = dist[i];
                    int n = j;
                    nArray[n] = nArray[n] + 4;
                    int[] nArray2 = dist[j];
                    int n2 = i;
                    nArray2[n2] = nArray2[n2] + 4;
                    continue;
                }
                if (i <= 2 || j >= protein.length - 2) continue;
                if (dist[i - 3][j - 3] >= 1 && dist[i + 3][j + 3] >= 1 || dist[i - 3][j + 3] >= 1 && dist[i + 3][j - 3] >= 1) {
                    int[] nArray = dist[i];
                    int n = j;
                    nArray[n] = nArray[n] + 4;
                    int[] nArray3 = dist[j];
                    int n3 = i;
                    nArray3[n3] = nArray3[n3] + 4;
                    continue;
                }
                if (i <= 3 || j >= protein.length - 3 || (dist[i - 3][j - 3] < 1 && dist[i - 3][j - 4] < 1 && dist[i - 4][j - 3] < 1 && dist[i - 4][j - 4] < 1 || dist[i + 4][j + 4] < 1 && dist[i + 4][j + 3] < 1 && dist[i + 3][j + 3] < 1 && dist[i + 3][j + 4] < 1) && (dist[i - 4][j + 4] < 1 && dist[i - 4][j + 3] < 1 && dist[i - 3][j + 4] < 1 && dist[i - 3][j + 3] < 1 || dist[i + 4][j - 4] < 1 && dist[i + 4][j - 3] < 1 && dist[i + 3][j - 4] < 1 && dist[i + 3][j - 3] < 1)) continue;
                int[] nArray = dist[i];
                int n = j;
                nArray[n] = nArray[n] + 4;
                int[] nArray4 = dist[j];
                int n4 = i;
                nArray4[n4] = nArray4[n4] + 4;
            }
        }
        PDPDistanceMatrix matrix = new PDPDistanceMatrix();
        matrix.setNclose(nclose);
        matrix.setIclose(iclose);
        matrix.setJclose(jclose);
        matrix.setDist(dist);
        return matrix;
    }

    private Atom getCBeta(Group g1) {
        Atom cb = null;
        cb = g1.getAtom("CB");
        if (cb == null && g1 instanceof AminoAcid) {
            AminoAcid aa = (AminoAcid)g1;
            try {
                cb = Calc.createVirtualCBAtom(aa);
            }
            catch (StructureException e1) {
                e1.printStackTrace();
            }
        }
        return cb;
    }
}

