/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.quaternary.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.align.client.JFatCatClient;
import org.biojava.nbio.structure.align.util.AtomCache;
import org.biojava.nbio.structure.align.util.HTTPConnectionTools;
import org.biojava.nbio.structure.quaternary.BiologicalAssemblyTransformation;
import org.biojava.nbio.structure.quaternary.io.BioUnitDataProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RemoteBioUnitDataProvider
implements BioUnitDataProvider {
    private static final Logger logger = LoggerFactory.getLogger(RemoteBioUnitDataProvider.class);
    public static final String DEFAULT_SERVERNAME = "http://pepper.rcsb.org:8080/pdb/rest/biolassembly/";
    public static final String NR_BIOL_APPEND = "nrBiolAssemblies?structureId=%s";
    public static final String BIO_ASSEMBLY = "bioAssembly?structureId=%s&nr=%s";
    private static final int DEFAULT_TIMEOUT = 5000;
    private String serverName = "http://pepper.rcsb.org:8080/pdb/rest/biolassembly/";
    private int timeout = 5000;

    @Override
    public List<BiologicalAssemblyTransformation> getBioUnitTransformationList(String pdbId, int biolAssemblyNr) {
        String serverURL = this.serverName + BIO_ASSEMBLY;
        String u = String.format(serverURL, pdbId, biolAssemblyNr);
        List<BiologicalAssemblyTransformation> transformations = new ArrayList<BiologicalAssemblyTransformation>();
        try {
            URL url = new URL(u);
            System.out.println("requesting biol assemblies from server..." + url);
            InputStream stream = HTTPConnectionTools.getInputStream(url, this.timeout);
            String xml = null;
            xml = JFatCatClient.convertStreamToString(stream);
            if (stream != null) {
                System.out.println(xml);
                transformations = BiologicalAssemblyTransformation.fromMultiXML(xml);
            }
        }
        catch (IOException e) {
            logger.error("Exception caught while getting biological assemblies", (Throwable)e);
        }
        catch (SAXException e) {
            logger.error("Exception caught while getting biological assemblies", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            logger.error("Exception caught while getting biological assemblies", (Throwable)e);
        }
        return transformations;
    }

    @Override
    public int getNrBiolAssemblies(String pdbId) {
        String serverURL = this.serverName + NR_BIOL_APPEND;
        int nrBiolAssemblies = -1;
        try {
            String u = String.format(serverURL, pdbId);
            URL url = new URL(u);
            System.out.println("requesting nr biol assemblies from server..." + url);
            InputStream stream = HTTPConnectionTools.getInputStream(url, this.timeout);
            String xml = null;
            if (stream != null) {
                xml = JFatCatClient.convertStreamToString(stream);
                System.out.println("got XML from server: " + xml);
                nrBiolAssemblies = RemoteBioUnitDataProvider.extractNrBiolAssemblies(xml);
            }
        }
        catch (IOException e) {
            logger.error("Exception caught while getting number of biological assemblies", (Throwable)e);
        }
        return nrBiolAssemblies;
    }

    @Override
    public boolean hasBiolAssembly(String pdbId) {
        int nrBiolAssemblies = this.getNrBiolAssemblies(pdbId);
        return nrBiolAssemblies > 0;
    }

    private static int extractNrBiolAssemblies(String xml) {
        int nrBiolAssemblies = -1;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = factory.newDocumentBuilder();
            InputSource inStream = new InputSource();
            inStream.setCharacterStream(new StringReader(xml));
            Document doc = db.parse(inStream);
            doc.getDocumentElement().normalize();
            NodeList listOfPairs = doc.getElementsByTagName("nrBiolAssemblies");
            for (int i = 0; i < listOfPairs.getLength(); ++i) {
                Node pair = listOfPairs.item(i);
                NamedNodeMap map = pair.getAttributes();
                String count = map.getNamedItem("count").getTextContent();
                nrBiolAssemblies = Integer.parseInt(count);
            }
        }
        catch (IOException e) {
            logger.error("Exception caught while getting number of biological assemblies", (Throwable)e);
        }
        catch (SAXException e) {
            logger.error("Exception caught while getting number of biological assemblies", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            logger.error("Exception caught while getting number of biological assemblies", (Throwable)e);
        }
        return nrBiolAssemblies;
    }

    @Override
    public Structure getAsymUnit(String pdbId) {
        logger.error("RemoteBioUnitDataProvider getAsymUnit Not implemented yet!");
        return null;
    }

    @Override
    public void setAsymUnit(Structure s) {
    }

    @Override
    public void setAtomCache(AtomCache cache) {
    }

    @Override
    public AtomCache getAtomCache() {
        return null;
    }
}

