/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.io.sifts;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import org.biojava.nbio.core.sequence.io.util.IOUtils;
import org.biojava.nbio.structure.align.util.UserConfiguration;
import org.biojava.nbio.structure.io.sifts.SiftsChainEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SiftsChainToUniprotMapping {
    private static final Logger logger = LoggerFactory.getLogger(SiftsChainToUniprotMapping.class);
    protected static File DEFAULT_FILE;
    private static final String DEFAULT_FILENAME = "pdb_chain_uniprot.tsv";
    private static final URL DEFAULT_URL;
    private Map<String, SiftsChainEntry> byChainId = new HashMap<String, SiftsChainEntry>();
    private Map<String, SiftsChainEntry> byUniProtId = new HashMap<String, SiftsChainEntry>();

    public static SiftsChainToUniprotMapping load() throws IOException {
        return SiftsChainToUniprotMapping.load(false);
    }

    public static SiftsChainToUniprotMapping load(boolean useOnlyLocal) throws IOException {
        UserConfiguration config = new UserConfiguration();
        File cacheDir = new File(config.getCacheFilePath());
        DEFAULT_FILE = new File(cacheDir, DEFAULT_FILENAME);
        if (!DEFAULT_FILE.exists() || DEFAULT_FILE.length() == 0L) {
            if (useOnlyLocal) {
                throw new IOException(DEFAULT_FILE + " does not exist, and did not download");
            }
            SiftsChainToUniprotMapping.download();
        }
        try {
            return SiftsChainToUniprotMapping.build();
        }
        catch (IOException e) {
            logger.info("Caught IOException while reading {}. Error: {}", (Object)DEFAULT_FILE, (Object)e.getMessage());
            if (useOnlyLocal) {
                throw new IOException(DEFAULT_FILE + " could not be read, and did not redownload");
            }
            SiftsChainToUniprotMapping.download();
            return SiftsChainToUniprotMapping.build();
        }
    }

    protected static SiftsChainToUniprotMapping build() throws IOException {
        SiftsChainToUniprotMapping sifts = new SiftsChainToUniprotMapping();
        BufferedReader br = new BufferedReader(new FileReader(DEFAULT_FILE));
        String line = "";
        while ((line = br.readLine()) != null) {
            if (line.isEmpty() || line.startsWith("#") || line.startsWith("PDB")) continue;
            String[] parts = line.split("\t");
            String pdbId = parts[0];
            String chainId = parts[1];
            String uniProtId = parts[2];
            String seqresStart = parts[3];
            String seqresEnd = parts[4];
            String pdbStart = parts[5];
            String pdbEnd = parts[6];
            String uniprotStart = parts[7];
            String uniprotEnd = parts[8];
            SiftsChainEntry entry = new SiftsChainEntry(pdbId, chainId, uniProtId, seqresStart, seqresEnd, pdbStart, pdbEnd, uniprotStart, uniprotEnd);
            sifts.byChainId.put(pdbId + "." + chainId, entry);
            sifts.byUniProtId.put(uniProtId, entry);
        }
        br.close();
        return sifts;
    }

    private static void download() throws IOException {
        logger.info("Downloading {} to {}", (Object)DEFAULT_URL.toString(), (Object)DEFAULT_FILE);
        GZIPInputStream in = null;
        FileOutputStream out = null;
        in = new GZIPInputStream(DEFAULT_URL.openStream());
        out = new FileOutputStream(DEFAULT_FILE);
        IOUtils.copy((InputStream)in, (OutputStream)out);
    }

    private SiftsChainToUniprotMapping() {
    }

    public Set<Map.Entry<String, SiftsChainEntry>> chainEntrySet() {
        return this.byChainId.entrySet();
    }

    public boolean containsChainId(String pdbId, String chainId) {
        return this.byChainId.containsKey(pdbId + "." + chainId);
    }

    public boolean containsUniProtId(String uniProtId) {
        return this.byUniProtId.containsKey(uniProtId);
    }

    public SiftsChainEntry getByChainId(String pdbId, String chainId) {
        return this.byChainId.get(pdbId + "." + chainId);
    }

    public SiftsChainEntry getByUniProtId(String uniProtId) {
        return this.byUniProtId.get(uniProtId);
    }

    public Set<String> keySet() {
        return this.byChainId.keySet();
    }

    public int size() {
        return this.byChainId.size();
    }

    public Set<Map.Entry<String, SiftsChainEntry>> uniProtEntrySet() {
        return this.byChainId.entrySet();
    }

    public Collection<SiftsChainEntry> values() {
        return this.byChainId.values();
    }

    static {
        try {
            DEFAULT_URL = new URL("ftp://ftp.ebi.ac.uk/pub/databases/msd/sifts/flatfiles/tsv/pdb_chain_uniprot.tsv.gz");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

