/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.EntityInfo;
import org.biojava.nbio.structure.EntityType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Model
implements Serializable {
    private static final long serialVersionUID = 5320613424668781882L;
    private static final Logger logger = LoggerFactory.getLogger(Model.class);
    private List<Chain> polyChains = new ArrayList<Chain>();
    private List<Chain> nonPolyChains = new ArrayList<Chain>();
    private List<Chain> waterChains = new ArrayList<Chain>();

    public List<Chain> getPolyChains() {
        return this.polyChains;
    }

    public List<Chain> getNonPolyChains() {
        return this.nonPolyChains;
    }

    public List<Chain> getWaterChains() {
        return this.waterChains;
    }

    public List<Chain> getChains() {
        ArrayList<Chain> chains = new ArrayList<Chain>();
        chains.addAll(this.polyChains);
        chains.addAll(this.nonPolyChains);
        chains.addAll(this.waterChains);
        chains.trimToSize();
        return chains;
    }

    public void setChains(List<Chain> modelChains) {
        this.polyChains.clear();
        this.nonPolyChains.clear();
        this.waterChains.clear();
        for (Chain c : modelChains) {
            this.addChain(c);
        }
    }

    public void addChain(Chain c) {
        EntityInfo info = c.getEntityInfo();
        if (info == null || info.getType() == null) {
            logger.info("No entity info could be found while adding chain with asym id {} (author id {}). Will consider it a polymer chain.", (Object)c.getId(), (Object)c.getName());
            this.polyChains.add(c);
        } else if (info.getType() == EntityType.POLYMER) {
            this.polyChains.add(c);
        } else if (info.getType() == EntityType.NONPOLYMER) {
            this.nonPolyChains.add(c);
        } else if (info.getType() == EntityType.WATER) {
            this.waterChains.add(c);
        } else if (info.getType() == EntityType.MACROLIDE) {
            logger.warn("Chain with asym id {} (author id {}) has entity type 'macrolide', considering it non-polymeric", (Object)c.getId(), (Object)c.getName());
            this.nonPolyChains.add(c);
        } else {
            logger.warn("Chain with asym id {} (author id {}) has unsupported entity type '{}'. Will not add it to the Structure.", new Object[]{c.getId(), c.getName(), info.getType().toString()});
        }
    }

    public int size() {
        return this.polyChains.size() + this.nonPolyChains.size() + this.waterChains.size();
    }

    public String toString() {
        return "[" + this.polyChains.size() + " poly chains, " + this.nonPolyChains.size() + " non-poly chains, " + this.waterChains.size() + " water chains]";
    }
}

