/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.contact;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.Element;
import org.biojava.nbio.structure.EntityInfo;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.GroupType;
import org.biojava.nbio.structure.ResidueNumber;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.asa.AsaCalculator;
import org.biojava.nbio.structure.asa.GroupAsa;
import org.biojava.nbio.structure.contact.AtomContactSet;
import org.biojava.nbio.structure.contact.GroupContact;
import org.biojava.nbio.structure.contact.GroupContactSet;
import org.biojava.nbio.structure.contact.Pair;
import org.biojava.nbio.structure.contact.ResidueIdentifier;
import org.biojava.nbio.structure.contact.StructureInterfaceCluster;
import org.biojava.nbio.structure.io.FileConvert;
import org.biojava.nbio.structure.io.mmcif.MMCIFFileTools;
import org.biojava.nbio.structure.io.mmcif.chem.PolymerType;
import org.biojava.nbio.structure.io.mmcif.model.AtomSite;
import org.biojava.nbio.structure.io.mmcif.model.ChemComp;
import org.biojava.nbio.structure.xtal.CrystalTransform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StructureInterface
implements Serializable,
Comparable<StructureInterface> {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(StructureInterface.class);
    private static final double SELF_SCORE_FOR_ISOLOGOUS = 0.3;
    private int id;
    private double totalArea;
    private AtomContactSet contacts;
    private GroupContactSet groupContacts;
    private Pair<Atom[]> molecules;
    private Pair<String> moleculeIds;
    private Pair<CrystalTransform> transforms;
    private Map<ResidueNumber, GroupAsa> groupAsas1;
    private Map<ResidueNumber, GroupAsa> groupAsas2;
    private StructureInterfaceCluster cluster;

    public StructureInterface(Atom[] firstMolecule, Atom[] secondMolecule, String firstMoleculeId, String secondMoleculeId, AtomContactSet contacts, CrystalTransform firstTransf, CrystalTransform secondTransf) {
        this.molecules = new Pair<Atom[]>(firstMolecule, secondMolecule);
        this.moleculeIds = new Pair<String>(firstMoleculeId, secondMoleculeId);
        this.contacts = contacts;
        this.transforms = new Pair<CrystalTransform>(firstTransf, secondTransf);
    }

    public StructureInterface() {
        this.groupAsas1 = new TreeMap<ResidueNumber, GroupAsa>();
        this.groupAsas2 = new TreeMap<ResidueNumber, GroupAsa>();
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Pair<String> getCrystalIds() {
        return new Pair<String>(this.moleculeIds.getFirst() + this.transforms.getFirst().getTransformId() + this.transforms.getFirst().getCrystalTranslation(), this.moleculeIds.getSecond() + this.transforms.getSecond().getTransformId() + this.transforms.getSecond().getCrystalTranslation());
    }

    public double getTotalArea() {
        return this.totalArea;
    }

    public void setTotalArea(double totalArea) {
        this.totalArea = totalArea;
    }

    public AtomContactSet getContacts() {
        return this.contacts;
    }

    public void setContacts(AtomContactSet contacts) {
        this.contacts = contacts;
    }

    public Pair<Atom[]> getMolecules() {
        return this.molecules;
    }

    public void setMolecules(Pair<Atom[]> molecules) {
        this.molecules = molecules;
    }

    public Pair<String> getMoleculeIds() {
        return this.moleculeIds;
    }

    public void setMoleculeIds(Pair<String> moleculeIds) {
        this.moleculeIds = moleculeIds;
    }

    public Pair<CrystalTransform> getTransforms() {
        return this.transforms;
    }

    public void setTransforms(Pair<CrystalTransform> transforms) {
        this.transforms = transforms;
    }

    protected void setAsas(double[] asas1, double[] asas2, int nSpherePoints, int nThreads, int cofactorSizeToUse) {
        GroupAsa groupAsa;
        Group g;
        int i;
        Atom[] atoms = this.getAtomsForAsa(cofactorSizeToUse);
        AsaCalculator asaCalc = new AsaCalculator(atoms, 1.4, nSpherePoints, nThreads);
        double[] complexAsas = asaCalc.calculateAsas();
        if (complexAsas.length != asas1.length + asas2.length) {
            throw new IllegalArgumentException("The size of ASAs of complex doesn't match that of ASAs 1 + ASAs 2");
        }
        this.groupAsas1 = new TreeMap<ResidueNumber, GroupAsa>();
        this.groupAsas2 = new TreeMap<ResidueNumber, GroupAsa>();
        this.totalArea = 0.0;
        for (i = 0; i < asas1.length; ++i) {
            g = atoms[i].getGroup();
            if (!g.getType().equals((Object)GroupType.HETATM) || StructureInterface.isInChain(g)) {
                this.totalArea += asas1[i] - complexAsas[i];
            }
            if (!this.groupAsas1.containsKey(g.getResidueNumber())) {
                groupAsa = new GroupAsa(g);
                groupAsa.addAtomAsaU(asas1[i]);
                groupAsa.addAtomAsaC(complexAsas[i]);
                this.groupAsas1.put(g.getResidueNumber(), groupAsa);
                continue;
            }
            groupAsa = this.groupAsas1.get(g.getResidueNumber());
            groupAsa.addAtomAsaU(asas1[i]);
            groupAsa.addAtomAsaC(complexAsas[i]);
        }
        for (i = 0; i < asas2.length; ++i) {
            g = atoms[i + asas1.length].getGroup();
            if (!g.getType().equals((Object)GroupType.HETATM) || StructureInterface.isInChain(g)) {
                this.totalArea += asas2[i] - complexAsas[i + asas1.length];
            }
            if (!this.groupAsas2.containsKey(g.getResidueNumber())) {
                groupAsa = new GroupAsa(g);
                groupAsa.addAtomAsaU(asas2[i]);
                groupAsa.addAtomAsaC(complexAsas[i + asas1.length]);
                this.groupAsas2.put(g.getResidueNumber(), groupAsa);
                continue;
            }
            groupAsa = this.groupAsas2.get(g.getResidueNumber());
            groupAsa.addAtomAsaU(asas2[i]);
            groupAsa.addAtomAsaC(complexAsas[i + asas1.length]);
        }
        this.totalArea /= 2.0;
    }

    protected Atom[] getFirstAtomsForAsa(int cofactorSizeToUse) {
        return StructureInterface.getAllNonHAtomArray(this.molecules.getFirst(), cofactorSizeToUse);
    }

    protected Atom[] getSecondAtomsForAsa(int cofactorSizeToUse) {
        return StructureInterface.getAllNonHAtomArray(this.molecules.getSecond(), cofactorSizeToUse);
    }

    protected Atom[] getAtomsForAsa(int cofactorSizeToUse) {
        int i;
        Atom[] atoms1 = this.getFirstAtomsForAsa(cofactorSizeToUse);
        Atom[] atoms2 = this.getSecondAtomsForAsa(cofactorSizeToUse);
        Atom[] atoms = new Atom[atoms1.length + atoms2.length];
        for (i = 0; i < atoms1.length; ++i) {
            atoms[i] = atoms1[i];
        }
        for (i = 0; i < atoms2.length; ++i) {
            atoms[i + atoms1.length] = atoms2[i];
        }
        return atoms;
    }

    private static final Atom[] getAllNonHAtomArray(Atom[] m, int minSizeHetAtomToInclude) {
        ArrayList<Atom> atoms = new ArrayList<Atom>();
        for (Atom a : m) {
            Group g;
            if (a.getElement() == Element.H || (g = a.getGroup()).getType().equals((Object)GroupType.HETATM) && !StructureInterface.isInChain(g) && StructureInterface.getSizeNoH(g) < minSizeHetAtomToInclude) continue;
            atoms.add(a);
        }
        return atoms.toArray(new Atom[atoms.size()]);
    }

    private static int getSizeNoH(Group g) {
        int size = 0;
        for (Atom a : g.getAtoms()) {
            if (a.getElement() == Element.H) continue;
            ++size;
        }
        return size;
    }

    private static boolean isInChain(Group g) {
        ChemComp chemComp = g.getChemComp();
        if (chemComp == null) {
            logger.warn("Warning: can't determine PolymerType for group " + g.getResidueNumber() + " (" + g.getPDBName() + "). Will consider it as non-nucleotide/non-protein type.");
            return false;
        }
        PolymerType polyType = chemComp.getPolymerType();
        for (PolymerType protOnlyType : PolymerType.PROTEIN_ONLY) {
            if (polyType != protOnlyType) continue;
            return true;
        }
        for (PolymerType protOnlyType : PolymerType.POLYNUCLEOTIDE_ONLY) {
            if (polyType != protOnlyType) continue;
            return true;
        }
        return false;
    }

    public boolean isSymRelated() {
        return this.moleculeIds.getFirst().equals(this.moleculeIds.getSecond());
    }

    public boolean isInfinite() {
        return this.isSymRelated() && this.transforms.getSecond().getTransformType().isInfinite();
    }

    public boolean isHomomeric() {
        EntityInfo first = this.getParentChains().getFirst().getEntityInfo();
        EntityInfo second = this.getParentChains().getSecond().getEntityInfo();
        if (first == null || second == null) {
            logger.warn("Some compound of interface {} is null, can't determine whether it is homo/heteromeric. Consider it homomeric", (Object)this.getId());
            return true;
        }
        return first.getRepresentative().getId().equals(second.getRepresentative().getId());
    }

    public Map<ResidueNumber, GroupAsa> getFirstGroupAsas() {
        return this.groupAsas1;
    }

    public GroupAsa getFirstGroupAsa(ResidueNumber resNum) {
        return this.groupAsas1.get(resNum);
    }

    public void setFirstGroupAsa(GroupAsa groupAsa) {
        this.groupAsas1.put(groupAsa.getGroup().getResidueNumber(), groupAsa);
    }

    public Map<ResidueNumber, GroupAsa> getSecondGroupAsas() {
        return this.groupAsas2;
    }

    public void setSecondGroupAsa(GroupAsa groupAsa) {
        this.groupAsas2.put(groupAsa.getGroup().getResidueNumber(), groupAsa);
    }

    public GroupAsa getSecondGroupAsa(ResidueNumber resNum) {
        return this.groupAsas2.get(resNum);
    }

    public Pair<List<Group>> getCoreResidues(double bsaToAsaCutoff, double minAsaForSurface) {
        ArrayList<Group> core1 = new ArrayList<Group>();
        ArrayList<Group> core2 = new ArrayList<Group>();
        for (GroupAsa groupAsa : this.groupAsas1.values()) {
            if (!(groupAsa.getAsaU() > minAsaForSurface) || !(groupAsa.getBsa() > 0.0) || groupAsa.getBsaToAsaRatio() < bsaToAsaCutoff) continue;
            core1.add(groupAsa.getGroup());
        }
        for (GroupAsa groupAsa : this.groupAsas2.values()) {
            if (!(groupAsa.getAsaU() > minAsaForSurface) || !(groupAsa.getBsa() > 0.0) || groupAsa.getBsaToAsaRatio() < bsaToAsaCutoff) continue;
            core2.add(groupAsa.getGroup());
        }
        return new Pair<List<Group>>(core1, core2);
    }

    public Pair<List<Group>> getRimResidues(double bsaToAsaCutoff, double minAsaForSurface) {
        ArrayList<Group> rim1 = new ArrayList<Group>();
        ArrayList<Group> rim2 = new ArrayList<Group>();
        for (GroupAsa groupAsa : this.groupAsas1.values()) {
            if (!(groupAsa.getAsaU() > minAsaForSurface) || !(groupAsa.getBsa() > 0.0) || !(groupAsa.getBsaToAsaRatio() < bsaToAsaCutoff)) continue;
            rim1.add(groupAsa.getGroup());
        }
        for (GroupAsa groupAsa : this.groupAsas2.values()) {
            if (!(groupAsa.getAsaU() > minAsaForSurface) || !(groupAsa.getBsa() > 0.0) || !(groupAsa.getBsaToAsaRatio() < bsaToAsaCutoff)) continue;
            rim2.add(groupAsa.getGroup());
        }
        return new Pair<List<Group>>(rim1, rim2);
    }

    public Pair<List<Group>> getInterfacingResidues(double minAsaForSurface) {
        ArrayList<Group> interf1 = new ArrayList<Group>();
        ArrayList<Group> interf2 = new ArrayList<Group>();
        for (GroupAsa groupAsa : this.groupAsas1.values()) {
            if (!(groupAsa.getAsaU() > minAsaForSurface) || !(groupAsa.getBsa() > 0.0)) continue;
            interf1.add(groupAsa.getGroup());
        }
        for (GroupAsa groupAsa : this.groupAsas2.values()) {
            if (!(groupAsa.getAsaU() > minAsaForSurface) || !(groupAsa.getBsa() > 0.0)) continue;
            interf2.add(groupAsa.getGroup());
        }
        return new Pair<List<Group>>(interf1, interf2);
    }

    public Pair<List<Group>> getSurfaceResidues(double minAsaForSurface) {
        ArrayList<Group> surf1 = new ArrayList<Group>();
        ArrayList<Group> surf2 = new ArrayList<Group>();
        for (GroupAsa groupAsa : this.groupAsas1.values()) {
            if (!(groupAsa.getAsaU() > minAsaForSurface)) continue;
            surf1.add(groupAsa.getGroup());
        }
        for (GroupAsa groupAsa : this.groupAsas2.values()) {
            if (!(groupAsa.getAsaU() > minAsaForSurface)) continue;
            surf2.add(groupAsa.getGroup());
        }
        return new Pair<List<Group>>(surf1, surf2);
    }

    public StructureInterfaceCluster getCluster() {
        return this.cluster;
    }

    public void setCluster(StructureInterfaceCluster cluster) {
        this.cluster = cluster;
    }

    public double getContactOverlapScore(StructureInterface other, boolean invert) {
        Structure otherStruct;
        Structure thisStruct = this.getParentStructure();
        if (thisStruct != (otherStruct = other.getParentStructure())) {
            logger.warn("Comparing interfaces from different structures, contact overlap score will be 0");
            return 0.0;
        }
        Pair<Chain> thisChains = this.getParentChains();
        Pair<Chain> otherChains = other.getParentChains();
        if (thisChains.getFirst().getEntityInfo() == null || thisChains.getSecond().getEntityInfo() == null || otherChains.getFirst().getEntityInfo() == null || otherChains.getSecond().getEntityInfo() == null) {
            logger.warn("Found chains with null compounds while comparing interfaces {} and {}. Contact overlap score for them will be 0.", (Object)this.getId(), (Object)other.getId());
            return 0.0;
        }
        Pair<EntityInfo> thisCompounds = new Pair<EntityInfo>(thisChains.getFirst().getEntityInfo(), thisChains.getSecond().getEntityInfo());
        Pair<EntityInfo> otherCompounds = new Pair<EntityInfo>(otherChains.getFirst().getEntityInfo(), otherChains.getSecond().getEntityInfo());
        if (thisCompounds.getFirst() == otherCompounds.getFirst() && thisCompounds.getSecond() == otherCompounds.getSecond() || thisCompounds.getFirst() == otherCompounds.getSecond() && thisCompounds.getSecond() == otherCompounds.getFirst()) {
            int common = 0;
            GroupContactSet thisContacts = this.getGroupContacts();
            GroupContactSet otherContacts = other.getGroupContacts();
            for (GroupContact thisContact : thisContacts) {
                ResidueIdentifier first = null;
                ResidueIdentifier second = null;
                if (!invert) {
                    first = new ResidueIdentifier(thisContact.getPair().getFirst());
                    second = new ResidueIdentifier(thisContact.getPair().getSecond());
                } else {
                    first = new ResidueIdentifier(thisContact.getPair().getSecond());
                    second = new ResidueIdentifier(thisContact.getPair().getFirst());
                }
                if (!otherContacts.hasContact(first, second)) continue;
                ++common;
            }
            return 2.0 * (double)common / (double)(thisContacts.size() + otherContacts.size());
        }
        logger.debug("Chain pairs {},{} and {},{} belong to different compound pairs, contact overlap score will be 0 ", new Object[]{thisChains.getFirst().getId(), thisChains.getSecond().getId(), otherChains.getFirst().getId(), otherChains.getSecond().getId()});
        return 0.0;
    }

    public GroupContactSet getGroupContacts() {
        if (this.groupContacts == null) {
            this.groupContacts = new GroupContactSet(this.contacts);
        }
        return this.groupContacts;
    }

    public boolean isIsologous() {
        double scoreInverse = this.getContactOverlapScore(this, true);
        logger.debug("Interface {} contact overlap score with itself inverted: {}", (Object)this.getId(), (Object)scoreInverse);
        return scoreInverse > 0.3;
    }

    public Pair<Chain> getParentChains() {
        Atom[] firstMol = this.molecules.getFirst();
        Atom[] secondMol = this.molecules.getSecond();
        if (firstMol.length == 0 || secondMol.length == 0) {
            logger.warn("No atoms found in first or second molecule, can't get parent Chains");
            return null;
        }
        return new Pair<Chain>(firstMol[0].getGroup().getChain(), secondMol[0].getGroup().getChain());
    }

    public Pair<EntityInfo> getParentCompounds() {
        Pair<Chain> chains = this.getParentChains();
        if (chains == null) {
            logger.warn("Could not find parents chains, compounds will be null");
            return null;
        }
        return new Pair<EntityInfo>(chains.getFirst().getEntityInfo(), chains.getSecond().getEntityInfo());
    }

    private Structure getParentStructure() {
        Atom[] firstMol = this.molecules.getFirst();
        if (firstMol.length == 0) {
            logger.warn("No atoms found in first molecule, can't get parent Structure");
            return null;
        }
        return firstMol[0].getGroup().getChain().getStructure();
    }

    public String toPDB() {
        String molecId1 = this.getMoleculeIds().getFirst();
        String molecId2 = this.getMoleculeIds().getSecond();
        if (molecId2.equals(molecId1)) {
            char letter = molecId1.charAt(0);
            molecId2 = letter != 'Z' && letter != 'z' ? Character.toString((char)(letter + '\u0001')) : Character.toString((char)(letter - 25));
        }
        StringBuilder sb = new StringBuilder();
        for (Atom atom : this.molecules.getFirst()) {
            sb.append(FileConvert.toPDB(atom, molecId1));
        }
        sb.append("TER");
        sb.append(System.getProperty("line.separator"));
        for (Atom atom : this.molecules.getSecond()) {
            sb.append(FileConvert.toPDB(atom, molecId2));
        }
        sb.append("TER");
        sb.append(System.getProperty("line.separator"));
        sb.append("END");
        sb.append(System.getProperty("line.separator"));
        return sb.toString();
    }

    public String toMMCIF() {
        StringBuilder sb = new StringBuilder();
        String molecId1 = this.getMoleculeIds().getFirst();
        String molecId2 = this.getMoleculeIds().getSecond();
        if (this.isSymRelated()) {
            molecId2 = molecId2 + "_" + this.getTransforms().getSecond().getTransformId();
        }
        sb.append("data_").append("BioJava_interface_").append(this.getId()).append(System.getProperty("line.separator"));
        sb.append(FileConvert.getAtomSiteHeader());
        int atomId = 1;
        ArrayList<AtomSite> atomSites = new ArrayList<AtomSite>();
        for (Atom atom : this.molecules.getFirst()) {
            if (this.isSymRelated()) {
                atomSites.add(MMCIFFileTools.convertAtomToAtomSite(atom, 1, molecId1, molecId1, atomId));
            } else {
                atomSites.add(MMCIFFileTools.convertAtomToAtomSite(atom, 1, molecId1, molecId1));
            }
            ++atomId;
        }
        for (Atom atom : this.molecules.getSecond()) {
            if (this.isSymRelated()) {
                atomSites.add(MMCIFFileTools.convertAtomToAtomSite(atom, 1, molecId2, molecId2, atomId));
            } else {
                atomSites.add(MMCIFFileTools.convertAtomToAtomSite(atom, 1, molecId2, molecId2));
            }
            ++atomId;
        }
        sb.append(MMCIFFileTools.toMMCIF(atomSites, AtomSite.class));
        return sb.toString();
    }

    @Override
    public int compareTo(StructureInterface o) {
        return Double.compare(o.totalArea, this.totalArea);
    }

    public String toString() {
        return String.format("StructureInterface %d (%s, %.0f A, <%s; %s>)", this.id, this.moleculeIds, this.totalArea, this.transforms.getFirst().toXYZString(), this.transforms.getSecond().toXYZString());
    }
}

