/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.io.mmcif;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.biojava.nbio.structure.io.mmcif.ChemCompConsumer;
import org.biojava.nbio.structure.io.mmcif.ChemCompProvider;
import org.biojava.nbio.structure.io.mmcif.ChemicalComponentDictionary;
import org.biojava.nbio.structure.io.mmcif.DownloadChemCompProvider;
import org.biojava.nbio.structure.io.mmcif.SimpleMMcifParser;
import org.biojava.nbio.structure.io.mmcif.chem.PolymerType;
import org.biojava.nbio.structure.io.mmcif.chem.ResidueType;
import org.biojava.nbio.structure.io.mmcif.model.ChemComp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipChemCompProvider
implements ChemCompProvider {
    private static final Logger s_logger = LoggerFactory.getLogger(ZipChemCompProvider.class);
    private final Path m_tempDir;
    private final Path m_zipRootDir;
    private final Path m_zipFile;
    private final DownloadChemCompProvider m_dlProvider;
    private boolean m_removeCif;
    private Set<String> unavailable = new HashSet<String>();

    public ZipChemCompProvider(String chemicalComponentDictionaryFile, String tempDir) throws IOException {
        this.m_zipFile = Paths.get(chemicalComponentDictionaryFile, new String[0]);
        this.m_tempDir = tempDir == null || tempDir.equals("") ? Paths.get(System.getProperty("java.io.tmpdir"), new String[0]) : Paths.get(tempDir, new String[0]);
        this.m_zipRootDir = Paths.get("chemcomp", new String[0]);
        this.m_dlProvider = new DownloadChemCompProvider(this.m_tempDir.toString());
        this.m_removeCif = true;
        this.initializeZip();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeZip() throws IOException {
        s_logger.info("Using chemical component dictionary: " + this.m_zipFile.toString());
        File f = this.m_zipFile.toFile();
        if (!f.exists()) {
            s_logger.info("Creating missing zip archive: " + this.m_zipFile.toString());
            FileOutputStream fo = new FileOutputStream(f);
            try (ZipOutputStream zip = new ZipOutputStream(new BufferedOutputStream(fo));){
                zip.putNextEntry(new ZipEntry("chemcomp/"));
                zip.closeEntry();
            }
        }
    }

    public void setRemoveCif(boolean doRemove) {
        this.m_removeCif = doRemove;
    }

    @Override
    public ChemComp getChemComp(String recordName) {
        if (null == recordName) {
            return null;
        }
        for (String str : this.unavailable) {
            if (!recordName.equals(str)) continue;
            return this.getEmptyChemComp(recordName);
        }
        ChemComp cc = this.getFromZip(recordName);
        if (cc == null) {
            s_logger.info("File " + recordName + " not found in archive. Attempting download from PDB.");
            cc = this.downloadAndAdd(recordName);
        }
        if (cc == null || null == cc.getName() && cc.getAtoms().size() == 0) {
            s_logger.info("Unable to find or download " + recordName + " - excluding from future searches.");
            this.unavailable.add(recordName);
            return this.getEmptyChemComp(recordName);
        }
        return cc;
    }

    private ChemComp downloadAndAdd(String recordName) {
        ChemComp cc = this.m_dlProvider.getChemComp(recordName);
        File[] files = new File[1];
        Path cif = this.m_tempDir.resolve("chemcomp").resolve(recordName + ".cif.gz");
        files[0] = cif.toFile();
        if (files[0] != null) {
            this.addToZipFileSystem(this.m_zipFile, files, this.m_zipRootDir);
            if (this.m_removeCif) {
                for (File f : files) {
                    f.delete();
                }
            }
        }
        return cc;
    }

    public static void purgeTempFiles(String tempdir) {
        if (tempdir == null) {
            return;
        }
        s_logger.info("Removing: " + tempdir);
        Path dlPath = Paths.get(tempdir, new String[0]).resolve("chemcomp");
        File[] chemCompOutFiles = ZipChemCompProvider.finder(dlPath.toString(), "cif.gz");
        if (null != chemCompOutFiles) {
            for (File f : chemCompOutFiles) {
                f.delete();
            }
        }
        dlPath.toFile().delete();
    }

    private ChemComp getEmptyChemComp(String resName) {
        String pdbName = "";
        if (null != resName && resName.length() >= 3) {
            pdbName = resName.substring(0, 3);
        }
        ChemComp comp = new ChemComp();
        comp.setOne_letter_code("?");
        comp.setThree_letter_code(pdbName);
        comp.setPolymerType(PolymerType.unknown);
        comp.setResidueType(ResidueType.atomn);
        return comp;
    }

    private static File[] finder(String dirName, final String suffix) {
        if (null == dirName || null == suffix) {
            return null;
        }
        File dir = new File(dirName);
        return dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                return filename.endsWith(suffix);
            }
        });
    }

    private synchronized ChemComp getFromZip(String recordName) {
        ChemComp cc = null;
        if (!this.m_zipFile.toFile().exists()) {
            return cc;
        }
        String filename = "chemcomp/" + recordName + ".cif.gz";
        try (FileSystem fs = FileSystems.newFileSystem(this.m_zipFile, (ClassLoader)null);){
            Path cif = fs.getPath(filename, new String[0]);
            if (Files.exists(cif, new LinkOption[0])) {
                InputStream zipStream = Files.newInputStream(cif, new OpenOption[0]);
                GZIPInputStream inputStream = new GZIPInputStream(zipStream);
                s_logger.debug("reading " + recordName + " from " + this.m_zipFile);
                SimpleMMcifParser parser = new SimpleMMcifParser();
                ChemCompConsumer consumer = new ChemCompConsumer();
                parser.addMMcifConsumer(consumer);
                parser.parse(inputStream);
                ((InputStream)inputStream).close();
                ChemicalComponentDictionary dict = consumer.getDictionary();
                cc = dict.getChemComp(recordName);
            }
        }
        catch (IOException e) {
            s_logger.error("Unable to read from zip file : " + e.getMessage());
        }
        return cc;
    }

    private synchronized boolean addToZipFileSystem(Path zipFile, File[] files, Path pathWithinArchive) {
        boolean ret = false;
        try (FileSystem zipfs = FileSystems.newFileSystem(zipFile, null);){
            Files.createDirectories(pathWithinArchive, new FileAttribute[0]);
            for (File f : files) {
                if (f.isDirectory() || !f.exists()) continue;
                Path externalFile = f.toPath();
                Path pathInZipFile = zipfs.getPath(pathWithinArchive.resolve(f.getName()).toString(), new String[0]);
                Files.copy(externalFile, pathInZipFile, StandardCopyOption.REPLACE_EXISTING);
            }
            ret = true;
        }
        catch (IOException ex) {
            s_logger.error("Unable to add entries to Chemical Component zip archive : " + ex.getMessage());
            ret = false;
        }
        return ret;
    }
}

