/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.scop;

import java.util.HashMap;
import java.util.Map;
import org.biojava.nbio.structure.scop.ScopInstallation;
import org.biojava.nbio.structure.scop.ScopMirror;

public class BerkeleyScopInstallation
extends ScopInstallation {
    String defaultBerkeleyDownloadURL = "http://scop.berkeley.edu/downloads/parse/";
    String defaultBerkeleyScopVersion = "2.08";
    public static final Map<String, String[]> EQUIVALENT_VERSIONS = new HashMap<String, String[]>();

    public BerkeleyScopInstallation() {
        this.setScopVersion(this.defaultBerkeleyScopVersion);
        this.addMirror(new BerkeleyScopMirror(this.defaultBerkeleyDownloadURL));
        this.addMirror(new ScopMirror());
    }

    static {
        EQUIVALENT_VERSIONS.put("2.01", new String[]{"1.75A"});
        EQUIVALENT_VERSIONS.put("2.02", new String[]{"1.75B"});
        EQUIVALENT_VERSIONS.put("2.03", new String[]{"1.75C"});
    }

    private static class BerkeleyScopMirror
    extends ScopMirror {
        private String rootURL;

        public BerkeleyScopMirror(String url) {
            super(url);
            this.rootURL = url;
        }

        @Override
        public String getClaURL(String scopVersion) {
            return this.rootURL + this.getFilename("cla", scopVersion);
        }

        @Override
        public String getDesURL(String scopVersion) {
            return this.rootURL + this.getFilename("des", scopVersion);
        }

        @Override
        public String getHieURL(String scopVersion) {
            return this.rootURL + this.getFilename("hie", scopVersion);
        }

        @Override
        public String getComURL(String scopVersion) {
            return this.rootURL + this.getFilename("com", scopVersion);
        }

        private String getFilename(String fileType, String version) {
            block0: for (Map.Entry<String, String[]> entry : EQUIVALENT_VERSIONS.entrySet()) {
                for (String vr : entry.getValue()) {
                    if (!version.equals(vr)) continue;
                    version = entry.getKey();
                    continue block0;
                }
            }
            String[] parts = version.split("\\.");
            if (Integer.parseInt(parts[0]) == 1) {
                return "dir." + fileType + ".scop." + version + ".txt";
            }
            return "dir." + fileType + ".scope." + version + "-stable.txt";
        }

        public String toString() {
            return "BerkeleyScopMirror[ \"" + this.rootURL + " ]";
        }
    }
}

