/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.AtomIterator;
import org.biojava.nbio.structure.Bond;
import org.biojava.nbio.structure.BondImpl;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.GroupType;
import org.biojava.nbio.structure.ResidueNumber;
import org.biojava.nbio.structure.chem.ChemComp;
import org.biojava.nbio.structure.chem.ChemCompGroupFactory;
import org.biojava.nbio.structure.chem.PolymerType;
import org.biojava.nbio.structure.chem.ResidueType;
import org.biojava.nbio.structure.io.GroupToSDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HetatomImpl
implements Group {
    private static final Logger logger = LoggerFactory.getLogger(HetatomImpl.class);
    private static final long serialVersionUID = 4491470432023820382L;
    public static final GroupType type = GroupType.HETATM;
    private Map<String, Object> properties;
    private long id;
    protected boolean pdb_flag = false;
    protected String pdb_name = null;
    protected ResidueNumber residueNumber = null;
    protected List<Atom> atoms = new ArrayList<Atom>();
    private Chain parent = null;
    private boolean isHetAtomInFile;
    private static PerformanceBehavior performanceBehavior = PerformanceBehavior.LESS_MEMORY_SLOWER_PERFORMANCE;
    private Map<String, Atom> atomNameLookup;
    protected ChemComp chemComp = null;
    private List<Group> altLocs = null;

    public HetatomImpl() {
        this.properties = new HashMap<String, Object>();
        this.atomNameLookup = performanceBehavior == PerformanceBehavior.BETTER_PERFORMANCE_MORE_MEMORY ? new HashMap<String, Atom>() : null;
    }

    @Override
    public boolean has3D() {
        return this.pdb_flag;
    }

    @Override
    public void setPDBFlag(boolean flag) {
        this.pdb_flag = flag;
    }

    @Override
    public void setPDBName(String s) {
        if (s != null && s.equals("?")) {
            logger.info("invalid pdbname: ?");
        }
        this.pdb_name = s;
    }

    @Override
    public String getPDBName() {
        return this.pdb_name;
    }

    @Override
    public void addAtom(Atom atom) {
        Atom existingAtom;
        atom.setGroup(this);
        this.atoms.add(atom);
        if (atom.getCoordsAsPoint3d() != null) {
            this.setPDBFlag(true);
        }
        if (this.atomNameLookup != null && (existingAtom = this.atomNameLookup.put(atom.getName(), atom)) != null) {
            Object altLocStr = "";
            char altLoc = atom.getAltLoc().charValue();
            if (altLoc != ' ') {
                altLocStr = "(alt loc '" + altLoc + "')";
            }
            logger.warn("An atom with name " + atom.getName() + " " + (String)altLocStr + " is already present in group: " + this.toString() + ". The atom with serial " + existingAtom.getPDBserial() + " will be ignored in look-ups.");
        }
    }

    @Override
    public void clearAtoms() {
        this.atoms.clear();
        this.setPDBFlag(false);
        if (this.atomNameLookup != null) {
            this.atomNameLookup.clear();
        }
    }

    @Override
    public int size() {
        return this.atoms.size();
    }

    @Override
    public List<Atom> getAtoms() {
        return this.atoms;
    }

    @Override
    public void setAtoms(List<Atom> atoms) {
        if (this.atomNameLookup != null) {
            this.atomNameLookup.clear();
        }
        for (Atom a : atoms) {
            a.setGroup(this);
            if (this.atomNameLookup == null) continue;
            this.atomNameLookup.put(a.getName(), a);
        }
        this.atoms = atoms;
        if (!atoms.isEmpty()) {
            this.pdb_flag = true;
        }
    }

    @Override
    public Atom getAtom(String name) {
        if (this.atomNameLookup != null) {
            return this.atomNameLookup.get(name);
        }
        for (Atom a : this.atoms) {
            if (!a.getName().equals(name)) continue;
            return a;
        }
        return null;
    }

    @Override
    public Atom getAtom(int position) {
        if (position < 0 || position >= this.atoms.size()) {
            return null;
        }
        return this.atoms.get(position);
    }

    @Override
    public boolean hasAtom(String fullName) {
        if (this.atomNameLookup != null) {
            Atom a = this.atomNameLookup.get(fullName.trim());
            return a != null;
        }
        for (Atom a : this.atoms) {
            if (!a.getName().equals(fullName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public GroupType getType() {
        return type;
    }

    public String toString() {
        String str = "Hetatom " + this.residueNumber + " " + this.pdb_name + " " + this.pdb_flag;
        if (this.pdb_flag) {
            str = str + " atoms: " + this.atoms.size();
        }
        if (this.altLocs != null) {
            str = str + " has altLocs :" + this.altLocs.size();
        }
        return str;
    }

    @Override
    public boolean hasAminoAtoms() {
        return this.hasAtom("CA") && this.hasAtom("C") && this.hasAtom("N") && this.hasAtom("O");
    }

    @Override
    public boolean isPolymeric() {
        ChemComp cc = this.getChemComp();
        if (cc == null) {
            return this.getType().equals((Object)GroupType.AMINOACID) || this.getType().equals((Object)GroupType.NUCLEOTIDE);
        }
        ResidueType rt = cc.getResidueType();
        if (rt.equals(ResidueType.nonPolymer)) {
            return false;
        }
        PolymerType pt = rt.getPolymerType();
        return PolymerType.PROTEIN_ONLY.contains(pt) || PolymerType.POLYNUCLEOTIDE_ONLY.contains(pt) || ResidueType.lPeptideLinking.equals(rt);
    }

    @Override
    public boolean isAminoAcid() {
        ChemComp cc = this.getChemComp();
        if (cc == null) {
            return this.getType().equals((Object)GroupType.AMINOACID);
        }
        ResidueType rt = ResidueType.getResidueTypeFromString(cc.getType());
        if (ResidueType.nonPolymer.equals(rt)) {
            return false;
        }
        PolymerType pt = rt.getPolymerType();
        return PolymerType.PROTEIN_ONLY.contains(pt);
    }

    @Override
    public boolean isNucleotide() {
        ChemComp cc = this.getChemComp();
        if (cc == null) {
            return this.getType().equals((Object)GroupType.NUCLEOTIDE);
        }
        ResidueType rt = ResidueType.getResidueTypeFromString(cc.getType());
        if (ResidueType.nonPolymer.equals(rt)) {
            return false;
        }
        PolymerType pt = rt.getPolymerType();
        return PolymerType.POLYNUCLEOTIDE_ONLY.contains(pt);
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        this.properties = props;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    @Override
    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    @Override
    public Iterator<Atom> iterator() {
        return new AtomIterator(this);
    }

    @Override
    public Object clone() {
        HetatomImpl n = new HetatomImpl();
        n.setPDBFlag(this.has3D());
        n.setResidueNumber(this.residueNumber);
        n.setPDBName(this.getPDBName());
        this.cloneAtomsAndBonds(n);
        if (this.altLocs != null) {
            for (Group altLocGroup : this.altLocs) {
                Group nAltLocGroup = (Group)altLocGroup.clone();
                n.addAltLoc(nAltLocGroup);
            }
        }
        if (this.chemComp != null) {
            n.setChemComp(this.chemComp);
        }
        return n;
    }

    protected void cloneAtomsAndBonds(Group newGroup) {
        for (Atom atom1 : this.atoms) {
            Atom atom = (Atom)atom1.clone();
            newGroup.addAtom(atom);
            atom.setGroup(newGroup);
        }
        for (int i = 0; i < this.atoms.size(); ++i) {
            Atom atom1;
            atom1 = this.atoms.get(i);
            List<Bond> bonds1 = atom1.getBonds();
            if (bonds1 == null) continue;
            for (Bond b : bonds1) {
                int atomAIndex = this.atoms.indexOf(b.getAtomA());
                int atomBIndex = this.atoms.indexOf(b.getAtomB());
                BondImpl newBond = new BondImpl(newGroup.getAtom(atomAIndex), newGroup.getAtom(atomBIndex), b.getBondOrder(), false);
                newGroup.getAtom(i).addBond(newBond);
            }
        }
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Override
    public ChemComp getChemComp() {
        if (this.chemComp == null) {
            this.chemComp = ChemCompGroupFactory.getChemComp(this.pdb_name);
            if (this.chemComp == null) {
                logger.info("getChemComp: {}", (Object)this.pdb_name);
            }
        }
        return this.chemComp;
    }

    @Override
    public void setChemComp(ChemComp cc) {
        this.chemComp = cc;
    }

    @Override
    public void setChain(Chain chain) {
        this.parent = chain;
        if (this.residueNumber != null) {
            this.residueNumber.setChainName(chain.getName());
        }
    }

    @Override
    public Chain getChain() {
        return this.parent;
    }

    @Override
    public String getChainId() {
        if (this.parent == null) {
            return "";
        }
        return this.parent.getId();
    }

    @Override
    public ResidueNumber getResidueNumber() {
        return this.residueNumber;
    }

    @Override
    public void setResidueNumber(ResidueNumber residueNumber) {
        this.residueNumber = residueNumber;
    }

    @Override
    public void setResidueNumber(String chainId, Integer resNum, Character iCode) {
        this.residueNumber = new ResidueNumber(chainId, resNum, iCode);
    }

    @Override
    public boolean hasAltLoc() {
        if (this.altLocs == null) {
            return false;
        }
        return !this.altLocs.isEmpty();
    }

    @Override
    public List<Group> getAltLocs() {
        if (this.altLocs == null) {
            return new ArrayList<Group>();
        }
        return this.altLocs;
    }

    @Override
    public Group getAltLocGroup(Character altLoc) {
        Atom a = this.getAtom(0);
        if (a == null) {
            return null;
        }
        if (a.getAltLoc().equals(altLoc)) {
            return this;
        }
        if (this.altLocs == null || this.altLocs.isEmpty()) {
            return null;
        }
        for (Group group : this.altLocs) {
            Atom b;
            if (group.getAtoms().isEmpty() || (b = group.getAtom(0)) == null || !b.getAltLoc().equals(altLoc)) continue;
            return group;
        }
        return null;
    }

    @Override
    public void addAltLoc(Group group) {
        if (this.altLocs == null) {
            this.altLocs = new ArrayList<Group>();
        }
        this.altLocs.add(group);
    }

    @Override
    public boolean isWater() {
        return GroupType.WATERNAMES.contains(this.pdb_name);
    }

    @Override
    public void trimToSize() {
        if (this.atoms instanceof ArrayList) {
            ArrayList myatoms = (ArrayList)this.atoms;
            myatoms.trimToSize();
        }
        if (this.altLocs instanceof ArrayList) {
            ArrayList myAltLocs = (ArrayList)this.altLocs;
            myAltLocs.trimToSize();
        }
        if (this.hasAltLoc()) {
            for (Group alt : this.getAltLocs()) {
                alt.trimToSize();
            }
        }
        this.properties = new HashMap<String, Object>(this.properties);
        if (this.atomNameLookup != null) {
            this.atomNameLookup = new HashMap<String, Atom>(this.atomNameLookup);
        }
    }

    @Override
    public String toSDF() {
        GroupToSDF gts = new GroupToSDF();
        return gts.getText(this);
    }

    @Override
    public boolean isHetAtomInFile() {
        return this.isHetAtomInFile;
    }

    @Override
    public void setHetAtomInFile(boolean isHetAtomInFile) {
        this.isHetAtomInFile = isHetAtomInFile;
    }

    public static enum PerformanceBehavior {
        BETTER_PERFORMANCE_MORE_MEMORY,
        LESS_MEMORY_SLOWER_PERFORMANCE;

    }
}

