/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.contact;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import org.biojava.nbio.core.util.SingleLinkageClusterer;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.asa.AsaCalculator;
import org.biojava.nbio.structure.contact.StructureInterface;
import org.biojava.nbio.structure.contact.StructureInterfaceCluster;
import org.biojava.nbio.structure.xtal.CrystalBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StructureInterfaceList
implements Serializable,
Iterable<StructureInterface> {
    private static final Logger logger = LoggerFactory.getLogger(StructureInterfaceList.class);
    public static final double DEFAULT_MINIMUM_INTERFACE_AREA = 35.0;
    public static final int DEFAULT_ASA_SPHERE_POINTS = 3000;
    public static final int DEFAULT_MIN_COFACTOR_SIZE = 40;
    public static final double DEFAULT_CONTACT_OVERLAP_SCORE_CLUSTER_CUTOFF = 0.2;
    private static final long serialVersionUID = 1L;
    private final List<StructureInterface> list = new ArrayList<StructureInterface>();
    private List<StructureInterfaceCluster> clusters = null;
    private List<StructureInterfaceCluster> clustersNcs = null;
    private Map<String, String> chainOrigNamesMap;

    public void add(StructureInterface interf) {
        this.list.add(interf);
    }

    public int size() {
        return this.list.size();
    }

    public List<StructureInterface> getList() {
        return this.list;
    }

    public StructureInterface get(int id) {
        return this.list.get(id - 1);
    }

    public void calcAsas() {
        this.calcAsas(3000, Runtime.getRuntime().availableProcessors(), 40);
    }

    public void calcAsas(int nSpherePoints, int nThreads, int cofactorSizeToUse) {
        List<StructureInterface> redundancyReducedList;
        TreeMap<Object, Atom[]> uniqAsaChains = new TreeMap<Object, Atom[]>();
        TreeMap<String, double[]> chainAsas = new TreeMap<String, double[]>();
        if (this.clustersNcs != null) {
            redundancyReducedList = new ArrayList<StructureInterface>();
            for (StructureInterfaceCluster ncsCluster : this.clustersNcs) {
                redundancyReducedList.add(ncsCluster.getMembers().get(0));
            }
        } else {
            redundancyReducedList = this.list;
        }
        for (StructureInterface interf : redundancyReducedList) {
            String molecId1 = interf.getMoleculeIds().getFirst() + interf.getTransforms().getFirst().getTransformId();
            String molecId2 = interf.getMoleculeIds().getSecond() + interf.getTransforms().getSecond().getTransformId();
            uniqAsaChains.put(molecId1, interf.getFirstAtomsForAsa(cofactorSizeToUse));
            uniqAsaChains.put(molecId2, interf.getSecondAtomsForAsa(cofactorSizeToUse));
        }
        logger.debug("Will calculate uncomplexed ASA for {} orientation-unique chains.", (Object)uniqAsaChains.size());
        long start = System.currentTimeMillis();
        for (String molecId : uniqAsaChains.keySet()) {
            logger.debug("Calculating uncomplexed ASA for molecId {}, with {} atoms", (Object)molecId, (Object)((Atom[])uniqAsaChains.get(molecId)).length);
            AsaCalculator asaCalc = new AsaCalculator((Atom[])uniqAsaChains.get(molecId), 1.4, nSpherePoints, nThreads);
            double[] atomAsas = asaCalc.calculateAsas();
            chainAsas.put(molecId, atomAsas);
        }
        long end = System.currentTimeMillis();
        logger.debug("Calculated uncomplexed ASA for {} orientation-unique chains. Time: {} s", (Object)uniqAsaChains.size(), (Object)((double)(end - start) / 1000.0));
        logger.debug("Will calculate complexed ASA for {} pairwise complexes.", (Object)redundancyReducedList.size());
        start = System.currentTimeMillis();
        for (StructureInterface interf : redundancyReducedList) {
            String molecId1 = interf.getMoleculeIds().getFirst() + interf.getTransforms().getFirst().getTransformId();
            String molecId2 = interf.getMoleculeIds().getSecond() + interf.getTransforms().getSecond().getTransformId();
            logger.debug("Calculating complexed ASAs for interface {} between molecules {} and {}", new Object[]{interf.getId(), molecId1, molecId2});
            interf.setAsas((double[])chainAsas.get(molecId1), (double[])chainAsas.get(molecId2), nSpherePoints, nThreads, cofactorSizeToUse);
        }
        end = System.currentTimeMillis();
        logger.debug("Calculated complexes ASA for {} pairwise complexes. Time: {} s", (Object)redundancyReducedList.size(), (Object)((double)(end - start) / 1000.0));
        if (this.clustersNcs != null) {
            if (this.chainOrigNamesMap == null) {
                logger.warn("No chainOrigNamesMap is set. Considering NCS interfaces in same order as reference. This is likely a bug.");
            }
            for (StructureInterfaceCluster ncsCluster : this.clustersNcs) {
                StructureInterface refInterf = ncsCluster.getMembers().get(0);
                String refMolecId1 = refInterf.getMoleculeIds().getFirst();
                for (int i = 1; i < ncsCluster.getMembers().size(); ++i) {
                    StructureInterface member = ncsCluster.getMembers().get(i);
                    member.setTotalArea(refInterf.getTotalArea());
                    String molecId1 = member.getMoleculeIds().getFirst();
                    if (this.areMolecIdsSameOrder(refMolecId1, molecId1)) {
                        member.setFirstGroupAsas(refInterf.getFirstGroupAsas());
                        member.setSecondGroupAsas(refInterf.getSecondGroupAsas());
                        continue;
                    }
                    member.setFirstGroupAsas(refInterf.getSecondGroupAsas());
                    member.setSecondGroupAsas(refInterf.getFirstGroupAsas());
                }
            }
        }
        this.sort();
    }

    private boolean areMolecIdsSameOrder(String refMolecId, String molecId) {
        if (this.chainOrigNamesMap == null) {
            return true;
        }
        String refMolecIdOrig = this.chainOrigNamesMap.get(refMolecId);
        String molecIdOrig = this.chainOrigNamesMap.get(molecId);
        return refMolecIdOrig.equals(molecIdOrig);
    }

    public void sort() {
        Collections.sort(this.list);
        int i = 1;
        for (StructureInterface interf : this.list) {
            interf.setId(i);
            ++i;
        }
    }

    public List<StructureInterfaceCluster> getClustersNcs() {
        return this.clustersNcs;
    }

    public void addNcsEquivalent(StructureInterface interfaceNew, StructureInterface interfaceRef) {
        this.add(interfaceNew);
        if (this.clustersNcs == null) {
            this.clustersNcs = new ArrayList<StructureInterfaceCluster>();
        }
        if (interfaceRef == null) {
            StructureInterfaceCluster newCluster = new StructureInterfaceCluster();
            newCluster.addMember(interfaceNew);
            this.clustersNcs.add(newCluster);
            return;
        }
        Optional<StructureInterfaceCluster> clusterRef = this.clustersNcs.stream().filter(r -> r.getMembers().stream().anyMatch(c -> c.equals(interfaceRef))).findFirst();
        if (clusterRef.isPresent()) {
            clusterRef.get().addMember(interfaceNew);
            return;
        }
        logger.warn("The specified reference interface, if not null, should have been added to this set previously. Creating new cluster and adding both interfaces. This is likely a bug.");
        this.add(interfaceRef);
        StructureInterfaceCluster newCluster = new StructureInterfaceCluster();
        newCluster.addMember(interfaceRef);
        newCluster.addMember(interfaceNew);
        this.clustersNcs.add(newCluster);
    }

    public void setChainOrigNamesMap(Map<String, String> chainOrigNamesMap) {
        this.chainOrigNamesMap = chainOrigNamesMap;
    }

    public void removeInterfacesBelowArea() {
        this.removeInterfacesBelowArea(35.0);
    }

    public void removeInterfacesBelowArea(double area) {
        this.list.removeIf(interf -> interf.getTotalArea() < area);
        if (this.clustersNcs != null) {
            this.clustersNcs.removeIf(ncsCluster -> ncsCluster.getMembers().get(0).getTotalArea() < area);
        }
    }

    public List<StructureInterfaceCluster> getClusters() {
        return this.getClusters(0.2);
    }

    public List<StructureInterfaceCluster> getClusters(double contactOverlapScoreClusterCutoff) {
        Iterator<StructureInterfaceCluster> iInterf;
        if (this.clusters != null) {
            return this.clusters;
        }
        this.clusters = new ArrayList<StructureInterfaceCluster>();
        if (this.list.size() == 0) {
            return this.clusters;
        }
        logger.debug("Calculating all-vs-all Jaccard scores for {} interfaces", (Object)this.list.size());
        double[][] matrix = new double[this.list.size()][this.list.size()];
        for (int i = 0; i < this.list.size(); ++i) {
            for (int j = i + 1; j < this.list.size(); ++j) {
                double maxScore;
                iInterf = this.list.get(i);
                StructureInterface jInterf = this.list.get(j);
                double scoreDirect = ((StructureInterface)((Object)iInterf)).getContactOverlapScore(jInterf, false);
                double scoreInvert = ((StructureInterface)((Object)iInterf)).getContactOverlapScore(jInterf, true);
                matrix[i][j] = maxScore = Math.max(scoreDirect, scoreInvert);
            }
        }
        logger.debug("Will now cluster {} interfaces based on full all-vs-all Jaccard scores matrix", (Object)this.list.size());
        SingleLinkageClusterer slc = new SingleLinkageClusterer(matrix, true);
        Map clusteredIndices = slc.getClusters(contactOverlapScoreClusterCutoff);
        iInterf = clusteredIndices.keySet().iterator();
        while (iInterf.hasNext()) {
            int clusterIdx = (Integer)iInterf.next();
            ArrayList<StructureInterface> members = new ArrayList<StructureInterface>();
            Iterator iterator = ((Set)clusteredIndices.get(clusterIdx)).iterator();
            while (iterator.hasNext()) {
                int idx = (Integer)iterator.next();
                members.add(this.list.get(idx));
            }
            StructureInterfaceCluster cluster = new StructureInterfaceCluster();
            cluster.setMembers(members);
            double averageScore = 0.0;
            int countPairs = 0;
            for (int i = 0; i < members.size(); ++i) {
                int iIdx = this.list.indexOf(members.get(i));
                for (int j = i + 1; j < members.size(); ++j) {
                    averageScore += matrix[iIdx][this.list.indexOf(members.get(j))];
                    ++countPairs;
                }
            }
            averageScore = countPairs > 0 ? (averageScore /= (double)countPairs) : 1.0;
            cluster.setAverageScore(averageScore);
            this.clusters.add(cluster);
        }
        for (StructureInterfaceCluster cluster : this.clusters) {
            for (StructureInterface interf : cluster.getMembers()) {
                interf.setCluster(cluster);
            }
        }
        logger.debug("Done clustering {} interfaces based on full all-vs-all Jaccard scores matrix. Found a total of {} clusters", (Object)this.list.size(), (Object)this.clusters.size());
        this.clusters.sort((o1, o2) -> Double.compare(o2.getTotalArea(), o1.getTotalArea()));
        int id = 1;
        for (StructureInterfaceCluster cluster : this.clusters) {
            cluster.setId(id);
            ++id;
        }
        return this.clusters;
    }

    @Override
    public Iterator<StructureInterface> iterator() {
        return this.list.iterator();
    }

    public String toString() {
        return this.list.toString();
    }

    public static StructureInterfaceList calculateInterfaces(Structure struc) {
        CrystalBuilder builder = new CrystalBuilder(struc);
        StructureInterfaceList interfaces = builder.getUniqueInterfaces();
        logger.debug("Calculating ASA for " + interfaces.size() + " potential interfaces");
        interfaces.calcAsas(3000, Runtime.getRuntime().availableProcessors(), 40);
        interfaces.removeInterfacesBelowArea();
        interfaces.getClusters();
        logger.debug("Found " + interfaces.size() + " interfaces");
        return interfaces;
    }
}

