/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.io;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.biojava.nbio.structure.AminoAcidImpl;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Bond;
import org.biojava.nbio.structure.BondImpl;
import org.biojava.nbio.structure.Calc;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.Element;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.NucleotideImpl;
import org.biojava.nbio.structure.ResidueNumber;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.chem.ChemComp;
import org.biojava.nbio.structure.chem.ChemCompBond;
import org.biojava.nbio.structure.chem.ChemCompGroupFactory;
import org.biojava.nbio.structure.io.FileParsingParameters;
import org.biojava.nbio.structure.io.SSBondImpl;
import org.biojava.nbio.structure.io.util.PDBTemporaryStorageUtils;
import org.rcsb.cif.model.ValueKind;
import org.rcsb.cif.schema.mm.StructConn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BondMaker {
    private static final Logger logger = LoggerFactory.getLogger(BondMaker.class);
    public static final Set<String> BOND_TYPES_TO_PARSE = new HashSet<String>();
    private static final double MAX_PEPTIDE_BOND_LENGTH = 1.8;
    private static final double MAX_NUCLEOTIDE_BOND_LENGTH = 2.1;
    private final Structure structure;
    private final FileParsingParameters params;

    public BondMaker(Structure structure, FileParsingParameters params) {
        this.structure = structure;
        this.params = params;
    }

    public void makeBonds() {
        logger.debug("Going to start making bonds");
        this.formPeptideBonds();
        this.formNucleotideBonds();
        this.formIntraResidueBonds();
        this.trimBondLists();
    }

    private void formPeptideBonds() {
        for (int modelInd = 0; modelInd < this.structure.nrModels(); ++modelInd) {
            for (Chain chain : this.structure.getChains(modelInd)) {
                List<Group> groups = chain.getSeqResGroups();
                for (int i = 0; i < groups.size() - 1; ++i) {
                    if (!(groups.get(i) instanceof AminoAcidImpl) || !(groups.get(i + 1) instanceof AminoAcidImpl)) continue;
                    AminoAcidImpl tail = (AminoAcidImpl)groups.get(i);
                    AminoAcidImpl head = (AminoAcidImpl)groups.get(i + 1);
                    if (tail.getResidueNumber() == null || head.getResidueNumber() == null) continue;
                    this.formBondAltlocAware(tail, "C", head, "N", 1.8, 1);
                }
            }
        }
    }

    private void formNucleotideBonds() {
        for (int modelInd = 0; modelInd < this.structure.nrModels(); ++modelInd) {
            for (Chain chain : this.structure.getChains(modelInd)) {
                List<Group> groups = chain.getSeqResGroups();
                for (int i = 0; i < groups.size() - 1; ++i) {
                    if (!(groups.get(i) instanceof NucleotideImpl) || !(groups.get(i + 1) instanceof NucleotideImpl)) continue;
                    NucleotideImpl tail = (NucleotideImpl)groups.get(i);
                    NucleotideImpl head = (NucleotideImpl)groups.get(i + 1);
                    if (tail.getResidueNumber() == null || head.getResidueNumber() == null) continue;
                    this.formBondAltlocAware(head, "P", tail, "O3'", 2.1, 1);
                }
            }
        }
    }

    private void formIntraResidueBonds() {
        for (int modelInd = 0; modelInd < this.structure.nrModels(); ++modelInd) {
            for (Chain chain : this.structure.getChains(modelInd)) {
                List<Group> groups = chain.getAtomGroups();
                for (Group mainGroup : groups) {
                    if (mainGroup.getResidueNumber() == null) continue;
                    ArrayList<Group> totList = new ArrayList<Group>();
                    totList.add(mainGroup);
                    totList.addAll(mainGroup.getAltLocs());
                    for (Group group : totList) {
                        ChemComp aminoChemComp = ChemCompGroupFactory.getChemComp(group.getPDBName());
                        logger.debug("chemcomp for residue {}-{} has {} atoms and {} bonds", new Object[]{group.getPDBName(), group.getResidueNumber(), aminoChemComp.getAtoms().size(), aminoChemComp.getBonds().size()});
                        for (ChemCompBond chemCompBond : aminoChemComp.getBonds()) {
                            this.formBondAltlocAware(group, chemCompBond.getAtomId1(), group, chemCompBond.getAtomId2(), -1.0, chemCompBond.getNumericalBondOrder());
                        }
                    }
                }
            }
        }
    }

    private void formBondAltlocAware(Group g1, String name1, Group g2, String name2, double maxAllowedLength, int bondOrder) {
        List<Atom> a1s = this.getAtoms(g1, name1);
        List<Atom> a2s = this.getAtoms(g2, name2);
        if (a1s.isEmpty() || a2s.isEmpty()) {
            return;
        }
        for (Atom a1 : a1s) {
            for (Atom a2 : a2s) {
                if (a1.getAltLoc() != null && a2.getAltLoc() != null && a1.getAltLoc().charValue() != ' ' && a2.getAltLoc().charValue() != ' ' && a1.getAltLoc() != a2.getAltLoc()) {
                    logger.debug("Skipping bond between atoms with differently named alt locs {} (altLoc '{}') -- {} (altLoc '{}')", new Object[]{a1.toString(), a1.getAltLoc(), a2.toString(), a2.getAltLoc()});
                    continue;
                }
                if (maxAllowedLength < 0.0) {
                    logger.debug("Forming bond between atoms {}-{} and {}-{} with bond order {}", new Object[]{a1.getPDBserial(), a1.getName(), a2.getPDBserial(), a2.getName(), bondOrder});
                    new BondImpl(a1, a2, bondOrder);
                    continue;
                }
                if (Calc.getDistance(a1, a2) < maxAllowedLength) {
                    logger.debug("Forming bond between atoms {}-{} and {}-{} with bond order {}. Distance is below {}", new Object[]{a1.getPDBserial(), a1.getName(), a2.getPDBserial(), a2.getName(), bondOrder, maxAllowedLength});
                    new BondImpl(a1, a2, bondOrder);
                    continue;
                }
                logger.debug("Not forming bond between atoms {}-{} and {}-{} with bond order {}, because distance is above {}", new Object[]{a1.getPDBserial(), a1.getName(), a2.getPDBserial(), a2.getName(), bondOrder, maxAllowedLength});
            }
        }
    }

    private List<Atom> getAtoms(Group g, String name) {
        ArrayList<Atom> atoms = new ArrayList<Atom>();
        ArrayList<Group> groupsWithAltLocs = new ArrayList<Group>();
        groupsWithAltLocs.add(g);
        groupsWithAltLocs.addAll(g.getAltLocs());
        for (Group group : groupsWithAltLocs) {
            Atom a = group.getAtom(name);
            if (a == null && name.startsWith("H") && (a = group.getAtom(name.replaceFirst("H", "D"))) != null && !a.getElement().equals((Object)Element.D)) {
                a = null;
            }
            if (a == null) continue;
            atoms.add(a);
        }
        return atoms;
    }

    private void trimBondLists() {
        for (int modelInd = 0; modelInd < this.structure.nrModels(); ++modelInd) {
            for (Chain chain : this.structure.getChains(modelInd)) {
                for (Group group : chain.getAtomGroups()) {
                    for (Atom atom : group.getAtoms()) {
                        if (atom.getBonds() == null || atom.getBonds().size() <= 0) continue;
                        ((ArrayList)atom.getBonds()).trimToSize();
                    }
                }
            }
        }
    }

    public void formDisulfideBonds(List<SSBondImpl> disulfideBonds) {
        for (SSBondImpl disulfideBond : disulfideBonds) {
            this.formDisulfideBond(disulfideBond);
        }
    }

    private void formDisulfideBond(SSBondImpl disulfideBond) {
        try {
            Chain polyChain1 = this.structure.getPolyChainByPDB(disulfideBond.getChainID1());
            Chain polyChain2 = this.structure.getPolyChainByPDB(disulfideBond.getChainID2());
            List<Chain> nonpolyChains1 = this.structure.getNonPolyChainsByPDB(disulfideBond.getChainID1());
            List<Chain> nonpolyChains2 = this.structure.getNonPolyChainsByPDB(disulfideBond.getChainID2());
            ArrayList<String> allChainIds1 = new ArrayList<String>();
            ArrayList<String> allChainIds2 = new ArrayList<String>();
            if (polyChain1 != null) {
                allChainIds1.add(polyChain1.getId());
            }
            if (polyChain2 != null) {
                allChainIds2.add(polyChain2.getId());
            }
            if (nonpolyChains1 != null) {
                nonpolyChains1.forEach(npc -> allChainIds1.add(npc.getId()));
            }
            if (nonpolyChains2 != null) {
                nonpolyChains2.forEach(npc -> allChainIds2.add(npc.getId()));
            }
            Map<Integer, Atom> a = this.getAtomFromRecordTryMultipleChainIds("SG", "", disulfideBond.getResnum1(), disulfideBond.getInsCode1(), allChainIds1);
            Map<Integer, Atom> b = this.getAtomFromRecordTryMultipleChainIds("SG", "", disulfideBond.getResnum2(), disulfideBond.getInsCode2(), allChainIds2);
            for (int i = 0; i < this.structure.nrModels(); ++i) {
                if (!a.containsKey(i) || !b.containsKey(i) || a.get(i).equals(b.get(i))) continue;
                BondImpl ssbond = new BondImpl(a.get(i), b.get(i), 1);
                this.structure.addSSBond(ssbond);
            }
        }
        catch (StructureException e) {
            if (!this.params.isParseCAOnly()) {
                logger.warn("Could not find atoms specified in SSBOND record: {}", (Object)disulfideBond.toString());
            }
            logger.debug("Could not find atoms specified in SSBOND record while parsing in parseCAonly mode.");
        }
    }

    public void formLinkRecordBond(PDBTemporaryStorageUtils.LinkRecord linkRecord) {
        if (linkRecord.getAltLoc1().equals(" ") || linkRecord.getAltLoc2().equals(" ")) {
            return;
        }
        try {
            Chain polyChain1 = this.structure.getPolyChainByPDB(linkRecord.getChainID1());
            Chain polyChain2 = this.structure.getPolyChainByPDB(linkRecord.getChainID2());
            List<Chain> nonpolyChains1 = this.structure.getNonPolyChainsByPDB(linkRecord.getChainID1());
            List<Chain> nonpolyChains2 = this.structure.getNonPolyChainsByPDB(linkRecord.getChainID2());
            Chain waterChain1 = this.structure.getWaterChainByPDB(linkRecord.getChainID1());
            Chain waterChain2 = this.structure.getWaterChainByPDB(linkRecord.getChainID2());
            ArrayList<String> allChainIds1 = new ArrayList<String>();
            ArrayList<String> allChainIds2 = new ArrayList<String>();
            if (polyChain1 != null) {
                allChainIds1.add(polyChain1.getId());
            }
            if (polyChain2 != null) {
                allChainIds2.add(polyChain2.getId());
            }
            if (nonpolyChains1 != null) {
                nonpolyChains1.forEach(npc -> allChainIds1.add(npc.getId()));
            }
            if (nonpolyChains2 != null) {
                nonpolyChains2.forEach(npc -> allChainIds2.add(npc.getId()));
            }
            if (waterChain1 != null && linkRecord.getResName1().equals("HOH")) {
                allChainIds1.add(waterChain1.getId());
            }
            if (waterChain2 != null && linkRecord.getResName2().equals("HOH")) {
                allChainIds2.add(waterChain2.getId());
            }
            Map<Integer, Atom> a = this.getAtomFromRecordTryMultipleChainIds(linkRecord.getName1(), linkRecord.getAltLoc1(), linkRecord.getResSeq1(), linkRecord.getiCode1(), allChainIds1);
            Map<Integer, Atom> b = this.getAtomFromRecordTryMultipleChainIds(linkRecord.getName2(), linkRecord.getAltLoc2(), linkRecord.getResSeq2(), linkRecord.getiCode2(), allChainIds2);
            for (int i = 0; i < this.structure.nrModels(); ++i) {
                if (!a.containsKey(i) || !b.containsKey(i) || a.get(i).equals(b.get(i))) continue;
                new BondImpl(a.get(i), b.get(i), 1);
            }
        }
        catch (StructureException e) {
            if (!this.params.isParseCAOnly()) {
                logger.warn("Could not find atoms specified in LINK record: {}", (Object)linkRecord.toString());
            }
            logger.debug("Could not find atoms specified in LINK record while parsing in parseCAonly mode.");
        }
    }

    private Map<Integer, Atom> getAtomFromRecordTryMultipleChainIds(String name, String altLoc, String resSeq, String iCode, List<String> chainIds) throws StructureException {
        Map<Integer, Atom> a = null;
        for (String chainId : chainIds) {
            try {
                a = this.getAtomFromRecord(name, altLoc, chainId, resSeq, iCode);
                break;
            }
            catch (StructureException e) {
                logger.debug("Tried to get atom {} {} {} (alt loc {}) from chain id {}, but did not find it", new Object[]{name, resSeq, iCode, altLoc, chainId});
            }
        }
        if (a == null) {
            throw new StructureException("Could not find atom " + name + " " + resSeq + " " + iCode + " (alt loc " + altLoc + ")");
        }
        return a;
    }

    public void formBondsFromStructConn(StructConn conn) {
        String symop = "1_555";
        ArrayList<Bond> ssbonds = new ArrayList<Bond>();
        for (int i = 0; i < conn.getRowCount(); ++i) {
            if (!BOND_TYPES_TO_PARSE.contains(conn.getConnTypeId().get(i))) continue;
            String chainId1 = conn.getPtnr1LabelAsymId().get(i);
            String chainId2 = conn.getPtnr2LabelAsymId().get(i);
            String insCode1 = "";
            if (conn.getPdbxPtnr1PDBInsCode().getValueKind(i) == ValueKind.PRESENT) {
                insCode1 = conn.getPdbxPtnr1PDBInsCode().get(i);
            }
            String insCode2 = "";
            if (conn.getPdbxPtnr2PDBInsCode().getValueKind(i) == ValueKind.PRESENT) {
                insCode2 = conn.getPdbxPtnr2PDBInsCode().get(i);
            }
            String seqId1 = conn.getPtnr1AuthSeqId().getStringData(i);
            String seqId2 = conn.getPtnr2AuthSeqId().getStringData(i);
            String resName1 = conn.getPtnr1LabelCompId().get(i);
            String resName2 = conn.getPtnr2LabelCompId().get(i);
            String atomName1 = conn.getPtnr1LabelAtomId().get(i);
            String atomName2 = conn.getPtnr2LabelAtomId().get(i);
            String altLoc1 = "";
            if (conn.getPdbxPtnr1LabelAltId().getValueKind(i) == ValueKind.PRESENT) {
                altLoc1 = conn.getPdbxPtnr1LabelAltId().get(i);
            }
            String altLoc2 = "";
            if (conn.getPdbxPtnr2LabelAltId().getValueKind(i) == ValueKind.PRESENT) {
                altLoc2 = conn.getPdbxPtnr2LabelAltId().get(i);
            }
            if (!conn.getPtnr1Symmetry().get(i).equals("1_555") || !conn.getPtnr2Symmetry().get(i).equals("1_555")) {
                logger.info("Skipping bond between atoms {}(residue {}{}) and {}(residue {}{}) belonging to different symmetry partners, because it is not supported yet", new Object[]{atomName1, seqId1, insCode1, atomName2, seqId2, insCode2});
                continue;
            }
            Object altLocStr1 = altLoc1.isEmpty() ? "" : "(alt loc " + altLoc1 + ")";
            Object altLocStr2 = altLoc2.isEmpty() ? "" : "(alt loc " + altLoc2 + ")";
            Map<Integer, Atom> a1 = null;
            Map<Integer, Atom> a2 = null;
            try {
                a1 = this.getAtomFromRecord(atomName1, altLoc1, chainId1, seqId1, insCode1);
            }
            catch (StructureException e) {
                logger.warn("Could not find atom specified in struct_conn record: {}{}({}) in chain {}, atom {} {}", new Object[]{seqId1, insCode1, resName1, chainId1, atomName1, altLocStr1});
                continue;
            }
            try {
                a2 = this.getAtomFromRecord(atomName2, altLoc2, chainId2, seqId2, insCode2);
            }
            catch (StructureException e) {
                logger.warn("Could not find atom specified in struct_conn record: {}{}({}) in chain {}, atom {} {}", new Object[]{seqId2, insCode2, resName2, chainId2, atomName2, altLocStr2});
                continue;
            }
            if (a1 == null) {
                logger.warn("Could not find atom {} {} from residue {}{}({}) in chain {} to create bond specified in struct_conn", new Object[]{atomName1, altLocStr1, seqId1, insCode1, resName1, chainId1});
                continue;
            }
            if (a2 == null) {
                logger.warn("Could not find atom {} {} from residue {}{}({}) in chain {} to create bond specified in struct_conn", new Object[]{atomName2, altLocStr2, seqId2, insCode2, resName2, chainId2});
                continue;
            }
            for (int j = 0; j < this.structure.nrModels(); ++j) {
                BondImpl bond = null;
                if (a1.containsKey(j) && a2.containsKey(j) && !a1.get(j).equals(a2.get(j))) {
                    bond = new BondImpl(a1.get(j), a2.get(j), 1);
                }
                if (bond == null || !conn.getConnTypeId().get(i).equals("disulf")) continue;
                ssbonds.add(bond);
            }
        }
        this.structure.setSSBonds(ssbonds);
    }

    private Map<Integer, Atom> getAtomFromRecord(String name, String altLoc, String chainID, String resSeq, String iCode) throws StructureException {
        if (iCode == null || iCode.isEmpty()) {
            iCode = " ";
        }
        HashMap<Integer, Atom> outMap = new HashMap<Integer, Atom>();
        ResidueNumber resNum = new ResidueNumber(chainID, Integer.parseInt(resSeq), Character.valueOf(iCode.charAt(0)));
        for (int i = 0; i < this.structure.nrModels(); ++i) {
            Group group;
            Chain chain = this.structure.getChain(chainID, i);
            Group g = group = chain.getGroupByPDB(resNum);
            if (!altLoc.isEmpty() && (g = group.getAltLocGroup(Character.valueOf(altLoc.charAt(0)))) == null) {
                throw new StructureException("Could not find altLoc code " + altLoc + " in group " + resSeq + iCode + " of chain " + chainID);
            }
            Atom a = g.getAtom(name);
            if (a == null) continue;
            outMap.put(i, a);
        }
        return outMap;
    }

    static {
        BOND_TYPES_TO_PARSE.add("disulf");
        BOND_TYPES_TO_PARSE.add("covale");
        BOND_TYPES_TO_PARSE.add("covale_base");
        BOND_TYPES_TO_PARSE.add("covale_phosphate");
        BOND_TYPES_TO_PARSE.add("covale_sugar");
        BOND_TYPES_TO_PARSE.add("modres");
    }
}

