/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.io;

import java.util.ArrayList;
import java.util.List;
import org.biojava.nbio.structure.Bond;
import org.biojava.nbio.structure.PDBRecord;

public class SSBondImpl
implements PDBRecord,
Cloneable {
    private static final long serialVersionUID = -8663681100691188647L;
    private int serNum = 0;
    private String chainID1;
    private String chainID2;
    private String resnum1;
    private String resnum2;
    private String insCode1;
    private String insCode2;

    @Override
    public String toPDB() {
        StringBuffer buf = new StringBuffer();
        this.toPDB(buf);
        return buf.toString();
    }

    @Override
    public void toPDB(StringBuffer buf) {
        buf.append("SSBOND ");
        buf.append(String.format("%3d", this.serNum));
        buf.append(String.format(" CYS %s %4s%1s  ", this.chainID1, this.resnum1, this.insCode1));
        buf.append(String.format(" CYS %s %4s%1s  ", this.chainID2, this.resnum2, this.insCode2));
    }

    public String getInsCode1() {
        return this.insCode1;
    }

    public void setInsCode1(String insCode1) {
        this.insCode1 = insCode1;
    }

    public String getInsCode2() {
        return this.insCode2;
    }

    public void setInsCode2(String insCode2) {
        this.insCode2 = insCode2;
    }

    public int getSerNum() {
        return this.serNum;
    }

    public void setSerNum(int serNum) {
        this.serNum = serNum;
    }

    public SSBondImpl clone() {
        SSBondImpl nbond = new SSBondImpl();
        nbond.setChainID1(this.chainID1);
        nbond.setChainID2(this.chainID2);
        nbond.setResnum1(this.resnum1);
        nbond.setResnum2(this.resnum2);
        return nbond;
    }

    public String getChainID1() {
        return this.chainID1;
    }

    public void setChainID1(String chainID1) {
        this.chainID1 = chainID1;
    }

    public String getChainID2() {
        return this.chainID2;
    }

    public void setChainID2(String chainID2) {
        this.chainID2 = chainID2;
    }

    public String getResnum1() {
        return this.resnum1;
    }

    public void setResnum1(String resnum1) {
        this.resnum1 = resnum1;
    }

    public String getResnum2() {
        return this.resnum2;
    }

    public void setResnum2(String resnum2) {
        this.resnum2 = resnum2;
    }

    public String toString() {
        Object s = "[SSBOND:\n";
        s = (String)s + "Atom 1:\n";
        s = (String)s + "\tChain: " + this.chainID1 + "\n";
        s = (String)s + "\tResidue #: " + this.resnum1 + "\n";
        s = (String)s + "\tIns. Code: " + this.insCode1 + "\n";
        s = (String)s + "Atom 2:\n";
        s = (String)s + "\tChain: " + this.chainID2 + "\n";
        s = (String)s + "\tResidue #: " + this.resnum2 + "\n";
        s = (String)s + "\tIns. Code: " + this.insCode2 + "\n";
        s = (String)s + "]";
        return s;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.chainID1 == null ? 0 : this.chainID1.hashCode());
        result = 31 * result + (this.chainID2 == null ? 0 : this.chainID2.hashCode());
        result = 31 * result + (this.insCode1 == null ? 0 : this.insCode1.hashCode());
        result = 31 * result + (this.insCode2 == null ? 0 : this.insCode2.hashCode());
        result = 31 * result + (this.resnum1 == null ? 0 : this.resnum1.hashCode());
        result = 31 * result + (this.resnum2 == null ? 0 : this.resnum2.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SSBondImpl other = (SSBondImpl)obj;
        if (this.chainID1 == null ? other.chainID1 != null : !this.chainID1.equals(other.chainID1)) {
            return false;
        }
        if (this.chainID2 == null ? other.chainID2 != null : !this.chainID2.equals(other.chainID2)) {
            return false;
        }
        if (this.insCode1 == null ? other.insCode1 != null : !this.insCode1.equals(other.insCode1)) {
            return false;
        }
        if (this.insCode2 == null ? other.insCode2 != null : !this.insCode2.equals(other.insCode2)) {
            return false;
        }
        if (this.resnum1 == null ? other.resnum1 != null : !this.resnum1.equals(other.resnum1)) {
            return false;
        }
        return !(this.resnum2 == null ? other.resnum2 != null : !this.resnum2.equals(other.resnum2));
    }

    public static List<SSBondImpl> getSsBondListFromBondList(List<Bond> bonds) {
        ArrayList<SSBondImpl> l = new ArrayList<SSBondImpl>();
        for (int i = 0; i < bonds.size(); ++i) {
            SSBondImpl ssbond = SSBondImpl.toSsBond(bonds.get(i));
            ssbond.setSerNum(i + 1);
            l.add(ssbond);
        }
        return l;
    }

    public static SSBondImpl toSsBond(Bond bond) {
        Character iCode2;
        if (!bond.getAtomA().getGroup().getPDBName().equals("CYS") || !bond.getAtomB().getGroup().getPDBName().equals("CYS")) {
            throw new IllegalArgumentException("Trying to create a SSBond from a Bond between 2 groups that are not CYS");
        }
        SSBondImpl ssbond = new SSBondImpl();
        ssbond.setChainID1(bond.getAtomA().getGroup().getChainId());
        ssbond.setChainID2(bond.getAtomB().getGroup().getChainId());
        ssbond.setResnum1(String.valueOf(bond.getAtomA().getGroup().getResidueNumber().getSeqNum()));
        ssbond.setResnum2(String.valueOf(bond.getAtomB().getGroup().getResidueNumber().getSeqNum()));
        Character iCode1 = bond.getAtomA().getGroup().getResidueNumber().getInsCode();
        if (iCode1 == null) {
            iCode1 = Character.valueOf(' ');
        }
        if ((iCode2 = bond.getAtomB().getGroup().getResidueNumber().getInsCode()) == null) {
            iCode2 = Character.valueOf(' ');
        }
        ssbond.setInsCode1(String.valueOf(iCode1));
        ssbond.setInsCode2(String.valueOf(iCode2));
        return ssbond;
    }
}

