/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.fatcat;

import org.biojava.nbio.structure.align.StructureAlignment;
import org.biojava.nbio.structure.align.ce.AbstractUserArgumentProcessor;
import org.biojava.nbio.structure.align.ce.StartupParameters;
import org.biojava.nbio.structure.align.fatcat.FatCat;
import org.biojava.nbio.structure.align.fatcat.FatCatFlexible;
import org.biojava.nbio.structure.align.fatcat.FatCatRigid;
import org.biojava.nbio.structure.align.fatcat.calc.FatCatParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FatCatUserArgumentProcessor
extends AbstractUserArgumentProcessor {
    Logger logger = LoggerFactory.getLogger(FatCatUserArgumentProcessor.class);

    @Override
    protected StartupParameters getStartupParametersInstance() {
        return new FatCatStartupParams();
    }

    @Override
    public StructureAlignment getAlgorithm() {
        FatCat algorithm = null;
        if (this.params != null && ((FatCatStartupParams)this.params).isFlexible()) {
            this.logger.info("running flexible alignment");
            algorithm = new FatCatFlexible();
        } else {
            this.logger.info("running rigid alignment");
            algorithm = new FatCatRigid();
        }
        return algorithm;
    }

    @Override
    public Object getParameters() {
        StructureAlignment alignment = this.getAlgorithm();
        FatCatParameters aligParams = (FatCatParameters)alignment.getParameters();
        FatCatStartupParams startParams = (FatCatStartupParams)this.params;
        if (aligParams == null) {
            aligParams = new FatCatParameters();
        }
        aligParams.setFragLen(startParams.getFragLen());
        aligParams.setRmsdCut(startParams.getRmsdCut());
        aligParams.setDisCut(startParams.getDisCut());
        aligParams.setMaxTra(startParams.getMaxTra());
        return aligParams;
    }

    @Override
    public String getDbSearchLegend() {
        return "# name1\tname2\tscore\tprobability\trmsd\tlen1\tlen2\tcov1\tcov2\t%ID\tDescription\t ";
    }

    protected class FatCatStartupParams
    extends StartupParameters {
        int fragLen = 8;
        Double rmsdCut = 3.0;
        double disCut = 5.0;
        int maxTra = 5;
        boolean flexible = false;

        public int getFragLen() {
            return this.fragLen;
        }

        public void setFragLen(int fragLen) {
            this.fragLen = fragLen;
        }

        public Double getRmsdCut() {
            return this.rmsdCut;
        }

        public void setRmsdCut(Double rmsdCut) {
            this.rmsdCut = rmsdCut;
        }

        public double getDisCut() {
            return this.disCut;
        }

        public void setDisCut(double disCut) {
            this.disCut = disCut;
        }

        public int getMaxTra() {
            return this.maxTra;
        }

        public void setMaxTra(int maxTra) {
            this.maxTra = maxTra;
        }

        public boolean isFlexible() {
            return this.flexible;
        }

        public void setFlexible(boolean flexible) {
            this.flexible = flexible;
        }
    }
}

