/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.xml;

import java.io.IOException;
import java.util.List;
import javax.vecmath.Matrix4d;
import org.biojava.nbio.core.util.PrettyXMLWriter;
import org.biojava.nbio.structure.StructureIdentifier;
import org.biojava.nbio.structure.align.multiple.Block;
import org.biojava.nbio.structure.align.multiple.BlockSet;
import org.biojava.nbio.structure.align.multiple.MultipleAlignment;
import org.biojava.nbio.structure.align.multiple.MultipleAlignmentEnsemble;
import org.biojava.nbio.structure.align.multiple.ScoresCache;

public class MultipleAlignmentXMLConverter {
    public static synchronized void printXMLensemble(PrettyXMLWriter xml, MultipleAlignmentEnsemble ensemble) throws IOException {
        xml.openTag("MultipleAlignmentEnsemble");
        MultipleAlignmentXMLConverter.printXMLheader(xml, ensemble);
        for (MultipleAlignment msa : ensemble.getMultipleAlignments()) {
            MultipleAlignmentXMLConverter.printXMLalignment(xml, msa);
        }
        MultipleAlignmentXMLConverter.printXMLscoresCache(xml, ensemble);
        xml.closeTag("MultipleAlignmentEnsemble");
    }

    public static synchronized void printXMLalignment(PrettyXMLWriter xml, MultipleAlignment msa) throws IOException {
        xml.openTag("MultipleAlignment");
        for (BlockSet bs : msa.getBlockSets()) {
            MultipleAlignmentXMLConverter.printXMLblockSet(xml, bs);
        }
        MultipleAlignmentXMLConverter.printXMLscoresCache(xml, msa);
        xml.closeTag("MultipleAlignment");
    }

    public static synchronized void printXMLblockSet(PrettyXMLWriter xml, BlockSet bs) throws IOException {
        xml.openTag("BlockSet");
        for (Block b : bs.getBlocks()) {
            MultipleAlignmentXMLConverter.printXMLblock(xml, b);
        }
        if (bs.getTransformations() != null) {
            for (Matrix4d t : bs.getTransformations()) {
                MultipleAlignmentXMLConverter.printXMLmatrix4d(xml, t);
            }
        }
        MultipleAlignmentXMLConverter.printXMLscoresCache(xml, bs);
        xml.closeTag("BlockSet");
    }

    public static synchronized void printXMLblock(PrettyXMLWriter xml, Block b) throws IOException {
        xml.openTag("Block");
        List<List<Integer>> alignment = b.getAlignRes();
        for (int pos = 0; pos < alignment.get(0).size(); ++pos) {
            xml.openTag("eqr" + pos);
            for (int str = 0; str < alignment.size(); ++str) {
                xml.attribute("str" + (str + 1), String.valueOf(alignment.get(str).get(pos)));
            }
            xml.closeTag("eqr" + pos);
        }
        MultipleAlignmentXMLConverter.printXMLscoresCache(xml, b);
        xml.closeTag("Block");
    }

    public static synchronized void printXMLmatrix4d(PrettyXMLWriter xml, Matrix4d transform) throws IOException {
        if (transform == null) {
            return;
        }
        xml.openTag("Matrix4d");
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 4; ++y) {
                String key = "mat" + (x + 1) + (y + 1);
                String value = "" + transform.getElement(x, y);
                xml.attribute(key, value);
            }
        }
        xml.closeTag("Matrix4d");
    }

    public static synchronized void printXMLscoresCache(PrettyXMLWriter xml, ScoresCache cache) throws IOException {
        if (cache == null) {
            return;
        }
        xml.openTag("ScoresCache");
        for (String score : cache.getScores()) {
            xml.openTag(score);
            String value = "" + cache.getScore(score);
            xml.attribute("value", value);
            xml.closeTag(score);
        }
        xml.closeTag("ScoresCache");
    }

    public static synchronized void printXMLheader(PrettyXMLWriter xml, MultipleAlignmentEnsemble ensemble) throws IOException {
        xml.attribute("Algorithm", ensemble.getAlgorithmName());
        xml.attribute("Version", ensemble.getVersion());
        xml.attribute("IOTime", "" + ensemble.getIoTime());
        xml.attribute("CalculationTime", "" + ensemble.getCalculationTime());
        xml.openTag("Structures");
        for (int i = 0; i < ensemble.size(); ++i) {
            StructureIdentifier name = ensemble.getStructureIdentifiers().get(i);
            xml.attribute("name" + (i + 1), name.getIdentifier());
        }
        xml.closeTag("Structures");
    }
}

