/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.cath;

public enum CathCategory {
    Class,
    Architecture,
    Topolgy,
    Homology,
    SequenceFamily,
    OrthologousSequenceFamily,
    LikeSequenceFamily,
    IdenticalSequenceFamily,
    DomainCounter;

    static final String lut = "CATHSOLID";

    public static CathCategory fromString(String type) {
        if ("C".equals(type)) {
            return Class;
        }
        if ("A".equals(type)) {
            return Architecture;
        }
        if ("T".equals(type)) {
            return Topolgy;
        }
        if ("H".equals(type)) {
            return Homology;
        }
        if ("S".equals(type)) {
            return SequenceFamily;
        }
        if ("O".equals(type)) {
            return OrthologousSequenceFamily;
        }
        if ("L".equals(type)) {
            return LikeSequenceFamily;
        }
        if ("I".equals(type)) {
            return IdenticalSequenceFamily;
        }
        return DomainCounter;
    }

    public String toString() {
        switch (this.ordinal()) {
            case 0: {
                return "C";
            }
            case 1: {
                return "A";
            }
            case 2: {
                return "T";
            }
            case 3: {
                return "H";
            }
            case 4: {
                return "S";
            }
            case 5: {
                return "O";
            }
            case 6: {
                return "L";
            }
            case 7: {
                return "I";
            }
        }
        return "D";
    }

    public static CathCategory fromCathCode(String code) {
        int count = 0;
        int idx = 0;
        while ((idx = code.indexOf(".", idx)) != -1) {
            ++count;
            ++idx;
        }
        return CathCategory.fromString(lut.substring(count, count + 1));
    }
}

