/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.chem;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Paths;
import java.util.concurrent.atomic.AtomicBoolean;
import org.biojava.nbio.structure.align.util.UserConfiguration;
import org.biojava.nbio.structure.chem.ChemComp;
import org.biojava.nbio.structure.chem.ChemCompProvider;
import org.biojava.nbio.structure.chem.ChemicalComponentDictionary;
import org.biojava.nbio.structure.io.LocalPDBDirectory;
import org.biojava.nbio.structure.io.cif.ChemCompConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllChemCompProvider
implements ChemCompProvider,
Runnable {
    private static final Logger logger = LoggerFactory.getLogger(AllChemCompProvider.class);
    public static final String COMPONENTS_FILE_LOCATION = "pub/pdb/data/monomers/components.cif.gz";
    private static String path;
    private static String serverName;
    static ChemicalComponentDictionary dict;
    static AtomicBoolean loading;
    static AtomicBoolean isInitialized;

    public AllChemCompProvider() {
        if (loading.get()) {
            logger.warn("other thread is already loading all chemcomps, no need to init twice");
            return;
        }
        if (isInitialized.get()) {
            return;
        }
        loading.set(true);
        Thread t = new Thread(this);
        t.start();
    }

    private static void initPath() {
        if (path == null) {
            UserConfiguration config = new UserConfiguration();
            path = config.getCacheFilePath();
        }
    }

    private static void initServerName() {
        if (serverName == null) {
            serverName = LocalPDBDirectory.getServerName();
        }
    }

    private void ensureFileExists() {
        String fileName = AllChemCompProvider.getLocalFileName();
        File f = new File(fileName);
        if (!f.exists()) {
            try {
                AllChemCompProvider.downloadFile();
            }
            catch (IOException e) {
                logger.error("Caught IOException", (Throwable)e);
            }
        }
    }

    public static void downloadFile() throws IOException {
        AllChemCompProvider.initPath();
        AllChemCompProvider.initServerName();
        String localName = AllChemCompProvider.getLocalFileName();
        String u = serverName + "/pub/pdb/data/monomers/components.cif.gz";
        AllChemCompProvider.downloadFileFromRemote(new URL(u), new File(localName));
    }

    private static void downloadFileFromRemote(URL remoteURL, File localFile) throws IOException {
        int bytesRead;
        logger.info("Downloading {} to: {}", (Object)remoteURL, (Object)localFile);
        FileOutputStream out = new FileOutputStream(localFile);
        InputStream in = remoteURL.openStream();
        byte[] buf = new byte[4096];
        while ((bytesRead = in.read(buf)) != -1) {
            out.write(buf, 0, bytesRead);
        }
        in.close();
        out.close();
    }

    private static String getLocalFileName() {
        File dir = new File(path, "chemcomp");
        if (!dir.exists()) {
            logger.info("Creating directory {}", (Object)dir.toString());
            dir.mkdir();
        }
        return new File(dir, "components.cif.gz").toString();
    }

    private void loadAllChemComps() throws IOException {
        String fileName = AllChemCompProvider.getLocalFileName();
        logger.debug("Loading {}", (Object)fileName);
        dict = ChemCompConverter.fromPath(Paths.get(fileName, new String[0]));
    }

    @Override
    public ChemComp getChemComp(String recordName) {
        while (loading.get()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                logger.error("Interrepted thread while waiting: {}", (Object)e.getMessage());
            }
        }
        return dict.getChemComp(recordName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long timeS = System.currentTimeMillis();
        AllChemCompProvider.initPath();
        this.ensureFileExists();
        try {
            this.loadAllChemComps();
            long timeE = System.currentTimeMillis();
            logger.debug("Time to init chem comp dictionary: {} sec.", (Object)((timeE - timeS) / 1000L));
        }
        catch (IOException e) {
            logger.error("Could not load chemical components definition file {}. Error: {}", (Object)AllChemCompProvider.getLocalFileName(), (Object)e.getMessage());
        }
        finally {
            loading.set(false);
            isInitialized.set(true);
        }
    }

    static {
        loading = new AtomicBoolean(false);
        isInitialized = new AtomicBoolean(false);
    }
}

