/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.PdbId;
import org.biojava.nbio.structure.ResidueNumber;
import org.biojava.nbio.structure.ResidueRange;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.StructureIdentifier;
import org.biojava.nbio.structure.SubstructureIdentifier;
import org.biojava.nbio.structure.align.model.AFPChain;
import org.biojava.nbio.structure.align.multiple.Block;
import org.biojava.nbio.structure.align.multiple.MultipleAlignment;
import org.biojava.nbio.structure.symmetry.internal.CESymmParameters;
import org.biojava.nbio.structure.symmetry.internal.SymmetryAxes;
import org.biojava.nbio.structure.symmetry.utils.SymmetryTools;

public class CeSymmResult {
    private MultipleAlignment multipleAlignment;
    private AFPChain selfAlignment;
    private StructureIdentifier structureId;
    private Atom[] atoms;
    private CESymmParameters params;
    private SymmetryAxes axes = new SymmetryAxes();
    private String symmGroup;
    private int numRepeats;
    private boolean refined;

    public boolean isSignificant() {
        if (this.numRepeats < 2) {
            return false;
        }
        if (this.selfAlignment.getTMScore() < this.params.getUnrefinedScoreThreshold()) {
            return false;
        }
        if (this.params.getRefineMethod() != CESymmParameters.RefineMethod.NOT_REFINED) {
            if (this.multipleAlignment == null || this.multipleAlignment.getCoreLength() < this.params.getMinCoreLength()) {
                return false;
            }
            return !(this.multipleAlignment.getScore("AvgTM-score") < this.params.getRefinedScoreThreshold());
        }
        return true;
    }

    public List<StructureIdentifier> getRepeatsID() throws StructureException {
        if (!this.isRefined()) {
            return null;
        }
        ArrayList<StructureIdentifier> repeats = new ArrayList<StructureIdentifier>(this.numRepeats);
        PdbId pdbId = this.structureId.toCanonical().getPdbId();
        Block align = this.multipleAlignment.getBlocks().get(0);
        for (int su = 0; su < this.numRepeats; ++su) {
            ResidueNumber res1 = this.atoms[align.getStartResidue(su)].getGroup().getResidueNumber();
            ResidueNumber res2 = this.atoms[align.getFinalResidue(su)].getGroup().getResidueNumber();
            ResidueRange range = new ResidueRange(res1.getChainName(), res1, res2);
            SubstructureIdentifier id = new SubstructureIdentifier(pdbId, Arrays.asList(range));
            repeats.add(id);
        }
        return repeats;
    }

    public String toString() {
        return String.valueOf(this.structureId) + ", symmGroup=" + this.getSymmGroup() + ", numRepeats=" + this.numRepeats + ", symmLevels=" + this.axes.getNumLevels() + ", refined=" + this.refined + " | " + String.valueOf(this.params);
    }

    public MultipleAlignment getMultipleAlignment() {
        return this.multipleAlignment;
    }

    public void setMultipleAlignment(MultipleAlignment multipleAlignment) {
        this.multipleAlignment = multipleAlignment;
    }

    public AFPChain getSelfAlignment() {
        return this.selfAlignment;
    }

    public void setSelfAlignment(AFPChain selfAlignment) {
        this.selfAlignment = selfAlignment;
    }

    public CESymmParameters getParams() {
        return this.params;
    }

    public void setParams(CESymmParameters params) {
        this.params = params.clone();
    }

    public SymmetryAxes getAxes() {
        return this.axes;
    }

    public void setAxes(SymmetryAxes axes) {
        this.axes = axes;
    }

    public int getNumRepeats() {
        if (this.isSignificant()) {
            return this.numRepeats;
        }
        return 1;
    }

    public void setNumRepeats(int symmOrder) {
        this.numRepeats = symmOrder;
    }

    public boolean isRefined() {
        return this.refined;
    }

    public void setRefined(boolean refined) {
        this.refined = refined;
    }

    public String getSymmGroup() {
        if (this.symmGroup == null) {
            if (this.isSignificant()) {
                if (this.isRefined()) {
                    try {
                        this.symmGroup = SymmetryTools.getQuaternarySymmetry(this).getSymmetry();
                    }
                    catch (StructureException e) {
                        this.symmGroup = "C1";
                    }
                    if ("C1".equals(this.symmGroup)) {
                        this.symmGroup = "R";
                    }
                } else {
                    this.symmGroup = this.axes.getElementaryAxis(0).getSymmType().equals((Object)CESymmParameters.SymmetryType.CLOSED) ? "C" + this.numRepeats : "R";
                }
            } else {
                this.symmGroup = "C1";
            }
        }
        return this.symmGroup;
    }

    public void setSymmGroup(String symmGroup) {
        this.symmGroup = symmGroup;
    }

    public Atom[] getAtoms() {
        return this.atoms;
    }

    public void setAtoms(Atom[] atoms) {
        this.atoms = atoms;
    }

    public int getSymmLevels() {
        return this.axes.getNumLevels();
    }

    public StructureIdentifier getStructureId() {
        return this.structureId;
    }

    public void setStructureId(StructureIdentifier structureId) {
        this.structureId = structureId;
    }

    public String getReason() {
        double tm = this.selfAlignment.getTMScore();
        if (tm < this.params.getUnrefinedScoreThreshold()) {
            return String.format("Insignificant self-alignment (TM=%.2f)", tm);
        }
        if (this.numRepeats == 1) {
            return String.format("Order detector found asymmetric alignment (TM=%.2f)", tm);
        }
        if (this.params.getRefineMethod() != CESymmParameters.RefineMethod.NOT_REFINED) {
            if (!this.refined) {
                return "Refinement failed";
            }
            tm = this.multipleAlignment.getScore("AvgTM-score");
            if (!this.isSignificant()) {
                return String.format("Refinement was not significant (TM=%.2f)", tm);
            }
        } else if (!this.isSignificant()) {
            return String.format("Result was not significant (TM=%.2f)", tm);
        }
        String hierarchical = "";
        if (this.axes.getNumLevels() > 1) {
            hierarchical = String.format("; Contains %d levels of symmetry", this.axes.getNumLevels());
        }
        if (this.axes.getElementaryAxis(0).getSymmType() == CESymmParameters.SymmetryType.OPEN) {
            return String.format("Contains %d open repeats (TM=%.2f)%s", this.getNumRepeats(), tm, hierarchical);
        }
        return String.format("Significant (TM=%.2f)%s", tm, hierarchical);
    }
}

