/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.ce;

import java.util.List;
import org.biojava.nbio.structure.align.ce.CeParameters;

public class CECPParameters
extends CeParameters {
    public static final int DEFAULT_MIN_CP_LENGTH = 5;
    protected DuplicationHint duplicationHint;
    protected Integer minCPLength;

    @Override
    public String toString() {
        return "CECPParameters [scoringStrategy=" + String.valueOf((Object)this.scoringStrategy) + ", maxGapSize=" + this.maxGapSize + ", rmsdThr=" + this.rmsdThr + ", rmsdThrJoin=" + this.rmsdThrJoin + ", winSize=" + this.winSize + ", showAFPRanges=" + this.showAFPRanges + ", maxOptRMSD=" + this.maxOptRMSD + ", seqWeight=" + this.seqWeight + ", duplicationHint=" + String.valueOf((Object)this.duplicationHint) + ", minCPLength=" + this.minCPLength + "]";
    }

    @Override
    public void reset() {
        super.reset();
        this.duplicationHint = DuplicationHint.SHORTER;
        this.minCPLength = 5;
        this.setMaxGapSize(0);
    }

    @Override
    public List<String> getUserConfigHelp() {
        List<String> params = super.getUserConfigHelp();
        params.add("Direction to duplicate: SHORTER, LEFT, or RIGHT");
        params.add("Minimum length of a CP block to consider");
        return params;
    }

    @Override
    public List<String> getUserConfigParameters() {
        List<String> params = super.getUserConfigParameters();
        params.add("DuplicationHint");
        params.add("MinCPLength");
        return params;
    }

    @Override
    public List<String> getUserConfigParameterNames() {
        List<String> params = super.getUserConfigParameterNames();
        params.add("Which to duplicate");
        params.add("Min CP Length");
        return params;
    }

    @Override
    public List<Class> getUserConfigTypes() {
        List<Class> params = super.getUserConfigTypes();
        params.add(DuplicationHint.class);
        params.add(Integer.class);
        return params;
    }

    public DuplicationHint getDuplicationHint() {
        return this.duplicationHint;
    }

    public void setDuplicationHint(DuplicationHint duplicationHint) {
        this.duplicationHint = duplicationHint;
    }

    public Integer getMinCPLength() {
        return this.minCPLength;
    }

    public void setMinCPLength(Integer minCPLength) {
        this.minCPLength = minCPLength;
    }

    public static enum DuplicationHint {
        SHORTER("Shorter of the two"),
        LEFT("Left"),
        RIGHT("Right");

        private String name;

        private DuplicationHint(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

