/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.util;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.biojava.nbio.structure.align.util.CollectionTools;
import org.biojava.nbio.structure.align.util.ConfigurationException;

public class CliTools {
    private CliTools() {
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String[] configureBean(Object bean, String[] args) throws ConfigurationException {
        PropertyDescriptor pd;
        BeanInfo bi;
        try {
            bi = Introspector.getBeanInfo(bean.getClass());
        }
        catch (Exception ex) {
            throw new ConfigurationException("Couldn't get information for target bean " + ex.getMessage());
        }
        HashMap<String, PropertyDescriptor> propertiesByName = new HashMap<String, PropertyDescriptor>();
        for (PropertyDescriptor pd2 : bi.getPropertyDescriptors()) {
            propertiesByName.put(pd2.getName(), pd2);
        }
        ArrayList<String> anonArgs = new ArrayList<String>();
        HashMap<PropertyDescriptor, ArrayList<Object>> arrayProps = new HashMap<PropertyDescriptor, ArrayList<Object>>();
        HashSet<PropertyDescriptor> usedProps = new HashSet<PropertyDescriptor>();
        boolean stdInUsed = false;
        boolean stdOutUsed = false;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg == null) continue;
            if (arg.length() > 0 && arg.charAt(0) == '-') {
                pd = (PropertyDescriptor)propertiesByName.get(arg.substring(1));
                boolean arrayMode = false;
                Object propVal = null;
                Object var14_22 = null;
                if (pd == null) {
                    if (!arg.startsWith("-no")) throw new ConfigurationException("No property named " + arg.substring(1));
                    String altPropName = Introspector.decapitalize(arg.substring(3));
                    pd = (PropertyDescriptor)propertiesByName.get(altPropName);
                    if (pd == null) {
                        throw new ConfigurationException("No property named " + arg.substring(1) + " or " + altPropName);
                    }
                    Class<?> clazz = pd.getPropertyType();
                    if (clazz != Boolean.TYPE) throw new ConfigurationException("Negatory option " + arg + " does not refer to a boolean property");
                    propVal = Boolean.FALSE;
                } else {
                    String name;
                    void var14_26;
                    Class<?> clazz = pd.getPropertyType();
                    if (clazz.isArray()) {
                        arrayMode = true;
                        Class<?> clazz2 = clazz.getComponentType();
                    }
                    if (var14_26 == Integer.TYPE) {
                        try {
                            propVal = Integer.valueOf(args[++i]);
                        }
                        catch (Exception ex) {
                            throw new ConfigurationException("Option " + arg + " requires an integer parameter");
                        }
                    } else if (var14_26 == Double.TYPE || var14_26 == Double.class) {
                        try {
                            propVal = Double.valueOf(args[++i]);
                        }
                        catch (Exception ex) {
                            throw new ConfigurationException("Option " + arg + " requires a numerical parameter");
                        }
                    } else if (var14_26 == String.class) {
                        propVal = args[++i];
                    } else if (var14_26 == Boolean.TYPE) {
                        String val;
                        if ((val = args[++i]) == null) {
                            propVal = Boolean.TRUE;
                        } else if ("true".equalsIgnoreCase(val) || "t".equalsIgnoreCase(val)) {
                            propVal = Boolean.TRUE;
                        } else {
                            if (!"false".equalsIgnoreCase(val) && !"f".equalsIgnoreCase(val)) throw new ConfigurationException("Option " + arg + " requires a boolean parameter");
                            propVal = Boolean.FALSE;
                        }
                    } else if (File.class.isAssignableFrom((Class<?>)var14_26)) {
                        propVal = new File(args[++i]);
                    } else if (Reader.class.isAssignableFrom((Class<?>)var14_26)) {
                        if ("-".equals(name = args[++i])) {
                            if (stdInUsed) {
                                throw new ConfigurationException("Can't use standard input more than once");
                            }
                            propVal = new InputStreamReader(System.in);
                            stdInUsed = true;
                        } else {
                            try {
                                propVal = new FileReader(new File(name));
                            }
                            catch (Exception ex) {
                                throw new ConfigurationException("Can't open " + name + " for input");
                            }
                        }
                    } else if (InputStream.class.isAssignableFrom((Class<?>)var14_26)) {
                        if ("-".equals(name = args[++i])) {
                            if (stdInUsed) {
                                throw new ConfigurationException("Can't use standard input more than once");
                            }
                            propVal = System.in;
                            stdInUsed = true;
                        } else {
                            try {
                                propVal = new FileInputStream(new File(name));
                            }
                            catch (Exception ex) {
                                throw new ConfigurationException("Can't open " + name + " for input");
                            }
                        }
                    } else if (Writer.class.isAssignableFrom((Class<?>)var14_26)) {
                        if ("-".equals(name = args[++i])) {
                            if (stdOutUsed) {
                                throw new ConfigurationException("Can't use standard output more than once");
                            }
                            propVal = new OutputStreamWriter(System.out);
                            stdOutUsed = true;
                        } else {
                            try {
                                propVal = new FileWriter(new File(name));
                            }
                            catch (Exception ex) {
                                throw new ConfigurationException("Can't open " + name + " for output");
                            }
                        }
                    } else if (OutputStream.class.isAssignableFrom((Class<?>)var14_26)) {
                        if ("-".equals(name = args[++i])) {
                            if (stdOutUsed) {
                                throw new ConfigurationException("Can't use standard output more than once");
                            }
                            propVal = System.out;
                            stdOutUsed = true;
                        } else {
                            try {
                                propVal = new FileOutputStream(new File(name));
                            }
                            catch (Exception ex) {
                                throw new ConfigurationException("Can't open " + name + " for output");
                            }
                        }
                    } else if (var14_26.isEnum()) {
                        name = args[++i];
                        try {
                            propVal = Enum.valueOf(var14_26, name);
                        }
                        catch (Exception ex) {
                            try {
                                propVal = Enum.valueOf(var14_26, name.toUpperCase());
                            }
                            catch (Exception ex2) {
                                StringBuilder errMsg = new StringBuilder();
                                errMsg.append("Option ").append(arg);
                                errMsg.append(" requires a ").append(var14_26.getSimpleName());
                                errMsg.append(" parameter. One of: ");
                                for (Object val : var14_26.getEnumConstants()) {
                                    Enum enumVal = (Enum)val;
                                    errMsg.append(enumVal.name());
                                    errMsg.append(" ");
                                }
                                throw new ConfigurationException(errMsg.toString());
                            }
                        }
                    } else {
                        System.err.println("Unsupported optionType for " + arg + " propType:" + String.valueOf(var14_26));
                        System.exit(1);
                    }
                }
                if (arrayMode) {
                    ArrayList<Object> valList = (ArrayList<Object>)arrayProps.get(pd);
                    if (valList == null) {
                        valList = new ArrayList<Object>();
                        arrayProps.put(pd, valList);
                    }
                    valList.add(propVal);
                    continue;
                }
                if (usedProps.contains(pd)) {
                    throw new ConfigurationException("Multiple values supplied for " + pd.getName());
                }
                try {
                    pd.getWriteMethod().invoke(bean, propVal);
                }
                catch (InvocationTargetException ex) {
                    throw new ConfigurationException("Error configuring '" + pd.getName() + "'");
                }
                catch (Exception ex) {
                    throw new ConfigurationException("Error configuring '" + pd.getName() + "'");
                }
                usedProps.add(pd);
                continue;
            }
            anonArgs.add(arg);
        }
        for (Map.Entry me : arrayProps.entrySet()) {
            pd = (PropertyDescriptor)me.getKey();
            List vals = (List)me.getValue();
            Class<?> compType = pd.getPropertyType().getComponentType();
            if (compType.isPrimitive()) {
                if (compType == Integer.TYPE) {
                    int[] nArray = CollectionTools.toIntArray(vals);
                } else {
                    if (compType != Double.TYPE) throw new ConfigurationException("Arrays of type " + compType.getName() + " are currently unsupported");
                    double[] dArray = CollectionTools.toDoubleArray(vals);
                }
            } else {
                Object[] objectArray = vals.toArray((Object[])Array.newInstance(compType, vals.size()));
            }
            try {
                void var14_31;
                pd.getWriteMethod().invoke(bean, var14_31);
            }
            catch (InvocationTargetException ex) {
                throw new ConfigurationException("Error configuring '" + pd.getName() + "'");
            }
            catch (Exception ex) {
                throw new ConfigurationException("Error configuring '" + pd.getName() + "'");
            }
        }
        return anonArgs.toArray(new String[anonArgs.size()]);
    }

    public static <T extends Enum<?>> String getEnumValuesAsString(Class<T> enumClass) {
        Enum[] vals = (Enum[])enumClass.getEnumConstants();
        StringBuilder str = new StringBuilder();
        if (vals.length == 1) {
            str.append(vals[0].name());
        } else if (vals.length > 1) {
            for (int i = 0; i < vals.length - 1; ++i) {
                str.append(vals[i].name());
                str.append(", ");
            }
            str.append("or ");
            str.append(vals[vals.length - 1].name());
        }
        return str.toString();
    }
}

