/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.ecod;

import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.biojava.nbio.structure.align.util.UserConfiguration;
import org.biojava.nbio.structure.ecod.EcodDatabase;
import org.biojava.nbio.structure.ecod.EcodInstallation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EcodFactory {
    private static final Logger logger = LoggerFactory.getLogger(EcodFactory.class);
    public static final String DEFAULT_VERSION = "latest";
    private static Map<String, SoftReference<EcodDatabase>> versionedEcodDBs = Collections.synchronizedMap(new HashMap());
    private static String defaultVersion = "latest";

    public static EcodDatabase getEcodDatabase() {
        return EcodFactory.getEcodDatabase(defaultVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EcodDatabase getEcodDatabase(String version) {
        if (version == null) {
            version = defaultVersion;
        }
        logger.trace("Waiting for EcodFactory lock to get version " + version);
        Map<String, SoftReference<EcodDatabase>> map = versionedEcodDBs;
        synchronized (map) {
            logger.trace("Got EcodFactory lock to get version " + version);
            EcodFactory.releaseReferences();
            SoftReference<EcodDatabase> ecodRef = versionedEcodDBs.get(version.toLowerCase());
            EcodDatabase ecod = null;
            if (ecodRef != null) {
                ecod = ecodRef.get();
            }
            if (ecod == null) {
                logger.debug("Creating new {}, version {}", (Object)EcodInstallation.class.getSimpleName(), (Object)version);
                String cacheDir = new UserConfiguration().getCacheFilePath();
                ecod = new EcodInstallation(cacheDir, version);
                versionedEcodDBs.put(version.toLowerCase(), new SoftReference<EcodDatabase>(ecod));
                try {
                    if (!versionedEcodDBs.containsKey(ecod.getVersion().toLowerCase())) {
                        versionedEcodDBs.put(ecod.getVersion().toLowerCase(), new SoftReference<EcodDatabase>(ecod));
                    }
                }
                catch (IOException e) {
                    logger.warn("Could not get Ecod version, or file is corrupted", (Throwable)e);
                    return null;
                }
            }
            logger.trace("Releasing EcodFactory lock after getting version " + version);
            return ecod;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void releaseReferences() {
        Map<String, SoftReference<EcodDatabase>> map = versionedEcodDBs;
        synchronized (map) {
            Iterator<Map.Entry<String, SoftReference<EcodDatabase>>> it = versionedEcodDBs.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, SoftReference<EcodDatabase>> entry = it.next();
                SoftReference<EcodDatabase> ref = entry.getValue();
                if (ref.get() != null) continue;
                logger.debug("Removed version {} from EcodFactory to save memory.", (Object)entry.getKey());
                it.remove();
            }
        }
    }

    public static void setEcodDatabase(String version) {
        EcodFactory.getEcodDatabase(version);
        defaultVersion = version;
    }

    private EcodFactory() {
    }
}

