/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.chem;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.biojava.nbio.structure.chem.ChemCompAtom;
import org.biojava.nbio.structure.chem.ChemCompBond;
import org.biojava.nbio.structure.chem.ChemCompDescriptor;
import org.biojava.nbio.structure.chem.ChemCompTools;
import org.biojava.nbio.structure.chem.PolymerType;
import org.biojava.nbio.structure.chem.ResidueType;
import org.biojava.nbio.structure.io.cif.CifBean;

public class ChemComp
implements CifBean,
Comparable<ChemComp> {
    private static final long serialVersionUID = -4736341142030215915L;
    private String id;
    private String name;
    private String type;
    private String pdbxType;
    private String formula;
    private String monNstdParentCompId;
    private String pdbxSynonyms;
    private int pdbxFormalCharge;
    private String pdbxInitialDate;
    private String pdbxModifiedDate;
    private String pdbxAmbiguousFlag;
    private String pdbxReleaseStatus;
    private String pdbxReplacedBy;
    private String pdbxReplaces;
    private double formulaWeight;
    private String oneLetterCode;
    private String threeLetterCode;
    private String pdbxModelCoordinatesDetails;
    private String pdbxModelCoordinatesMissingFlag;
    private String pdbxIdealCoordinatesDetails;
    private String pdbxIdealCoordinatesMissingFlag;
    private String pdbxModelCoordinatesDbCode;
    private String pdbxSubcomponentList;
    private String pdbxProcessingSite;
    private String monNstdFlag;
    private List<ChemCompDescriptor> descriptors = new ArrayList<ChemCompDescriptor>();
    private List<ChemCompBond> bonds = new ArrayList<ChemCompBond>();
    private List<ChemCompAtom> atoms = new ArrayList<ChemCompAtom>();
    private ResidueType residueType;
    private PolymerType polymerType;
    private boolean standard;

    public String toString() {
        return "ChemComp " + this.id + " " + this.oneLetterCode + " " + this.threeLetterCode + " poly:" + String.valueOf(this.getPolymerType()) + " resi:" + String.valueOf(this.getResidueType()) + (this.isStandard() ? " standard" : " modified") + " " + this.name + " " + this.pdbxType + " " + this.formula + " parent:" + this.monNstdParentCompId;
    }

    public boolean hasParent() {
        String pid = this.monNstdParentCompId;
        return pid != null && !"?".equals(pid);
    }

    public boolean isStandard() {
        return this.standard;
    }

    private void setStandardFlag() {
        this.standard = ChemCompTools.isStandardChemComp(this);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
        this.residueType = ResidueType.getResidueTypeFromString(type);
        if (this.residueType != null) {
            this.polymerType = this.residueType.polymerType;
        }
    }

    public ResidueType getResidueType() {
        return this.residueType;
    }

    public void setResidueType(ResidueType residueType) {
        this.residueType = residueType;
    }

    public PolymerType getPolymerType() {
        return this.polymerType;
    }

    public void setPolymerType(PolymerType polymerType) {
        this.polymerType = polymerType;
    }

    public String getPdbxType() {
        return this.pdbxType;
    }

    public void setPdbxType(String pdbxType) {
        this.pdbxType = pdbxType;
    }

    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String formula) {
        this.formula = formula;
    }

    public String getMonNstdParentCompId() {
        return this.monNstdParentCompId;
    }

    public void setMonNstdParentCompId(String monNstdParentCompId) {
        this.monNstdParentCompId = monNstdParentCompId == null || monNstdParentCompId.isEmpty() ? null : monNstdParentCompId;
        this.setStandardFlag();
    }

    public String getPdbxSynonyms() {
        return this.pdbxSynonyms;
    }

    public void setPdbxSynonyms(String pdbxSynonyms) {
        this.pdbxSynonyms = pdbxSynonyms;
    }

    public int getPdbxFormalCharge() {
        return this.pdbxFormalCharge;
    }

    public void setPdbxFormalCharge(int pdbxFormalCharge) {
        this.pdbxFormalCharge = pdbxFormalCharge;
    }

    public String getPdbxInitialDate() {
        return this.pdbxInitialDate;
    }

    public void setPdbxInitialDate(String pdbxInitialDate) {
        this.pdbxInitialDate = pdbxInitialDate;
    }

    public String getPdbxModifiedDate() {
        return this.pdbxModifiedDate;
    }

    public void setPdbxModifiedDate(String pdbxModifiedDate) {
        this.pdbxModifiedDate = pdbxModifiedDate;
    }

    public String getPdbxAmbiguousFlag() {
        return this.pdbxAmbiguousFlag;
    }

    public void setPdbxAmbiguousFlag(String pdbxAmbiguousFlag) {
        this.pdbxAmbiguousFlag = pdbxAmbiguousFlag;
    }

    public String getPdbxReleaseStatus() {
        return this.pdbxReleaseStatus;
    }

    public void setPdbxReleaseStatus(String pdbxReleaseStatus) {
        this.pdbxReleaseStatus = pdbxReleaseStatus;
    }

    public String getPdbxReplacedBy() {
        return this.pdbxReplacedBy;
    }

    public void setPdbxReplacedBy(String pdbxReplacedBy) {
        this.pdbxReplacedBy = pdbxReplacedBy;
    }

    public String getPdbxReplaces() {
        return this.pdbxReplaces;
    }

    public void setPdbxReplaces(String pdbxReplaces) {
        this.pdbxReplaces = pdbxReplaces;
    }

    public double getFormulaWeight() {
        return this.formulaWeight;
    }

    public void setFormulaWeight(double formulaWeight) {
        this.formulaWeight = formulaWeight;
    }

    public String getOneLetterCode() {
        return this.oneLetterCode;
    }

    public void setOneLetterCode(String oneLetterCode) {
        this.oneLetterCode = "".equals(oneLetterCode) ? "?" : oneLetterCode;
        this.setStandardFlag();
    }

    public String getThreeLetterCode() {
        return this.threeLetterCode;
    }

    public void setThreeLetterCode(String threeLetterCode) {
        this.threeLetterCode = threeLetterCode;
    }

    public String getPdbxModelCoordinatesDetails() {
        return this.pdbxModelCoordinatesDetails;
    }

    public void setPdbxModelCoordinatesDetails(String pdbxModelCoordinatesDetails) {
        this.pdbxModelCoordinatesDetails = pdbxModelCoordinatesDetails;
    }

    public String getPdbxModelCoordinatesMissingFlag() {
        return this.pdbxModelCoordinatesMissingFlag;
    }

    public void setPdbxModelCoordinatesMissingFlag(String pdbxModelCoordinatesMissingFlag) {
        this.pdbxModelCoordinatesMissingFlag = pdbxModelCoordinatesMissingFlag;
    }

    public String getPdbxIdealCoordinatesDetails() {
        return this.pdbxIdealCoordinatesDetails;
    }

    public void setPdbxIdealCoordinatesDetails(String pdbxIdealCoordinatesDetails) {
        this.pdbxIdealCoordinatesDetails = pdbxIdealCoordinatesDetails;
    }

    public String getPdbxIdealCoordinatesMissingFlag() {
        return this.pdbxIdealCoordinatesMissingFlag;
    }

    public void setPdbxIdealCoordinatesMissingFlag(String pdbxIdealCoordinatesMissingFlag) {
        this.pdbxIdealCoordinatesMissingFlag = pdbxIdealCoordinatesMissingFlag;
    }

    public String getPdbxModelCoordinatesDbCode() {
        return this.pdbxModelCoordinatesDbCode;
    }

    public void setPdbxModelCoordinatesDbCode(String pdbxModelCoordinatesDbCode) {
        this.pdbxModelCoordinatesDbCode = pdbxModelCoordinatesDbCode;
    }

    public String getPdbxSubcomponentList() {
        return this.pdbxSubcomponentList;
    }

    public void setPdbxSubcomponentList(String pdbxSubcomponentList) {
        this.pdbxSubcomponentList = pdbxSubcomponentList;
    }

    public String getPdbxProcessingSite() {
        return this.pdbxProcessingSite;
    }

    public void setPdbxProcessingSite(String pdbxProcessingSite) {
        this.pdbxProcessingSite = pdbxProcessingSite;
    }

    public String getMonNstdFlag() {
        return this.monNstdFlag;
    }

    public void setMonNstdFlag(String monNstdFlag) {
        this.monNstdFlag = monNstdFlag;
    }

    public List<ChemCompDescriptor> getDescriptors() {
        return this.descriptors;
    }

    public void setDescriptors(List<ChemCompDescriptor> descriptors) {
        this.descriptors = descriptors;
    }

    public List<ChemCompBond> getBonds() {
        return this.bonds;
    }

    public void setBonds(List<ChemCompBond> bonds) {
        this.bonds = bonds;
    }

    public List<ChemCompAtom> getAtoms() {
        return this.atoms;
    }

    public void setAtoms(List<ChemCompAtom> atoms) {
        this.atoms = atoms;
    }

    @Override
    public int compareTo(ChemComp arg0) {
        if (this.equals(arg0)) {
            return 0;
        }
        return this.getId().compareTo(arg0.getId());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChemComp chemComp = (ChemComp)o;
        return this.standard == chemComp.standard && Objects.equals(this.id, chemComp.id) && Objects.equals(this.name, chemComp.name) && Objects.equals(this.type, chemComp.type) && Objects.equals(this.pdbxType, chemComp.pdbxType) && Objects.equals(this.formula, chemComp.formula) && Objects.equals(this.monNstdParentCompId, chemComp.monNstdParentCompId) && Objects.equals(this.pdbxSynonyms, chemComp.pdbxSynonyms) && Objects.equals(this.pdbxFormalCharge, chemComp.pdbxFormalCharge) && Objects.equals(this.pdbxInitialDate, chemComp.pdbxInitialDate) && Objects.equals(this.pdbxModifiedDate, chemComp.pdbxModifiedDate) && Objects.equals(this.pdbxAmbiguousFlag, chemComp.pdbxAmbiguousFlag) && Objects.equals(this.pdbxReleaseStatus, chemComp.pdbxReleaseStatus) && Objects.equals(this.pdbxReplacedBy, chemComp.pdbxReplacedBy) && Objects.equals(this.pdbxReplaces, chemComp.pdbxReplaces) && Objects.equals(this.formulaWeight, chemComp.formulaWeight) && Objects.equals(this.oneLetterCode, chemComp.oneLetterCode) && Objects.equals(this.threeLetterCode, chemComp.threeLetterCode) && Objects.equals(this.pdbxModelCoordinatesDetails, chemComp.pdbxModelCoordinatesDetails) && Objects.equals(this.pdbxModelCoordinatesMissingFlag, chemComp.pdbxModelCoordinatesMissingFlag) && Objects.equals(this.pdbxIdealCoordinatesDetails, chemComp.pdbxIdealCoordinatesDetails) && Objects.equals(this.pdbxIdealCoordinatesMissingFlag, chemComp.pdbxIdealCoordinatesMissingFlag) && Objects.equals(this.pdbxModelCoordinatesDbCode, chemComp.pdbxModelCoordinatesDbCode) && Objects.equals(this.pdbxSubcomponentList, chemComp.pdbxSubcomponentList) && Objects.equals(this.pdbxProcessingSite, chemComp.pdbxProcessingSite) && Objects.equals(this.monNstdFlag, chemComp.monNstdFlag) && Objects.equals(this.descriptors, chemComp.descriptors) && Objects.equals(this.bonds, chemComp.bonds) && Objects.equals(this.atoms, chemComp.atoms) && this.residueType == chemComp.residueType && this.polymerType == chemComp.polymerType;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.type, this.pdbxType, this.formula, this.monNstdParentCompId, this.pdbxSynonyms, this.pdbxFormalCharge, this.pdbxInitialDate, this.pdbxModifiedDate, this.pdbxAmbiguousFlag, this.pdbxReleaseStatus, this.pdbxReplacedBy, this.pdbxReplaces, this.formulaWeight, this.oneLetterCode, this.threeLetterCode, this.pdbxModelCoordinatesDetails, this.pdbxModelCoordinatesMissingFlag, this.pdbxIdealCoordinatesDetails, this.pdbxIdealCoordinatesMissingFlag, this.pdbxModelCoordinatesDbCode, this.pdbxSubcomponentList, this.pdbxProcessingSite, this.monNstdFlag, this.descriptors, this.bonds, this.atoms, this.residueType, this.polymerType, this.standard);
    }

    public static ChemComp getEmptyChemComp() {
        ChemComp comp = new ChemComp();
        comp.setOneLetterCode("?");
        comp.setThreeLetterCode("???");
        comp.setPolymerType(PolymerType.unknown);
        comp.setResidueType(ResidueType.atomn);
        return comp;
    }

    public boolean isEmpty() {
        return this.id == null || this.getThreeLetterCode() == null || "???".equals(this.getThreeLetterCode());
    }
}

