/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.cluster.Subunit;
import org.biojava.nbio.structure.cluster.SubunitCluster;
import org.biojava.nbio.structure.symmetry.core.HelixLayers;
import org.biojava.nbio.structure.symmetry.core.QuatSymmetryScores;
import org.biojava.nbio.structure.symmetry.core.RotationGroup;
import org.biojava.nbio.structure.symmetry.core.Stoichiometry;
import org.biojava.nbio.structure.symmetry.core.SymmetryPerceptionMethod;

public class QuatSymmetryResults {
    private Structure structure;
    private Stoichiometry stoichiometry;
    private boolean local = false;
    private List<SubunitCluster> clusters;
    private List<Subunit> subunits;
    private SymmetryPerceptionMethod method;
    private HelixLayers helixLayers;
    private RotationGroup rotationGroup = new RotationGroup();

    public QuatSymmetryResults(Stoichiometry stoichiometry, RotationGroup rotationGroup, SymmetryPerceptionMethod method) {
        this.stoichiometry = stoichiometry;
        this.clusters = stoichiometry.getClusters();
        this.subunits = new ArrayList<Subunit>();
        for (SubunitCluster c : this.clusters) {
            this.subunits.addAll(c.getSubunits());
        }
        this.rotationGroup = rotationGroup;
        this.method = method;
    }

    public QuatSymmetryResults(Stoichiometry stoichiometry, HelixLayers helixLayers, SymmetryPerceptionMethod method) {
        this.stoichiometry = stoichiometry;
        this.clusters = stoichiometry.getClusters();
        this.subunits = new ArrayList<Subunit>();
        for (SubunitCluster c : this.clusters) {
            this.subunits.addAll(c.getSubunits());
        }
        this.helixLayers = helixLayers;
        this.method = method;
    }

    public boolean isSupersededBy(QuatSymmetryResults other) {
        if (other.getSymmetry().startsWith("H")) {
            return (this.getSymmetry().startsWith("C") || this.getSymmetry().startsWith("H")) && other.subunits.containsAll(this.subunits);
        }
        if (this.getSymmetry().startsWith("H")) {
            return false;
        }
        return this.rotationGroup.getOrder() <= other.rotationGroup.getOrder() && other.subunits.containsAll(this.subunits);
    }

    public List<SubunitCluster> getSubunitClusters() {
        return Collections.unmodifiableList(this.clusters);
    }

    public List<Subunit> getSubunits() {
        return Collections.unmodifiableList(this.subunits);
    }

    public int getSubunitCount() {
        return this.subunits.size();
    }

    public RotationGroup getRotationGroup() {
        return this.rotationGroup;
    }

    public HelixLayers getHelixLayers() {
        return this.helixLayers;
    }

    public SymmetryPerceptionMethod getMethod() {
        return this.method;
    }

    public String getSymmetry() {
        if (this.helixLayers != null && this.helixLayers.size() > 0) {
            return "H";
        }
        if (this.rotationGroup != null && this.rotationGroup.getOrder() > 0) {
            return this.rotationGroup.getPointGroup();
        }
        return "";
    }

    public QuatSymmetryScores getScores() {
        if (this.helixLayers != null && this.helixLayers.size() > 0) {
            return this.helixLayers.getScores();
        }
        if (this.rotationGroup != null && this.rotationGroup.getOrder() > 0) {
            return this.rotationGroup.getScores();
        }
        return new QuatSymmetryScores();
    }

    public Stoichiometry getStoichiometry() {
        return this.stoichiometry;
    }

    public boolean isPseudoStoichiometric() {
        return this.stoichiometry.isPseudoStoichiometric();
    }

    public boolean isLocal() {
        return this.local;
    }

    void setLocal(boolean local) {
        this.local = local;
    }

    public Structure getStructure() {
        return this.structure;
    }

    public void setStructure(Structure structure) {
        this.structure = structure;
    }

    public String toString() {
        return "QuatSymmetryResults [stoichiometry: " + String.valueOf(this.getStoichiometry()) + ", symmetry: " + this.getSymmetry() + ", pseudo-stoichiometric: " + this.isPseudoStoichiometric() + ", local: " + this.local + ", method: " + String.valueOf((Object)this.method) + "]";
    }
}

