/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.biojava.nbio.structure.geometry.CalcPoint;
import org.biojava.nbio.structure.geometry.UnitQuaternions;
import org.biojava.nbio.structure.symmetry.core.PermutationGroup;
import org.biojava.nbio.structure.symmetry.core.QuatSuperpositionScorer;
import org.biojava.nbio.structure.symmetry.core.QuatSymmetryParameters;
import org.biojava.nbio.structure.symmetry.core.QuatSymmetryScores;
import org.biojava.nbio.structure.symmetry.core.QuatSymmetrySolver;
import org.biojava.nbio.structure.symmetry.core.QuatSymmetrySubunits;
import org.biojava.nbio.structure.symmetry.core.Rotation;
import org.biojava.nbio.structure.symmetry.core.RotationGroup;
import org.biojava.nbio.structure.symmetry.utils.PermutationGenerator;

public class SystematicSolver
implements QuatSymmetrySolver {
    private QuatSymmetrySubunits subunits = null;
    private QuatSymmetryParameters parameters = null;
    private Point3d[] originalCoords = null;
    private Point3d[] transformedCoords = null;
    private RotationGroup rotations = new RotationGroup();
    private Vector3d centroid = new Vector3d();
    private Matrix4d centroidInverse = new Matrix4d();
    private Set<List<Integer>> hashCodes = new HashSet<List<Integer>>();

    public SystematicSolver(QuatSymmetrySubunits subunits, QuatSymmetryParameters parameters) {
        if (subunits.getSubunitCount() == 2) {
            throw new IllegalArgumentException("SystematicSolver cannot be applied to subunits with 2 centers");
        }
        this.subunits = subunits;
        this.parameters = parameters;
    }

    @Override
    public RotationGroup getSymmetryOperations() {
        if (this.rotations.getOrder() == 0) {
            this.solve();
            this.rotations.complete();
        }
        return this.rotations;
    }

    private void solve() {
        this.initialize();
        int n = this.subunits.getSubunitCount();
        PermutationGenerator g = new PermutationGenerator(n);
        while (g.hasMore()) {
            int[] perm = g.getNext();
            ArrayList<Integer> permutation = new ArrayList<Integer>(perm.length);
            for (int j = 0; j < n; ++j) {
                permutation.add(perm[j]);
            }
            if (!this.isValidPermutation(permutation)) continue;
            boolean newPermutation = this.evaluatePermutation(permutation);
            if (newPermutation) {
                this.completeRotationGroup();
            }
            if (this.rotations.getOrder() < this.subunits.getSubunitCount()) continue;
            return;
        }
    }

    private void combineWithTranslation(Matrix4d rotation) {
        rotation.setTranslation(this.centroid);
        rotation.mul(rotation, this.centroidInverse);
    }

    private Rotation createSymmetryOperation(List<Integer> permutation, Matrix4d transformation, AxisAngle4d axisAngle, int fold, QuatSymmetryScores scores) {
        Rotation s = new Rotation();
        s.setPermutation(new ArrayList<Integer>(permutation));
        s.setTransformation(new Matrix4d(transformation));
        s.setAxisAngle(new AxisAngle4d(axisAngle));
        s.setFold(fold);
        s.setScores(scores);
        return s;
    }

    private void completeRotationGroup() {
        int i;
        PermutationGroup g = new PermutationGroup();
        for (i = 0; i < this.rotations.getOrder(); ++i) {
            Rotation s = this.rotations.getRotation(i);
            g.addPermutation(s.getPermutation());
        }
        g.completeGroup();
        if (g.getOrder() == this.rotations.getOrder()) {
            return;
        }
        for (i = 0; i < g.getOrder(); ++i) {
            List<Integer> permutation = g.getPermutation(i);
            if (!this.isValidPermutation(permutation)) continue;
            this.evaluatePermutation(permutation);
        }
    }

    private boolean isValidPermutation(List<Integer> permutation) {
        if (permutation.isEmpty()) {
            return false;
        }
        if (this.hashCodes.contains(permutation)) {
            return false;
        }
        if (!this.isAllowedPermuation(permutation)) {
            return false;
        }
        int fold = PermutationGroup.getOrder(permutation);
        if (this.rotations.getOrder() > 1 && fold == 1) {
            return false;
        }
        if (fold == 0 || this.subunits.getSubunitCount() % fold != 0) {
            return false;
        }
        return this.hashCodes.add(permutation);
    }

    private boolean isAllowedPermuation(List<Integer> permutation) {
        List<Integer> seqClusterId = this.subunits.getClusterIds();
        for (int i = 0; i < permutation.size(); ++i) {
            int j = permutation.get(i);
            if (Objects.equals(seqClusterId.get(i), seqClusterId.get(j))) continue;
            return false;
        }
        return true;
    }

    private boolean evaluatePermutation(List<Integer> permutation) {
        int n = this.subunits.getSubunitCount();
        for (int j = 0; j < n; ++j) {
            this.transformedCoords[j].set((Tuple3d)this.originalCoords[permutation.get(j)]);
        }
        int fold = PermutationGroup.getOrder(permutation);
        Quat4d quat = UnitQuaternions.relativeOrientation(this.originalCoords, this.transformedCoords);
        AxisAngle4d axisAngle = new AxisAngle4d();
        Matrix4d transformation = new Matrix4d();
        transformation.set(quat);
        axisAngle.set(quat);
        Vector3d axis = new Vector3d(axisAngle.x, axisAngle.y, axisAngle.z);
        if (axis.lengthSquared() < 1.0E-6) {
            axisAngle.x = 0.0;
            axisAngle.y = 0.0;
            axisAngle.z = 1.0;
            axisAngle.angle = 0.0;
        } else {
            axis.normalize();
            axisAngle.x = axis.x;
            axisAngle.y = axis.y;
            axisAngle.z = axis.z;
        }
        CalcPoint.transform(transformation, this.transformedCoords);
        double subunitRmsd = CalcPoint.rmsd(this.transformedCoords, this.originalCoords);
        if (subunitRmsd < this.parameters.getRmsdThreshold()) {
            this.combineWithTranslation(transformation);
            QuatSymmetryScores scores = QuatSuperpositionScorer.calcScores(this.subunits, transformation, permutation);
            if (scores.getRmsd() < 0.0 || scores.getRmsd() > this.parameters.getRmsdThreshold()) {
                return false;
            }
            scores.setRmsdCenters(subunitRmsd);
            Rotation symmetryOperation = this.createSymmetryOperation(permutation, transformation, axisAngle, fold, scores);
            this.rotations.addRotation(symmetryOperation);
            return true;
        }
        return false;
    }

    private void initialize() {
        this.centroid = new Vector3d((Tuple3d)this.subunits.getCentroid());
        Vector3d reverse = new Vector3d(this.centroid);
        reverse.negate();
        this.centroidInverse.set(reverse);
        this.centroidInverse.setElement(3, 3, 1.0);
        List<Point3d> centers = this.subunits.getCenters();
        int n = this.subunits.getSubunitCount();
        this.originalCoords = new Point3d[n];
        this.transformedCoords = new Point3d[n];
        for (int i = 0; i < n; ++i) {
            this.originalCoords[i] = centers.get(i);
            this.transformedCoords[i] = new Point3d();
        }
    }
}

