/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.bytecode;

import org.biojava.utils.bytecode.CodeContext;
import org.biojava.utils.bytecode.CodeException;
import org.biojava.utils.bytecode.Instruction;

class FloatConstantInstruction
implements Instruction {
    private final float val;

    FloatConstantInstruction(float val) {
        this.val = val;
    }

    @Override
    public void writeCode(CodeContext ctx) throws CodeException {
        int i_indx = ctx.getConstants().resolveFloat(this.val);
        if (i_indx < 256) {
            ctx.writeByte((byte)18);
            ctx.writeByte((byte)i_indx);
        } else {
            ctx.writeByte((byte)19);
            ctx.writeShort(i_indx);
        }
    }

    @Override
    public int stackDepth() {
        return this.stackDelta();
    }

    @Override
    public int stackDelta() {
        return 1;
    }
}

