/*
 * Copyright (c) 2010, Paul Merlin. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.codeartisans.java.toolbox.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

public class ReaderUtil
{

    public static String readStringFully( Reader reader )
            throws IOException
    {
        BufferedReader br = new BufferedReader( reader );
        char[] buffer = new char[ 65536 ];
        StringBuffer sb = new StringBuffer();
        int chars = 0;
        while ( chars != -1 ) {
            chars = br.read( buffer, 0, 65536 );
            sb.append( buffer, 0, chars );
        }
        return sb.toString();
    }

    private ReaderUtil()
    {
    }

}
