/*
 * Decompiled with CFR 0.152.
 */
package org.codeartisans.java.toolbox;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class StringUtils {
    private static final String TEMPLATE_TOKEN_PATTERN_STR = "\\$\\{([^}]+)\\}";
    private static final Pattern TEMPLATE_TOKEN_PATTERN = Pattern.compile("\\$\\{([^}]+)\\}");
    public static final String EMPTY = "";
    public static final char[] EMPTY_CHAR_ARRAY = "".toCharArray();

    private StringUtils() {
    }

    public static boolean isEmpty(String s) {
        return s == null || s.length() <= 0;
    }

    public static boolean isEmpty(char[] array) {
        return array == null || array.length <= 0;
    }

    public static StringBuffer renderTemplate(StringBuffer template, Map<String, String> dict, boolean removeUnknown) {
        Matcher matcher = TEMPLATE_TOKEN_PATTERN.matcher(template);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            String token = matcher.group(1);
            if (token == null) continue;
            String replacement = dict.get(token);
            if (replacement != null) {
                String quotedReplacement = Matcher.quoteReplacement(replacement);
                matcher.appendReplacement(buffer, quotedReplacement);
                continue;
            }
            if (!removeUnknown) continue;
            matcher.appendReplacement(buffer, EMPTY);
        }
        matcher.appendTail(buffer);
        return buffer;
    }

    public static StringBuffer renderTemplate(StringBuffer template, Map<String, String> dict) {
        return StringUtils.renderTemplate(template, dict, false);
    }
}

