/*
 * Decompiled with CFR 0.152.
 */
package org.codeartisans.java.toolbox.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class IterableBufferedReader
implements Iterable<String> {
    private final BufferedReader reader;
    private final Integer maxLines;

    public IterableBufferedReader(BufferedReader reader) {
        this(reader, -1);
    }

    public IterableBufferedReader(BufferedReader reader, Integer maxLines) {
        this.reader = reader;
        this.maxLines = maxLines;
    }

    @Override
    public Iterator<String> iterator() {
        return new BufferedReaderIterator();
    }

    private class BufferedReaderIterator
    implements Iterator<String> {
        private String nextline;
        private Integer linesRead = 0;

        public BufferedReaderIterator() {
            try {
                if (IterableBufferedReader.this.maxLines != 0) {
                    this.nextline = IterableBufferedReader.this.reader.readLine();
                }
            }
            catch (IOException ex) {
                throw new IllegalArgumentException(ex);
            }
        }

        @Override
        public boolean hasNext() {
            if (IterableBufferedReader.this.maxLines > 0 && IterableBufferedReader.this.maxLines <= this.linesRead) {
                return false;
            }
            return this.nextline != null;
        }

        @Override
        public String next() {
            try {
                if (IterableBufferedReader.this.maxLines > 0 && IterableBufferedReader.this.maxLines <= this.linesRead) {
                    throw new NoSuchElementException();
                }
                String result = this.nextline;
                if (this.nextline != null) {
                    this.nextline = IterableBufferedReader.this.reader.readLine();
                    if (this.nextline == null) {
                        IterableBufferedReader.this.reader.close();
                    }
                }
                Integer n = this.linesRead;
                Integer n2 = this.linesRead = Integer.valueOf(this.linesRead + 1);
                return result;
            }
            catch (IOException ex) {
                throw new IllegalArgumentException(ex);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + " is read only");
        }
    }
}

