/*
 * Decompiled with CFR 0.152.
 */
package org.codeartisans.java.toolbox;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.codeartisans.java.toolbox.Arrays;
import org.codeartisans.java.toolbox.Filter;

public final class Collections {
    private Collections() {
    }

    public static boolean isEmpty(Iterable<?> iterable) {
        if (iterable == null) {
            return true;
        }
        return iterable.iterator().hasNext();
    }

    public static <T> T firstElementOrNull(Iterable<T> iterable) {
        if (iterable == null) {
            return null;
        }
        Iterator<T> iterator = iterable.iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public static <T> List<T> filter(List<T> list, Filter<T> ... filters) {
        if (Arrays.isEmpty(filters)) {
            return new ArrayList<T>(list);
        }
        return Collections.filterToList(list, filters);
    }

    public static <T> Collection<T> filter(Collection<T> list, Filter<T> ... filters) {
        if (Arrays.isEmpty(filters)) {
            return new ArrayList<T>(list);
        }
        return Collections.filterToList(list, filters);
    }

    public static <T> Iterable<T> filter(Iterable<T> list, Filter<T> ... filters) {
        if (Arrays.isEmpty(filters)) {
            ArrayList<T> copy = new ArrayList<T>();
            for (T each : list) {
                copy.add(each);
            }
            return copy;
        }
        return Collections.filterToList(list, filters);
    }

    private static <T> List<T> filterToList(Iterable<T> source, Filter<T> ... filters) {
        ArrayList<T> dest = new ArrayList<T>();
        block0: for (T each : source) {
            for (Filter<T> filter : filters) {
                if (!filter.accept(each)) continue;
                dest.add(each);
                continue block0;
            }
        }
        return dest;
    }

    public static boolean collectionEquals(Collection<?> oldCollection, Collection<?> newCollection) {
        if (oldCollection == null && newCollection == null) {
            return true;
        }
        return oldCollection != null && newCollection != null && newCollection.size() == oldCollection.size() && oldCollection.containsAll(newCollection);
    }

    public static <T> Collection<T> removed(Collection<T> left, Collection<T> right) {
        if (left == null || left.isEmpty()) {
            return java.util.Collections.emptyList();
        }
        if (right == null || right.isEmpty()) {
            return new ArrayList<T>(left);
        }
        ArrayList<T> removed = new ArrayList<T>();
        for (T eachLeft : left) {
            if (right.contains(eachLeft)) continue;
            removed.add(eachLeft);
        }
        return removed;
    }

    public static <T> Collection<T> added(Collection<T> left, Collection<T> right) {
        if (right == null || right.isEmpty()) {
            return java.util.Collections.emptyList();
        }
        if (left == null || left.isEmpty()) {
            return new ArrayList<T>(right);
        }
        ArrayList<T> added = new ArrayList<T>();
        for (T eachRight : right) {
            if (left.contains(eachRight)) continue;
            added.add(eachRight);
        }
        return added;
    }
}

