/*
 * Decompiled with CFR 0.152.
 */
package org.codeartisans.java.toolbox.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.codeartisans.java.toolbox.io.IO;

public final class Files {
    public static void touch(File ... paths) throws IOException {
        IOException exception = null;
        for (File eachPath : paths) {
            if (eachPath.isFile()) {
                try {
                    IO.closeSilently(new FileOutputStream(eachPath));
                }
                catch (IOException ex) {
                    exception = ex;
                }
                continue;
            }
            eachPath.setLastModified(System.currentTimeMillis());
        }
        if (exception != null) {
            throw exception;
        }
    }

    public static void deleteSilently(File ... paths) {
        try {
            Files.delete(paths);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void delete(File ... paths) throws IOException {
        IOException exception = null;
        for (File eachPath : paths) {
            if (!eachPath.exists()) continue;
            if (eachPath.isDirectory()) {
                Files.delete(eachPath.listFiles());
            }
            if (eachPath.delete()) continue;
            exception = new IOException("Unable to delete " + eachPath);
        }
        if (exception != null) {
            throw exception;
        }
    }

    public static void mkdir(File ... paths) throws IOException {
        IOException exception = null;
        for (File eachPath : paths) {
            if (eachPath.mkdirs()) continue;
            exception = new IOException("Unable to mkdir " + eachPath);
        }
        if (exception != null) {
            throw exception;
        }
    }

    public static void empty(File ... paths) throws IOException {
        Object exception = null;
        for (File eachPath : paths) {
            if (!eachPath.exists()) {
                throw new FileNotFoundException("File or directory do not exists " + eachPath);
            }
            if (eachPath.isFile()) {
                Files.delete(eachPath);
                Files.touch(eachPath);
                continue;
            }
            Files.delete(eachPath.listFiles());
        }
        if (exception != null) {
            throw exception;
        }
    }

    public static void move(File path, File to) throws IOException {
        Files.move(new File[]{path}, to);
        if (!path.exists()) {
            throw new FileNotFoundException("File not found " + path);
        }
        if (!path.renameTo(to)) {
            throw new IOException("Unable to move " + path + " to " + to);
        }
    }

    public static void move(File[] paths, File to) throws IOException {
        Files.move(Arrays.asList(paths), to);
    }

    public static void move(Collection<File> paths, File to) throws IOException {
        IOException exception = null;
        if (paths.size() > 1) {
            if (!to.exists()) {
                throw new IllegalArgumentException("Destination directory for several files or directories do not exists");
            }
            if (!to.isDirectory()) {
                throw new IllegalArgumentException("Cannot move several files or directories to an existing file");
            }
        }
        for (File eachPath : paths) {
            File target;
            if (eachPath.renameTo(target = new File(to, eachPath.getName()))) continue;
            exception = new IOException("Unable to move " + eachPath + " to " + target);
        }
        if (exception != null) {
            throw exception;
        }
    }

    private Files() {
    }
}

