/*
 * Decompiled with CFR 0.152.
 */
package org.commandmosaic.plain;

import java.lang.reflect.InvocationTargetException;
import org.commandmosaic.api.Command;
import org.commandmosaic.api.CommandContext;
import org.commandmosaic.api.conversion.TypeConversionService;
import org.commandmosaic.api.executor.CommandExecutor;
import org.commandmosaic.api.executor.ParameterSource;
import org.commandmosaic.core.parameter.ParameterInjector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ReflectiveCommandExecutor
implements CommandExecutor {
    private static final Logger log = LoggerFactory.getLogger(ReflectiveCommandExecutor.class);
    private final ParameterInjector parameterInjector;

    ReflectiveCommandExecutor(TypeConversionService typeConversionService) {
        this.parameterInjector = new ParameterInjector(typeConversionService);
    }

    public <R, C extends Command<R>> R execute(Class<C> commandClass, ParameterSource parameters, CommandContext context) {
        log.debug("Executing command {} with parameters: {} and context: {}", new Object[]{commandClass, parameters, context});
        C command = this.instantiateCommand(commandClass);
        this.parameterInjector.processInjection(command, parameters);
        return (R)command.execute(context);
    }

    private <R, C extends Command<R>> C instantiateCommand(Class<C> commandClass) {
        try {
            return (C)((Command)commandClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Failed to instantiate Command: " + commandClass, e);
        }
    }
}

