/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.auditquery.fileevent;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.commonjava.auditquery.fileevent.FileEventType;

public class FileEvent
implements Comparable<FileEvent>,
Externalizable {
    private static final int VERSION = 1;
    private UUID eventId = UUID.randomUUID();
    private String sessionId;
    private String nodeId;
    private String checksum;
    private String targetLocation;
    private String targetPath;
    private FileEventType eventType;
    private String requestId;
    private Integer eventVersion = 1;
    private String sourceLocation;
    private String sourcePath;
    private String md5;
    private Long size;
    private String sha1;
    private String storeKey;
    private Map<String, String> extra;
    @JsonFormat(shape=JsonFormat.Shape.STRING)
    private Date timestamp;

    public FileEvent() {
    }

    public FileEvent(@JsonProperty(value="eventType") FileEventType eventType) {
        this.eventType = eventType;
    }

    public UUID getEventId() {
        return this.eventId;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public String getTargetLocation() {
        return this.targetLocation;
    }

    public void setTargetLocation(String targetLocation) {
        this.targetLocation = targetLocation;
    }

    public String getTargetPath() {
        return this.targetPath;
    }

    public void setTargetPath(String targetPath) {
        this.targetPath = targetPath;
    }

    public FileEventType getEventType() {
        return this.eventType;
    }

    public void setEventType(FileEventType eventType) {
        this.eventType = eventType;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public Integer getEventVersion() {
        return this.eventVersion;
    }

    public void setEventVersion(Integer eventVersion) {
        this.eventVersion = eventVersion;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public Map<String, String> getExtra() {
        return this.extra;
    }

    public void setExtra(Map<String, String> extra) {
        this.extra = extra;
    }

    public String getSourceLocation() {
        return this.sourceLocation;
    }

    public void setSourceLocation(String sourceLocation) {
        this.sourceLocation = sourceLocation;
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public void setSourcePath(String sourcePath) {
        this.sourcePath = sourcePath;
    }

    public String getMd5() {
        return this.md5;
    }

    public void setMd5(String md5) {
        this.md5 = md5;
    }

    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public String getSha1() {
        return this.sha1;
    }

    public void setSha1(String sha1) {
        this.sha1 = sha1;
    }

    public String getStoreKey() {
        return this.storeKey;
    }

    public void setStoreKey(String storeKey) {
        this.storeKey = storeKey;
    }

    @Override
    public int compareTo(FileEvent o) {
        return this.getTimestamp().compareTo(o.getTimestamp());
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(Integer.toString(1));
        out.writeObject(this.eventId);
        out.writeObject(this.sessionId);
        out.writeObject(this.nodeId);
        out.writeObject(this.checksum);
        out.writeObject(this.targetLocation);
        out.writeObject(this.targetPath);
        out.writeObject((Object)this.eventType);
        out.writeObject(this.requestId);
        out.writeObject(this.eventVersion);
        out.writeObject(this.sourceLocation);
        out.writeObject(this.sourcePath);
        out.writeObject(this.md5);
        out.writeObject(this.size);
        out.writeObject(this.sha1);
        out.writeObject(this.storeKey);
        out.writeObject(this.extra);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int version = Integer.parseInt((String)in.readObject());
        if (version > 1) {
            throw new IOException("Cannot deserialize. This class is of an older version: 1 vs. the version read from the data stream: " + version + ".");
        }
        this.eventId = (UUID)in.readObject();
        this.sessionId = (String)in.readObject();
        this.nodeId = (String)in.readObject();
        this.checksum = (String)in.readObject();
        this.targetLocation = (String)in.readObject();
        this.targetPath = (String)in.readObject();
        this.eventType = (FileEventType)((Object)in.readObject());
        this.requestId = (String)in.readObject();
        this.eventVersion = (Integer)in.readObject();
        this.sourceLocation = (String)in.readObject();
        this.sourcePath = (String)in.readObject();
        this.md5 = (String)in.readObject();
        this.size = (Long)in.readObject();
        this.sha1 = (String)in.readObject();
        this.storeKey = (String)in.readObject();
        Map extraMap = (Map)in.readObject();
        this.extra = extraMap == null ? new HashMap<String, String>() : new HashMap(extraMap);
    }
}

