/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.auditquery.fileevent;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.commonjava.auditquery.fileevent.FileGroupingEventType;

public class FileGroupingEvent
implements Comparable<FileGroupingEvent>,
Externalizable {
    private static final int VERSION = 1;
    private UUID eventId = UUID.randomUUID();
    private String sessionId;
    private List<UUID> fileEvents;
    private String nodeId;
    private FileGroupingEventType eventType;
    private String requestId;
    private Integer eventVersion = 1;
    private Map<String, String> extra;
    @JsonFormat(shape=JsonFormat.Shape.STRING)
    private Date timestamp;

    public FileGroupingEvent() {
    }

    public FileGroupingEvent(@JsonProperty(value="eventType") FileGroupingEventType eventType) {
        this.eventType = eventType;
    }

    public UUID getEventId() {
        return this.eventId;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public List<UUID> getFileEvents() {
        return this.fileEvents;
    }

    public void setFileEvents(List<UUID> fileEvents) {
        this.fileEvents = fileEvents;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public FileGroupingEventType getEventType() {
        return this.eventType;
    }

    public void setEventType(FileGroupingEventType eventType) {
        this.eventType = eventType;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public Integer getEventVersion() {
        return this.eventVersion;
    }

    public void setEventVersion(Integer eventVersion) {
        this.eventVersion = eventVersion;
    }

    public Map<String, String> getExtra() {
        return this.extra;
    }

    public void setExtra(Map<String, String> extra) {
        this.extra = extra;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public int compareTo(FileGroupingEvent o) {
        return this.getTimestamp().compareTo(o.getTimestamp());
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(Integer.toString(1));
        out.writeObject(this.eventId);
        out.writeObject(this.sessionId);
        out.writeObject(this.nodeId);
        out.writeObject(this.fileEvents);
        out.writeObject((Object)this.eventType);
        out.writeObject(this.requestId);
        out.writeObject(this.eventVersion);
        out.writeObject(this.extra);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int version = Integer.parseInt((String)in.readObject());
        if (version > 1) {
            throw new IOException("Cannot deserialize. This class is of an older version: 1 vs. the version read from the data stream: " + version + ".");
        }
        this.eventId = (UUID)in.readObject();
        this.sessionId = (String)in.readObject();
        this.nodeId = (String)in.readObject();
        List events = (List)in.readObject();
        this.fileEvents = events == null ? new ArrayList<UUID>() : new ArrayList(events);
        this.eventType = (FileGroupingEventType)((Object)in.readObject());
        this.requestId = (String)in.readObject();
        this.eventVersion = (Integer)in.readObject();
        Map extraMap = (Map)in.readObject();
        this.extra = extraMap == null ? new HashMap<String, String>() : new HashMap(extraMap);
    }
}

