/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.auditquery.history;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import javax.persistence.Entity;
import org.commonjava.auditquery.history.ChangeType;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;

@Entity
@Indexed
@ApiModel
public class ChangeEvent
implements Serializable,
Externalizable {
    @JsonProperty
    @ApiModelProperty(required=true, dataType="string", value="The id for change event")
    private String eventId;
    @JsonProperty
    @ApiModelProperty(required=true, dataType="string", value="Serialized store key, of the form: '[hosted|group|remote]:name'")
    @Field(index=Index.YES, analyze=Analyze.NO)
    private String storeKey;
    @JsonProperty
    @ApiModelProperty(required=true, dataType="java.util.Date", value="Timestamp for this changing")
    @Field(index=Index.YES, analyze=Analyze.NO)
    private Date changeTime;
    @JsonProperty
    @ApiModelProperty(required=true, dataType="string", value="The version of this change")
    @Field(index=Index.YES, analyze=Analyze.NO)
    private String version;
    @JsonProperty
    @ApiModelProperty(required=true, dataType="string", value="Summary of this change")
    @Field(index=Index.YES, analyze=Analyze.NO)
    private String summary;
    @JsonProperty
    @ApiModelProperty(required=true, dataType="string", value="The type of this change [delete|update|create]")
    @Field(index=Index.YES, analyze=Analyze.NO)
    private ChangeType changeType;
    @JsonProperty
    @ApiModelProperty(required=true, dataType="string", value="User who did this change")
    @Field(index=Index.YES, analyze=Analyze.NO)
    private String user;
    @JsonProperty
    @ApiModelProperty(required=true, dataType="string", value="The diff content of this change between old and new")
    @Field(index=Index.YES, analyze=Analyze.NO)
    private String diffContent;

    public String getEventId() {
        return this.eventId;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public String getStoreKey() {
        return this.storeKey;
    }

    public void setStoreKey(String storeKey) {
        this.storeKey = storeKey;
    }

    public Date getChangeTime() {
        return this.changeTime;
    }

    public void setChangeTime(Date changeTime) {
        this.changeTime = changeTime;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public ChangeType getChangeType() {
        return this.changeType;
    }

    public void setChangeType(ChangeType changeType) {
        this.changeType = changeType;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getDiffContent() {
        return this.diffContent;
    }

    public void setDiffContent(String diffContent) {
        this.diffContent = diffContent;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.storeKey, this.changeTime, this.version, this.summary, this.changeType, this.user, this.diffContent});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChangeEvent other = (ChangeEvent)obj;
        return Objects.equals(this.storeKey, other.storeKey) && Objects.equals(this.changeTime, other.changeTime) && Objects.equals(this.version, other.version) && Objects.equals(this.summary, other.summary) && Objects.equals((Object)this.changeType, (Object)other.changeType) && Objects.equals(this.user, other.user) && Objects.equals(this.diffContent, other.diffContent);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.eventId = (String)in.readObject();
        this.storeKey = (String)in.readObject();
        this.changeTime = (Date)in.readObject();
        this.version = (String)in.readObject();
        this.summary = (String)in.readObject();
        this.changeType = (ChangeType)((Object)in.readObject());
        this.user = (String)in.readObject();
        this.diffContent = (String)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.eventId);
        out.writeObject(this.storeKey);
        out.writeObject(this.changeTime);
        out.writeObject(this.version);
        out.writeObject(this.summary);
        out.writeObject((Object)this.changeType);
        out.writeObject(this.user);
        out.writeObject(this.diffContent);
    }
}

