/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.auditquery.tracking;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;

@Indexed
public class TrackingSummary
implements Externalizable {
    private static final int VERSION = 1;
    @Field
    private String trackingID;
    private Set<String> uploads;
    private Set<String> downloads;
    private Date startTime;
    private Date endTime;

    public TrackingSummary() {
    }

    public TrackingSummary(String trackingID, Set<String> uploads, Set<String> downloads) {
        this.trackingID = trackingID;
        this.uploads = uploads;
        this.downloads = downloads;
    }

    public String getTrackingID() {
        return this.trackingID;
    }

    public void setTrackingID(String trackingID) {
        this.trackingID = trackingID;
    }

    public Set<String> getUploads() {
        return this.uploads;
    }

    public void setUploads(Set<String> uploads) {
        this.uploads = uploads;
    }

    public Set<String> getDownloads() {
        return this.downloads;
    }

    public void setDownloads(Set<String> downloads) {
        this.downloads = downloads;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(Integer.toString(1));
        out.writeObject(this.trackingID);
        out.writeObject(this.uploads);
        out.writeObject(this.downloads);
        out.writeObject(this.startTime);
        out.writeObject(this.endTime);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int version = Integer.parseInt((String)in.readObject());
        if (version != 1) {
            throw new IOException("Cannot deserialize. Unmatched version, class version: 1 vs. the version read from the data stream: " + version);
        }
        this.trackingID = (String)in.readObject();
        Set ups = (Set)in.readObject();
        this.uploads = ups == null ? new HashSet<String>() : new HashSet(ups);
        Set downs = (Set)in.readObject();
        this.downloads = downs == null ? new HashSet<String>() : new HashSet(downs);
        this.startTime = (Date)in.readObject();
        this.endTime = (Date)in.readObject();
    }
}

