/*
 * Decompiled with CFR 0.152.
 */
package org.compacto.parser;

import java.text.MessageFormat;
import org.compacto.parser.AbstractCompactoParser;
import org.compacto.parser.exceptions.OpeningCharacterNotFound;

public abstract class BaseCompactoParser
implements AbstractCompactoParser {
    protected static final String CHAR_CLOSE_VALUE = ",";
    protected static final String CHAR_EQUALITY = "=";
    protected static final String CHAR_OPEN_LIST = "[";
    protected static final String CHAR_CLOSE_LIST = "]";
    protected static final String CHAR_OPEN_OBJECT = "{";
    protected static final String CHAR_CLOSE_OBJECT = "}";
    protected static final String CHAR_OPEN_MAP = "(";
    protected static final String CHAR_CLOSE_MAP = ")";
    protected static final String CHAR_KEY_SEPARATOR = "#";
    protected char CH_OPEN_OBJECT = (char)123;
    protected char CH_CLOSE_OBJECT = (char)125;
    protected char CH_VALUE_SEPARATOR = (char)44;
    protected char CH_EQUALITY = (char)61;
    protected char CH_OPEN_LIST = (char)91;
    protected char CH_CLOSE_LIST = (char)93;
    protected char CH_KEY_SEPARATOR = (char)35;
    protected char CH_OPEN_MAP = (char)40;
    protected char CH_CLOSE_MAP = (char)41;

    public Integer getEnclosingIndex(String input, int start) throws OpeningCharacterNotFound {
        if (input.charAt(start) == this.CH_OPEN_OBJECT) {
            return this.getEnclosingIndexObject(input, start);
        }
        if (input.charAt(start) == this.CH_OPEN_LIST) {
            return this.getEnclosingIndexList(input, start);
        }
        if (input.charAt(start) == this.CH_OPEN_MAP) {
            return this.getEnclosingIndexMap(input, start);
        }
        throw new OpeningCharacterNotFound(MessageFormat.format("{0}{1}{2} is not an opening character.", "'", "" + input.charAt(start), "'"));
    }

    protected Integer getEnclosingIndexObject(String input, int start) {
        return start + this.getEnclosingIndex(input.substring(start), this.CH_OPEN_OBJECT, this.CH_CLOSE_OBJECT);
    }

    protected Integer getEnclosingIndexList(String input, int start) {
        return start + this.getEnclosingIndex(input.substring(start), this.CH_OPEN_LIST, this.CH_CLOSE_LIST);
    }

    protected Integer getEnclosingIndexMap(String input, int start) {
        return start + this.getEnclosingIndex(input.substring(start), this.CH_OPEN_MAP, this.CH_CLOSE_MAP);
    }

    private int getEnclosingIndex(String input, char open, char close) {
        int openCount = 0;
        int closeCount = 0;
        for (int i = 0; i < input.length(); ++i) {
            if (input.charAt(i) == open) {
                if (i - 1 >= 0) {
                    if (input.charAt(i - 1) != '\\') {
                        ++openCount;
                    }
                } else {
                    ++openCount;
                }
            } else if (input.charAt(i) == close) {
                if (i - 1 >= 0) {
                    if (input.charAt(i - 1) != '\\') {
                        ++closeCount;
                    }
                } else {
                    ++closeCount;
                }
            }
            if (openCount != closeCount) continue;
            return i;
        }
        throw new RuntimeException(input);
    }
}

