/*
 * Decompiled with CFR 0.152.
 */
package org.compacto.parser;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.compacto.parser.BaseCompactoParser;
import org.compacto.parser.annotations.CompactoProperty;
import org.compacto.parser.exceptions.CompactoException;
import org.compacto.parser.exceptions.InvalidObjectException;
import org.compacto.parser.exceptions.MalFormatException;
import org.compacto.parser.exceptions.OpeningCharacterNotFound;
import org.compacto.parser.model.CompactoSerializable;
import org.compacto.parser.model.ListCompactoSerializable;

public class CompactoParser
extends BaseCompactoParser {
    Logger logger = Logger.getLogger(this.getClass().getName());
    private List<Class> numericalValueClasses = Arrays.asList(Integer.class, Long.class, Float.class, Double.class, BigDecimal.class, BigInteger.class, Boolean.class);

    @Override
    public String toCompacto(Object object, Type resolvedType) throws CompactoException {
        StringBuilder sb = new StringBuilder();
        try {
            this.stringfy(sb, object, resolvedType);
        }
        catch (Exception e) {
            throw new CompactoException(e);
        }
        return sb.toString();
    }

    public String toCompacto(List<CompactoSerializable> list) throws ClassNotFoundException, CompactoException {
        ListCompactoSerializable output = new ListCompactoSerializable(list);
        return this.toCompacto(output, output.getClass());
    }

    protected void stringfy(StringBuilder sb, Object obj, Type type) throws NoSuchAlgorithmException, IllegalArgumentException, IllegalAccessException, ClassNotFoundException {
        if (obj instanceof List) {
            sb.append("[");
            Iterator iterator = ((List)obj).iterator();
            while (iterator.hasNext()) {
                Object item = iterator.next();
                if (item == null) {
                    sb.append("null");
                    if (!iterator.hasNext()) continue;
                    sb.append(",");
                    continue;
                }
                if (item instanceof List || item instanceof Map) {
                    this.stringfy(sb, item, item.getClass());
                } else if (this.numericalValueClasses.contains(item.getClass())) {
                    sb.append(item.toString());
                } else if (item.getClass() == String.class) {
                    sb.append(this.escapeCharacters(item.toString()));
                } else if (item.getClass().isEnum()) {
                    sb.append(((Enum)item).name());
                } else {
                    this.stringifyObject(sb, item);
                }
                if (!iterator.hasNext()) continue;
                sb.append(",");
            }
            sb.append("]");
        } else if (this.numericalValueClasses.contains(obj.getClass())) {
            sb.append(obj.toString());
        } else if (obj.getClass() == String.class) {
            sb.append(this.escapeCharacters(obj.toString()));
        } else if (obj instanceof Map) {
            this.stringifyMap(sb, obj, obj.getClass());
        } else if (obj instanceof Object) {
            sb.append("{");
            Map<String, Field> fields = this.getAllFields(obj);
            Set<String> keyFields = fields.keySet();
            Iterator<String> keyFieldsIterator = keyFields.iterator();
            for (int i = 0; i < fields.size(); ++i) {
                Field field = fields.get(keyFieldsIterator.next());
                field.setAccessible(true);
                String key = this.getAnnotationValueOrFieldName(field);
                sb.append(key);
                sb.append("=");
                if (field.getType() == String.class) {
                    sb.append(this.escapeCharacters(field.get(obj).toString()));
                } else if (field.getType().isPrimitive() || this.numericalValueClasses.contains(field.getType())) {
                    sb.append(field.get(obj));
                } else if (field.get(obj) instanceof List || field.get(obj) instanceof Map) {
                    this.stringfy(sb, field.get(obj), Class.forName(field.getType().getTypeName()));
                } else if (field.getType().isEnum()) {
                    sb.append(((Enum)field.get(obj)).name());
                } else if (field.get(obj) instanceof Object) {
                    this.stringfy(sb, field.get(obj), Class.forName(field.getType().getTypeName()));
                } else {
                    sb.append("null");
                }
                if (i >= fields.size() - 1) continue;
                sb.append(",");
            }
            sb.append("}");
        } else {
            throw this.createException(5, null, null, obj);
        }
    }

    private String stringifyKey(Object obj) throws NoSuchAlgorithmException, IllegalArgumentException, IllegalAccessException, ClassNotFoundException {
        if (obj == null) {
            return "null";
        }
        StringBuilder sbRet = new StringBuilder();
        this.stringfy(sbRet, obj, obj.getClass());
        return sbRet.toString();
    }

    private void stringifyObject(StringBuilder sb, Object obj) throws IllegalArgumentException, IllegalAccessException, NoSuchAlgorithmException, ClassNotFoundException {
        sb.append("{");
        List<Field> fields = this.getAllFields(obj).values().stream().toList();
        for (int i = 0; i < fields.size(); ++i) {
            String key;
            Field f = fields.get(i);
            f.setAccessible(true);
            if (f.get(obj) == null) {
                key = this.getAnnotationValueOrFieldName(f);
                sb.append(key);
                sb.append("=");
                sb.append("null");
                if (i >= fields.size() - 1) continue;
                sb.append(",");
                continue;
            }
            key = this.getAnnotationValueOrFieldName(f);
            if (f.getType() == String.class) {
                sb.append(key);
                sb.append("=");
                sb.append(this.escapeCharacters(f.get(obj).toString()));
            } else if (f.getType().isPrimitive() || this.numericalValueClasses.contains(f.getType())) {
                sb.append(key);
                sb.append("=");
                sb.append(String.valueOf(f.get(obj)));
            } else if (f.get(obj) instanceof List || f.get(obj) instanceof Map) {
                sb.append(key);
                sb.append("=");
                this.stringfy(sb, f.get(obj), obj.getClass());
            } else if (f.getType().isEnum()) {
                for (Object enumConstant : Class.forName(f.getType().getTypeName()).getEnumConstants()) {
                    if (((Enum)enumConstant).compareTo((Enum)f.get(obj)) != 0) continue;
                    sb.append(key);
                    sb.append("=");
                    sb.append(this.escapeCharacters(f.get(obj).toString()));
                    break;
                }
            } else if (f.get(obj) instanceof Object) {
                sb.append(key);
                sb.append("=");
                this.stringifyObject(sb, f.get(obj));
            }
            if (i >= fields.size() - 1) continue;
            sb.append(",");
        }
        sb.append("}");
    }

    private String getAnnotationValueOrFieldName(Field field) {
        Annotation[] annotations = field.getDeclaredAnnotations();
        CompactoProperty myAnnotation = null;
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof CompactoProperty)) continue;
            myAnnotation = (CompactoProperty)annotation;
            break;
        }
        if (myAnnotation != null) {
            return myAnnotation.value();
        }
        return field.getName();
    }

    private String escapeCharacters(String value) {
        return value.replace("{", "\\{").replace("}", "\\}").replace("=", "\\=").replace(",", "\\,").replace("#", "\\#").replace("[", "\\[").replace("]", "\\]").replace("(", "\\(").replace(")", "\\)");
    }

    private String unescapeCharacters(String value) {
        return value.replace("\\{", "{").replace("\\}", "}").replace("\\=", "=").replace("\\,", ",").replace("\\#", "#").replace("\\[", "[").replace("\\]", "]").replace("\\(", "(").replace("\\)", ")");
    }

    @Override
    public Object fromCompacto(String input, Type type) throws CompactoException {
        Object result = null;
        try {
            try {
                result = Class.forName(type.getTypeName()).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new CompactoException("Invalid class constructor");
            }
            for (int i = 0; i < input.length(); ++i) {
                if (input.charAt(i) != this.CH_OPEN_OBJECT) continue;
                int nextCloseObj = -1;
                try {
                    nextCloseObj = this.getEnclosingIndex(input, i);
                }
                catch (OpeningCharacterNotFound e) {
                    e.printStackTrace();
                }
                if (nextCloseObj == -1) {
                    throw this.createException(1, input, "}", null);
                }
                String objInput = input.substring(i + 1, nextCloseObj);
                try {
                    this.instantiateAttributes(result, objInput);
                }
                catch (OpeningCharacterNotFound e) {
                    throw this.createException(-1, input, objInput, e);
                }
                i = nextCloseObj;
            }
        }
        catch (Exception e) {
            throw new CompactoException(e);
        }
        return result;
    }

    private Integer getNextEqualityIndex(String input, int start) {
        for (int i = start; i < input.length(); ++i) {
            if (input.charAt(i) != this.CH_EQUALITY) continue;
            if (i == 0) {
                return 0;
            }
            if (i - 1 < 0 || input.charAt(i - 1) == '\\') continue;
            return i;
        }
        return -1;
    }

    private void instantiateAttributes(Object obj, String input) throws IllegalArgumentException, IllegalAccessException, SecurityException, InstantiationException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException, OpeningCharacterNotFound {
        Map<String, Field> objFields = this.getAllFields(obj);
        block2: for (int i = 0; i < input.length(); ++i) {
            int nextEqual = this.getNextEqualityIndex(input, i);
            String varName = input.substring(i, nextEqual);
            if (varName.isEmpty()) {
                throw this.createException(2, input, null, null);
            }
            String varValue = input.substring(nextEqual + 1);
            if (varValue.charAt(0) == this.CH_OPEN_OBJECT || varValue.charAt(0) == this.CH_OPEN_LIST || varValue.charAt(0) == this.CH_OPEN_MAP) {
                int nextClose = -1;
                try {
                    nextClose = this.getEnclosingIndex(varValue, 0);
                }
                catch (OpeningCharacterNotFound openingCharacterNotFound) {
                    openingCharacterNotFound.printStackTrace();
                }
                varValue = varValue.substring(1, nextClose);
                i += varName.length() + 1 + 2 + varValue.length();
            } else {
                i = nextEqual;
                boolean foundTheValue = false;
                do {
                    if (Arrays.asList(Character.valueOf(this.CH_VALUE_SEPARATOR), Character.valueOf(this.CH_CLOSE_LIST), Character.valueOf(this.CH_CLOSE_OBJECT)).contains(Character.valueOf(input.charAt(i))) && i > 0 && input.charAt(i - 1) != '\\') {
                        varValue = input.substring(nextEqual + 1, i);
                        foundTheValue = true;
                    }
                    if (foundTheValue) continue;
                    ++i;
                } while (i < input.length() && !foundTheValue);
            }
            Field field = objFields.get(varName);
            if (field == null) continue;
            field.setAccessible(true);
            if (varValue.equals("null") || field.getType().isArray()) {
                field.set(obj, null);
                continue;
            }
            if (field.getType() == String.class) {
                field.set(obj, this.unescapeCharacters(varValue));
                continue;
            }
            if (field.getType() == Integer.class) {
                field.set(obj, Integer.parseInt(varValue));
                continue;
            }
            if (field.getType() == Long.class) {
                field.set(obj, Long.parseLong(varValue));
                continue;
            }
            if (field.getType() == Float.class) {
                field.set(obj, Float.valueOf(Float.parseFloat(varValue)));
                continue;
            }
            if (field.getType() == Double.class) {
                field.set(obj, Double.parseDouble(varValue));
                continue;
            }
            if (field.getType() == Boolean.class) {
                field.set(obj, Boolean.parseBoolean(varValue));
                continue;
            }
            if (field.getType() == BigInteger.class) {
                field.set(obj, new BigInteger(varValue));
                continue;
            }
            if (field.getType() == BigDecimal.class) {
                field.set(obj, new BigDecimal(varValue));
                continue;
            }
            if (field.getType() == List.class) {
                if (field.getGenericType() instanceof ParameterizedType) {
                    List list = CompactoParser.createListOfType(field.getClass());
                    field.set(obj, list);
                    this.populateList(list, ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0], varValue);
                    continue;
                }
                this.logger.warning("Will not read not parameterized generic list/map");
                continue;
            }
            if (field.getType() == Map.class) {
                if (field.getGenericType() instanceof ParameterizedType) {
                    Map<?, ?> map = CompactoParser.createMapOfType(((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0].getClass(), ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[1].getClass());
                    field.set(obj, map);
                    this.populateMap(map, ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0], ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[1], varValue);
                    continue;
                }
                this.logger.warning("Will not read not parameterized generic list/map");
                continue;
            }
            if (field.getType().isEnum()) {
                for (Object enumConstant : field.getType().getEnumConstants()) {
                    if (!((Enum)enumConstant).name().equals(varValue)) continue;
                    field.set(obj, enumConstant);
                    continue block2;
                }
                continue;
            }
            Object obj2 = field.getType().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            field.set(obj, obj2);
            this.instantiateAttributes(obj2, varValue);
        }
    }

    private void populateList(List list, Type type, String input) throws IllegalArgumentException, IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException, SecurityException, ClassNotFoundException, OpeningCharacterNotFound {
        int endOfLastItem = 0;
        for (int i = 0; i <= input.length(); ++i) {
            if (type instanceof ParameterizedType && ((ParameterizedType)type).getRawType() == List.class) {
                if (i < input.length() && input.charAt(i) == this.CH_OPEN_LIST) {
                    int nextClose = -1;
                    try {
                        nextClose = this.getEnclosingIndex(input, i);
                    }
                    catch (OpeningCharacterNotFound e) {
                        throw this.createException(-1, input, null, null);
                    }
                    ArrayList itemList = (ArrayList)CompactoParser.createListOfType(((ParameterizedType)type).getActualTypeArguments()[0].getClass());
                    list.add(itemList);
                    this.populateList(itemList, ((ParameterizedType)type).getActualTypeArguments()[0], input.substring(i + 1, nextClose));
                    i += nextClose + 1;
                }
            } else if (type instanceof ParameterizedType && ((ParameterizedType)type).getRawType() == Map.class) {
                if (i < input.length() && input.charAt(i) == this.CH_OPEN_MAP) {
                    int nextClose = -1;
                    try {
                        nextClose = this.getEnclosingIndex(input, i);
                    }
                    catch (OpeningCharacterNotFound e) {
                        e.printStackTrace();
                        throw this.createException(-1, input, null, null);
                    }
                    Map<?, ?> itemMap = CompactoParser.createMapOfType(((ParameterizedType)type).getActualTypeArguments()[0].getClass(), ((ParameterizedType)type).getActualTypeArguments()[1].getClass());
                    list.add(itemMap);
                    this.populateMap(itemMap, ((ParameterizedType)type).getActualTypeArguments()[0], ((ParameterizedType)type).getActualTypeArguments()[1], input.substring(i + 1, nextClose));
                    endOfLastItem = i += nextClose + 1;
                }
            } else if (i < input.length() && (input.charAt(i) == this.CH_OPEN_LIST || input.charAt(i) == this.CH_OPEN_MAP || input.charAt(i) == this.CH_OPEN_OBJECT)) {
                int nextCloseObj = -1;
                try {
                    nextCloseObj = this.getEnclosingIndex(input, i);
                }
                catch (OpeningCharacterNotFound e) {
                    throw this.createException(3, input, null, e);
                }
                String itemValueStr = input.substring(endOfLastItem + 1, nextCloseObj);
                endOfLastItem = nextCloseObj + 2;
                i = nextCloseObj + 1;
                list.add(this.instantiateFromStringByClass(type, itemValueStr));
            } else if (i >= input.length() || input.charAt(i) == this.CH_VALUE_SEPARATOR) {
                String itemValueStr = input.substring(endOfLastItem, i);
                endOfLastItem = i + 1;
                if (type == String.class) {
                    String value = itemValueStr;
                    list.add(value);
                } else if (!itemValueStr.isEmpty() && !itemValueStr.isBlank()) {
                    if (type == Integer.class) {
                        list.add(Integer.parseInt(itemValueStr));
                    } else if (type == Long.class) {
                        list.add(Long.parseLong(itemValueStr));
                    } else if (type == Float.class) {
                        list.add(Float.valueOf(Float.parseFloat(itemValueStr)));
                    } else if (type == Double.class) {
                        list.add(Double.parseDouble(itemValueStr));
                    } else if (type == Boolean.class) {
                        list.add(Boolean.parseBoolean(itemValueStr));
                    } else if (type == BigDecimal.class) {
                        list.add(new BigDecimal(itemValueStr));
                    } else if (type == BigInteger.class) {
                        list.add(new BigInteger(itemValueStr));
                    } else {
                        if (type == List.class) {
                            throw new RuntimeException("Essa exce\u00e7\u00e3o n\u00e3o deveria acontecer.");
                        }
                        if (Class.forName(type.getTypeName()).isEnum()) {
                            for (Object enumConstant : Class.forName(type.getTypeName()).getEnumConstants()) {
                                if (!((Enum)enumConstant).name().equals(itemValueStr)) continue;
                                list.add(enumConstant);
                                break;
                            }
                        } else {
                            int nextCloseObj = -1;
                            try {
                                nextCloseObj = this.getEnclosingIndex(itemValueStr, 0);
                            }
                            catch (OpeningCharacterNotFound e) {
                                throw this.createException(3, input, null, e);
                            }
                            String objInput = itemValueStr.substring(1, nextCloseObj);
                            Object newObject = Class.forName(type.getTypeName()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                            this.instantiateAttributes(newObject, objInput);
                            list.add(newObject);
                        }
                    }
                }
            }
            if (i == input.length()) break;
        }
    }

    private static List createListOfType(Class type) {
        return new ArrayList();
    }

    private RuntimeException createException(int code, String input, String strAux, Object objAux) {
        int start = 0;
        String chunkMalformedInput = null;
        if (input != null) {
            start = input.length() - 32;
            start = start < 0 ? 0 : start;
            chunkMalformedInput = input.substring(start);
        }
        if (code == 1) {
            String message = MessageFormat.format("Missing closing character in input: {0}{1}{2}\n", "'", chunkMalformedInput, "'");
            return new MalFormatException(message, new Throwable("'" + strAux + "' is missing."));
        }
        if (code == 2) {
            String message = MessageFormat.format("Missing field name in input: {0}{1}{2}\n", "'", chunkMalformedInput, "'");
            return new MalFormatException(message, new Throwable("field name is missing."));
        }
        if (code == 3) {
            String message = MessageFormat.format("Opening character mismatched in input: {0}{1}{2}\n", "'", chunkMalformedInput, "'");
            return new MalFormatException(message, new Throwable(((OpeningCharacterNotFound)objAux).getMessage()));
        }
        if (code == 4) {
            if (input != null) {
                start = input.indexOf(strAux) - 1;
                start = start < 0 ? 0 : start;
                chunkMalformedInput = input.substring(start);
                String message = MessageFormat.format("Invalid field {0}{1}{2} in input: {3}\n", "'", strAux, "'", chunkMalformedInput);
                return new MalFormatException(message, new Throwable(MessageFormat.format("{0}{1}{2} is an invalid field name.", "'", strAux, "'")));
            }
            return new MalFormatException("Will never happen");
        }
        if (code == 5) {
            return new InvalidObjectException("Object is not parseable. Verify if it implements 'CompactoSerializable' interface.");
        }
        return new MalFormatException("Ic!");
    }

    private static <K, V> Map<K, V> createMapOfType(Class<K> typeKey, Class<V> typeValue) {
        return new HashMap();
    }

    private void stringifyMap(StringBuilder sb, Object obj, Type type) throws NoSuchAlgorithmException, IllegalArgumentException, IllegalAccessException, ClassNotFoundException {
        sb.append("(");
        Iterator iterator = ((Map)obj).keySet().iterator();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            Object value = ((Map)obj).get(key);
            String keyString = this.stringifyKey(key);
            if (value == null) {
                sb.append(String.valueOf(key) + "#null");
                if (!iterator.hasNext()) continue;
                sb.append(",");
                continue;
            }
            if (value instanceof List || value instanceof Map) {
                sb.append(keyString);
                sb.append("#");
                this.stringfy(sb, value, Class.forName(type.getTypeName()));
            } else if (this.numericalValueClasses.contains(value.getClass())) {
                sb.append(keyString);
                sb.append("#");
                sb.append(value.toString());
            } else if (String.class == value.getClass()) {
                sb.append(keyString);
                sb.append("#");
                sb.append(this.escapeCharacters(value.toString()));
            } else {
                sb.append(keyString);
                sb.append("#");
                this.stringifyObject(sb, value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(",");
        }
        sb.append(")");
    }

    private void populateMap(Map map, Type keyType, Type valueType, String input) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, OpeningCharacterNotFound {
        int endOfLastValue = 0;
        Boolean keyFound = false;
        Boolean valueFound = false;
        String inputKey = "";
        String inputValue = "";
        for (int i = 0; i <= input.length(); ++i) {
            if (!keyFound.booleanValue()) {
                if (input.charAt(i) == this.CH_OPEN_LIST || input.charAt(i) == this.CH_OPEN_MAP || input.charAt(i) == this.CH_OPEN_OBJECT) {
                    int nextClose = -1;
                    try {
                        nextClose = this.getEnclosingIndex(input, i);
                    }
                    catch (OpeningCharacterNotFound e) {
                        e.printStackTrace();
                        throw this.createException(-1, input, null, null);
                    }
                    inputKey = input.substring(endOfLastValue + 1, nextClose);
                    i = endOfLastValue = nextClose + 2;
                    keyFound = true;
                } else if (input.charAt(i) == this.CH_KEY_SEPARATOR) {
                    inputKey = input.substring(endOfLastValue, i);
                    endOfLastValue = i + 1;
                    keyFound = true;
                }
            } else if (!valueFound.booleanValue() || i >= input.length()) {
                if (i >= input.length()) {
                    inputValue = input.substring(endOfLastValue, i);
                    endOfLastValue = i + 1;
                    valueFound = true;
                } else if (input.charAt(i) == this.CH_VALUE_SEPARATOR) {
                    inputValue = input.substring(endOfLastValue, i);
                    endOfLastValue = i + 1;
                    valueFound = true;
                } else if (input.charAt(i) == this.CH_OPEN_LIST || input.charAt(i) == this.CH_OPEN_MAP || input.charAt(i) == this.CH_OPEN_OBJECT) {
                    int nextClose = -1;
                    try {
                        nextClose = this.getEnclosingIndex(input, i);
                    }
                    catch (OpeningCharacterNotFound e) {
                        e.printStackTrace();
                        throw this.createException(-1, input, null, null);
                    }
                    inputValue = input.substring(endOfLastValue + 1, nextClose);
                    i = endOfLastValue = nextClose + 2;
                    valueFound = true;
                }
            }
            if (!keyFound.booleanValue() || !valueFound.booleanValue()) continue;
            Object key = this.instantiateFromStringByClass(keyType, inputKey);
            Object value = this.instantiateFromStringByClass(valueType, inputValue);
            map.put(key, value);
            keyFound = false;
            valueFound = false;
        }
    }

    private Object instantiateFromStringByClass(Type valueType, String input) throws ClassNotFoundException, IllegalArgumentException, IllegalAccessException, SecurityException, InstantiationException, InvocationTargetException, NoSuchMethodException, OpeningCharacterNotFound {
        if (valueType == String.class) {
            return input;
        }
        if (valueType == Integer.class) {
            return Integer.parseInt(input);
        }
        if (valueType == Long.class) {
            return Long.valueOf(input);
        }
        if (valueType == Float.class) {
            return Float.valueOf(Float.parseFloat(input));
        }
        if (valueType == Double.class) {
            return Double.parseDouble(input);
        }
        if (valueType == Boolean.class) {
            return Boolean.parseBoolean(input);
        }
        if (valueType == BigDecimal.class) {
            return new BigDecimal(input);
        }
        if (valueType instanceof ParameterizedType && ((ParameterizedType)valueType).getRawType() == List.class) {
            ArrayList list = (ArrayList)CompactoParser.createListOfType(((ParameterizedType)valueType).getActualTypeArguments()[0].getClass());
            this.populateList(list, ((ParameterizedType)valueType).getActualTypeArguments()[0], input);
            return list;
        }
        if (valueType instanceof ParameterizedType && ((ParameterizedType)valueType).getRawType() == Map.class) {
            Map<?, ?> map = CompactoParser.createMapOfType(((ParameterizedType)valueType).getActualTypeArguments()[0].getClass(), ((ParameterizedType)valueType).getActualTypeArguments()[1].getClass());
            this.populateMap(map, ((ParameterizedType)valueType).getActualTypeArguments()[0], ((ParameterizedType)valueType).getActualTypeArguments()[1], input);
            return map;
        }
        Object resultObject = Class.forName(valueType.getTypeName()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        this.instantiateAttributes(resultObject, input);
        return resultObject;
    }

    private boolean hasRestrictModifiers(Field field) {
        return this.hasModifier(field, 2) && this.hasModifier(field, 8) && this.hasModifier(field, 16);
    }

    private boolean hasModifier(Field field, int modifier) {
        return (field.getModifiers() & modifier) != 0;
    }

    private Map<String, Field> getAllFields(Object obj) {
        HashMap<String, Field> fields = new HashMap<String, Field>();
        for (Class<?> objSuperclass = obj.getClass(); objSuperclass != Object.class; objSuperclass = objSuperclass.getSuperclass()) {
            Arrays.asList(objSuperclass.getDeclaredFields()).stream().filter(f -> !this.hasRestrictModifiers((Field)f)).forEach(f -> fields.put(f.getName(), (Field)f));
        }
        return fields;
    }
}

