/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.jpa;

import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.persistence.EntityExistsException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityNotFoundException;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.PersistenceContextType;
import javax.persistence.PersistenceException;
import javax.persistence.TransactionRequiredException;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManager;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.jdo.JDOPersistenceManager;
import org.datanucleus.jpa.EntityManagerFactoryImpl;
import org.datanucleus.jpa.EntityTransactionImpl;
import org.datanucleus.jpa.JPAQuery;
import org.datanucleus.jpa.NucleusJPAHelper;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.QueryLanguage;
import org.datanucleus.metadata.QueryMetaData;
import org.datanucleus.metadata.QueryResultMetaData;
import org.datanucleus.metadata.TransactionType;
import org.datanucleus.store.query.Query;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.StringUtils;

public class EntityManagerImpl
implements EntityManager {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.jpa.Localisation", (ClassLoader)NucleusJPAHelper.class.getClassLoader());
    protected PersistenceManager pm;
    protected ObjectManager om;
    protected EntityManagerFactory emf;
    protected EntityTransaction tx;
    protected FlushModeType flushMode = FlushModeType.AUTO;
    protected PersistenceContextType persistenceContextType;

    public EntityManagerImpl(EntityManagerFactory emf, PersistenceManagerFactory pmf, PersistenceContextType contextType) {
        this.emf = emf;
        this.pm = pmf.getPersistenceManager();
        this.om = ((JDOPersistenceManager)this.pm).getObjectManager();
        ObjectManagerFactoryImpl omf = (ObjectManagerFactoryImpl)pmf;
        if (omf.getOMFContext().getPersistenceConfiguration().getStringProperty("datanucleus.TransactionType").equalsIgnoreCase(TransactionType.RESOURCE_LOCAL.toString())) {
            this.tx = new EntityTransactionImpl(this.om);
        }
    }

    public void clear() {
        this.assertIsOpen();
        this.om.detachAll();
        this.om.clearDirty();
        this.om.evictAllObjects();
    }

    public boolean isOpen() {
        return !this.om.isClosed();
    }

    public void close() {
        this.assertIsOpen();
        if (((EntityManagerFactoryImpl)this.emf).isContainerManaged()) {
            // empty if block
        }
        this.pm.close();
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.emf;
    }

    public boolean contains(Object entity) {
        this.assertIsOpen();
        this.assertEntity(entity);
        if (this.om.getApiAdapter().getPersistenceManager(entity) != this.pm) {
            return false;
        }
        if (this.om.getApiAdapter().isDeleted(entity)) {
            return false;
        }
        return !this.om.getApiAdapter().isDetached(entity);
    }

    public Object find(Class entityClass, Object primaryKey) {
        Object pc;
        block10: {
            this.assertIsOpen();
            this.assertEntity(entityClass);
            AbstractClassMetaData acmd = this.om.getMetaDataManager().getMetaDataForClass(entityClass, this.om.getClassLoaderResolver());
            if (acmd == null) {
                throw new EntityNotFoundException();
            }
            try {
                if (acmd.getObjectidClass().equals(primaryKey.getClass().getName())) {
                    pc = this.om.findObject(primaryKey, true, true, null);
                    break block10;
                }
                Object id = null;
                try {
                    id = this.om.newObjectId(entityClass, primaryKey);
                }
                catch (NucleusException jpe) {
                    throw new IllegalArgumentException(jpe);
                }
                pc = this.om.findObject(id, true, true, null);
            }
            catch (NucleusObjectNotFoundException ex) {
                return null;
            }
        }
        if (this.om.getApiAdapter().isTransactional(pc)) {
            StateManager sm = this.om.findStateManager(pc);
            if (this.om.getApiAdapter().isDeleted(pc)) {
                try {
                    sm.locate();
                }
                catch (NucleusObjectNotFoundException ex) {
                    return null;
                }
            }
        }
        return pc;
    }

    public Object getDelegate() {
        this.assertIsOpen();
        return this.om;
    }

    public Object getReference(Class entityClass, Object primaryKey) {
        this.assertIsOpen();
        this.assertEntity(entityClass);
        Object id = null;
        try {
            id = this.om.newObjectId(entityClass, primaryKey);
        }
        catch (NucleusException jpe) {
            throw new IllegalArgumentException(jpe);
        }
        return this.om.findObject(id, true, true, null);
    }

    public void lock(Object entity, LockModeType lockMode) {
        this.assertIsOpen();
        this.assertIsActive();
        this.assertEntity(entity);
        if (this.om.getApiAdapter().isDetached(entity)) {
            throw new IllegalArgumentException(LOCALISER.msg("EM.EntityIsDetached", (Object)StringUtils.toJVMIDString((Object)entity), (Object)("" + this.om.getApiAdapter().getIdForObject(entity))));
        }
        if (!this.contains(entity)) {
            throw new PersistenceException("Entity is not contained in this persistence context so cant lock it");
        }
    }

    public void persist(Object entity) {
        this.assertIsOpen();
        this.assertTransactionNotRequired();
        this.assertEntity(entity);
        if (this.om.exists(entity) && this.om.getApiAdapter().isDetached(entity)) {
            throw new EntityExistsException(LOCALISER.msg("EM.EntityIsPersistent", (Object)StringUtils.toJVMIDString((Object)entity)));
        }
        try {
            this.om.persistObject(entity);
        }
        catch (NucleusException jpe) {
            throw NucleusJPAHelper.getJPAExceptionForNucleusException(jpe);
        }
    }

    public Object merge(Object entity) {
        this.assertIsOpen();
        this.assertTransactionNotRequired();
        this.assertEntity(entity);
        if (this.om.getApiAdapter().isDeleted(entity)) {
            throw new IllegalArgumentException(LOCALISER.msg("EM.EntityIsDeleted", (Object)StringUtils.toJVMIDString((Object)entity), (Object)("" + this.om.getApiAdapter().getIdForObject(entity))));
        }
        try {
            return this.om.persistObject(entity);
        }
        catch (NucleusException jpe) {
            throw NucleusJPAHelper.getJPAExceptionForNucleusException(jpe);
        }
    }

    public void refresh(Object entity) {
        this.assertIsOpen();
        this.assertTransactionNotRequired();
        this.assertEntity(entity);
        if (this.om.getApiAdapter().getPersistenceManager(entity) != this.pm) {
            throw new IllegalArgumentException(LOCALISER.msg("EM.EntityIsNotManaged", (Object)StringUtils.toJVMIDString((Object)entity)));
        }
        if (!this.om.exists(entity)) {
            throw new EntityNotFoundException(LOCALISER.msg("EM.EntityNotInDatastore", (Object)StringUtils.toJVMIDString((Object)entity)));
        }
        try {
            this.om.refreshObject(entity);
        }
        catch (NucleusException jpe) {
            throw NucleusJPAHelper.getJPAExceptionForNucleusException(jpe);
        }
    }

    public void remove(Object entity) {
        this.assertIsOpen();
        this.assertTransactionNotRequired();
        if (entity == null) {
            return;
        }
        this.assertEntity(entity);
        if (this.om.getApiAdapter().isDetached(entity)) {
            throw new IllegalArgumentException(LOCALISER.msg("EM.EntityIsDetached", (Object)StringUtils.toJVMIDString((Object)entity), (Object)("" + this.om.getApiAdapter().getIdForObject(entity))));
        }
        try {
            this.om.deleteObject(entity);
        }
        catch (NucleusException jpe) {
            throw NucleusJPAHelper.getJPAExceptionForNucleusException(jpe);
        }
    }

    public void flush() {
        this.assertIsOpen();
        this.assertIsActive();
        try {
            this.om.flush();
        }
        catch (NucleusException jpe) {
            throw NucleusJPAHelper.getJPAExceptionForNucleusException(jpe);
        }
    }

    public FlushModeType getFlushMode() {
        this.assertIsOpen();
        return this.flushMode;
    }

    public void setFlushMode(FlushModeType flushMode) {
        this.assertIsOpen();
        this.flushMode = flushMode;
    }

    public EntityTransaction getTransaction() {
        if (this.tx == null) {
            throw new IllegalStateException(LOCALISER.msg("EM.TransactionNotLocal"));
        }
        return this.tx;
    }

    public void joinTransaction() {
        this.assertIsOpen();
        this.tx = new EntityTransactionImpl(this.om);
    }

    public javax.persistence.Query createNamedQuery(String queryName) {
        this.assertIsOpen();
        if (queryName == null) {
            throw new IllegalArgumentException(LOCALISER.msg("Query.NamedQueryNotFound", (Object)queryName));
        }
        ClassLoaderResolver clr = this.om.getClassLoaderResolver();
        QueryMetaData qmd = this.om.getMetaDataManager().getMetaDataForQuery(null, clr, queryName);
        if (qmd == null) {
            throw new IllegalArgumentException(LOCALISER.msg("Query.NamedQueryNotFound", (Object)queryName));
        }
        try {
            if (qmd.getLanguage().equals(QueryLanguage.JPQL.toString())) {
                Query jpoxQuery = this.getObjectManager().getOMFContext().getQueryManager().newQuery(qmd.getLanguage().toString(), this.getObjectManager(), (Object)qmd.getQuery());
                return new JPAQuery(this, jpoxQuery, qmd.getLanguage());
            }
            if (qmd.getLanguage().equals(QueryLanguage.SQL.toString())) {
                Query jpoxQuery = this.getObjectManager().getOMFContext().getQueryManager().newQuery(qmd.getLanguage(), this.getObjectManager(), (Object)qmd.getQuery());
                if (qmd.getResultClass() != null) {
                    String resultClassName = qmd.getResultClass();
                    Class resultClass = null;
                    try {
                        resultClass = this.om.getClassLoaderResolver().classForName(resultClassName);
                        jpoxQuery.setResultClass(resultClass);
                        return new JPAQuery(this, jpoxQuery, qmd.getLanguage());
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException(LOCALISER.msg("Query.ResultClassNotFound", (Object)qmd.getName(), (Object)resultClassName));
                    }
                }
                if (qmd.getResultMetaDataName() != null) {
                    QueryResultMetaData qrmd = this.om.getMetaDataManager().getMetaDataForQueryResult(qmd.getResultMetaDataName());
                    if (qrmd == null) {
                        throw new IllegalArgumentException("ResultSetMapping " + qmd.getResultMetaDataName() + " is not found");
                    }
                    jpoxQuery.setResultMetaData(qrmd);
                    return new JPAQuery(this, jpoxQuery, qmd.getLanguage());
                }
                return new JPAQuery(this, jpoxQuery, qmd.getLanguage());
            }
            throw new IllegalArgumentException(LOCALISER.msg("Query.LanguageNotSupportedByStore", (Object)qmd.getLanguage()));
        }
        catch (NucleusException jpe) {
            throw new IllegalArgumentException(jpe.getMessage(), jpe);
        }
    }

    public javax.persistence.Query createNativeQuery(String sqlString) {
        this.assertIsOpen();
        try {
            Query jpoxQuery = this.getObjectManager().getOMFContext().getQueryManager().newQuery(QueryLanguage.SQL.toString(), this.getObjectManager(), (Object)sqlString);
            return new JPAQuery(this, jpoxQuery, QueryLanguage.SQL.toString());
        }
        catch (NucleusException jpe) {
            throw new IllegalArgumentException(jpe.getMessage(), jpe);
        }
    }

    public javax.persistence.Query createNativeQuery(String sqlString, Class resultClass) {
        this.assertIsOpen();
        try {
            Query jpoxQuery = this.getObjectManager().getOMFContext().getQueryManager().newQuery(QueryLanguage.SQL.toString(), this.getObjectManager(), (Object)sqlString);
            jpoxQuery.setResultClass(resultClass);
            return new JPAQuery(this, jpoxQuery, QueryLanguage.SQL.toString());
        }
        catch (NucleusException jpe) {
            throw new IllegalArgumentException(jpe.getMessage(), jpe);
        }
    }

    public javax.persistence.Query createNativeQuery(String sqlString, String resultSetMapping) {
        this.assertIsOpen();
        try {
            Query jpoxQuery = this.getObjectManager().getOMFContext().getQueryManager().newQuery(QueryLanguage.SQL.toString(), this.getObjectManager(), (Object)sqlString);
            QueryResultMetaData qrmd = this.om.getMetaDataManager().getMetaDataForQueryResult(resultSetMapping);
            if (qrmd == null) {
                throw new IllegalArgumentException("ResultSetMapping " + resultSetMapping + " is not found");
            }
            jpoxQuery.setResultMetaData(qrmd);
            return new JPAQuery(this, jpoxQuery, QueryLanguage.SQL.toString());
        }
        catch (NucleusException jpe) {
            throw new IllegalArgumentException(jpe.getMessage(), jpe);
        }
    }

    public javax.persistence.Query createQuery(String queryString) {
        this.assertIsOpen();
        try {
            Query jpoxQuery = this.getObjectManager().getOMFContext().getQueryManager().newQuery(QueryLanguage.JPQL.toString(), this.getObjectManager(), (Object)queryString);
            return new JPAQuery(this, jpoxQuery, QueryLanguage.JPQL.toString());
        }
        catch (NucleusException jpe) {
            throw new IllegalArgumentException(jpe.getMessage(), jpe);
        }
    }

    public ObjectManager getObjectManager() {
        this.assertIsOpen();
        return this.om;
    }

    private void assertIsOpen() {
        if (this.om.isClosed()) {
            throw new IllegalStateException(LOCALISER.msg("EM.IsClosed"));
        }
    }

    private void assertIsActive() {
        if (!this.isTransactionActive()) {
            throw new TransactionRequiredException(LOCALISER.msg("EM.TransactionRequired"));
        }
    }

    private boolean isTransactionActive() {
        return this.tx != null && this.tx.isActive();
    }

    private void assertEntity(Object entity) {
        if (entity == null) {
            throw new IllegalArgumentException(LOCALISER.msg("EM.EntityNotAnEntity", entity));
        }
        Class<?> cls = null;
        cls = entity instanceof Class ? (Class<?>)entity : entity.getClass();
        try {
            this.om.assertClassPersistable(cls);
        }
        catch (NucleusException jpe) {
            throw new IllegalArgumentException(LOCALISER.msg("EM.EntityNotAnEntity", (Object)cls.getName()), jpe);
        }
    }

    private void assertTransactionNotRequired() {
        if (this.persistenceContextType == PersistenceContextType.TRANSACTION && !this.isTransactionActive()) {
            throw new TransactionRequiredException(LOCALISER.msg("EM.TransactionRequired"));
        }
    }
}

