/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.jpa;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.TemporalType;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.jpa.NucleusJPAHelper;
import org.datanucleus.store.query.NoQueryResultsException;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.QueryInvalidParametersException;
import org.datanucleus.store.query.QueryNotUniqueException;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPAQuery
implements javax.persistence.Query {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.jpa.Localisation", (ClassLoader)NucleusJPAHelper.class.getClassLoader());
    EntityManager em;
    String language;
    Query query;
    FlushModeType flushMode = FlushModeType.AUTO;
    private long startPosition = 0L;
    private long maxResults = Long.MAX_VALUE;

    public JPAQuery(EntityManager em, Query query, String language) {
        this.em = em;
        this.query = query;
        this.language = language;
        this.flushMode = em.getFlushMode();
    }

    public int executeUpdate() {
        if (this.query.getType() == 0) {
            throw new IllegalStateException(LOCALISER.msg("Query.ExecuteUpdateForSelectInvalid"));
        }
        try {
            Object result;
            if (this.flushMode == FlushModeType.AUTO && this.em.getTransaction().isActive()) {
                this.em.flush();
            }
            if ((result = this.query.executeWithMap(null)) != null) {
                return ((Long)result).intValue();
            }
            throw new NucleusException("Invalid return from query for an update/delete. Expected Long");
        }
        catch (NoQueryResultsException nqre) {
            return 0;
        }
        catch (QueryInvalidParametersException ex) {
            throw new IllegalArgumentException(ex.getMessage(), ex);
        }
        catch (NucleusException jpe) {
            throw NucleusJPAHelper.getJPAExceptionForNucleusException(jpe);
        }
    }

    public List getResultList() {
        if (this.query.getType() != 0) {
            throw new IllegalStateException(LOCALISER.msg("Query.GetResultForUpdateInvalid"));
        }
        try {
            if (this.flushMode == FlushModeType.AUTO && this.em.getTransaction().isActive()) {
                this.em.flush();
            }
            return (List)this.query.executeWithMap(null);
        }
        catch (NoQueryResultsException nqre) {
            return null;
        }
        catch (QueryInvalidParametersException ex) {
            throw new IllegalArgumentException(ex.getMessage(), ex);
        }
        catch (NucleusException jpe) {
            throw NucleusJPAHelper.getJPAExceptionForNucleusException(jpe);
        }
    }

    public Object getSingleResult() {
        if (this.query.getType() != 0) {
            throw new IllegalStateException(LOCALISER.msg("Query.GetResultForUpdateInvalid"));
        }
        try {
            if (this.flushMode == FlushModeType.AUTO && this.em.getTransaction().isActive()) {
                this.em.flush();
            }
            this.query.setUnique(true);
            return this.query.executeWithMap(null);
        }
        catch (NoQueryResultsException nqre) {
            throw new NoResultException("No results for query: " + this.query.toString());
        }
        catch (QueryNotUniqueException ex) {
            throw new NonUniqueResultException("Expected a single result for query: " + this.query.toString() + " : " + StringUtils.getStringFromStackTrace((Throwable)ex));
        }
        catch (QueryInvalidParametersException ex) {
            throw new IllegalArgumentException(ex.getMessage(), ex);
        }
        catch (NucleusException jpe) {
            throw NucleusJPAHelper.getJPAExceptionForNucleusException(jpe);
        }
    }

    public javax.persistence.Query setFirstResult(int startPosition) {
        if (startPosition < 0) {
            throw new IllegalArgumentException(LOCALISER.msg("Query.StartPositionInvalid"));
        }
        this.startPosition = startPosition;
        this.query.setRange(this.startPosition, this.maxResults);
        return this;
    }

    public javax.persistence.Query setMaxResults(int max) {
        if (max < 0) {
            throw new IllegalArgumentException(LOCALISER.msg("Query.MaxResultsInvalid"));
        }
        this.maxResults = max;
        this.query.setRange(this.startPosition, this.startPosition + (long)max);
        return this;
    }

    public int getMaxResults() {
        long queryMin = this.query.getRangeFromIncl();
        long queryMax = this.query.getRangeToExcl();
        long max = queryMax - queryMin;
        if (max > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)max;
    }

    public int getFirstResult() {
        long queryMin = this.query.getRangeFromIncl();
        return (int)queryMin;
    }

    public javax.persistence.Query setFlushMode(FlushModeType mode) {
        this.flushMode = mode;
        return this;
    }

    public FlushModeType getFlushMode() {
        return this.flushMode;
    }

    public javax.persistence.Query setHint(String hintName, Object value) {
        this.query.addExtension(hintName, value);
        return this;
    }

    public Map getHints() {
        Map extensions = this.query.getExtensions();
        HashMap map = new HashMap();
        if (extensions != null && extensions.size() > 0) {
            map.putAll(extensions);
        }
        return map;
    }

    public Set<String> getSupportedHints() {
        return null;
    }

    public javax.persistence.Query setParameter(String name, Object value) {
        try {
            this.query.setImplicitParameter(name, value);
        }
        catch (QueryInvalidParametersException ipe) {
            throw new IllegalArgumentException(ipe.getMessage());
        }
        return this;
    }

    public javax.persistence.Query setParameter(int position, Object value) {
        try {
            this.query.setImplicitParameter(position, value);
        }
        catch (QueryInvalidParametersException ipe) {
            throw new IllegalArgumentException(ipe.getMessage());
        }
        return this;
    }

    public javax.persistence.Query setParameter(String name, Date value, TemporalType temporalType) {
        try {
            this.query.setImplicitParameter(name, (Object)value);
        }
        catch (QueryInvalidParametersException ipe) {
            throw new IllegalArgumentException(ipe.getMessage());
        }
        return this;
    }

    public javax.persistence.Query setParameter(String name, Calendar value, TemporalType temporalType) {
        try {
            this.query.setImplicitParameter(name, (Object)value);
        }
        catch (QueryInvalidParametersException ipe) {
            throw new IllegalArgumentException(ipe.getMessage());
        }
        return this;
    }

    public javax.persistence.Query setParameter(int position, Date value, TemporalType temporalType) {
        try {
            this.query.setImplicitParameter(position, (Object)value);
        }
        catch (QueryInvalidParametersException ipe) {
            throw new IllegalArgumentException(ipe.getMessage());
        }
        return this;
    }

    public javax.persistence.Query setParameter(int position, Calendar value, TemporalType temporalType) {
        try {
            this.query.setImplicitParameter(position, (Object)value);
        }
        catch (QueryInvalidParametersException ipe) {
            throw new IllegalArgumentException(ipe.getMessage());
        }
        return this;
    }

    public Map getNamedParameters() {
        Map params = this.query.getImplicitParameters();
        HashMap map = new HashMap();
        if (params != null && params.size() > 0) {
            boolean named = true;
            for (Object obj : params.keySet()) {
                if (!(obj instanceof Integer)) continue;
                named = false;
                break;
            }
            if (named) {
                map.putAll(params);
            }
        }
        return map;
    }

    public List getPositionalParameters() {
        Map params = this.query.getImplicitParameters();
        ArrayList list = new ArrayList();
        if (params != null && params.size() > 0) {
            boolean positional = true;
            for (Object obj : params.keySet()) {
                if (!(obj instanceof String)) continue;
                positional = false;
                break;
            }
            if (positional) {
                for (int i = 0; i < params.size(); ++i) {
                    list.add(params.get(new Integer(i + 1)));
                }
            }
        }
        return list;
    }

    public Query getInternalQuery() {
        return this.query;
    }

    public String getLanguage() {
        return this.language;
    }
}

