/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.jpa.metadata;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.persistence.AssociationOverride;
import javax.persistence.AttributeOverride;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.ColumnResult;
import javax.persistence.DiscriminatorType;
import javax.persistence.EmbeddedId;
import javax.persistence.EntityResult;
import javax.persistence.EnumType;
import javax.persistence.FetchType;
import javax.persistence.FieldResult;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.NamedNativeQuery;
import javax.persistence.NamedQuery;
import javax.persistence.PostLoad;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;
import javax.persistence.PrePersist;
import javax.persistence.PreRemove;
import javax.persistence.PreUpdate;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.SecondaryTable;
import javax.persistence.SqlResultSetMapping;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.jpa.annotations.Extension;
import org.datanucleus.jpa.metadata.JPAAnnotationUtils;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ArrayMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.ClassPersistenceModifier;
import org.datanucleus.metadata.CollectionMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.ContainerMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.ElementMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.EventListenerMetaData;
import org.datanucleus.metadata.ExtensionMetaData;
import org.datanucleus.metadata.FieldMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.metadata.FileMetaData;
import org.datanucleus.metadata.IdentityMetaData;
import org.datanucleus.metadata.IdentityStrategy;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.InheritanceMetaData;
import org.datanucleus.metadata.InheritanceStrategy;
import org.datanucleus.metadata.JoinMetaData;
import org.datanucleus.metadata.KeyMetaData;
import org.datanucleus.metadata.MapMetaData;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.OrderMetaData;
import org.datanucleus.metadata.PackageMetaData;
import org.datanucleus.metadata.PrimaryKeyMetaData;
import org.datanucleus.metadata.QueryLanguage;
import org.datanucleus.metadata.QueryMetaData;
import org.datanucleus.metadata.QueryResultMetaData;
import org.datanucleus.metadata.SequenceMetaData;
import org.datanucleus.metadata.TableGeneratorMetaData;
import org.datanucleus.metadata.UniqueMetaData;
import org.datanucleus.metadata.ValueMetaData;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.metadata.VersionStrategy;
import org.datanucleus.metadata.annotations.AbstractAnnotationReader;
import org.datanucleus.metadata.annotations.AnnotationObject;
import org.datanucleus.metadata.annotations.Member;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPAAnnotationReader
extends AbstractAnnotationReader {
    public JPAAnnotationReader(MetaDataManager mgr) {
        super(mgr);
        this.setSupportedAnnotationPackages(new String[]{"javax.persistence", "org.datanucleus"});
    }

    @Override
    protected AbstractClassMetaData processClassAnnotations(PackageMetaData pmd, Class cls, AnnotationObject[] annotations, ClassLoaderResolver clr) {
        ClassMetaData cmd = null;
        if (annotations != null && annotations.length > 0) {
            String identityType = IdentityType.APPLICATION.toString();
            String identityColumn = null;
            String identityStrategy = null;
            String identityGenerator = null;
            String requiresExtent = "true";
            String detachable = "true";
            String embeddedOnly = "false";
            String persistenceModifier = ClassPersistenceModifier.NON_PERSISTENT.toString();
            String idClassName = null;
            String catalog = null;
            String schema = null;
            String table = null;
            String inheritanceStrategyForTree = null;
            String inheritanceStrategy = null;
            String discriminatorColumnName = null;
            String discriminatorColumnType = null;
            Integer discriminatorColumnLength = null;
            String discriminatorValue = null;
            String entityName = null;
            Class[] entityListeners = null;
            boolean excludeSuperClassListeners = false;
            boolean excludeDefaultListeners = false;
            ColumnMetaData[] pkColumnMetaData = null;
            HashSet uniques = null;
            HashSet<FieldMetaData> overriddenFields = null;
            HashSet<QueryMetaData> namedQueries = null;
            ArrayList<QueryResultMetaData> resultMappings = null;
            HashSet<ExtensionMetaData> extensions = null;
            String jpaLevel = this.mgr.getOMFContext().getPersistenceConfiguration().getStringProperty("datanucleus.jpa.level");
            for (int i = 0; i < annotations.length; ++i) {
                NamedQuery[] queries;
                FieldMetaData fmd;
                AttributeOverride[] overrides;
                Object[] values;
                GenerationType type;
                if (!this.isSupportedAnnotation(annotations[i].getName())) continue;
                HashMap<String, Object> annotationValues = annotations[i].getNameValueMap();
                String annName = annotations[i].getName();
                if (annName.equals(JPAAnnotationUtils.ENTITY)) {
                    persistenceModifier = ClassPersistenceModifier.PERSISTENCE_CAPABLE.toString();
                    entityName = (String)annotationValues.get("name");
                    if (entityName != null && entityName.length() != 0) continue;
                    entityName = ClassUtils.getClassNameForClass((Class)cls);
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.MAPPED_SUPERCLASS)) {
                    if (!this.isClassPersistenceCapable(cls)) continue;
                    persistenceModifier = ClassPersistenceModifier.PERSISTENCE_CAPABLE.toString();
                    inheritanceStrategy = InheritanceStrategy.SUBCLASS_TABLE.toString();
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.PERSISTENCE_AWARE) && jpaLevel.equalsIgnoreCase("DataNucleus")) {
                    persistenceModifier = ClassPersistenceModifier.PERSISTENCE_AWARE.toString();
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.DATASTORE_IDENTITY) && jpaLevel.equalsIgnoreCase("DataNucleus")) {
                    identityType = IdentityType.DATASTORE.toString();
                    identityColumn = (String)annotationValues.get("column");
                    type = (GenerationType)annotationValues.get("generationType");
                    identityStrategy = JPAAnnotationUtils.getIdentityStrategyString(type);
                    identityGenerator = (String)annotationValues.get("generator");
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.TABLE)) {
                    table = (String)annotationValues.get("name");
                    catalog = (String)annotationValues.get("catalog");
                    schema = (String)annotationValues.get("schema");
                    UniqueConstraint[] constrs = (UniqueConstraint[])annotationValues.get("uniqueConstraints");
                    if (constrs == null || constrs.length <= 0) continue;
                    for (int j = 0; j < constrs.length; ++j) {
                        UniqueMetaData unimd = new UniqueMetaData(null, (String)annotationValues.get("name"), null);
                        for (int k = 0; k < constrs[j].columnNames().length; ++k) {
                            unimd.addColumn(new ColumnMetaData((MetaData)unimd, constrs[j].columnNames()[k]));
                        }
                        uniques.add(unimd);
                    }
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.ID_CLASS)) {
                    idClassName = ((Class)annotationValues.get("value")).getName();
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.INHERITANCE)) {
                    InheritanceType inhType = (InheritanceType)annotationValues.get("strategy");
                    inheritanceStrategyForTree = inhType.toString();
                    if (inhType == InheritanceType.JOINED) {
                        inheritanceStrategy = InheritanceStrategy.NEW_TABLE.toString();
                        continue;
                    }
                    if (inhType == InheritanceType.TABLE_PER_CLASS) {
                        inheritanceStrategy = InheritanceStrategy.COMPLETE_TABLE.toString();
                        continue;
                    }
                    if (inhType != InheritanceType.SINGLE_TABLE) continue;
                }
                if (annName.equals(JPAAnnotationUtils.DISCRIMINATOR_COLUMN)) {
                    discriminatorColumnName = (String)annotationValues.get("name");
                    type = (DiscriminatorType)annotationValues.get("discriminatorType");
                    if (type == DiscriminatorType.CHAR) {
                        discriminatorColumnType = "CHAR";
                    } else if (type == DiscriminatorType.INTEGER) {
                        discriminatorColumnType = "INTEGER";
                    } else if (type == DiscriminatorType.STRING) {
                        discriminatorColumnType = "VARCHAR";
                    }
                    discriminatorColumnLength = (Integer)annotationValues.get("length");
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.DISCRIMINATOR_VALUE)) {
                    discriminatorValue = (String)annotationValues.get("value");
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.EMBEDDABLE)) {
                    embeddedOnly = "true";
                    persistenceModifier = ClassPersistenceModifier.PERSISTENCE_CAPABLE.toString();
                    identityType = IdentityType.NONDURABLE.toString();
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.ENTITY_LISTENERS)) {
                    entityListeners = (Class[])annotationValues.get("value");
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.EXCLUDE_SUPERCLASS_LISTENERS)) {
                    excludeSuperClassListeners = true;
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.EXCLUDE_DEFAULT_LISTENERS)) {
                    excludeDefaultListeners = true;
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.SEQUENCE_GENERATOR)) {
                    this.processSequenceGeneratorAnnotation(pmd, annotationValues);
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.TABLE_GENERATOR)) {
                    this.processTableGeneratorAnnotation(pmd, annotationValues);
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.PRIMARY_KEY_JOIN_COLUMN)) {
                    pkColumnMetaData = new ColumnMetaData[]{new ColumnMetaData((MetaData)cmd, (String)annotationValues.get("name"), (String)annotationValues.get("referencedColumnName"), null, null, null, null, null, null, null, null, null, null, null)};
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.PRIMARY_KEY_JOIN_COLUMNS)) {
                    values = (PrimaryKeyJoinColumn[])annotationValues.get("value");
                    pkColumnMetaData = new ColumnMetaData[values.length];
                    for (int j = 0; j < values.length; ++j) {
                        pkColumnMetaData[j] = new ColumnMetaData((MetaData)cmd, values[j].name(), values[j].referencedColumnName(), null, null, null, null, null, null, null, null, null, null, null);
                    }
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.ATTRIBUTE_OVERRIDES)) {
                    overrides = (AttributeOverride[])annotationValues.get("value");
                    if (overrides == null) continue;
                    if (overriddenFields == null) {
                        overriddenFields = new HashSet();
                    }
                    for (int j = 0; j < overrides.length; ++j) {
                        FieldMetaData fmd2 = this.mgr.getMetaDataFactory().newFieldObject((MetaData)cmd, "#UNKNOWN." + overrides[j].name(), null, "persistent", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
                        Column col = overrides[j].column();
                        fmd2.addColumn(new ColumnMetaData((MetaData)fmd2, col.name(), null, null, null, null, "" + col.length(), "" + col.scale(), "" + col.nullable(), null, null, "" + col.insertable(), "" + col.updatable(), "" + col.unique()));
                        overriddenFields.add(fmd2);
                    }
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.ATTRIBUTE_OVERRIDE)) {
                    if (overriddenFields == null) {
                        overriddenFields = new HashSet<FieldMetaData>();
                    }
                    fmd = this.mgr.getMetaDataFactory().newFieldObject((MetaData)cmd, "#UNKNOWN." + (String)annotationValues.get("name"), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
                    Column col = (Column)annotationValues.get("column");
                    fmd.addColumn(new ColumnMetaData((MetaData)fmd, col.name(), null, null, null, null, "" + col.length(), "" + col.scale(), "" + col.nullable(), null, null, "" + col.insertable(), "" + col.updatable(), "" + col.unique()));
                    overriddenFields.add(fmd);
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.ASSOCIATION_OVERRIDES)) {
                    overrides = (AssociationOverride[])annotationValues.get("value");
                    if (overrides == null) continue;
                    if (overriddenFields == null) {
                        overriddenFields = new HashSet();
                    }
                    for (int j = 0; j < overrides.length; ++j) {
                        FieldMetaData fmd3 = this.mgr.getMetaDataFactory().newFieldObject((MetaData)cmd, "#UNKNOWN." + overrides[j].name(), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
                        JoinColumn[] cols = overrides[j].joinColumns();
                        for (int k = 0; k < cols.length; ++k) {
                            fmd3.addColumn(new ColumnMetaData((MetaData)fmd3, cols[k].name(), null, cols[k].referencedColumnName(), null, null, null, null, "" + cols[k].nullable(), null, null, "" + cols[k].insertable(), "" + cols[k].updatable(), "" + cols[k].unique()));
                        }
                        overriddenFields.add(fmd3);
                    }
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.ASSOCIATION_OVERRIDE)) {
                    if (overriddenFields == null) {
                        overriddenFields = new HashSet();
                    }
                    fmd = this.mgr.getMetaDataFactory().newFieldObject((MetaData)cmd, "#UNKNOWN." + (String)annotationValues.get("name"), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
                    JoinColumn[] cols = (JoinColumn[])annotationValues.get("joinColumns");
                    for (int k = 0; k < cols.length; ++k) {
                        fmd.addColumn(new ColumnMetaData((MetaData)fmd, cols[k].name(), null, cols[k].referencedColumnName(), null, null, null, null, "" + cols[k].nullable(), null, null, "" + cols[k].insertable(), "" + cols[k].updatable(), "" + cols[k].unique()));
                    }
                    overriddenFields.add(fmd);
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.NAMED_QUERIES)) {
                    queries = (NamedQuery[])annotationValues.get("value");
                    if (namedQueries == null) {
                        namedQueries = new HashSet();
                    }
                    for (int j = 0; j < queries.length; ++j) {
                        QueryMetaData qmd = new QueryMetaData((MetaData)cmd, null, queries[j].name(), QueryLanguage.JPQL.toString(), "true", null, null, null, null);
                        qmd.setQuery(queries[j].query());
                        namedQueries.add(qmd);
                    }
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.NAMED_QUERY)) {
                    if (namedQueries == null) {
                        namedQueries = new HashSet<QueryMetaData>();
                    }
                    QueryMetaData qmd = new QueryMetaData((MetaData)cmd, null, (String)annotationValues.get("name"), QueryLanguage.JPQL.toString(), "true", null, null, null, null);
                    qmd.setQuery((String)annotationValues.get("query"));
                    namedQueries.add(qmd);
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.NAMED_NATIVE_QUERIES)) {
                    queries = (NamedNativeQuery[])annotationValues.get("value");
                    if (namedQueries == null) {
                        namedQueries = new HashSet();
                    }
                    for (int j = 0; j < queries.length; ++j) {
                        String resultClassName = null;
                        if (queries[j].resultClass() != null && queries[j].resultClass() != Void.TYPE) {
                            resultClassName = queries[j].resultClass().getName();
                        }
                        String resultMappingName = null;
                        if (queries[j].resultSetMapping() != null) {
                            resultMappingName = queries[j].resultSetMapping();
                        }
                        QueryMetaData qmd = new QueryMetaData((MetaData)cmd, null, queries[j].name(), QueryLanguage.SQL.toString(), "true", resultClassName, resultMappingName, null, null);
                        qmd.setQuery(queries[j].query());
                        namedQueries.add(qmd);
                    }
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.NAMED_NATIVE_QUERY)) {
                    String resultMappingName;
                    if (namedQueries == null) {
                        namedQueries = new HashSet();
                    }
                    Class resultClass = (Class)annotationValues.get("resultClass");
                    String resultClassName = null;
                    if (resultClass != null && resultClass != Void.TYPE) {
                        resultClassName = resultClass.getName();
                    }
                    if (StringUtils.isWhitespace((String)(resultMappingName = (String)annotationValues.get("resultSetMapping")))) {
                        resultMappingName = null;
                    }
                    QueryMetaData qmd = new QueryMetaData((MetaData)cmd, null, (String)annotationValues.get("name"), QueryLanguage.SQL.toString(), "true", resultClassName, resultMappingName, null, null);
                    qmd.setQuery((String)annotationValues.get("query"));
                    namedQueries.add(qmd);
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.SQL_RESULTSET_MAPPINGS)) {
                    SqlResultSetMapping[] mappings = (SqlResultSetMapping[])annotationValues.get("value");
                    if (resultMappings == null) {
                        resultMappings = new ArrayList();
                    }
                    for (int j = 0; j < mappings.length; ++j) {
                        ColumnResult[] colResults;
                        QueryResultMetaData qrmd = new QueryResultMetaData((MetaData)cmd, mappings[j].name());
                        EntityResult[] entityResults = mappings[j].entities();
                        if (entityResults != null) {
                            for (int k = 0; k < entityResults.length; ++k) {
                                String entityClassName = entityResults[k].entityClass().getName();
                                qrmd.addPersistentTypeMapping(entityClassName, null, entityResults[k].discriminatorColumn());
                                FieldResult[] fields = entityResults[k].fields();
                                if (fields == null) continue;
                                for (int l = 0; l < fields.length; ++l) {
                                    qrmd.addMappingForPersistentTypeMapping(entityClassName, fields[l].name(), fields[l].column());
                                }
                            }
                        }
                        if ((colResults = mappings[j].columns()) != null) {
                            for (int k = 0; k < colResults.length; ++k) {
                                qrmd.addScalarColumn(colResults[k].name());
                            }
                        }
                        resultMappings.add(qrmd);
                    }
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.SQL_RESULTSET_MAPPING)) {
                    ColumnResult[] colResults;
                    if (resultMappings == null) {
                        resultMappings = new ArrayList<QueryResultMetaData>();
                    }
                    QueryResultMetaData qrmd = new QueryResultMetaData((MetaData)cmd, (String)annotationValues.get("name"));
                    EntityResult[] entityResults = (EntityResult[])annotationValues.get("entities");
                    if (entityResults != null) {
                        for (int j = 0; j < entityResults.length; ++j) {
                            String entityClassName = entityResults[j].entityClass().getName();
                            qrmd.addPersistentTypeMapping(entityClassName, null, entityResults[j].discriminatorColumn());
                            FieldResult[] fields = entityResults[j].fields();
                            if (fields == null) continue;
                            for (int k = 0; k < fields.length; ++k) {
                                qrmd.addMappingForPersistentTypeMapping(entityClassName, fields[k].name(), fields[k].column());
                            }
                        }
                    }
                    if ((colResults = (ColumnResult[])annotationValues.get("columns")) != null) {
                        for (int j = 0; j < colResults.length; ++j) {
                            qrmd.addScalarColumn(colResults[j].name());
                        }
                    }
                    resultMappings.add(qrmd);
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.SECONDARY_TABLES) || annName.equals(JPAAnnotationUtils.SECONDARY_TABLE)) continue;
                if (annName.equals(JPAAnnotationUtils.EXTENSION)) {
                    ExtensionMetaData extmd = new ExtensionMetaData((String)annotationValues.get("vendorName"), (String)annotationValues.get("key"), (String)annotationValues.get("value"));
                    if (extensions == null) {
                        extensions = new HashSet<ExtensionMetaData>(1);
                    }
                    extensions.add(extmd);
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.EXTENSIONS)) {
                    values = (Extension[])annotationValues.get("value");
                    if (values == null || values.length <= 0) continue;
                    if (extensions == null) {
                        extensions = new HashSet(values.length);
                    }
                    for (int j = 0; j < values.length; ++j) {
                        ExtensionMetaData extmd = new ExtensionMetaData(values[j].vendorName(), values[j].key().toString(), values[j].value().toString());
                        extensions.add(extmd);
                    }
                    continue;
                }
                NucleusLogger.METADATA.error((Object)LOCALISER.msg("MetaData.Annotations.AnnotationNotProcessed", (Object)cls.getName(), (Object)annotations[i].getName()));
            }
            if (entityName == null || entityName.length() == 0) {
                entityName = ClassUtils.getClassNameForClass((Class)cls);
            }
            if (persistenceModifier.equals(ClassPersistenceModifier.PERSISTENCE_CAPABLE.toString()) || persistenceModifier.equals(ClassPersistenceModifier.PERSISTENCE_AWARE.toString())) {
                Iterator iter;
                NucleusLogger.METADATA.info((Object)LOCALISER.msg("MetaData.Annotations.ClassUsingAnnotations", (Object)cls.getName(), (Object)"JPA"));
                if (pmd == null) {
                    FileMetaData filemd = new FileMetaData("annotations", null, null, null);
                    filemd.setType(4);
                    pmd = new PackageMetaData(filemd, cls.getPackage().getName(), null, null);
                    filemd.addPackage(pmd);
                }
                boolean superClassPC = this.isClassPersistenceCapable(cls.getSuperclass());
                cmd = this.mgr.getMetaDataFactory().newClassObject(pmd, ClassUtils.getClassNameForClass((Class)cls), identityType, idClassName, requiresExtent, detachable, embeddedOnly, persistenceModifier, superClassPC ? cls.getSuperclass().getName() : null, catalog, schema, table, entityName);
                if (excludeSuperClassListeners) {
                    cmd.excludeSuperClassListeners();
                }
                if (excludeDefaultListeners) {
                    cmd.excludeDefaultListeners();
                }
                if (entityListeners != null) {
                    for (int i = 0; i < entityListeners.length; ++i) {
                        EventListenerMetaData elmd = new EventListenerMetaData(entityListeners[i].getName());
                        cmd.addListener(elmd);
                    }
                }
                pmd.addClass(cmd);
                InheritanceMetaData inhmd = null;
                if (inheritanceStrategy != null) {
                    inhmd = new InheritanceMetaData((AbstractClassMetaData)cmd, inheritanceStrategy);
                    inhmd.setStrategyForTree(inheritanceStrategyForTree);
                } else if (discriminatorValue != null || discriminatorColumnName != null || discriminatorColumnLength != null || discriminatorColumnType != null) {
                    inhmd = new InheritanceMetaData((AbstractClassMetaData)cmd, null);
                    inhmd.setStrategyForTree(inheritanceStrategyForTree);
                }
                if (discriminatorValue != null || discriminatorColumnName != null || discriminatorColumnLength != null || discriminatorColumnType != null) {
                    DiscriminatorMetaData dismd = null;
                    if (discriminatorValue != null) {
                        dismd = new DiscriminatorMetaData(inhmd, discriminatorColumnName, discriminatorValue, "value-map", "false");
                    } else {
                        discriminatorValue = cls.getName();
                        dismd = new DiscriminatorMetaData(inhmd, discriminatorColumnName, discriminatorValue, "class-name", "false");
                    }
                    ColumnMetaData discolmd = null;
                    if (discriminatorColumnLength != null || discriminatorColumnName != null || discriminatorColumnType != null) {
                        discolmd = new ColumnMetaData((MetaData)dismd, discriminatorColumnName);
                        if (discriminatorColumnType != null) {
                            discolmd.setJdbcType(discriminatorColumnType);
                        }
                        if (discriminatorColumnLength != null) {
                            discolmd.setLength(discriminatorColumnLength);
                        }
                        dismd.setColumnMetaData(discolmd);
                    }
                    inhmd.setDiscriminatorMetaData(dismd);
                }
                if (inhmd != null) {
                    cmd.setInheritanceMetaData(inhmd);
                }
                if (identityType == IdentityType.DATASTORE.toString() && jpaLevel.equalsIgnoreCase("DataNucleus")) {
                    IdentityMetaData idmd = new IdentityMetaData((AbstractClassMetaData)cmd, identityColumn, identityStrategy, identityGenerator);
                    if (identityGenerator != null) {
                        idmd.setValueGeneratorName(identityGenerator);
                    }
                    cmd.setIdentityMetaData(idmd);
                }
                if (pkColumnMetaData != null) {
                    PrimaryKeyMetaData pkmd = cmd.getPrimaryKeyMetaData();
                    if (pkmd == null) {
                        pkmd = new PrimaryKeyMetaData((MetaData)cmd, null, null);
                        cmd.setPrimaryKeyMetaData(pkmd);
                    }
                    for (int i = 0; i < pkColumnMetaData.length; ++i) {
                        pkmd.addColumn(pkColumnMetaData[i]);
                    }
                }
                if (uniques != null && uniques.size() > 0) {
                    Iterator uniquesIter = uniques.iterator();
                    while (uniquesIter.hasNext()) {
                        cmd.addUniqueConstraint((UniqueMetaData)uniquesIter.next());
                    }
                }
                if (overriddenFields != null) {
                    iter = overriddenFields.iterator();
                    while (iter.hasNext()) {
                        cmd.addMember((AbstractMemberMetaData)iter.next());
                    }
                }
                if (namedQueries != null) {
                    iter = namedQueries.iterator();
                    while (iter.hasNext()) {
                        cmd.addQuery((QueryMetaData)iter.next());
                    }
                }
                if (resultMappings != null) {
                    iter = resultMappings.iterator();
                    while (iter.hasNext()) {
                        cmd.addQueryResultMetaData((QueryResultMetaData)iter.next());
                    }
                }
                if (extensions != null) {
                    for (ExtensionMetaData extmd : extensions) {
                        cmd.addExtension(extmd.getVendorName(), extmd.getKey(), extmd.getValue());
                    }
                }
            }
            this.newJoinMetaDataForClass((AbstractClassMetaData)cmd, annotations);
        }
        return cmd;
    }

    @Override
    protected AbstractMemberMetaData processMemberAnnotations(AbstractClassMetaData cmd, Member member, AnnotationObject[] annotations, boolean propertyAccessor) {
        if (Modifier.isTransient(member.getModifiers())) {
            return null;
        }
        if (member.getName().startsWith("jdo")) {
            return null;
        }
        String jpaLevel = this.mgr.getOMFContext().getPersistenceConfiguration().getStringProperty("datanucleus.jpa.level");
        if (annotations != null && annotations.length > 0 || JPAAnnotationUtils.isBasicByDefault(member.getType())) {
            ColumnMetaData colmd;
            int i;
            if (!member.isProperty() && (annotations == null || annotations.length == 0) && propertyAccessor) {
                return null;
            }
            if (member.isProperty() && (annotations == null || annotations.length == 0) && !propertyAccessor) {
                return null;
            }
            AbstractMemberMetaData mmd = this.newMetaDataForMember(cmd, member, annotations);
            ColumnMetaData[] columnMetaData = null;
            JoinMetaData joinmd = null;
            boolean oneToMany = false;
            boolean manyToMany = false;
            for (i = 0; annotations != null && i < annotations.length; ++i) {
                UniqueConstraint[] joinUniqueConstraints;
                ArrayList<JoinColumn> joinColumns;
                int j;
                if (!this.isSupportedAnnotation(annotations[i].getName())) continue;
                String annName = annotations[i].getName();
                HashMap<String, Object> annotationValues = annotations[i].getNameValueMap();
                if (annName.equals(JPAAnnotationUtils.JOIN_COLUMNS)) {
                    JoinColumn[] cols = (JoinColumn[])annotationValues.get("value");
                    if (cols == null) continue;
                    columnMetaData = new ColumnMetaData[cols.length];
                    for (j = 0; j < cols.length; ++j) {
                        columnMetaData[j] = new ColumnMetaData((MetaData)mmd, cols[j].name(), null, cols[j].referencedColumnName(), null, null, null, null, "" + cols[j].nullable(), null, null, "" + cols[j].insertable(), "" + cols[j].updatable(), "" + cols[j].unique());
                    }
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.JOIN_COLUMN)) {
                    columnMetaData = new ColumnMetaData[1];
                    String colNullable = null;
                    String colInsertable = null;
                    String colUpdateable = null;
                    String colUnique = null;
                    if (annotationValues.get("nullable") != null) {
                        colNullable = annotationValues.get("nullable").toString();
                    }
                    if (annotationValues.get("insertable") != null) {
                        colInsertable = annotationValues.get("insertable").toString();
                    }
                    if (annotationValues.get("updatable") != null) {
                        colUpdateable = annotationValues.get("updatable").toString();
                    }
                    if (annotationValues.get("unique") != null) {
                        colUnique = annotationValues.get("unique").toString();
                    }
                    columnMetaData[0] = new ColumnMetaData((MetaData)mmd, (String)annotationValues.get("name"), null, (String)annotationValues.get("referencedColumnName"), null, null, null, null, colNullable, null, null, colInsertable, colUpdateable, colUnique);
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.ATTRIBUTE_OVERRIDES) && mmd.isEmbedded()) {
                    EmbeddedMetaData emd = new EmbeddedMetaData((MetaData)mmd, mmd.getName(), "", "");
                    mmd.setEmbeddedMetaData(emd);
                    AttributeOverride[] attributeOverride = (AttributeOverride[])annotationValues.get("value");
                    for (int j2 = 0; j2 < attributeOverride.length; ++j2) {
                        FieldMetaData apmd = this.mgr.getMetaDataFactory().newFieldObject((MetaData)emd, attributeOverride[j2].name(), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
                        emd.addMember((AbstractMemberMetaData)apmd);
                        try {
                            Field overrideField = member.getType().getDeclaredField(attributeOverride[j2].name());
                            apmd.addColumn(JPAAnnotationUtils.getColumnMetaDataForColumnAnnotation((MetaData)apmd, new Member(overrideField), attributeOverride[j2].column()));
                            continue;
                        }
                        catch (SecurityException e) {
                            throw new NucleusException("Cannot obtain override field " + attributeOverride[j2].name() + " of class " + member.getType() + " for persistent class " + cmd.getName(), (Throwable)e);
                        }
                        catch (NoSuchFieldException e) {
                            throw new NucleusException("Override field " + attributeOverride[j2].name() + " does not exist in class " + member.getType() + " for persistent class " + cmd.getName(), (Throwable)e);
                        }
                    }
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.JOIN_TABLE)) {
                    mmd.setTable((String)annotationValues.get("name"));
                    mmd.setCatalog((String)annotationValues.get("catalog"));
                    mmd.setSchema((String)annotationValues.get("schema"));
                    joinmd = new JoinMetaData((MetaData)mmd, null, null, null, null, null, null, null, null);
                    mmd.setJoinMetaData(joinmd);
                    if (annotationValues.get("joinColumns") != null) {
                        joinColumns = new ArrayList();
                        joinColumns.addAll(Arrays.asList((JoinColumn[])annotationValues.get("joinColumns")));
                        for (j = 0; j < joinColumns.size(); ++j) {
                            ColumnMetaData colmd2 = new ColumnMetaData((MetaData)joinmd, ((JoinColumn)joinColumns.get(j)).name(), ((JoinColumn)joinColumns.get(j)).referencedColumnName(), null, null, null, null, null, Boolean.valueOf(((JoinColumn)joinColumns.get(j)).nullable()).toString(), null, null, null, null, null);
                            joinmd.addColumn(colmd2);
                        }
                    }
                    if (annotationValues.get("inverseJoinColumns") != null) {
                        ArrayList<JoinColumn> elementColumns = new ArrayList<JoinColumn>();
                        elementColumns.addAll(Arrays.asList((JoinColumn[])annotationValues.get("inverseJoinColumns")));
                        ElementMetaData elmd = new ElementMetaData((MetaData)mmd, null, null, null, null, null, null);
                        mmd.setElementMetaData(elmd);
                        for (int j3 = 0; j3 < elementColumns.size(); ++j3) {
                            ColumnMetaData colmd3 = new ColumnMetaData((MetaData)elmd, ((JoinColumn)elementColumns.get(j3)).name(), ((JoinColumn)elementColumns.get(j3)).referencedColumnName(), null, null, null, null, null, Boolean.valueOf(((JoinColumn)elementColumns.get(j3)).nullable()).toString(), null, null, null, null, null);
                            elmd.addColumn(colmd3);
                        }
                    }
                    if ((joinUniqueConstraints = (UniqueConstraint[])annotationValues.get("uniqueConstraints")) == null || joinUniqueConstraints.length <= 0) continue;
                    for (int j4 = 0; j4 < joinUniqueConstraints.length; ++j4) {
                        UniqueMetaData unimd = new UniqueMetaData(null, null, null);
                        for (int k = 0; k < joinUniqueConstraints[j4].columnNames().length; ++k) {
                            unimd.addColumn(new ColumnMetaData((MetaData)unimd, joinUniqueConstraints[j4].columnNames()[k]));
                        }
                        joinmd.setUniqueMetaData(unimd);
                    }
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.COLLECTION_TABLE) && (jpaLevel.equalsIgnoreCase("JPA2") || jpaLevel.equalsIgnoreCase("DataNucleus"))) {
                    mmd.setTable((String)annotationValues.get("name"));
                    mmd.setCatalog((String)annotationValues.get("catalog"));
                    mmd.setSchema((String)annotationValues.get("schema"));
                    joinmd = mmd.getJoinMetaData();
                    if (joinmd == null) {
                        joinmd = new JoinMetaData((MetaData)mmd, null, null, null, null, null, null, null, null);
                        mmd.setJoinMetaData(joinmd);
                    }
                    if (annotationValues.get("joinColumns") != null) {
                        joinColumns = new ArrayList<JoinColumn>();
                        joinColumns.addAll(Arrays.asList((JoinColumn[])annotationValues.get("joinColumns")));
                        for (j = 0; j < joinColumns.size(); ++j) {
                            ColumnMetaData colmd4 = new ColumnMetaData((MetaData)joinmd, ((JoinColumn)joinColumns.get(j)).name(), ((JoinColumn)joinColumns.get(j)).referencedColumnName(), null, null, null, null, null, Boolean.valueOf(((JoinColumn)joinColumns.get(j)).nullable()).toString(), null, null, null, null, null);
                            joinmd.addColumn(colmd4);
                        }
                    }
                    if ((joinUniqueConstraints = (UniqueConstraint[])annotationValues.get("uniqueConstraints")) == null || joinUniqueConstraints.length <= 0) continue;
                    for (j = 0; j < joinUniqueConstraints.length; ++j) {
                        UniqueMetaData unimd = new UniqueMetaData(null, null, null);
                        for (int k = 0; k < joinUniqueConstraints[j].columnNames().length; ++k) {
                            unimd.addColumn(new ColumnMetaData((MetaData)unimd, joinUniqueConstraints[j].columnNames()[k]));
                        }
                        joinmd.setUniqueMetaData(unimd);
                    }
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.MAP_KEY)) {
                    String keyMappedBy = (String)annotationValues.get("name");
                    if (keyMappedBy == null) continue;
                    mmd.setKeyMetaData(new KeyMetaData((MetaData)mmd, null, null, null, null, null, keyMappedBy));
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.ORDER_BY)) {
                    String orderBy = (String)annotationValues.get("value");
                    if (orderBy == null) continue;
                    mmd.setOrderMetaData(new OrderMetaData(orderBy));
                    continue;
                }
                if (annName.equals(JPAAnnotationUtils.ONE_TO_MANY)) {
                    oneToMany = true;
                    continue;
                }
                if (!annName.equals(JPAAnnotationUtils.MANY_TO_MANY)) continue;
                manyToMany = true;
            }
            if (oneToMany && mmd.getJoinMetaData() == null && mmd.getMappedBy() == null && jpaLevel.equalsIgnoreCase("JPA1")) {
                mmd.setJoinMetaData(new JoinMetaData((MetaData)mmd, null, null, null, null, null, null, null, null));
            }
            if (manyToMany && mmd.getJoinMetaData() == null && mmd.getMappedBy() == null) {
                mmd.setJoinMetaData(new JoinMetaData((MetaData)mmd, null, null, null, null, null, null, null, null));
            }
            if (mmd.getOrderMetaData() == null && Collection.class.isAssignableFrom(member.getType())) {
                mmd.setOrderMetaData(new OrderMetaData("#PK"));
            }
            if (columnMetaData == null && (colmd = this.newColumnMetaData((MetaData)mmd, member, annotations)) != null) {
                columnMetaData = new ColumnMetaData[]{colmd};
            }
            if (columnMetaData != null) {
                if ((mmd.hasCollection() || mmd.hasArray()) && joinmd == null) {
                    ElementMetaData elemmd = mmd.getElementMetaData();
                    if (elemmd == null) {
                        elemmd = new ElementMetaData((MetaData)mmd, null, null, null, null, null, null);
                        mmd.setElementMetaData(elemmd);
                    }
                    for (int i2 = 0; i2 < columnMetaData.length; ++i2) {
                        elemmd.addColumn(columnMetaData[i2]);
                    }
                } else if (mmd.hasMap() && joinmd == null) {
                    ValueMetaData valmd = mmd.getValueMetaData();
                    if (valmd == null) {
                        valmd = new ValueMetaData((MetaData)mmd, null, null, null, null, null, null);
                        mmd.setValueMetaData(valmd);
                    }
                    for (int i3 = 0; i3 < columnMetaData.length; ++i3) {
                        valmd.addColumn(columnMetaData[i3]);
                    }
                } else {
                    for (i = 0; i < columnMetaData.length; ++i) {
                        mmd.addColumn(columnMetaData[i]);
                    }
                }
            }
            return mmd;
        }
        return null;
    }

    @Override
    protected void processMethodAnnotations(AbstractClassMetaData cmd, Method method) {
        Annotation[] annotations = method.getAnnotations();
        EventListenerMetaData elmd = cmd.getListenerForClass(cmd.getFullClassName());
        if (elmd == null) {
            elmd = new EventListenerMetaData(cmd.getFullClassName());
            cmd.addListener(elmd);
        }
        if (annotations != null) {
            for (int i = 0; i < annotations.length; ++i) {
                String annotationTypeName = annotations[i].annotationType().getName();
                if (!annotationTypeName.equals(PrePersist.class.getName()) && !annotationTypeName.equals(PostPersist.class.getName()) && !annotationTypeName.equals(PreRemove.class.getName()) && !annotationTypeName.equals(PostRemove.class.getName()) && !annotationTypeName.equals(PreUpdate.class.getName()) && !annotationTypeName.equals(PostUpdate.class.getName()) && !annotationTypeName.equals(PostLoad.class.getName())) continue;
                elmd.addCallback(annotationTypeName, method.getDeclaringClass().getName(), method.getName());
            }
        }
    }

    private AbstractMemberMetaData newMetaDataForMember(AbstractClassMetaData cmd, Member field, AnnotationObject[] annotations) {
        String modifier = null;
        String dfg = null;
        String embedded = null;
        String pk = null;
        String version = null;
        String nullValue = null;
        String mappedBy = null;
        CascadeType[] cascades = null;
        HashSet<ExtensionMetaData> extensions = null;
        String valueStrategy = null;
        String valueGenerator = null;
        boolean storeInLob = false;
        Class targetEntity = null;
        boolean addJoin = false;
        String jpaLevel = this.mgr.getOMFContext().getPersistenceConfiguration().getStringProperty("datanucleus.jpa.level");
        for (int i = 0; annotations != null && i < annotations.length; ++i) {
            FetchType fetch;
            if (!this.isSupportedAnnotation(annotations[i].getName())) continue;
            String annName = annotations[i].getName();
            HashMap<String, Object> annotationValues = annotations[i].getNameValueMap();
            if (annName.equals(JPAAnnotationUtils.EMBEDDED)) {
                embedded = "true";
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.ID)) {
                pk = "true";
                dfg = "true";
                if (modifier != null) continue;
                modifier = FieldPersistenceModifier.PERSISTENT.toString();
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.TRANSIENT)) {
                modifier = FieldPersistenceModifier.NONE.toString();
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.ENUMERATED)) {
                if (modifier != null) continue;
                modifier = FieldPersistenceModifier.PERSISTENT.toString();
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.VERSION)) {
                version = "true";
                if (modifier != null) continue;
                modifier = FieldPersistenceModifier.PERSISTENT.toString();
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.EMBEDDED_ID)) {
                pk = "true";
                dfg = "true";
                embedded = "true";
                if (modifier != null) continue;
                modifier = FieldPersistenceModifier.PERSISTENT.toString();
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.BASIC)) {
                fetch = (FetchType)annotationValues.get("fetch");
                if (fetch == FetchType.LAZY) {
                    dfg = "false";
                    continue;
                }
                dfg = "true";
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.ONE_TO_ONE)) {
                modifier = FieldPersistenceModifier.PERSISTENT.toString();
                mappedBy = (String)annotationValues.get("mappedBy");
                cascades = (CascadeType[])annotationValues.get("cascade");
                targetEntity = (Class)annotationValues.get("targetEntity");
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.ONE_TO_MANY)) {
                modifier = FieldPersistenceModifier.PERSISTENT.toString();
                mappedBy = (String)annotationValues.get("mappedBy");
                cascades = (CascadeType[])annotationValues.get("cascade");
                targetEntity = (Class)annotationValues.get("targetEntity");
                fetch = (FetchType)annotationValues.get("fetch");
                if (fetch == FetchType.LAZY) {
                    dfg = "false";
                    continue;
                }
                dfg = "true";
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.MANY_TO_MANY)) {
                modifier = FieldPersistenceModifier.PERSISTENT.toString();
                mappedBy = (String)annotationValues.get("mappedBy");
                cascades = (CascadeType[])annotationValues.get("cascade");
                targetEntity = (Class)annotationValues.get("targetEntity");
                fetch = (FetchType)annotationValues.get("fetch");
                if (fetch == FetchType.LAZY) {
                    dfg = "false";
                    continue;
                }
                dfg = "true";
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.MANY_TO_ONE)) {
                modifier = FieldPersistenceModifier.PERSISTENT.toString();
                mappedBy = (String)annotationValues.get("mappedBy");
                cascades = (CascadeType[])annotationValues.get("cascade");
                targetEntity = (Class)annotationValues.get("targetEntity");
                fetch = (FetchType)annotationValues.get("fetch");
                if (fetch == FetchType.LAZY) {
                    dfg = "false";
                    continue;
                }
                dfg = "true";
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.ELEMENT_COLLECTION) && (jpaLevel.equalsIgnoreCase("JPA2") || jpaLevel.equalsIgnoreCase("DataNucleus"))) {
                modifier = FieldPersistenceModifier.PERSISTENT.toString();
                targetEntity = (Class)annotationValues.get("targetClass");
                addJoin = true;
                fetch = (FetchType)annotationValues.get("fetch");
                dfg = fetch == FetchType.LAZY ? "false" : "true";
                cascades = new CascadeType[]{CascadeType.ALL};
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.GENERATED_VALUE)) {
                GenerationType type = (GenerationType)annotationValues.get("strategy");
                valueStrategy = JPAAnnotationUtils.getIdentityStrategyString(type);
                valueGenerator = (String)annotationValues.get("generator");
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.LOB)) {
                storeInLob = true;
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.EXTENSION) && jpaLevel.equalsIgnoreCase("DataNucleus")) {
                ExtensionMetaData extmd = new ExtensionMetaData((String)annotationValues.get("vendorName"), (String)annotationValues.get("key"), (String)annotationValues.get("value"));
                if (extensions == null) {
                    extensions = new HashSet<ExtensionMetaData>(1);
                }
                extensions.add(extmd);
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.EXTENSIONS) && jpaLevel.equalsIgnoreCase("DataNucleus")) {
                Extension[] values = (Extension[])annotationValues.get("value");
                if (values == null || values.length <= 0) continue;
                if (extensions == null) {
                    extensions = new HashSet(values.length);
                }
                for (int j = 0; j < values.length; ++j) {
                    ExtensionMetaData extmd = new ExtensionMetaData(values[j].vendorName(), values[j].key().toString(), values[j].value().toString());
                    extensions.add(extmd);
                }
                continue;
            }
            if (annName.equals(JPAAnnotationUtils.SEQUENCE_GENERATOR)) {
                this.processSequenceGeneratorAnnotation(cmd.getPackageMetaData(), annotationValues);
                continue;
            }
            if (!annName.equals(JPAAnnotationUtils.TABLE_GENERATOR)) continue;
            this.processTableGeneratorAnnotation(cmd.getPackageMetaData(), annotationValues);
        }
        if (JPAAnnotationUtils.isBasicByDefault(field.getType()) && modifier == null) {
            modifier = FieldPersistenceModifier.PERSISTENT.toString();
        }
        Object fmd = field.isProperty() ? this.mgr.getMetaDataFactory().newPropertyObject((MetaData)cmd, field.getName(), pk, modifier, dfg, nullValue, embedded, null, null, mappedBy, null, null, null, null, null, null, null, null, null, null, null, null, null) : this.mgr.getMetaDataFactory().newFieldObject((MetaData)cmd, field.getName(), pk, modifier, dfg, nullValue, embedded, null, null, mappedBy, null, null, null, null, null, null, null, null, null, null, null, null);
        if (version != null) {
            VersionMetaData vermd = new VersionMetaData(VersionStrategy.VERSION_NUMBER.toString(), fmd.getName());
            cmd.setVersionMetaData(vermd);
        }
        cmd.addMember((AbstractMemberMetaData)fmd);
        if (cascades != null) {
            for (int i = 0; i < cascades.length; ++i) {
                if (cascades[i] == CascadeType.ALL) {
                    fmd.setCascadePersist(true);
                    fmd.setCascadeUpdate(true);
                    fmd.setCascadeDelete(true);
                    fmd.setCascadeRefresh(true);
                    continue;
                }
                if (cascades[i] == CascadeType.PERSIST) {
                    fmd.setCascadePersist(true);
                    continue;
                }
                if (cascades[i] == CascadeType.MERGE) {
                    fmd.setCascadeUpdate(true);
                    continue;
                }
                if (cascades[i] == CascadeType.REMOVE) {
                    fmd.setCascadeDelete(true);
                    continue;
                }
                if (cascades[i] != CascadeType.REFRESH) continue;
                fmd.setCascadeRefresh(true);
            }
        }
        if (valueStrategy != null && valueGenerator != null) {
            fmd.setValueGeneratorName(valueGenerator);
        }
        if (valueStrategy != null) {
            fmd.setValueStrategy(IdentityStrategy.getIdentityStrategy(valueStrategy));
        }
        if (storeInLob) {
            fmd.setStoreInLob();
        }
        ArrayMetaData contmd = null;
        if (Collection.class.isAssignableFrom(field.getType())) {
            String elementType = null;
            if (targetEntity != null && targetEntity != Void.TYPE) {
                elementType = targetEntity.getName();
            }
            if (elementType == null) {
                elementType = ClassUtils.getCollectionElementType((Class)field.getType(), (Type)field.getGenericType());
            }
            contmd = new CollectionMetaData((AbstractMemberMetaData)fmd, elementType, null, null, null);
        } else if (field.getType().isArray()) {
            contmd = new ArrayMetaData((AbstractMemberMetaData)fmd, null, null, null, null);
        } else if (Map.class.isAssignableFrom(field.getType())) {
            String keyType = ClassUtils.getMapKeyType((Class)field.getType(), (Type)field.getGenericType());
            String valueType = null;
            if (targetEntity != null && targetEntity != Void.TYPE) {
                valueType = targetEntity.getName();
            }
            if (valueType == null) {
                valueType = ClassUtils.getMapValueType((Class)field.getType(), (Type)field.getGenericType());
            }
            contmd = new MapMetaData((AbstractMemberMetaData)fmd, keyType, null, null, null, valueType, null, null, null);
        }
        if (contmd != null) {
            fmd.setContainer((ContainerMetaData)contmd);
        }
        if (addJoin && fmd.getJoinMetaData() == null) {
            JoinMetaData joinmd = new JoinMetaData((MetaData)fmd, null, null, null, null, null, null, null, null);
            fmd.setJoinMetaData(joinmd);
        }
        if (extensions != null) {
            for (ExtensionMetaData extmd : extensions) {
                fmd.addExtension(extmd.getVendorName(), extmd.getKey(), extmd.getValue());
            }
        }
        return fmd;
    }

    private ColumnMetaData newColumnMetaData(MetaData parent, Member field, AnnotationObject[] annotations) {
        String columnName = null;
        String target = null;
        String targetField = null;
        String jdbcType = null;
        String sqlType = null;
        String length = null;
        String scale = null;
        String allowsNull = null;
        String defaultValue = null;
        String insertValue = null;
        String insertable = null;
        String updateable = null;
        String unique = null;
        String table = null;
        for (int i = 0; annotations != null && i < annotations.length; ++i) {
            if (!this.isSupportedAnnotation(annotations[i].getName())) continue;
            String annName = annotations[i].getName();
            HashMap<String, Object> annotationValues = annotations[i].getNameValueMap();
            if (annName.equals(JPAAnnotationUtils.COLUMN)) {
                String columnTable;
                columnName = (String)annotationValues.get("name");
                if (field.getType().isPrimitive()) {
                    int scaleValue;
                    int precisionValue;
                    if (annotationValues.get("precision") != null && (precisionValue = ((Integer)annotationValues.get("precision")).intValue()) != 0) {
                        length = "" + precisionValue;
                    }
                    if (annotationValues.get("scale") != null && (scaleValue = ((Integer)annotationValues.get("scale")).intValue()) != 0) {
                        scale = "" + scaleValue;
                    }
                    if ((length == null || length.equals("0")) && Character.TYPE.isAssignableFrom(field.getType())) {
                        length = "1";
                    }
                    if (field.getType() == Boolean.TYPE) {
                        jdbcType = "SMALLINT";
                    }
                } else if (String.class.isAssignableFrom(field.getType())) {
                    if (annotationValues.get("length") != null) {
                        length = annotationValues.get("length").toString();
                    }
                } else if (Number.class.isAssignableFrom(field.getType())) {
                    if (annotationValues.get("precision") != null) {
                        length = annotationValues.get("precision").toString();
                    }
                    if (annotationValues.get("scale") != null) {
                        scale = annotationValues.get("scale").toString();
                    }
                }
                if (annotationValues.get("nullable") != null) {
                    allowsNull = annotationValues.get("nullable").toString();
                }
                if (annotationValues.get("insertable") != null) {
                    insertable = annotationValues.get("insertable").toString();
                }
                if (annotationValues.get("updatable") != null) {
                    updateable = annotationValues.get("updatable").toString();
                }
                if (annotationValues.get("unique") != null) {
                    unique = annotationValues.get("unique").toString();
                }
                if (annotationValues.get("table") == null || StringUtils.isWhitespace((String)(columnTable = (String)annotationValues.get("table")))) continue;
                table = columnTable;
                continue;
            }
            if (Enum.class.isAssignableFrom(field.getType()) && annName.equals(JPAAnnotationUtils.ENUMERATED)) {
                EnumType type = (EnumType)annotationValues.get("value");
                jdbcType = type == EnumType.STRING ? "VARCHAR" : "INTEGER";
                continue;
            }
            if (!JPAAnnotationUtils.isTemporalType(field.getType()) || !annName.equals(JPAAnnotationUtils.TEMPORAL_TYPE)) continue;
            TemporalType type = (TemporalType)annotationValues.get("value");
            if (type == TemporalType.DATE) {
                jdbcType = "DATE";
                continue;
            }
            if (type == TemporalType.TIME) {
                jdbcType = "TIME";
                continue;
            }
            if (type != TemporalType.TIMESTAMP) continue;
            jdbcType = "TIMESTAMP";
        }
        if (columnName == null && length == null && scale == null && insertable == null && updateable == null && allowsNull == null && unique == null && jdbcType == null && sqlType == null) {
            return null;
        }
        ColumnMetaData colmd = new ColumnMetaData(parent, columnName, target, targetField, jdbcType, sqlType, length, scale, allowsNull, defaultValue, insertValue, insertable, updateable, unique);
        if (parent instanceof AbstractMemberMetaData) {
            AbstractMemberMetaData apmd = (AbstractMemberMetaData)parent;
            apmd.setTable(table);
            colmd.setAllowsNull(new Boolean(apmd.isPrimaryKey() ? false : colmd.isAllowsNull()));
        }
        return colmd;
    }

    private JoinMetaData[] newJoinMetaDataForClass(AbstractClassMetaData cmd, AnnotationObject[] annotations) {
        HashSet<JoinMetaData> joins = new HashSet<JoinMetaData>();
        for (int i = 0; annotations != null && i < annotations.length; ++i) {
            int j;
            String annName = annotations[i].getName();
            HashMap<String, Object> annotationValues = annotations[i].getNameValueMap();
            if (annName.equals(JPAAnnotationUtils.SECONDARY_TABLES)) {
                SecondaryTable[] secTableAnns = (SecondaryTable[])annotationValues.get("value");
                if (secTableAnns == null) continue;
                for (int j2 = 0; j2 < secTableAnns.length; ++j2) {
                    JoinMetaData joinmd = new JoinMetaData((MetaData)cmd, secTableAnns[j2].name(), secTableAnns[j2].catalog(), secTableAnns[j2].schema(), null, null, null, null, null);
                    PrimaryKeyJoinColumn[] pkJoinCols = secTableAnns[j2].pkJoinColumns();
                    if (pkJoinCols != null) {
                        for (int k = 0; k < pkJoinCols.length; ++k) {
                            ColumnMetaData colmd = new ColumnMetaData((MetaData)joinmd, pkJoinCols[k].name(), pkJoinCols[k].referencedColumnName(), null, null, null, null, null, null, null, null, null, null, null);
                            joinmd.addColumn(colmd);
                        }
                    }
                    joins.add(joinmd);
                    cmd.addJoin(joinmd);
                    UniqueConstraint[] constrs = secTableAnns[j2].uniqueConstraints();
                    if (constrs == null || constrs.length <= 0) continue;
                    for (int k = 0; k < constrs.length; ++k) {
                        UniqueMetaData unimd = new UniqueMetaData(null, (String)annotationValues.get("table"), null);
                        for (int l = 0; l < constrs[k].columnNames().length; ++l) {
                            unimd.addColumn(new ColumnMetaData((MetaData)unimd, constrs[k].columnNames()[l]));
                        }
                        joinmd.setUniqueMetaData(unimd);
                    }
                }
                continue;
            }
            if (!annName.equals(JPAAnnotationUtils.SECONDARY_TABLE)) continue;
            JoinMetaData joinmd = new JoinMetaData((MetaData)cmd, (String)annotationValues.get("name"), (String)annotationValues.get("catalog"), (String)annotationValues.get("schema"), null, null, null, null, null);
            if (annotationValues.get("pkJoinColumns") != null) {
                PrimaryKeyJoinColumn[] joinCols = (PrimaryKeyJoinColumn[])annotationValues.get("pkJoinColumns");
                for (j = 0; j < joinCols.length; ++j) {
                    ColumnMetaData colmd = new ColumnMetaData((MetaData)joinmd, joinCols[j].name(), joinCols[j].referencedColumnName(), null, null, null, null, null, null, null, null, null, null, null);
                    joinmd.addColumn(colmd);
                }
            }
            joins.add(joinmd);
            cmd.addJoin(joinmd);
            UniqueConstraint[] constrs = (UniqueConstraint[])annotationValues.get("uniqueConstraints");
            if (constrs == null || constrs.length <= 0) continue;
            for (j = 0; j < constrs.length; ++j) {
                UniqueMetaData unimd = new UniqueMetaData(null, (String)annotationValues.get("table"), null);
                for (int k = 0; k < constrs[j].columnNames().length; ++k) {
                    unimd.addColumn(new ColumnMetaData((MetaData)unimd, constrs[j].columnNames()[k]));
                }
                joinmd.setUniqueMetaData(unimd);
            }
        }
        return joins.toArray(new JoinMetaData[joins.size()]);
    }

    private void processSequenceGeneratorAnnotation(PackageMetaData pmd, HashMap<String, Object> annotationValues) {
        Integer allocationSize;
        String name = (String)annotationValues.get("name");
        String seqName = (String)annotationValues.get("sequenceName");
        Integer initialValue = (Integer)annotationValues.get("initialValue");
        if (initialValue == null) {
            initialValue = new Integer(1);
        }
        if ((allocationSize = (Integer)annotationValues.get("allocationSize")) == null) {
            allocationSize = new Integer(50);
        }
        SequenceMetaData seqmd = new SequenceMetaData((MetaData)pmd, name, seqName, null, null, "" + initialValue, "" + allocationSize);
        pmd.addSequence(seqmd);
    }

    private void processTableGeneratorAnnotation(PackageMetaData pmd, HashMap<String, Object> annotationValues) {
        String name = (String)annotationValues.get("name");
        String tgTable = (String)annotationValues.get("table");
        String tgCatalog = (String)annotationValues.get("catalog");
        String tgSchema = (String)annotationValues.get("schema");
        String tgPKColumnName = (String)annotationValues.get("pkColumnName");
        String tgValueColumnName = (String)annotationValues.get("valueColumnName");
        String tgPKColumnValue = (String)annotationValues.get("pkColumnValue");
        Integer initialValue = (Integer)annotationValues.get("initialValue");
        Integer allocationSize = (Integer)annotationValues.get("allocationSize");
        TableGeneratorMetaData tgmd = new TableGeneratorMetaData((MetaData)pmd, name, tgTable, tgCatalog, tgSchema, tgPKColumnName, tgValueColumnName, tgPKColumnValue, "" + initialValue, "" + allocationSize);
        pmd.addTableGenerator(tgmd);
    }

    protected boolean isClassPersistenceCapable(Class cls) {
        AnnotationObject[] annotations = this.getClassAnnotationsForClass(cls);
        for (int i = 0; i < annotations.length; ++i) {
            String annClassName = annotations[i].getName();
            if (annClassName.equals(JPAAnnotationUtils.ENTITY)) {
                return true;
            }
            if (annClassName.equals(JPAAnnotationUtils.EMBEDDABLE)) {
                return true;
            }
            if (!annClassName.equals(JPAAnnotationUtils.MAPPED_SUPERCLASS)) continue;
            Field[] fields = cls.getDeclaredFields();
            for (int j = 0; j < fields.length; ++j) {
                if (fields[j].getAnnotation(Id.class) != null) {
                    return true;
                }
                if (fields[j].getAnnotation(EmbeddedId.class) == null) continue;
                return true;
            }
            Method[] methods = cls.getDeclaredMethods();
            for (int j = 0; j < methods.length; ++j) {
                if (methods[j].getAnnotation(Id.class) != null) {
                    return true;
                }
                if (methods[j].getAnnotation(EmbeddedId.class) == null) continue;
                return true;
            }
        }
        return false;
    }
}

