/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.jpa.metadata;

import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.ClassPersistenceModifier;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.metadata.ElementMetaData;
import org.datanucleus.metadata.EventListenerMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.metadata.FileMetaData;
import org.datanucleus.metadata.IdentityStrategy;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.InheritanceMetaData;
import org.datanucleus.metadata.InheritanceStrategy;
import org.datanucleus.metadata.JoinMetaData;
import org.datanucleus.metadata.KeyMetaData;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.OrderMetaData;
import org.datanucleus.metadata.PackageMetaData;
import org.datanucleus.metadata.QueryMetaData;
import org.datanucleus.metadata.QueryResultMetaData;
import org.datanucleus.metadata.SequenceMetaData;
import org.datanucleus.metadata.TableGeneratorMetaData;
import org.datanucleus.metadata.UniqueMetaData;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.metadata.VersionStrategy;
import org.datanucleus.metadata.xml.AbstractMetaDataHandler;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public class JPAMetaDataHandler
extends AbstractMetaDataHandler {
    String defaultPackageName = null;
    boolean metaDataComplete = false;
    boolean defaultCascadePersist = false;
    boolean propertyAccess = false;
    String queryResultEntityName = null;

    public JPAMetaDataHandler(MetaDataManager mgr, String filename, EntityResolver resolver) {
        super(mgr, filename, resolver);
        this.metadata = new FileMetaData(filename, mgr, null, null);
        this.pushStack(this.metadata);
    }

    protected ClassMetaData newClassObject(PackageMetaData pmd, Attributes attrs, boolean embeddedOnly) {
        String className = this.getAttr(attrs, "class");
        if (className.indexOf(46) > 0) {
            className = className.substring(className.lastIndexOf(46) + 1);
        }
        ClassMetaData cmd = this.mgr.getMetaDataFactory().newClassObject(pmd, className, embeddedOnly ? IdentityType.NONDURABLE.toString() : IdentityType.APPLICATION.toString(), null, "true", "true", "" + embeddedOnly, ClassPersistenceModifier.PERSISTENCE_CAPABLE.toString(), null, null, null, null, this.getAttr(attrs, "name"));
        String classMetaDataComplete = this.getAttr(attrs, "metadata-complete");
        if (this.metaDataComplete || classMetaDataComplete != null && classMetaDataComplete.equalsIgnoreCase("true")) {
            cmd.setMetaDataComplete();
        }
        return cmd;
    }

    protected AbstractMemberMetaData newFieldObject(AbstractClassMetaData acmd, Attributes attrs) {
        String fetch = this.getAttr(attrs, "fetch");
        String dfg = "true";
        if (fetch != null && fetch.equalsIgnoreCase("LAZY")) {
            dfg = "false";
        }
        Object mmd = null;
        mmd = acmd.getMetaDataForMember(this.getAttr(attrs, "name"));
        if (mmd != null) {
            String depString;
            if (dfg != null) {
                mmd.setDefaultFetchGroup(dfg.equals("true"));
            }
            if (!StringUtils.isWhitespace((String)(depString = this.getAttr(attrs, "dependent")))) {
                mmd.setDependent(depString.trim().equalsIgnoreCase("true"));
            }
            mmd.setMappedBy(this.getAttr(attrs, "mapped-by"));
            String loadFg = this.getAttr(attrs, "load-fetch-group");
            if (!StringUtils.isWhitespace((String)loadFg)) {
                mmd.setLoadFetchGroup(loadFg);
            }
        } else {
            mmd = this.propertyAccess ? this.mgr.getMetaDataFactory().newPropertyObject((MetaData)acmd, this.getAttr(attrs, "name"), null, FieldPersistenceModifier.PERSISTENT.toString(), dfg, null, null, null, this.getAttr(attrs, "dependent"), this.getAttr(attrs, "mapped-by"), null, null, null, null, null, null, null, null, this.getAttr(attrs, "load-fetch-group"), null, null, null, null) : this.mgr.getMetaDataFactory().newFieldObject((MetaData)acmd, this.getAttr(attrs, "name"), null, FieldPersistenceModifier.PERSISTENT.toString(), dfg, null, null, null, this.getAttr(attrs, "dependent"), this.getAttr(attrs, "mapped-by"), null, null, null, null, null, null, null, null, this.getAttr(attrs, "load-fetch-group"), null, null, null);
            acmd.addMember(mmd);
        }
        if (this.defaultCascadePersist) {
            mmd.setCascadePersist(true);
        }
        return mmd;
    }

    protected AbstractMemberMetaData newPKFieldObject(AbstractClassMetaData acmd, Attributes attrs) {
        Object mmd = null;
        mmd = acmd.getMetaDataForMember(this.getAttr(attrs, "name"));
        if (mmd != null) {
            mmd.setPrimaryKey();
        } else {
            mmd = this.propertyAccess ? this.mgr.getMetaDataFactory().newPropertyObject((MetaData)acmd, this.getAttr(attrs, "name"), "true", FieldPersistenceModifier.PERSISTENT.toString(), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null) : this.mgr.getMetaDataFactory().newFieldObject((MetaData)acmd, this.getAttr(attrs, "name"), "true", FieldPersistenceModifier.PERSISTENT.toString(), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
            if (this.defaultCascadePersist) {
                mmd.setCascadePersist(true);
            }
            acmd.addMember(mmd);
        }
        return mmd;
    }

    protected AbstractMemberMetaData newTransientFieldObject(MetaData md, String name) {
        Object mmd = null;
        mmd = this.propertyAccess ? this.mgr.getMetaDataFactory().newPropertyObject(md, name, null, FieldPersistenceModifier.NONE.toString(), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null) : this.mgr.getMetaDataFactory().newFieldObject(md, name, null, FieldPersistenceModifier.NONE.toString(), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        if (this.defaultCascadePersist) {
            mmd.setCascadePersist(true);
        }
        return mmd;
    }

    protected AbstractMemberMetaData newOverriddenFieldObject(MetaData md, Attributes attrs) {
        Object mmd = null;
        mmd = this.propertyAccess ? this.mgr.getMetaDataFactory().newPropertyObject(md, "#UNKNOWN." + this.getAttr(attrs, "name"), null, FieldPersistenceModifier.PERSISTENT.toString(), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null) : this.mgr.getMetaDataFactory().newFieldObject(md, "#UNKNOWN." + this.getAttr(attrs, "name"), null, FieldPersistenceModifier.PERSISTENT.toString(), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        if (this.defaultCascadePersist) {
            mmd.setCascadePersist(true);
        }
        return mmd;
    }

    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        block148: {
            if (NucleusLogger.METADATA.isDebugEnabled()) {
                StringBuffer sb = new StringBuffer();
                sb.append("<" + qName);
                for (int i = 0; i < attrs.getLength(); ++i) {
                    sb.append(" ");
                    sb.append(attrs.getQName(i)).append("=\"").append(attrs.getValue(i)).append("\"");
                }
                sb.append(">");
                NucleusLogger.METADATA.debug((Object)LOCALISER.msg("044034", (Object)sb.toString(), (Object)("" + this.stack.size())));
            }
            if (localName.length() < 1) {
                localName = qName;
            }
            try {
                AbstractMemberMetaData mmd;
                AbstractMemberMetaData fmd;
                ClassMetaData cmd;
                QueryResultMetaData qrmd;
                MetaData md;
                FileMetaData filemd;
                if (localName.equals("entity-mappings")) {
                    filemd = (FileMetaData)this.getStack();
                    filemd.setType(5);
                    break block148;
                }
                if (localName.equals("description") || localName.equals("persistence-unit-metadata")) break block148;
                if (localName.equals("xml-mapping-metadata-complete")) {
                    this.metaDataComplete = true;
                    break block148;
                }
                if (localName.equals("persistence-unit-defaults") || localName.equals("package") || localName.equals("schema") || localName.equals("catalog") || localName.equals("access")) break block148;
                if (localName.equals("sequence-generator")) {
                    String allocSize;
                    md = this.getStack();
                    String initValue = this.getAttr(attrs, "initial-value");
                    if (StringUtils.isWhitespace((String)initValue)) {
                        initValue = "1";
                    }
                    if (StringUtils.isWhitespace((String)(allocSize = this.getAttr(attrs, "allocation-size")))) {
                        allocSize = "50";
                    }
                    SequenceMetaData seqmd = new SequenceMetaData(md, this.getAttr(attrs, "name"), this.getAttr(attrs, "sequence-name"), null, null, initValue, allocSize);
                    PackageMetaData pmd = null;
                    if (this.defaultPackageName != null) {
                        pmd = ((FileMetaData)this.metadata).getPackage(this.defaultPackageName);
                    } else if (((FileMetaData)this.metadata).getNoOfPackages() > 0) {
                        pmd = ((FileMetaData)this.metadata).getPackage(0);
                    } else {
                        pmd = new PackageMetaData((FileMetaData)this.metadata, "", null, null);
                        ((FileMetaData)this.metadata).addPackage(pmd);
                    }
                    pmd.addSequence(seqmd);
                    break block148;
                }
                if (localName.equals("table-generator")) {
                    md = this.getStack();
                    TableGeneratorMetaData tgmd = new TableGeneratorMetaData(md, this.getAttr(attrs, "name"), this.getAttr(attrs, "table"), this.getAttr(attrs, "catalog"), this.getAttr(attrs, "schema"), this.getAttr(attrs, "pk-column-name"), this.getAttr(attrs, "value-column-name"), this.getAttr(attrs, "pk-column-value"), this.getAttr(attrs, "initial-value"), this.getAttr(attrs, "allocation-size"));
                    PackageMetaData pmd = null;
                    if (this.defaultPackageName != null) {
                        pmd = ((FileMetaData)this.metadata).getPackage(this.defaultPackageName);
                    } else if (((FileMetaData)this.metadata).getNoOfPackages() > 0) {
                        pmd = ((FileMetaData)this.metadata).getPackage(0);
                    } else {
                        pmd = new PackageMetaData((FileMetaData)this.metadata, "", null, null);
                        ((FileMetaData)this.metadata).addPackage(pmd);
                    }
                    pmd.addTableGenerator(tgmd);
                    break block148;
                }
                if (localName.equals("named-query")) {
                    md = this.getStack();
                    if (md instanceof FileMetaData) {
                        FileMetaData filemd2 = (FileMetaData)md;
                        QueryMetaData qmd = new QueryMetaData((MetaData)filemd2, null, this.getAttr(attrs, "name"), "JPQL", null, null, null, null, null);
                        filemd2.addQuery(qmd);
                        this.pushStack((MetaData)qmd);
                    } else if (md instanceof ClassMetaData) {
                        ClassMetaData cmd2 = (ClassMetaData)md;
                        QueryMetaData qmd = new QueryMetaData((MetaData)cmd2, null, this.getAttr(attrs, "name"), "JPQL", null, null, null, null, null);
                        cmd2.addQuery(qmd);
                        this.pushStack((MetaData)qmd);
                    }
                    break block148;
                }
                if (localName.equals("named-native-query")) {
                    md = this.getStack();
                    if (md instanceof FileMetaData) {
                        FileMetaData filemd3 = (FileMetaData)md;
                        QueryMetaData qmd = new QueryMetaData((MetaData)filemd3, null, this.getAttr(attrs, "name"), "SQL", null, this.getAttr(attrs, "result-class"), this.getAttr(attrs, "result-set-mapping"), null, null);
                        filemd3.addQuery(qmd);
                        this.pushStack((MetaData)qmd);
                    } else if (md instanceof ClassMetaData) {
                        ClassMetaData cmd3 = (ClassMetaData)md;
                        QueryMetaData qmd = new QueryMetaData((MetaData)cmd3, null, this.getAttr(attrs, "name"), "SQL", null, this.getAttr(attrs, "result-class"), this.getAttr(attrs, "result-set-mapping"), null, null);
                        cmd3.addQuery(qmd);
                        this.pushStack((MetaData)qmd);
                    }
                    break block148;
                }
                if (localName.equals("sql-result-set-mapping")) {
                    md = this.getStack();
                    if (md instanceof FileMetaData) {
                        FileMetaData filemd4 = (FileMetaData)md;
                        QueryResultMetaData qrmd2 = new QueryResultMetaData((MetaData)filemd4, this.getAttr(attrs, "name"));
                        filemd4.addQueryResultMetaData(qrmd2);
                        this.pushStack((MetaData)qrmd2);
                    } else if (md instanceof ClassMetaData) {
                        ClassMetaData cmd4 = (ClassMetaData)md;
                        QueryResultMetaData qrmd3 = new QueryResultMetaData((MetaData)cmd4, this.getAttr(attrs, "name"));
                        cmd4.addQueryResultMetaData(qrmd3);
                        this.pushStack((MetaData)qrmd3);
                    }
                    break block148;
                }
                if (localName.equals("entity-result")) {
                    qrmd = (QueryResultMetaData)this.getStack();
                    this.queryResultEntityName = this.getAttr(attrs, "entity-class");
                    qrmd.addPersistentTypeMapping(this.queryResultEntityName, null, this.getAttr(attrs, "discriminator-column"));
                    break block148;
                }
                if (localName.equals("field-result")) {
                    qrmd = (QueryResultMetaData)this.getStack();
                    qrmd.addMappingForPersistentTypeMapping(this.queryResultEntityName, this.getAttr(attrs, "name"), this.getAttr(attrs, "column"));
                    break block148;
                }
                if (localName.equals("column-result")) {
                    qrmd = (QueryResultMetaData)this.getStack();
                    qrmd.addScalarColumn(this.getAttr(attrs, "name"));
                    break block148;
                }
                if (localName.equals("mapped-superclass")) {
                    filemd = (FileMetaData)this.getStack();
                    String className = this.getAttr(attrs, "class");
                    String packageName = null;
                    if (className.indexOf(46) > 0) {
                        packageName = className.substring(0, className.lastIndexOf(46));
                    }
                    PackageMetaData pmd = null;
                    if (packageName != null) {
                        pmd = filemd.getPackage(packageName);
                    }
                    if (pmd == null) {
                        pmd = packageName != null ? new PackageMetaData(filemd, packageName, null, null) : (this.defaultPackageName != null ? filemd.getPackage(this.defaultPackageName) : new PackageMetaData(filemd, "", null, null));
                    }
                    ClassMetaData cmd5 = this.newClassObject(pmd, attrs, false);
                    pmd.addClass(cmd5);
                    cmd5.setInheritanceMetaData(new InheritanceMetaData((AbstractClassMetaData)cmd5, InheritanceStrategy.SUBCLASS_TABLE.toString()));
                    this.pushStack((MetaData)cmd5);
                    break block148;
                }
                if (localName.equals("query")) break block148;
                if (localName.equals("entity")) {
                    filemd = (FileMetaData)this.getStack();
                    String className = this.getAttr(attrs, "class");
                    String packageName = null;
                    if (className.indexOf(46) > 0) {
                        packageName = className.substring(0, className.lastIndexOf(46));
                    }
                    PackageMetaData pmd = null;
                    if (packageName != null) {
                        pmd = filemd.getPackage(packageName);
                    }
                    if (pmd == null) {
                        if (packageName != null) {
                            pmd = new PackageMetaData(filemd, packageName, null, null);
                            filemd.addPackage(pmd);
                        } else if (this.defaultPackageName != null) {
                            pmd = filemd.getPackage(this.defaultPackageName);
                        } else {
                            pmd = new PackageMetaData(filemd, "", null, null);
                            filemd.addPackage(pmd);
                        }
                    }
                    ClassMetaData cmd6 = this.newClassObject(pmd, attrs, false);
                    pmd.addClass(cmd6);
                    this.pushStack((MetaData)cmd6);
                    break block148;
                }
                if (localName.equals("embeddable")) {
                    filemd = (FileMetaData)this.getStack();
                    String className = this.getAttr(attrs, "class");
                    String packageName = null;
                    if (className.indexOf(46) > 0) {
                        packageName = className.substring(0, className.lastIndexOf(46));
                    }
                    PackageMetaData pmd = null;
                    if (packageName != null) {
                        pmd = filemd.getPackage(packageName);
                    }
                    if (pmd == null) {
                        pmd = packageName != null ? new PackageMetaData(filemd, packageName, null, null) : (this.defaultPackageName != null ? filemd.getPackage(this.defaultPackageName) : new PackageMetaData(filemd, "", null, null));
                    }
                    ClassMetaData cmd7 = this.newClassObject(pmd, attrs, true);
                    pmd.addClass(cmd7);
                    this.pushStack((MetaData)cmd7);
                    break block148;
                }
                if (localName.equals("attributes") || localName.equals("embeddable-attributes")) break block148;
                if (localName.equals("id-class")) {
                    cmd = (ClassMetaData)this.getStack();
                    cmd.setObjectIdClass(this.getAttr(attrs, "class"));
                    break block148;
                }
                if (localName.equals("inheritance")) {
                    cmd = (ClassMetaData)this.getStack();
                    String strategy = this.getAttr(attrs, "strategy");
                    String strategyType = null;
                    if (strategy.equalsIgnoreCase("JOINED")) {
                        strategyType = InheritanceStrategy.NEW_TABLE.toString();
                    } else if (strategy.equalsIgnoreCase("TABLE_PER_CLASS")) {
                        strategyType = InheritanceStrategy.COMPLETE_TABLE.toString();
                    }
                    InheritanceMetaData inhmd = new InheritanceMetaData((AbstractClassMetaData)cmd, this.getAttr(attrs, strategyType));
                    inhmd.setStrategyForTree(strategy.toUpperCase());
                    cmd.setInheritanceMetaData(inhmd);
                    break block148;
                }
                if (localName.equals("table")) {
                    cmd = (ClassMetaData)this.getStack();
                    cmd.setCatalog(this.getAttr(attrs, "catalog"));
                    cmd.setSchema(this.getAttr(attrs, "schema"));
                    cmd.setTable(this.getAttr(attrs, "name"));
                    break block148;
                }
                if (localName.equals("secondary-table")) {
                    cmd = (ClassMetaData)this.getStack();
                    JoinMetaData joinmd = new JoinMetaData((MetaData)cmd, this.getAttr(attrs, "name"), this.getAttr(attrs, "catalog"), this.getAttr(attrs, "schema"), null, null, null, null, null);
                    cmd.addJoin(joinmd);
                    this.pushStack((MetaData)joinmd);
                    break block148;
                }
                if (localName.equals("primary-key-join-column")) {
                    md = this.getStack();
                    if (md instanceof ClassMetaData) {
                        ClassMetaData cmd8 = (ClassMetaData)md;
                        ColumnMetaData colmd = new ColumnMetaData((MetaData)cmd8.getInheritanceMetaData().getJoinMetaData(), this.getAttr(attrs, "name"), this.getAttr(attrs, "referenced-column-name"), null, null, null, null, null, null, null, null, null, null, null);
                        cmd8.getInheritanceMetaData().getJoinMetaData().addColumn(colmd);
                    } else if (md instanceof JoinMetaData) {
                        JoinMetaData joinmd = (JoinMetaData)md;
                        ColumnMetaData colmd = new ColumnMetaData((MetaData)joinmd, this.getAttr(attrs, "name"), this.getAttr(attrs, "referenced-column-name"), null, null, null, null, null, null, null, null, null, null, null);
                        joinmd.addColumn(colmd);
                    }
                    break block148;
                }
                if (localName.equals("id")) {
                    cmd = (ClassMetaData)this.getStack();
                    AbstractMemberMetaData mmd2 = this.newPKFieldObject((AbstractClassMetaData)cmd, attrs);
                    this.pushStack((MetaData)mmd2);
                    break block148;
                }
                if (localName.equals("embedded-id")) {
                    cmd = (ClassMetaData)this.getStack();
                    AbstractMemberMetaData mmd3 = this.newPKFieldObject((AbstractClassMetaData)cmd, attrs);
                    this.pushStack((MetaData)mmd3);
                    break block148;
                }
                if (localName.equals("basic")) {
                    cmd = (AbstractClassMetaData)this.getStack();
                    AbstractMemberMetaData mmd4 = this.newFieldObject((AbstractClassMetaData)cmd, attrs);
                    this.pushStack((MetaData)mmd4);
                    break block148;
                }
                if (localName.equals("lob")) {
                    fmd = (AbstractMemberMetaData)this.getStack();
                    fmd.setStoreInLob();
                    break block148;
                }
                if (localName.equals("enumerated") || localName.equals("temporal")) break block148;
                if (localName.equals("transient")) {
                    cmd = (ClassMetaData)this.getStack();
                    AbstractMemberMetaData mmd5 = this.newTransientFieldObject((MetaData)cmd, this.getAttr(attrs, "name"));
                    cmd.addMember(mmd5);
                    this.pushStack((MetaData)mmd5);
                    break block148;
                }
                if (localName.equals("one-to-many")) {
                    cmd = (ClassMetaData)this.getStack();
                    AbstractMemberMetaData mmd6 = this.newFieldObject((AbstractClassMetaData)cmd, attrs);
                    mmd6.setTargetClassName(this.getAttr(attrs, "target-entity"));
                    mmd6.setOrdered();
                    String jpaLevel = this.mgr.getOMFContext().getPersistenceConfiguration().getStringProperty("datanucleus.jpa.level");
                    if (mmd6.getMappedBy() == null && mmd6.getJoinMetaData() == null && jpaLevel.equalsIgnoreCase("JPA1")) {
                        mmd6.setJoinMetaData(new JoinMetaData((MetaData)mmd6, null, null, null, null, null, null, null, null));
                    }
                    this.pushStack((MetaData)mmd6);
                    break block148;
                }
                if (localName.equals("one-to-one")) {
                    cmd = (ClassMetaData)this.getStack();
                    AbstractMemberMetaData mmd7 = this.newFieldObject((AbstractClassMetaData)cmd, attrs);
                    mmd7.setTargetClassName(this.getAttr(attrs, "target-entity"));
                    this.pushStack((MetaData)mmd7);
                    break block148;
                }
                if (localName.equals("many-to-one")) {
                    cmd = (ClassMetaData)this.getStack();
                    AbstractMemberMetaData mmd8 = this.newFieldObject((AbstractClassMetaData)cmd, attrs);
                    mmd8.setTargetClassName(this.getAttr(attrs, "target-entity"));
                    this.pushStack((MetaData)mmd8);
                    break block148;
                }
                if (localName.equals("many-to-many")) {
                    cmd = (ClassMetaData)this.getStack();
                    AbstractMemberMetaData mmd9 = this.newFieldObject((AbstractClassMetaData)cmd, attrs);
                    mmd9.setTargetClassName(this.getAttr(attrs, "target-entity"));
                    mmd9.setOrdered();
                    if (mmd9.getMappedBy() == null && mmd9.getJoinMetaData() == null) {
                        mmd9.setJoinMetaData(new JoinMetaData((MetaData)mmd9, null, null, null, null, null, null, null, null));
                    }
                    this.pushStack((MetaData)mmd9);
                    break block148;
                }
                if (localName.equals("map-key")) {
                    fmd = (AbstractMemberMetaData)this.getStack();
                    String mappedByFieldName = this.getAttr(attrs, "name");
                    if (StringUtils.isWhitespace((String)mappedByFieldName)) {
                        mappedByFieldName = "#PK";
                    }
                    KeyMetaData keymd = new KeyMetaData((MetaData)fmd, null, null, null, null, null, mappedByFieldName);
                    fmd.setKeyMetaData(keymd);
                    break block148;
                }
                if (localName.equals("order-by") || localName.equals("cascade") || localName.equals("cascade-type")) break block148;
                if (localName.equals("cascade-all")) {
                    mmd = (AbstractMemberMetaData)this.getStack();
                    mmd.setCascadePersist(true);
                    mmd.setCascadeUpdate(true);
                    mmd.setCascadeDelete(true);
                    mmd.setCascadeRefresh(true);
                    break block148;
                }
                if (localName.equals("cascade-persist")) {
                    md = this.getStack();
                    if (md instanceof AbstractMemberMetaData) {
                        AbstractMemberMetaData mmd10 = (AbstractMemberMetaData)md;
                        mmd10.setCascadePersist(true);
                    } else if (md instanceof FileMetaData) {
                        this.defaultCascadePersist = true;
                    }
                    break block148;
                }
                if (localName.equals("cascade-merge")) {
                    mmd = (AbstractMemberMetaData)this.getStack();
                    mmd.setCascadeUpdate(true);
                    break block148;
                }
                if (localName.equals("cascade-remove")) {
                    mmd = (AbstractMemberMetaData)this.getStack();
                    mmd.setCascadeDelete(true);
                    break block148;
                }
                if (localName.equals("cascade-refresh")) {
                    mmd = (AbstractMemberMetaData)this.getStack();
                    mmd.setCascadeRefresh(true);
                    break block148;
                }
                if (localName.equals("version")) {
                    if (this.getStack() instanceof ClassMetaData) {
                        cmd = (ClassMetaData)this.getStack();
                        AbstractMemberMetaData mmd11 = this.newFieldObject((AbstractClassMetaData)cmd, attrs);
                        VersionMetaData vermd = new VersionMetaData(VersionStrategy.VERSION_NUMBER.toString(), mmd11.getName());
                        cmd.setVersionMetaData(vermd);
                        this.pushStack((MetaData)mmd11);
                    }
                    break block148;
                }
                if (localName.equals("discriminator-value")) break block148;
                if (localName.equals("discriminator-column")) {
                    DiscriminatorMetaData discmd;
                    cmd = (ClassMetaData)this.getStack();
                    InheritanceMetaData inhmd = cmd.getInheritanceMetaData();
                    if (inhmd == null) {
                        inhmd = new InheritanceMetaData((AbstractClassMetaData)cmd, null);
                        cmd.setInheritanceMetaData(inhmd);
                    }
                    if ((discmd = inhmd.getDiscriminatorMetaData()) == null) {
                        discmd = new DiscriminatorMetaData(inhmd, null, null, DiscriminatorStrategy.CLASS_NAME.toString(), "true");
                        inhmd.setDiscriminatorMetaData(discmd);
                    }
                    String jdbcType = null;
                    String discType = this.getAttr(attrs, "discriminator-type");
                    if (discType != null) {
                        if (discType.equalsIgnoreCase("STRING")) {
                            jdbcType = "VARCHAR";
                        } else if (discType.equalsIgnoreCase("CHAR")) {
                            jdbcType = "CHAR";
                        } else if (discType.equalsIgnoreCase("INTEGER")) {
                            jdbcType = "INTEGER";
                        }
                    }
                    ColumnMetaData colmd = new ColumnMetaData((MetaData)discmd, this.getAttr(attrs, "name"), null, null, jdbcType, null, this.getAttr(attrs, "length"), null, null, null, null, null, null, null);
                    discmd.setColumnMetaData(colmd);
                    break block148;
                }
                if (localName.equals("generated-value")) {
                    fmd = (AbstractMemberMetaData)this.getStack();
                    IdentityStrategy idStrategy = IdentityStrategy.getIdentityStrategy((String)this.getAttr(attrs, "strategy"));
                    fmd.setValueStrategy(idStrategy);
                    fmd.setValueGeneratorName(this.getAttr(attrs, "generator"));
                    break block148;
                }
                if (localName.equals("join-table")) {
                    fmd = (AbstractMemberMetaData)this.getStack();
                    JoinMetaData joinmd = new JoinMetaData((MetaData)fmd, null, null, null, null, null, null, null, null);
                    String tableName = this.getAttr(attrs, "name");
                    String schemaName = this.getAttr(attrs, "schema");
                    String catalogName = this.getAttr(attrs, "catalog");
                    fmd.setJoinMetaData(joinmd);
                    if (!StringUtils.isWhitespace((String)tableName)) {
                        fmd.setTable(tableName);
                    }
                    if (!StringUtils.isWhitespace((String)schemaName)) {
                        fmd.setSchema(schemaName);
                    }
                    if (!StringUtils.isWhitespace((String)catalogName)) {
                        fmd.setSchema(catalogName);
                    }
                    this.pushStack((MetaData)joinmd);
                    break block148;
                }
                if (localName.equals("column")) {
                    fmd = (AbstractMemberMetaData)this.getStack();
                    ColumnMetaData colmd = new ColumnMetaData((MetaData)fmd, this.getAttr(attrs, "name"), null, null, null, null, this.getAttr(attrs, "length"), this.getAttr(attrs, "scale"), this.getAttr(attrs, "nullable"), null, null, this.getAttr(attrs, "insertable"), this.getAttr(attrs, "updatable"), this.getAttr(attrs, "unique"));
                    fmd.addColumn(colmd);
                    String table = this.getAttr(attrs, "table");
                    if (!StringUtils.isWhitespace((String)table)) {
                        fmd.setTable(table);
                    }
                    break block148;
                }
                if (localName.equals("join-column")) {
                    md = this.getStack();
                    if (md instanceof JoinMetaData) {
                        JoinMetaData joinmd = (JoinMetaData)md;
                        ColumnMetaData colmd = new ColumnMetaData((MetaData)joinmd, this.getAttr(attrs, "name"), this.getAttr(attrs, "referenced-column-name"), null, null, null, null, null, this.getAttr(attrs, "nullable"), null, null, this.getAttr(attrs, "insertable"), this.getAttr(attrs, "updatable"), this.getAttr(attrs, "unique"));
                        joinmd.addColumn(colmd);
                    } else if (md instanceof AbstractMemberMetaData) {
                        AbstractMemberMetaData fmd2 = (AbstractMemberMetaData)md;
                        ColumnMetaData colmd = new ColumnMetaData((MetaData)fmd2, this.getAttr(attrs, "name"), this.getAttr(attrs, "referenced-column-name"), null, null, null, null, null, this.getAttr(attrs, "nullable"), null, null, this.getAttr(attrs, "insertable"), this.getAttr(attrs, "updatable"), this.getAttr(attrs, "unique"));
                        fmd2.addColumn(colmd);
                    }
                    break block148;
                }
                if (localName.equals("inverse-join-column")) {
                    md = this.getStack();
                    if (md instanceof JoinMetaData) {
                        JoinMetaData joinmd = (JoinMetaData)md;
                        ElementMetaData elemmd = null;
                        AbstractMemberMetaData fmd3 = (AbstractMemberMetaData)joinmd.getParent();
                        if (fmd3.getElementMetaData() != null) {
                            elemmd = fmd3.getElementMetaData();
                        } else {
                            elemmd = new ElementMetaData((MetaData)fmd3, null, null, null, null, null, null);
                            fmd3.setElementMetaData(elemmd);
                        }
                        ColumnMetaData colmd = new ColumnMetaData((MetaData)elemmd, this.getAttr(attrs, "name"), this.getAttr(attrs, "referenced-column-name"), null, null, null, null, null, this.getAttr(attrs, "nullable"), null, null, this.getAttr(attrs, "insertable"), this.getAttr(attrs, "updatable"), this.getAttr(attrs, "unique"));
                        elemmd.addColumn(colmd);
                    }
                    break block148;
                }
                if (localName.equals("unique-constraint")) {
                    md = this.getStack();
                    if (md instanceof AbstractClassMetaData) {
                        AbstractClassMetaData cmd9 = (AbstractClassMetaData)md;
                        UniqueMetaData unimd = new UniqueMetaData(null, cmd9.getTable(), null);
                        cmd9.addUniqueConstraint(unimd);
                        this.pushStack((MetaData)unimd);
                    } else if (md instanceof JoinMetaData) {
                        JoinMetaData joinmd = (JoinMetaData)md;
                        UniqueMetaData unimd = new UniqueMetaData(null, null, null);
                        joinmd.setUniqueMetaData(unimd);
                        this.pushStack((MetaData)unimd);
                    }
                    break block148;
                }
                if (localName.equals("entity-listeners")) break block148;
                if (localName.equals("entity-listener")) {
                    md = this.getStack();
                    EventListenerMetaData elmd = new EventListenerMetaData(this.getAttr(attrs, "class"));
                    if (md instanceof AbstractClassMetaData) {
                        ((AbstractClassMetaData)md).addListener(elmd);
                    } else if (md instanceof FileMetaData) {
                        ((FileMetaData)md).addListener(elmd);
                    }
                    this.pushStack((MetaData)elmd);
                    break block148;
                }
                if (localName.equals("pre-persist")) {
                    md = this.getStack();
                    if (md instanceof AbstractClassMetaData) {
                        AbstractClassMetaData cmd10 = (AbstractClassMetaData)md;
                        EventListenerMetaData elmd = cmd10.getListenerForClass(cmd10.getFullClassName());
                        if (elmd == null) {
                            elmd = new EventListenerMetaData(cmd10.getFullClassName());
                            cmd10.addListener(elmd);
                        }
                        elmd.addCallback("javax.persistence.PrePersist", this.getAttr(attrs, "method-name"));
                    } else {
                        EventListenerMetaData elmd = (EventListenerMetaData)md;
                        elmd.addCallback("javax.persistence.PrePersist", this.getAttr(attrs, "method-name"));
                    }
                    break block148;
                }
                if (localName.equals("post-persist")) {
                    md = this.getStack();
                    if (md instanceof AbstractClassMetaData) {
                        AbstractClassMetaData cmd11 = (AbstractClassMetaData)md;
                        EventListenerMetaData elmd = cmd11.getListenerForClass(cmd11.getFullClassName());
                        if (elmd == null) {
                            elmd = new EventListenerMetaData(cmd11.getFullClassName());
                            cmd11.addListener(elmd);
                        }
                        elmd.addCallback("javax.persistence.PostPersist", this.getAttr(attrs, "method-name"));
                    } else {
                        EventListenerMetaData elmd = (EventListenerMetaData)md;
                        elmd.addCallback("javax.persistence.PostPersist", this.getAttr(attrs, "method-name"));
                    }
                    break block148;
                }
                if (localName.equals("pre-remove")) {
                    md = this.getStack();
                    if (md instanceof AbstractClassMetaData) {
                        AbstractClassMetaData cmd12 = (AbstractClassMetaData)md;
                        EventListenerMetaData elmd = cmd12.getListenerForClass(cmd12.getFullClassName());
                        if (elmd == null) {
                            elmd = new EventListenerMetaData(cmd12.getFullClassName());
                            cmd12.addListener(elmd);
                        }
                        elmd.addCallback("javax.persistence.PreRemove", this.getAttr(attrs, "method-name"));
                    } else {
                        EventListenerMetaData elmd = (EventListenerMetaData)md;
                        elmd.addCallback("javax.persistence.PreRemove", this.getAttr(attrs, "method-name"));
                    }
                    break block148;
                }
                if (localName.equals("post-remove")) {
                    md = this.getStack();
                    if (md instanceof AbstractClassMetaData) {
                        AbstractClassMetaData cmd13 = (AbstractClassMetaData)md;
                        EventListenerMetaData elmd = cmd13.getListenerForClass(cmd13.getFullClassName());
                        if (elmd == null) {
                            elmd = new EventListenerMetaData(cmd13.getFullClassName());
                            cmd13.addListener(elmd);
                        }
                        elmd.addCallback("javax.persistence.PostRemove", this.getAttr(attrs, "method-name"));
                    } else {
                        EventListenerMetaData elmd = (EventListenerMetaData)md;
                        elmd.addCallback("javax.persistence.PostRemove", this.getAttr(attrs, "method-name"));
                    }
                    break block148;
                }
                if (localName.equals("pre-update")) {
                    md = this.getStack();
                    if (md instanceof AbstractClassMetaData) {
                        AbstractClassMetaData cmd14 = (AbstractClassMetaData)md;
                        EventListenerMetaData elmd = cmd14.getListenerForClass(cmd14.getFullClassName());
                        if (elmd == null) {
                            elmd = new EventListenerMetaData(cmd14.getFullClassName());
                            cmd14.addListener(elmd);
                        }
                        elmd.addCallback("javax.persistence.PreUpdate", this.getAttr(attrs, "method-name"));
                    } else {
                        EventListenerMetaData elmd = (EventListenerMetaData)md;
                        elmd.addCallback("javax.persistence.PreUpdate", this.getAttr(attrs, "method-name"));
                    }
                    break block148;
                }
                if (localName.equals("post-update")) {
                    md = this.getStack();
                    if (md instanceof AbstractClassMetaData) {
                        AbstractClassMetaData cmd15 = (AbstractClassMetaData)md;
                        EventListenerMetaData elmd = cmd15.getListenerForClass(cmd15.getFullClassName());
                        if (elmd == null) {
                            elmd = new EventListenerMetaData(cmd15.getFullClassName());
                            cmd15.addListener(elmd);
                        }
                        elmd.addCallback("javax.persistence.PostUpdate", this.getAttr(attrs, "method-name"));
                    } else {
                        EventListenerMetaData elmd = (EventListenerMetaData)md;
                        elmd.addCallback("javax.persistence.PostUpdate", this.getAttr(attrs, "method-name"));
                    }
                    break block148;
                }
                if (localName.equals("post-load")) {
                    md = this.getStack();
                    if (md instanceof AbstractClassMetaData) {
                        AbstractClassMetaData cmd16 = (AbstractClassMetaData)md;
                        EventListenerMetaData elmd = cmd16.getListenerForClass(cmd16.getFullClassName());
                        if (elmd == null) {
                            elmd = new EventListenerMetaData(cmd16.getFullClassName());
                            cmd16.addListener(elmd);
                        }
                        elmd.addCallback("javax.persistence.PostLoad", this.getAttr(attrs, "method-name"));
                    } else {
                        EventListenerMetaData elmd = (EventListenerMetaData)md;
                        elmd.addCallback("javax.persistence.PostLoad", this.getAttr(attrs, "method-name"));
                    }
                    break block148;
                }
                if (localName.equals("attribute-override")) {
                    cmd = (AbstractClassMetaData)this.getStack();
                    AbstractMemberMetaData fmd4 = this.newOverriddenFieldObject((MetaData)cmd, attrs);
                    cmd.addMember(fmd4);
                    this.pushStack((MetaData)fmd4);
                    break block148;
                }
                if (localName.equals("association-override")) {
                    cmd = (AbstractClassMetaData)this.getStack();
                    AbstractMemberMetaData fmd5 = this.newOverriddenFieldObject((MetaData)cmd, attrs);
                    cmd.addMember(fmd5);
                    this.pushStack((MetaData)fmd5);
                    break block148;
                }
                if (localName.equals("exclude-default-listeners")) {
                    cmd = (AbstractClassMetaData)this.getStack();
                    cmd.excludeDefaultListeners();
                    break block148;
                }
                if (localName.equals("exclude-superclass-listeners")) {
                    cmd = (AbstractClassMetaData)this.getStack();
                    cmd.excludeSuperClassListeners();
                    break block148;
                }
                String message = LOCALISER.msg("044037", (Object)qName);
                NucleusLogger.METADATA.error((Object)message);
                throw new RuntimeException(message);
            }
            catch (RuntimeException ex) {
                NucleusLogger.METADATA.error((Object)LOCALISER.msg("044042", (Object)qName, (Object)this.getStack(), (Object)uri), (Throwable)ex);
                throw ex;
            }
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        String currentString;
        if (NucleusLogger.METADATA.isDebugEnabled()) {
            NucleusLogger.METADATA.debug((Object)LOCALISER.msg("044035", (Object)("<" + qName + ">"), (Object)("" + this.stack.size())));
        }
        if (localName.length() < 1) {
            localName = qName;
        }
        if ((currentString = this.getString().trim()).length() > 0) {
            MetaData md = this.getStack();
            if (localName.equals("schema")) {
                if (md instanceof FileMetaData) {
                    ((FileMetaData)md).setSchema(currentString);
                }
            } else if (localName.equals("catalog")) {
                if (md instanceof FileMetaData) {
                    ((FileMetaData)md).setCatalog(currentString);
                }
            } else if (localName.equals("access")) {
                if (md instanceof FileMetaData && currentString.equalsIgnoreCase("PROPERTY")) {
                    this.propertyAccess = true;
                }
            } else if (localName.equals("package")) {
                if (md instanceof FileMetaData) {
                    FileMetaData filemd = (FileMetaData)md;
                    filemd.addPackage(new PackageMetaData(filemd, currentString, null, null));
                    this.defaultPackageName = currentString;
                }
            } else if (localName.equals("discriminator-value")) {
                if (md instanceof ClassMetaData) {
                    ClassMetaData cmd = (ClassMetaData)md;
                    InheritanceMetaData inhmd = cmd.getInheritanceMetaData();
                    if (inhmd == null) {
                        inhmd = new InheritanceMetaData((AbstractClassMetaData)cmd, null);
                        cmd.setInheritanceMetaData(inhmd);
                    }
                    String discrimValue = currentString;
                    DiscriminatorMetaData discmd = new DiscriminatorMetaData(inhmd, null, discrimValue, DiscriminatorStrategy.VALUE_MAP.toString(), null);
                    inhmd.setDiscriminatorMetaData(discmd);
                }
            } else if (localName.equals("column-name")) {
                if (md instanceof UniqueMetaData) {
                    ((UniqueMetaData)md).addColumn(new ColumnMetaData(md, currentString));
                }
            } else if (localName.equals("order-by")) {
                if (md instanceof AbstractMemberMetaData) {
                    AbstractMemberMetaData fmd = (AbstractMemberMetaData)md;
                    fmd.setOrderMetaData(new OrderMetaData(currentString));
                }
            } else if (localName.equals("query")) {
                if (md instanceof QueryMetaData) {
                    ((QueryMetaData)md).setQuery(currentString);
                }
            } else if (localName.equals("enumerated")) {
                if (md instanceof AbstractMemberMetaData) {
                    AbstractMemberMetaData mmd = (AbstractMemberMetaData)md;
                    String enumerationType = currentString;
                    String jdbcType = "INTEGER";
                    if (enumerationType.equalsIgnoreCase("STRING")) {
                        jdbcType = "VARCHAR";
                    }
                    if (mmd.getColumnMetaData() == null) {
                        ColumnMetaData colmd = new ColumnMetaData((MetaData)mmd, null, null, null, jdbcType, null, null, null, null, null, null, null, null, null);
                        mmd.addColumn(colmd);
                    } else {
                        mmd.getColumnMetaData()[0].setJdbcType(jdbcType);
                    }
                }
            } else if (localName.equals("temporal") && md instanceof AbstractMemberMetaData) {
                AbstractMemberMetaData mmd = (AbstractMemberMetaData)md;
                String enumerationType = currentString;
                String jdbcType = null;
                if (enumerationType.equalsIgnoreCase("DATE")) {
                    jdbcType = "DATE";
                } else if (enumerationType.equalsIgnoreCase("TIME")) {
                    jdbcType = "TIME";
                } else if (enumerationType.equalsIgnoreCase("TIMESTAMP")) {
                    jdbcType = "TIMESTAMP";
                }
                if (mmd.getColumnMetaData() == null) {
                    ColumnMetaData colmd = new ColumnMetaData((MetaData)mmd, null, null, null, jdbcType, null, null, null, null, null, null, null, null, null);
                    mmd.addColumn(colmd);
                } else {
                    mmd.getColumnMetaData()[0].setJdbcType(jdbcType);
                }
            }
        }
        if (localName.equals("entity") || localName.equals("mapped-superclass") || localName.equals("entity-listener") || localName.equals("attribute-override") || localName.equals("association-override") || localName.equals("id") || localName.equals("embedded-id") || localName.equals("basic") || localName.equals("transient") || localName.equals("one-to-one") || localName.equals("one-to-many") || localName.equals("many-to-one") || localName.equals("many-to-many") || localName.equals("version") || localName.equals("secondary-table") || localName.equals("join-table") || localName.equals("unique-constraint") || localName.equals("named-query") || localName.equals("named-native-query") || localName.equals("sql-result-set-mapping")) {
            this.popStack();
        }
    }
}

