/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.jpa.metadata;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.List;
import javax.persistence.PostLoad;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;
import javax.persistence.PrePersist;
import javax.persistence.PreRemove;
import javax.persistence.PreUpdate;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.OMFContext;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.EventListenerMetaData;
import org.datanucleus.metadata.FileMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.PackageMetaData;
import org.datanucleus.metadata.xml.MetaDataParser;
import org.datanucleus.util.NucleusLogger;

public class JPAMetaDataManager
extends MetaDataManager {
    public JPAMetaDataManager(OMFContext ctxt) {
        super(ctxt);
        if (NucleusLogger.METADATA.isDebugEnabled()) {
            this.logConfiguration();
        }
    }

    protected FileMetaData parseFile(URL fileURL) {
        if (this.metaDataParser == null) {
            this.metaDataParser = new MetaDataParser((MetaDataManager)this, this.validateMetaData);
        }
        return (FileMetaData)this.metaDataParser.parseMetaDataURL(fileURL, "jpa");
    }

    public void registerFile(String fileURLString, FileMetaData filemd, ClassLoaderResolver clr) {
        if (fileURLString == null) {
            return;
        }
        if (this.fileMetaDataByURLString.get(fileURLString) != null) {
            return;
        }
        this.fileMetaDataByURLString.put(fileURLString, filemd);
        this.registerQueriesForFile(filemd);
        this.registerSequencesForFile(filemd);
        this.registerTableGeneratorsForFile(filemd);
        this.registerQueryResultMetaDataForFile(filemd);
        if (filemd.getListeners() != null) {
            List fileListeners = filemd.getListeners();
            this.listeners.addAll(fileListeners);
            for (int i = 0; i < fileListeners.size(); ++i) {
                EventListenerMetaData elmd = (EventListenerMetaData)fileListeners.get(i);
                this.populateListenerMethodsForEventListener(elmd, clr);
            }
        }
        if (filemd.getType() == 5 || filemd.getType() == 4) {
            for (int i = 0; i < filemd.getNoOfPackages(); ++i) {
                PackageMetaData pmd = filemd.getPackage(i);
                for (int j = 0; j < pmd.getNoOfClasses(); ++j) {
                    ClassMetaData cmd = pmd.getClass(j);
                    if (cmd.getEntityName() != null) {
                        this.classMetaDataByEntityName.put(cmd.getEntityName(), cmd);
                    }
                    this.registerMetaDataForClass(cmd.getFullClassName(), (AbstractClassMetaData)cmd);
                    if (cmd.getListeners() == null) continue;
                    List classListeners = cmd.getListeners();
                    for (int k = 0; k < classListeners.size(); ++k) {
                        EventListenerMetaData elmd = (EventListenerMetaData)classListeners.get(k);
                        this.populateListenerMethodsForEventListener(elmd, clr);
                    }
                }
            }
        }
    }

    private void populateListenerMethodsForEventListener(EventListenerMetaData elmd, ClassLoaderResolver clr) {
        Class listenerClass = clr.classForName(elmd.getClassName());
        this.populateListenerMethodsForClassInEventListener(elmd, listenerClass, clr);
    }

    private void populateListenerMethodsForClassInEventListener(EventListenerMetaData elmd, Class cls, ClassLoaderResolver clr) {
        Method[] methods = cls.getDeclaredMethods();
        if (methods != null) {
            for (int i = 0; i < methods.length; ++i) {
                Annotation[] methodAnnots = methods[i].getAnnotations();
                if (methodAnnots == null) continue;
                for (int j = 0; j < methodAnnots.length; ++j) {
                    if (methodAnnots[j].annotationType() != PrePersist.class && methodAnnots[j].annotationType() != PostPersist.class && methodAnnots[j].annotationType() != PreRemove.class && methodAnnots[j].annotationType() != PostRemove.class && methodAnnots[j].annotationType() != PreUpdate.class && methodAnnots[j].annotationType() != PostUpdate.class && methodAnnots[j].annotationType() != PostLoad.class) continue;
                    elmd.addCallback(methodAnnots[j].annotationType().getName(), methods[i].getDeclaringClass().getName(), methods[i].getName());
                }
            }
        }
        if (cls.getSuperclass() == null || cls.getSuperclass() == Object.class) {
            return;
        }
        this.populateListenerMethodsForClassInEventListener(elmd, cls.getSuperclass(), clr);
    }

    public synchronized AbstractClassMetaData getMetaDataForClassInternal(Class c, ClassLoaderResolver clr) {
        if (this.isClassWithoutPersistenceInfo(c.getName())) {
            return null;
        }
        AbstractClassMetaData acmd = (AbstractClassMetaData)this.classMetaDataByClass.get(c.getName());
        if (acmd != null) {
            return acmd;
        }
        FileMetaData annFilemd = this.loadAnnotationsForClass(c, clr, true, true);
        if (annFilemd != null) {
            return annFilemd.getPackage(0).getClass(0);
        }
        if (NucleusLogger.METADATA.isDebugEnabled()) {
            NucleusLogger.METADATA.debug((Object)LOCALISER.msg("044043", (Object)c.getName()));
        }
        this.classesWithoutPersistenceInfo.add(c.getName());
        return null;
    }
}

